	.nlist
	.include	"jaguar.inc"
	.include	"blit.inc"
	.list
;
;
debugd	equ	0	;if debugging DSP (6502) section
debugg	equ	0	;if debugging GPU (TIA) section
nomerg	equ	1	;=0 if merge line buffers visible
;
;
dlist	equ	$80000
image	equ	$90000
;
pfbuf		equ	204	;playfield SRC regs on this line
lbufs		equ	205	;line buffers start on this line
;
;
;
p0lin		equ	lbufs+0	
m0lin		equ	lbufs+1	
p1lin		equ	lbufs+2	
m1lin		equ	lbufs+3	
pflin		equ	lbufs+4	
ballin		equ	lbufs+5	
bglin		equ	lbufs+6	
;
;underlin	equ	37	;underscan lines
underlin	equ	33	;underscan lines
;
screnlin	equ	199	;total displayable lines
;
;
pf0	equ	image+(pfbuf*160)
pf1	equ	pf0+16
pf2	equ	pf1+16
;
;
grp0	equ	pf2+16
grp1	equ	grp0+16
;
;
;
INPT4	equ	$f1b03c
SWCHA	equ	$f1bfe8
;
;
start:
	clr.w	joymode
	lea	$200000,sp		;set stack at top of memory
	move.w	#$100,JOY1		;unmute
;
	bsr	initdisp		;start-up some display here
;
;
;*****************************************************************
;  Now, let's do 6502 emulator
;
	lea	$100000,a0
	moveq	#-1,d0
	move.w	#$400-1,d1		;-1 to 0xxx
initer:
	move.l	d0,(a0)+
	dbra	d1,initer
;
;
	lea	$180000,a0
	lea	$1A0000,a1
	moveq	#0,d0
	move.w	#$4000-1,d1		;clear event que for tia
tiaque:
	move.l	d0,(a0)+
	move.l	d0,(a1)+
	dbra	d1,tiaque
;
; Load, & initialize DSP program
;
	move.l	#DSPU_S,a0
	move.l	#DSPU_E,a1
;
	move.l	a0,d1
	move.l	a1,d0
	sub.l	d1,d0		; Size in bytes
	asr.l	#2,d0
	move.l	#D_RAM,a1
xferloop:
	move.l	(a0)+,(a1)+
        dbra    d0,xferloop
;
; Load, & initialize GPU program
;
	move.l	#GPUU_S,a0
	move.l	#GPUU_E,a1
;
	move.l	a0,d1
	move.l	a1,d0
	sub.l	d1,d0		; Size in bytes
	asr.l	#2,d0
	move.l	#G_RAM,a1
xfrloop:
	move.l	(a0)+,(a1)+
        dbra    d0,xfrloop
;
	move.l	#GPUstart,G_PC
;
refrm:
	bsr	firstjoy
;
;
	.if	1
	beq	refrm
	.else
	moveq	#1,d0		;just do pacman for now
	bra.s	gotone
	.endif
;
;
	moveq	#9,d0
bitllp:
	move.b	bitb(PC,d0.w),d1
	btst.l	d1,d3
	bne.s	gotone
	dbra	d0,bitllp
	bra	refrm
bitb:
	dc.b	8,19,11,3,18,10,2,17,9,1
;
gotone:
	cmpi.w	#(ovgamez-gamez)/4,d0
	bcc	refrm
;
;
	add.w	d0,d0
	add.w	d0,d0
	move.l	gamez(pc,d0.w),a0
	bra.s	ovgamez
gamez:
	dc.l	berz		;0
	dc.l	pac		;1
	dc.l	yars		;2
	dc.l	mcomand		;3
	dc.l	frostb		;4
	dc.l	test1		;5
ovgamez:
;	lea	$101000,a1
;
	lea	$f1c000,a1
	move.w	#$400-1,d0
looper:
	move.l	(a0)+,(a1)+
	dbra	d0,looper
;
	subq.l	#4,a1
	moveq	#0,d0
	move.l	(a1),d0
	swap	d0
	rol.w	#8,d0
	move.l	d0,PCinit
;
;
;
	move.l	#DSPstart,D_PC
;
;****test code
;
	lea	pretabl,a2
;
	lea	preindex,a3

	move.l	(a2)+,d1
prebuild:
	move.l	(a2),d2
	sub.l	d1,d2
	move.l	d2,d3
	lsr.l	#2,d2
	move.l	d2,(a2)+	
	andi.l	#3,d3
	beq.s	goobu
	illegal
goobu:
	cmp.l	a3,a2
	bcs	prebuild
;
;
	lea	addrtabl,a2
	lea	addrindx,a3
	move.l	(a2)+,d1
abuild:
	move.l	(a2),d2
	sub.l	d1,d2
	move.l	d2,d3
	lsr.l	#2,d2
	move.l	d2,(a2)+	
	andi.l	#3,d3
	beq.s	gooobu
	illegal
gooobu:
	cmp.l	a3,a2
	bcs	abuild
;
;
;
	lea	opmdtabl,a2
	lea	opindex,a3
	move.l	(a2)+,d1
obuild:
	move.l	(a2),d2
	sub.l	d1,d2
	move.l	d2,d3
	lsr.l	#2,d2
	move.l	d2,(a2)+	
	andi.l	#3,d3
	beq.s	gooobuu
	illegal
gooobuu:
	cmp.l	a3,a2
	bcs	obuild
;
;
;
;
;	lea	$4000,a0
	lea	$f1bc00,a0
;
	lea	cyclez,a1
	lea	pretabl+4,a2
	lea	preindex,a3
	lea	addrtabl+4,a4
	lea	addrindx,a5	
	move.l	#opmdtabl+4,d5
	move.l	#opindex,d6
;
	move.w	#255,d0
packlp1:
	moveq	#0,d1
	move.w	(a1)+,d1	;get cycle count

	moveq	#0,d2
	move.b	(a3)+,d2	;get pre-index index
	lsl.w	#2,d2
	move.l	(a2,d2.w),d3	;pre index offset
	lsl.l	#5,d3
	or.l	d3,d1		;pack pre-index

	move.b	(a5)+,d2	;get addressing index
	lsl.w	#2,d2
	move.l	(a4,d2.w),d3	;and addressing offset
	swap	d3
	lsr.l	#3,d3
	or.l	d3,d1		;pack addressing offset

	move.l	d6,a6
	move.b	(a6)+,d2	;get opcode index
	move.l	a6,d6
	tst.b	d2
	beq.s	skipop
	move.l	d5,a6
	lsl.w	#2,d2
	move.l	(a6,d2.w),d3
	swap	d3
	lsl.l	#5,d3
	or.l	d3,d1		;pack opcode index
;
skipop:
	move.l	d1,(a0)+
	dbra	d0,packlp1
;
waitup:
	bsr	firstjoy
;		              147     2580    369
;		   3         2         1     
;		  10987654321098765432109876543210
	andi.l	#%00000000000011100000111100001110,d4
	bne	waitup		;wait for game select button to be released
	
	move.w	#-1,joymode	;go to 2600 joystick mode
;
;
;  mimic init conditions for testing
;
	move.l	#$ffffbfff,$f1bfe8	;$280-$283 ($282=$BF)
	move.l	#$ffffffff,$f1bfec	;$284-$287

	move.l	#$bcffffff,$f1b03c	; for test
;
;
;  debug DSP code
;
	.if	debugd
;
	move.l	#1,G_CTRL
testp:
	bra	testp
	.endif
;
;
;
	move.l	#1,D_CTRL	;start it up
;
	lea	Vsemi,a0
waitD:	
	move.l	(a0),d0
	beq	waitD
;
;  debug GPU code
;
	.if	debugg
	move.l	#0,(a0)
testp:
	bra	testp

	.endif



	move.l	#1,G_CTRL
;
	lea	fcount,a1
	move.l	#$180000,d5	;base address of tia event que
	move.l	#$8000,d3	;size of event que
	move.l	#$200,d4	;max distance GPU can be behind DSP
ww:
	move.l	(a1),d1
	move.l	#0,(a0)
;
;	addq.l	#1,d1
fwait:
	move.l	d1,d2
	sub.l	(a1),d2
	bpl	fwait
;
waitDD:
	move.l	(a0),d0
	beq	waitDD
;
	sub.l	d4,d0		;check some distance back for GPU
	cmp.l	d5,d0		;should we underflo wrap?
	bcc.s	nnwrap		;br if not
	add.l	d3,d0		;else, adjust for wrap
nnwrap:
	move.l	d0,a2
waitGP:
	tst.l	(a2)
	bne	waitGP		;wait til GPU gets here
	bra	ww
;
;	.if	!debugd
;testp:
;	bra	testp
;	.endif
;
	move.l	#1,G_CTRL
;
	nop
	nop
	nop
	nop
	nop
	nop
	nop
;
;
;
firstjoy:
;
	lea	fcount,a0
;
newj:
	move.l	(a0),d0
frmwait:
	cmp.l	(a0),d0
	beq	frmwait
;
	lea	joycur,a1
	lea	oldjoy,a2

	moveq	#3,d2
packlp:
	move.l	(a1)+,d0
	move.l	(a2),d1
	move.l	d0,(a2)+
	eor.l	d0,d1
	and.l	d0,d1
	rol.l	#8,d1
	lsl.l	#8,d3
	move.b	d1,d3
;
	rol.l	#8,d0
	lsl.l	#8,d4
	move.b	d0,d4
	dbra	d2,packlp
;
;
;		              147     2580    369
;		   3         2         1     
;		  10987654321098765432109876543210
	andi.l	#%00000000000011100000111100001110,d3
;
	rts
;
;
;
;  Cycle counts
;
cyclez:
	.if	0
;
; (in 6502 machine cycles)
	dc.w	7,6,0,0,0,3,5,0,3,2,5,0,0,4,6,0
	dc.w	2,5,0,0,0,4,6,0,2,4,0,0,0,4,7,0
	dc.w	6,6,0,0,3,3,5,0,4,2,2,0,4,4,6,0
	dc.w	2,5,0,0,0,4,6,0,2,4,0,0,0,4,7,0

	dc.w	6,6,0,0,0,3,5,0,3,2,2,0,3,4,6,0
	dc.w	2,5,0,0,0,4,6,0,2,4,0,0,0,4,7,0
	dc.w	6,6,0,0,0,3,5,0,4,2,2,0,5,4,6,0
	dc.w	2,5,0,0,0,4,6,0,2,4,0,0,0,4,7,0

	dc.w	0,6,0,0,3,3,3,0,2,0,2,0,4,4,4,0
	dc.w	2,6,0,0,4,4,4,0,2,5,2,0,0,4,0,0
	dc.w	2,6,2,0,3,3,3,0,2,2,2,0,4,4,4,0
	dc.w	2,5,0,0,4,4,4,0,2,4,2,0,4,4,4,0

	dc.w	2,6,0,0,3,3,5,0,2,2,2,0,4,4,6,0
	dc.w	2,5,0,0,0,4,6,0,2,4,0,0,0,4,7,0
	dc.w	2,6,0,0,3,3,5,0,2,2,2,0,4,4,6,0
	dc.w	2,5,0,0,0,4,6,0,2,4,0,0,0,4,7,0
	.endif
;
;  (in 2600 color clocks)
	dc.w	$15,$12,$0C,$0C,$0C,$09,$0F,$00
	dc.w	$09,$06,$0F,$00,$00,$0C,$12,$00
	dc.w	$06,$0F,$00,$00,$00,$0C,$12,$00
	dc.w	$06,$0C,$00,$00,$00,$0C,$15,$00
	dc.w	$12,$12,$00,$00,$09,$09,$0F,$00
	dc.w	$0C,$06,$06,$00,$0C,$0C,$12,$00
	dc.w	$06,$0F,$00,$00,$00,$0C,$12,$00
	dc.w	$06,$0C,$00,$00,$00,$0C,$15,$00
	dc.w	$12,$12,$00,$00,$00,$09,$0F,$00
	dc.w	$09,$06,$06,$00,$09,$0C,$12,$00
	dc.w	$06,$0F,$00,$00,$00,$0C,$12,$00
	dc.w	$06,$0C,$00,$00,$00,$0C,$15,$00
	dc.w	$12,$12,$00,$00,$00,$09,$0F,$00
	dc.w	$0C,$06,$06,$00,$0F,$0C,$12,$00
	dc.w	$06,$0F,$00,$00,$00,$0C,$12,$00
	dc.w	$06,$0C,$00,$00,$00,$0C,$15,$00
	dc.w	$00,$12,$00,$00,$09,$09,$09,$00
	dc.w	$06,$00,$06,$00,$0C,$0C,$0C,$00
	dc.w	$06,$12,$00,$00,$0C,$0C,$0C,$00
	dc.w	$06,$0F,$06,$00,$00,$0C,$00,$00
	dc.w	$06,$12,$06,$00,$09,$09,$09,$00
	dc.w	$06,$06,$06,$00,$0C,$0C,$0C,$00
	dc.w	$06,$0F,$00,$00,$0C,$0C,$0C,$00
	dc.w	$06,$0C,$06,$00,$0C,$0C,$0C,$00
	dc.w	$06,$12,$00,$00,$09,$09,$0F,$00
	dc.w	$06,$06,$06,$00,$0C,$0C,$12,$00
	dc.w	$06,$0F,$00,$00,$00,$0C,$12,$00
	dc.w	$06,$0C,$00,$00,$00,$0C,$15,$00
	dc.w	$06,$12,$00,$00,$09,$09,$0F,$00
	dc.w	$06,$06,$06,$00,$0C,$0C,$12,$00
	dc.w	$06,$0F,$00,$00,$00,$0C,$12,$00
	dc.w	$06,$0C,$00,$00,$00,$0C,$15,$00
;
;
;
;	.nlist
;	.include	"68k265.s"
;	.list
;
;
;
;
Frame:
	movem.l	d0-d2/a0-a1,-(sp)
	lea	dlistROM+32,a0
	lea	dlist+32,a1
	moveq	#3,d0
Flist:
	move.l	(a0)+,(a1)+
	dbra	d0,Flist		;copy ROM display list to ram
;
	move.w	#$0101,INT1		;clear CPU interrupt
	move.w	#0,INT2
;
	addq.l	#1,fcount
;
;
	tst.w	joymode
	bne	joy26
;	.if	0
	lea	joycur,a0
	lea	$f14000,a1
	move.w	#$81ff,d1
	moveq	#$11,d0
Floop:
	eor.w	d1,d0
	move.w	d0,(a1)		;ask for next row
;
	move.l	(a1),d2
	not.l	d2
	move.l	d2,(a0)+
;
	eor.w	d1,d0
	add.w	d0,d0
	cmpi.w	#$110,d0
	bcs	Floop
;
	bra	frameout
;	.else
;
joy26:
	lea	joycur,a0
	lea	$f14000,a1
	move.w	#$81EE,(a1)		;ask for top row
;
;				  P1   P0                           P1P0
	move.l	(a1),d0		;369# RLDU xxxx xxxx xxxx xxxx xxxx OxAP
	move.l	d0,d2
	swap	d0		;xxxx xxxx xxxx OxAP 369# RLDU xxxx xxxx
	ror.l	#4,d0		;xxxx xxxx xxxx xxxx OxAP 369# RLDU xxxx 
	move.l	d0,(a0)+

	move.w	#$8177,(a1)
;
	ror.w	#2,d2
;				  P1   P0                           P1P0
	move.l	(a1),d1		;RLDU 369# xxxx xxxx xxxx xxxx xxxx APOx
	rol.l	#4,d1		;369# xxxx xxxx xxxx xxxx xxxx APOx RLDU
;
	move.l	d1,(a0)+
;
	move.b	d1,d2
	ori.w	#$7f7f,d2
	swap	d2
	move.l	d2,INPT4
;
	andi.w	#$f0,d0
	andi.w	#$0f,d1
	or.w	d1,d0
	ror.l	#8,d0
	andi.l	#$ff000000,d0
	or.l	#$00ffbeff,d0
	tst.l	d1
	bpl.s	not3
	or.w	#$100,d0
not3:
	move.l	d0,SWCHA	
;
;	.endif
frameout:
	movem.l	(sp)+,d0-d2/a0-a1
;	move.w	#$0101,INT1		;clear CPU interrupt
;	move.w	#0,INT2
rrte:
	rte
;
;
;
;
;  Init the display
;
initdisp:
	lea	dlistROM,a0
	lea	dlist,a1
	moveq	#15,d0
getlist:
	move.l	(a0)+,(a1)+
	dbra	d0,getlist		;copy ROM display list to ram
;
	bsr	fillgrey
;
;
	clr.l	fcount
;
	lea	CLUT,a0
	lea	chroma,a1
	move.w	#127,d2
chrlp0:
	move.w	(a1)+,d3
	move.w	d3,(a0)+
	move.w	d3,(a0)+
	dbra	d2,chrlp0
;
	move.l	#Frame,$100
	move.l	#dlist,d0
	swap	d0
	move.l	d0,OLP			;stop object is here
;
	moveq	#0,d0
	move.l	d0,BORD1
	move.w	d0,BG
	move.w	#-1,VDE
;
	move.w	#$101,INT1
;
	move.w	#$cc1,VMODE
;
	move.w	#%0000000000000000,BG		;black
;
	lea	image+(lbufs*160),a0
	moveq	#0,d0
	move.w	#7*40-1,d1
clerbufz:
	move.l	d0,(a0)+
	dbra	d1,clerbufz
;
	lea	BASE,a0			;use relative addressing for economy
.waitblit:
	move.l	b_cmd(a0),d0	;if blitter is in use, wait til done
	lsr.w	#1,d0
	bcc	.waitblit
;
;
;
	move.l	#image,d0	;all blits use same form
	move.l	d0,a1_base(a0)
	move.l	d0,a2_base(a0)
;
;
	rts
;
;
;
fillgrey:
	lea	image,a0
	move.l	#$02020202,d0
	move.w	#40*240-1,d1
clearimg:
	move.l	d0,(a0)+
	dbra	d1,clearimg
	rts
;
;
;
;
chroma:
	.nlist
	.include	"coltab.s"
	.list
;
;
;
;  Pre Addressing Calculations (all 1 byte instructions go here)
;
pretabl:
	dc.l	preaddrm
;
	dc.l	BRKa	;0
	dc.l	ASLa	;1
;
	dc.l	byte2	;2
	dc.l	byte3	;3
;
	dc.l	CLCa	;4
	dc.l	CLDa	;5
	dc.l	CLIa	;6
	dc.l	CLVa	;7
	dc.l	SEIa	;8
	dc.l	SECa	;9
	dc.l	SEDa	;10
;
	dc.l	INXa	;11
	dc.l	DEXa	;12
	dc.l	INYa	;13
	dc.l	DEYa	;14
	dc.l	LSRa	;15
	dc.l	TAXa	;16
	dc.l	TAYa	;17
	dc.l	TYAa	;18
	dc.l	TXAa	;19
	dc.l	TSXa	;20
	dc.l	TXSa	;21
	dc.l	PHAa	;22
	dc.l	PHPa	;23
	dc.l	PLAa	;24
	dc.l	PLPa	;25
	dc.l	RTSa	;26
	dc.l	NOPa	;27
	dc.l	ROLa	;28
	dc.l	RORa	;29
	dc.l	WAITIMy	;30
	dc.l	WAITIMa	;31
	dc.l	WAITIMx	;32
;
;	
preindex:	;0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
	dc.b	00,02,30,31,32,02,02,00,23,02,01,00,00,03,03,00
	dc.b	02,02,00,00,00,02,02,00,04,03,00,00,00,03,03,00
	dc.b	03,02,00,00,02,02,02,00,25,02,28,00,03,03,03,00
	dc.b	02,02,00,00,00,02,02,00,09,03,00,00,00,03,03,00

;		 0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
	dc.b	00,02,00,00,00,02,02,00,22,02,15,00,03,03,03,00
	dc.b	02,02,00,00,00,02,02,00,06,02,00,00,00,03,03,00
	dc.b	26,02,00,00,00,02,02,00,24,02,29,00,03,03,03,00
	dc.b	02,02,00,00,00,02,02,00,08,03,00,00,00,03,03,00

;		 0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
	dc.b	00,02,00,00,02,02,02,00,14,00,19,00,03,03,03,00
	dc.b	02,02,00,00,02,02,02,00,18,03,21,00,00,03,00,00
	dc.b	02,02,02,00,02,02,02,00,17,02,16,00,03,03,03,00
	dc.b	02,02,00,00,02,02,02,00,07,03,20,00,03,03,03,00

;		 0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
	dc.b	02,02,00,00,02,02,02,00,13,02,12,00,03,03,03,00
	dc.b	02,02,00,00,00,02,02,00,05,03,00,00,00,03,03,00
	dc.b	02,02,00,00,02,02,02,00,11,02,27,00,03,03,03,00
	dc.b	02,02,00,00,00,02,02,00,10,03,00,00,00,03,03,00
;
;
addrtabl:
	dc.l	addrmode

	dc.l	immed		;0
	dc.l	relat		;1
	dc.l	absolrd		;2
	dc.l	absolx		;3
	dc.l	absoly		;4
	dc.l	indx		;5
	dc.l	indy		;6
	dc.l	zpage		;7
	dc.l	zpagex		;8
	dc.l	zpagey		;9
	dc.l	indir		;10
	dc.l	absol		;11
;
;
addrindx:
	dc.b	0,5,0,0,0,7,7,0,0,0,0,0,0,2,2,0
	dc.b	1,6,0,0,0,8,8,0,0,4,0,0,0,3,3,0
	dc.b	11,5,0,0,7,7,7,0,0,0,0,0,2,2,2,0
	dc.b	1,6,0,0,0,8,8,0,0,4,0,0,0,3,3,0

	dc.b	0,5,0,0,0,7,7,0,0,0,0,0,11,2,2,0
	dc.b	1,6,0,0,0,8,8,0,0,4,0,0,0,3,3,0
	dc.b	0,5,0,0,0,7,7,0,0,0,0,0,10,2,2,0
	dc.b	1,6,0,0,0,8,8,0,0,4,0,0,0,3,3,0

	dc.b	0,5,0,0,7,7,7,0,0,0,0,0,2,2,2,0
	dc.b	1,6,0,0,8,8,9,0,0,4,0,0,0,3,0,0
	dc.b	0,5,0,0,7,7,7,0,0,0,0,0,2,2,2,0
	dc.b	1,6,0,0,8,8,9,0,0,4,0,0,3,3,4,0

	dc.b	0,5,0,0,7,7,7,0,0,0,0,0,2,2,2,0
	dc.b	1,6,0,0,0,8,8,0,0,4,0,0,0,3,3,0
	dc.b	0,5,0,0,7,7,7,0,0,0,0,0,2,2,2,0
	dc.b	1,6,0,0,0,8,8,0,0,4,0,0,0,3,3,0
;
;
opmdtabl:
	dc.l	opmode
;
	dc.l	Btaken		;0 dummy placeholder
	dc.l	ADCn		;1
	dc.l	EORn		;2	
	dc.l	ORAn		;3	
	dc.l	ANDn		;4	
	dc.l	ASLn		;5	
	dc.l	BCCn		;6	
	dc.l	BCSn		;7	
	dc.l	BEQn		;8	
	dc.l	BNEn		;9	
	dc.l	BMIn		;10	
	dc.l	BPLn		;11
	dc.l	BVCn		;12
	dc.l	BVSn		;13
	dc.l	BITn		;14
	dc.l	CMPn		;15
	dc.l	CPXn		;16
	dc.l	CPYn		;17
	dc.l	DECn		;18
	dc.l	INCn		;19
	dc.l	JMPn		;20
	dc.l	JSRn		;21
	dc.l	LDAn		;22
	dc.l	LDXn		;23
	dc.l	LDYn		;24
	dc.l	LSRn		;25
	dc.l	ROLn		;26
	dc.l	RORn		;27
	dc.l	SBCn		;28
	dc.l	STAn		;29
	dc.l	STXn		;30
	dc.l	STYn		;31
;
;
opindex:	;0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
	dc.b	00,03,00,00,00,03,05,00,00,03,05,00,00,03,05,00
	dc.b	11,03,00,00,00,03,05,00,00,03,00,00,00,03,05,00
	dc.b	21,04,00,00,14,04,26,00,00,04,26,00,14,04,26,00
	dc.b	10,04,00,00,00,04,26,00,00,04,00,00,00,04,26,00

;		 0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
	dc.b	00,02,00,00,00,02,25,00,00,02,00,00,20,02,25,00
	dc.b	12,02,00,00,00,02,25,00,00,02,00,00,00,02,25,00
	dc.b	00,01,00,00,00,01,27,00,00,01,00,00,20,01,27,00
	dc.b	13,01,00,00,00,01,27,00,00,01,00,00,00,01,27,00

;		 0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
	dc.b	00,29,00,00,31,29,30,00,00,00,00,00,31,29,30,00
	dc.b	06,29,00,00,31,29,30,00,00,29,00,00,00,29,00,00
	dc.b	24,22,23,00,24,22,23,00,00,22,00,00,24,22,23,00
	dc.b	07,22,00,00,24,22,23,00,00,22,00,00,24,22,23,00

;		 0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
	dc.b	17,15,00,00,17,15,18,00,00,15,00,00,17,15,18,00
	dc.b	09,15,00,00,00,15,18,00,00,15,00,00,00,15,18,00
	dc.b	16,28,00,00,16,28,19,00,00,28,00,00,16,28,19,00
	dc.b	08,28,00,00,00,28,19,00,00,28,00,00,00,28,19,00

;
;----------------------------------------------------------
;
;  Object type (Bits 0-2 in 1st 64-bit phrase of object)
; 
BMAPTYP		equ	0	;Bit-Map object
SCALTYP		equ	1	;Scaled Bit-Map object
GPUTYP		equ	2	;Graphics Processor interrupt Object
BRTYP		equ	3	;Branch Object
STOPTYP		equ	4	;Stop Object
;
;
;
;
;   Rom copy of the Object list
;
dlistROM:

OBJTYPE		set	BRTYP	;1st object is a BR object
BCC		set	1	;Br Condition Code (br if YPOS=<VC)
YPOS		set	21	;top branch object
	dc.w	0
	dc.l	(dlist+16) << 5
	dc.w	(BCC << 14) + (YPOS << 3) + OBJTYPE	;
;
YPOS		set	519	;bottom branch object
	dc.w	0
	dc.l	(dlist+32) << 5
	dc.w	(BCC << 14) + (YPOS << 3) + OBJTYPE	;
;
	dc.l	0,STOPTYP
	dc.l	0,STOPTYP
;
;

OBJTYPE		set	BMAPTYP	;1st object is a Scaled Bit-Map object
	.if	nomerg
HEIGHT		set	200*2	;fill the screen
	.else
HEIGHT		set	212*2	;fill the screen
	.endif
YPOS		set	55	;from the top
XPOS		set	16	;from the left edge
FIRSTPIX	set	0	;no left edge clipping
RELEASE		set	0	;release bus between image data fetches
TRANSPAR	set	0	;make logical color 0 transparent
RMW		set	0	;no read-modify-write
REFLECT		set	0	;no horizontal reflect
INDEX		set	0	;palette offset if 1-4 bits/pix
IWIDTH		set	20	;20 phrases in displayed image
DWIDTH		set	20	;20 phrases in source form
PITCH		set	1	;increment by 1 phrase for next fetch
DEPTH		set	3	;8 bits/pixel (2 color)
;
;  1st Object is a vanilla Bit-map, so it needs a 2 phrase header
;
;  1st phrase
 dc.l	(image << 8) + ((dlist+48) >> 11)
 dc.l	((dlist+48) << 21) + (HEIGHT << 13) + (YPOS << 3) + OBJTYPE 
;
;  2nd phrase
 dc.w (FIRSTPIX << 1) + RELEASE
 dc.w (TRANSPAR << 15) + (RMW << 14) + (REFLECT <<13) + (INDEX << 6) + (IWIDTH >> 4)
 dc.w ((IWIDTH & $0F) << 12) + (DWIDTH << 2) + (PITCH & $06)
 dc.w ((PITCH & 1) << 15) + (DEPTH << 12) + XPOS
;
 dc.l	0,STOPTYP,0,STOPTYP
;
;
;
	.bss
;
joycur:
	ds.l	4
oldjoy:
	ds.l	4
fcount:
	ds.l	1
;
joymode:
	ds.w	1
;
