; Atomic: an atomix clone for the Atari Jaguar v 1.0
; Copyright (C) 2006 Seb/The Removers
; http://removers.atari.org

; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; as published by the Free Software Foundation; either version 2
; of the License, or (at your option) any later version.

; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.

; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
	
	.text
	.68000

	include	"jaguar.inc"

START_LEVEL	equ	0
BLITTER		equ	0	; a l'air de stresser la Jag au bout d'un moment (semble attendre sans fin le blitter)

RED	equ	$f800
GREEN	equ	$003f
BLUE	equ	$07c0
YELLOW	equ	RED|GREEN
PURPLE	equ	RED|BLUE
CYAN	equ	BLUE|GREEN
WHITE	equ	$ffff
BLACK	equ	0

	;; j'espere ne pas m'etre vautre dans ces equ
JOY0_U	equ	0
JOY0_D	equ	1
JOY0_L	equ	2
JOY0_R	equ	3
JOY0_STAR	equ	4
JOY0_7	equ	5
JOY0_4	equ	6
JOY0_1	equ	7
JOY0_0	equ	8
JOY0_8	equ	9
JOY0_5	equ	10
JOY0_2	equ	11
JOY0_SHARP	equ	12
JOY0_9	equ	13
JOY0_6	equ	14
JOY0_3	equ	15
JOY0_PAUSE	equ	16+0
JOY0_A	equ	16+1
JOY0_B	equ	16+2
JOY0_C	equ	16+3
JOY0_OPTION	equ	16+4

JOY_COMBO	equ	31
	
INCX	equ	2	; doit etre un diviseur de 16 (16 est la largeur d'un sprite)
INCY	equ	2	; ici, idem (je sais, c'est mal d'hardcoder comme ca certaine valeurs!)

INTRO_TEXT_WIDTH	equ	40 ; 40 caracteres
MOLE_NAME_WIDTH		equ	32 ; 32 caracteres
NB_MOVES_WIDTH		equ	6 ; 6 caracteres
TIME_WIDTH		equ	6
LEVEL_NUM_WIDTH		equ	2

SOUND_ON	equ	1
					
.macro	wait_blitter
*.\~:
	move.l	B_CMD,\1
	ror.w	#1,\1
	bcc.s	.\~
.endm
			
start:
	;; initialisation GPU, DSP
	move.w	#$100,JOYSTICK	;mettre le son sur mute
	move.l	#0,G_CTRL	;arreter le GPU
	move.l	#0,D_CTRL	;arreter le DSP
	move.l	#0,G_FLAGS	;initialiser les FLAGS du GPU
	move.l	#0,D_FLAGS	;initialiser les FLAGS du DSP
	move.l	#$00070007,G_END	;GPU en mode BigEndian (mode compatible 68000)
	move.l	#$00070007,D_END	;DSP en mode BigEndian
	move.w	#%11010111001100,MEMCON2	;memoire en mode BigEndian
	move.w	#$ffff,VI	; disable video interrupts
	;; initialisation memoire
	move.l	#INITSTACK,a7	; initialise la pile
	move.l	#Bss_end,a0
	move.l	#INITSTACK-4*1024,a1
	bsr	mm_init		;  initialise le memory manager
	;; initialisation volume
	.if	SOUND_ON
	move.w	#160,d0		; musique
	jsr	player+$14
	move.w	#160,d0		; sample
	jsr	player+$18
	.endif
	;; initialisation video
	bsr	VideoIni                    ;initialiser le systeme video
	move.l	#stop_object,d0
	swap	d0
	move.l	d0,OLP
	move.w	#RGB16|CSYNC|BGEN|PWIDTH4|VIDEN,VMODE
	bsr	IntIni

	bsr	get_joypad_state
	move.l	d2,joypad_state
	bsr	init_game
main:
	move.l	joypad_state,old_joypad_state
	bsr	get_joypad_state
	move.l	d2,joypad_state
	bsr	wait_vbl	; attend la VBL
	move.w	current_state,d0
	lsl.w	#2,d0
	move.l	#select_action,a0
	move.l	(a0,d0.w),a0
	jsr	(a0)
	bra	main

get_joypad_state:
	;; modifie d0, d1, d2, d3
	;; renvoie l'etat dans d2.l
	move.w	#$8107,JOYSTICK	
	move.w	JOYSTICK,d0	;  3 6 9 #
	move.w	JOYBUTS,d2	;  Option
	lsl.w	#4,d0
	and.w	#$f000,d0
	and.w	#%10,d2
	or.w	#$fffc,d2	; les autres bits sont mis (lecture joypad inversee!!)
	lsl.w	#3,d2
	move.w	#$810b,JOYSTICK
	move.w	JOYSTICK,d1	; 2 5 8 0
	move.w	JOYBUTS,d3	; C
	and.w	#$0f00,d1
	or.w	d1,d0
	and.w	#%10,d3
	lsl.w	#2,d3
	or.w	d3,d2
	move.w	#$810d,JOYSTICK
	move.w	JOYSTICK,d1	; 1 4 7 *
	move.w	JOYBUTS,d3	; B
	lsr.w	#4,d1
	and.w	#$00f0,d1
	or.w	d1,d0
	and.w	#%10,d3
	lsl.w	#1,d3
	or.w	d3,d2
	move.w	#$810e,JOYSTICK
	move.w	JOYSTICK,d1	; R L D U
	move.w	JOYBUTS,d3	; A Pause
	lsr.w	#8,d1
	and.w	#$000f,d1
	or.w	d1,d0
	and.w	#%11,d3
	or.w	d3,d2
	swap	d2		; mets dans poids fort
	move.w	d0,d2		; copie les directions
	rts	
	
	.bss
old_joypad_state:	ds.l	1
joypad_state:	ds.l	1
game_state:	ds.w	1
pause_state:	ds.w	1
	
	.data

LOAD_LEVEL_STATE	equ	0
GAME_SCREEN_STATE	equ	1
PAUSE_SCREEN_STATE	equ	2
INTRO_SCREEN_STATE	equ	3

START_LEVEL_SCREEN	equ	GAME_SCREEN_STATE

GAME_NB_ACTION_IDLE	equ	20
GAME_NB_ACTION_MOVING	equ	14
	
GAME_GO_PAUSE	equ	0
*GAME_GO_NEXT	equ	1
*GAME_GO_PREV	equ	2
GAME_GO_LEFT	equ	3
GAME_GO_RIGHT	equ	4
GAME_GO_UP	equ	5
GAME_GO_DOWN	equ	6
GAME_CHG_BACK	equ	7
GAME_CHG_FORW	equ	8
GAME_REINIT	equ	9
GAME_GO_INTRO	equ	10
GAME_GO_RESET	equ	11
GAME_ENTER_NUM	equ	12
GAME_VALIDATE_NUM	equ	13
	
PAUSE_GO_GAME	equ	0
PAUSE_GO_RESET	equ	1

ATOM_CAN_GO_LEFT	equ	0
ATOM_CAN_GO_RIGHT	equ	1
ATOM_CAN_GO_UP		equ	2
ATOM_CAN_GO_DOWN	equ	3	
	
select_action:
	dc.l	init_level
	dc.l	game_screen
	dc.l	pause_screen
	dc.l	intro_screen

current_state:
	dc.w	LOAD_LEVEL_STATE

	.text

	;; gestion des listes pour l'OP
	include	"object_list.s"

intro_screen:
	tst.w	intro_screen_init_done
	beq	.init_intro
	move.l	joypad_state,d0
	btst	#JOY0_B,d0
	beq.s	.no_intro
	tst.w	intro_text_wrap
	beq.s	.intro
	bra.s	.intro
.no_intro:	
	move.l	#stop_object,d0
	swap	d0
	move.l	d0,OLP
	.if	SOUND_ON
	jsr	player+$20
	.endif
	move.w	#LOAD_LEVEL_STATE,current_state
	rts
.intro:
	move.l	intro_screen_list,d0
	swap	d0
	move.l	d0,OLP
	moveq	#0,d6		; les deux logos sont en place
.move_jagware:	
	move.l	#jagware_sprite,a0
	move.w	SPRITE_YPOS(a0),d0
	cmp.w	intro_jagware_ypos,d0
	ble.s	.ok_jagware
	moveq	#-1,d6		; non
	subq.w	#1,SPRITE_YPOS(a0)
	bsr	refresh_coords_sprite_object
	bra.s	.move_removers
.ok_jagware:		
	fast_refresh_nonscaled_sprite_object	a0
.move_removers:	
	move.l	#removers_sprite,a0
	move.w	SPRITE_YPOS(a0),d0
	cmp.w	intro_removers_ypos,d0
	bge.s	.ok_removers
	moveq	#-1,d6		; non
	addq.w	#1,SPRITE_YPOS(a0)
	bsr	refresh_coords_sprite_object
	bra.s	.do_intro
.ok_removers:	
	fast_refresh_nonscaled_sprite_object	a0
.do_intro:
	tst.w	d6
	bne	.end_intro
	move.l	#intro_text_sprite,a0
	tst.w	SPRITE_HEIGHT(a0)
	bne.s	.txt_visible
	move.w	#8,SPRITE_HEIGHT(a0)
	bsr	update_sprite_object
	bra.s	.txt_refresh
.txt_visible:
	fast_refresh_nonscaled_sprite_object	a0
.txt_refresh:
	move.w	intro_screen_counter,d0
	and.w	#%11,d0
	bne.s	.end_txt
	move.l	intro_screen_text_ptr,a0
	move.l	#intro_text_gfx,a1
	moveq	#0,d0
	move.b	(a0)+,d0
	bne.s	.no_loop_text
	move.w	#$ffff,intro_text_wrap
	move.l	#intro_text,a0
	move.b	(a0)+,d0
.no_loop_text:	
	cmp.b	#13,d0
	bne.s	.no_cr
	moveq	#0,d1
	move.w	#(INTRO_TEXT_WIDTH*8*8*2)/8-1,d2
.clr_text:
	move.l	d1,(a1)+
	move.l	d1,(a1)+	
	dbf	d2,.clr_text
	move.l	#intro_text_gfx,a1
	clr.w	intro_screen_text_pos
	move.b	(a0)+,d0
.no_cr:
	move.l	a0,intro_screen_text_ptr	
	cmp.b	#11,d0
	beq.s	.end_txt
	move.l	#fonte+8,a0
	lsl.w	#3,d0
	lea	(a0,d0.w),a0
	move.w	#INTRO_TEXT_WIDTH*8*2,d1
	move.w	#WHITE,d0
	move.w	intro_screen_text_pos,d2
	lea	(a1,d2.w),a1
	add.w	#16,d2
	move.w	d2,intro_screen_text_pos
	bsr	draw_char
.end_txt:	
	addq.w	#1,intro_screen_counter
.end_intro:	
	rts
.init_intro:
	move.l	#stop_object,d0
	swap	d0
	move.l	d0,OLP
	;; initialisation player de modules
	.if	SOUND_ON
	jsr	player
	move.l	#musique,a0
	jsr	player+$4
	.endif	
	;; initialisation des positions
	move.w	width,d0
	lsr.w	#2,d0
	sub.w	#256,d0
	lsr.w	#1,d0
	move.w	height,d1
	move.w	d1,d2
	move.w	a_vdb,d3
	lsr.w	#1,d3		; a_vdb en lignes
	sub.w	#64,d1		; Removers en bas
	add.w	d3,d1		; 
	move.w	d3,d2		; JagWare en haut
	move.w	d1,intro_removers_ypos
	move.w	d2,intro_jagware_ypos
	add.w	#51,d2
	sub.w	d2,d1
	lsr.w	#1,d1
	add.w	#51,d1
	move.w	d1,d2
	sub.w	#51,d2
	move.l	#removers_sprite,a0
	move.w	d0,SPRITE_XPOS(a0)
	move.w	d1,SPRITE_YPOS(a0)
	move.l	#jagware_sprite,a0
	move.w	d0,SPRITE_XPOS(a0)
	move.w	d2,SPRITE_YPOS(a0)
	move.w	width,d0
	lsr.w	#2,d0
	sub.w	#INTRO_TEXT_WIDTH*8,d0
	lsr.w	#1,d0
	move.l	#intro_text_sprite,a0
	move.w	d0,SPRITE_XPOS(a0)
	move.w	height,d0
	lsr.w	#1,d0
	move.w	a_vdb,d1
	lsr.w	#1,d1
	add.w	d1,d0
	move.w	d0,SPRITE_YPOS(a0)
	clr.w	SPRITE_HEIGHT(a0) ; on cache au debut
	;; construction de la liste
	move.l	#intro_text_sprite,a0
	move.l	#stop_object,a1
	bsr	finalize_sprite_object
	move.l	#jagware_sprite,a0
	move.l	#intro_text_sprite,a1
	bsr	finalize_sprite_object
	move.l	#removers_sprite,a0
	move.l	#jagware_sprite,a1
	bsr	finalize_sprite_object
	move.l	#stop_object,a0
	move.l	#removers_sprite,a1
	move.w	a_vde,d0
	move.w	#O_BRLT,d1
	bsr	new_branch_object
	move.l	a0,a1
	move.l	#stop_object,a0
	move.w	a_vdb,d0
	move.w	#O_BRGT,d1
	bsr	new_branch_object
	move.l	a0,intro_screen_list
	clr.w	intro_screen_counter
	move.l	#intro_text,intro_screen_text_ptr
	clr.w	intro_screen_text_pos
	move.l	#intro_text_gfx,a1
	moveq	#0,d1
	move.w	#(INTRO_TEXT_WIDTH*8*8*2)/8-1,d2
.clr:
	move.l	d1,(a1)+
	move.l	d1,(a1)+	
	dbf	d2,.clr
	clr.w	intro_text_wrap
	move.w	#$ffff,intro_screen_init_done
	rts

	.data
	.even
intro_text:
*	dc.b	13,'0123456789012345678901234567890123456789'
	dc.b	13,'         The Removers presents          ',11,11,11,11,11
	dc.b	13,'      with the support of JagWare       ',11,11,11,11,11
	dc.b	13,'            in the year 2006            ',11,11,11,11,11
	dc.b	13,'           on the Atari Jaguar          ',11,11,11,11,11
	dc.b	13,'  after a few days of intensive coding  ',11,11,11,11,11
	dc.b	13,'       a clone of the Atomix game       ',11,11,11,11,11
	dc.b	13,' With [A][C], you switch between atoms  ',11,11,11,11,11
	dc.b	13,' With [Pause], you can see the molecule ',11,11,11,11,11
	dc.b	13,' With [*], you reset the current level  ',11,11,11,11,11
	dc.b	13,' With [',1,'][',2,'][',3,'][',4,'], you move the atom',11,11,11,11,11
	dc.b	13,' You can also enter a level number...   ',11,11,11,11,11
	dc.b	13,'         ...and validate with [#]       ',11,11,11,11,11
	dc.b	13,'            Greetings go to:            ',11,11,11,11,11
	dc.b	13,'            The JagWare Team            ',11,11,11,11,11
	dc.b	13,'       Cerebral Vortex Development      ',11,11,11,11,11
	dc.b	13,'               SCPCD Corp.              ',11,11,11,11,11
	dc.b	13,'               Sector One               ',11,11,11,11,11
	dc.b	13,'                MJJ Prod                ',11,11,11,11,11
	dc.b	13,'                 U.L.M.                 ',11,11,11,11,11
	dc.b	13,'      and all the Atari community.      ',11,11,11,11,11
	dc.b	13,'                Credits:                ',11,11,11,11,11
	dc.b	13,'  Original Atomix game was invented by  ',11,11,11,11,11
	dc.b	13,'    Guenter Kraemer and Rolf Steffens   ',11,11,11,11,11
	dc.b	13,'  Graphics and Level Design were taken  ',11,11,11,11,11
	dc.b	13,' from katomic  (KDE and Qtopia version) ',11,11,11,11,11
	dc.b	13,'   by Andreas Wuest and Robert Ernst.   ',11,11,11,11,11
	dc.b	13,'        Music "Dreams of Love" by       ',11,11,11,11,11
	dc.b	13,'                 Mercury                ',11,11,11,11,11
	dc.b	13,'        Module Replay Routine is        ',11,11,11,11,11
	dc.b	13,'     (c) 1995 Sinister Developments     ',11,11,11,11,11
	;; pour l'instant, rien n'est compresse
*	dc.b	13,'        LZW Unpacking Routine by        ',11,11,11,11,11
*	dc.b	13,'         Ray (TSCC) & GT Turbo          ',11,11,11,11,11
	dc.b	13,'       All other code was made by       ',11,11,11,11,11
	dc.b	13,'            Seb/The Removers            ',11,11,11,11,11,11,11,11,11,11,11,11,11,11,11 ; ca flatte l'ego de rester a l'ecran plus longtemps :)
	dc.b	13,'             Enjoy the game             ',11,11,11,11,11
	dc.b	13,'  and be ready for our next production! ',11,11,11,11,11
	dc.b	13,11,11,11,11,11,11,11,11,11,11
	dc.b	13,'         Press [B] to start...          ',11,11,11,11,11
	dc.b	13,11,11,11,11,11,11,11,11,11,11
	dc.b	0  
	.even
	
	.bss
intro_screen_counter:	ds.w	1
intro_screen_list:	ds.l	1
intro_jagware_ypos:	ds.w	1
intro_removers_ypos:	ds.w	1
intro_screen_text_ptr:	ds.l	1
intro_screen_text_pos:	ds.w	1
intro_text_wrap:	ds.w	1
intro_screen_init_done:	ds.w	1
	.text

	;; clairement, toute la gestion du joypad est a revoir!
exec_actions:
	;; a0: adresse du tableau des actions
	;; d0: etat du joypad
	;; d7: etat courant
	;; execute la premiere action possible
	move.w	(a0)+,d5
	subq.w	#1,d5
.one_action:
	move.l	(a0)+,d1	; masque
	move.w	(a0)+,d6	; bit etat
	bsr	update_state
	tst.w	d2
	blt.s	.action_descending
	bgt.s	.action_ascending
	addq.w	#8,a0		; saute les actions
	dbf	d5,.one_action
	rts
.action_descending:
	move.l	d0,-(sp)
	move.l	4(a0),a0
	jsr	(a0)		; front descendant
	move.l	(sp)+,d0
	rts
.action_ascending:
	move.l	d0,-(sp)
	move.l	(a0),a0
	jsr	(a0)		; front ascendant
	move.l	(sp)+,d0
	rts
	
update_state:
	;; d7 contient l'etat courant
	;; d0 contient l'etat du joypad
	;; d1 contient le masque de bits du joypad a tester
	;; d6 contient le numero de bit de l'etat courant a mettre a jour
	;; si le bit d7 de d6 est mis, teste si le bouton d1 de d0 a ete relache (efface le bit d6 de d7)
	;; si le bit d7 de d6 est efface, teste si le bouton d1 de d0 a ete presse (positionne le bit d6 de d7)
	;; d2 contient 0 si pas d'evenement, 
	;;             1 si le bouton souhaite a ete presse, 
	;;         et -1 si le bouton souhaite a ete relache
	moveq	#0,d2 
	btst	d6,d7
	bne.s	.wait_release
.button_down:
	bclr	#JOY_COMBO,d1	; est-ce un combo?
	beq.s	.not_combo	; non
	not.l	d1		; on inverse (car les bits du joypad fonctionnent a l'envers)
	cmp.l	d1,d0
	bne.s	.not_down
	bset	d6,d7
	moveq	#1,d2
.not_down:
	rts
.not_combo:
	move.l	d0,d2
	not.l	d2		; on inverse
	and.l	d1,d2
	cmp.l	d1,d2
	bne.s	.not_combo_not_down
	bset	d6,d7
	moveq	#1,d2
	rts
.not_combo_not_down:
	moveq	#0,d2
	rts
.wait_release:
	bclr	#JOY_COMBO,d1	; la on veut qu'au moins un bouton soit relache...
	and.l	d0,d1
	beq.s	.not_up
	bclr	d6,d7
	moveq	#-1,d2
.not_up:
	rts

draw_word:
	;; a0: adresse de l'image
	;; d3: largeur en caracteres
	;; d5.w: entier a ecrire
	;; d0: couleur
	moveq	#0,d2
	move.l	a0,a1
	move.w	d3,d1
	lsl.w	#4,d1		; multiplie par (8*8*2)/8
	subq.w	#1,d1
.clr:
	move.l	d2,(a0)+
	move.l	d2,(a0)+
	dbf	d1,.clr
	swap	d5
	clr.w	d5
	swap	d5
	move.w	d3,d1
	lsl.w	#4,d1		; multiplie par 8*2
	subq.w	#1,d3
	move.w	d3,d2
	lsl.w	#4,d2
	add.w	d2,a1
.draw:
	divu.w	#10,d5
	swap	d5
	move.w	d5,d4		; reste
	clr.w	d5
	swap	d5
	add.w	#'0',d4		;
	lsl.w	#3,d4
	move.l	#fonte+8,a3	; adresse de la fonte
	lea	(a3,d4.w),a0	; adresse du caractere
	bsr	draw_char
	sub.w	#16,a1
	tst.w	d5
	dbeq	d3,.draw
	rts
	
draw_nb_moves:
	move.l	#nb_moves_gfx,a0
	moveq	#NB_MOVES_WIDTH,d3
	move.w	nb_moves,d5
	move.w	#CYAN,d0
	bra.s	draw_word

draw_time:
	move.l	#time_gfx,a0
	moveq	#TIME_WIDTH,d3
	move.w	nb_seconds,d5
	move.w	#RED,d0
	bra.s	draw_word
	
init_time:
	clr.w	time_counter
	clr.w	nb_seconds
	bra	draw_time
	
refresh_time:
	move.w	time_counter,d0
	addq.w	#1,d0
	moveq	#50,d2
	move.w	CONFIG,d1
	and.w	#VIDTYPE,d1
	beq.s	.pal
.ntsc:
	moveq	#60,d2
.pal:
	move.w	d0,time_counter
	cmp.w	d0,d2
	bgt.s	.no_second
	moveq	#0,d0
	addq.w	#1,nb_seconds
	bsr	draw_time
	clr.w	time_counter
.no_second:
	rts
				
init_level:
	bsr	mm_reset
	move.l	#stop_object,d0
	swap	d0
	move.l	d0,OLP
	bsr	load_level
	clr.w	nb_moves
	bsr	init_gfx_level
	move.w	#START_LEVEL_SCREEN,current_state
	clr.w	game_state
	clr.w	pause_state
	clr.w	go_level_num
	clr.w	go_level_next_digit
	bsr	init_time
	bsr	init_active_atom
	rts

	.bss
go_level_num:	ds.w	1
go_level_next_digit:	ds.w	1
	
	.text
	;; ce bout de code est hyper moche
	;; il faudra repenser un peu la gestion du joypad
	;; ici, j'ai vraiment hacke pour que ca marche mais mouais...
game_enter:
	moveq	#0,d1
.test0:	
	btst	#JOY0_0,d0
	beq.s	.ok
.test1:
	moveq	#1,d1
	btst	#JOY0_1,d0
	beq.s	.ok
.test2:
	moveq	#2,d1
	btst	#JOY0_2,d0
	beq.s	.ok
.test3:
	moveq	#3,d1
	btst	#JOY0_3,d0
	beq.s	.ok
.test4:
	moveq	#4,d1
	btst	#JOY0_4,d0
	beq.s	.ok
.test5:
	moveq	#5,d1
	btst	#JOY0_5,d0
	beq.s	.ok
.test6:
	moveq	#6,d1
	btst	#JOY0_6,d0
	beq.s	.ok
.test7:
	moveq	#7,d1
	btst	#JOY0_7,d0
	beq.s	.ok
.test8:
	moveq	#8,d1
	btst	#JOY0_8,d0
	beq.s	.ok
.test9:	
	moveq	#9,d1
.ok:
	move.w	d1,go_level_next_digit
	rts

no_game_enter:
	move.w	go_level_next_digit,d1
	beq.s	.test_0
	cmp.w	#1,d1
	beq.s	.test_1
	cmp.w	#2,d1
	beq.s	.test_2
	cmp.w	#3,d1
	beq.s	.test_3
	cmp.w	#4,d1
	beq.s	.test_4
	cmp.w	#5,d1
	beq.s	.test_5
	cmp.w	#6,d1
	beq.s	.test_6
	cmp.w	#7,d1
	beq.s	.test_7
	cmp.w	#8,d1
	beq.s	.test_8
.test_9:
	btst	#JOY0_9,d0
	bne.s	.ok
	or.w	#1<<GAME_ENTER_NUM,d7
	rts
.test_0:
	btst	#JOY0_0,d0
	bne.s	.ok
	or.w	#1<<GAME_ENTER_NUM,d7
	rts
.test_1:
	btst	#JOY0_1,d0
	bne.s	.ok
	or.w	#1<<GAME_ENTER_NUM,d7
	rts
.test_2:
	btst	#JOY0_2,d0
	bne.s	.ok
	or.w	#1<<GAME_ENTER_NUM,d7
	rts
.test_3:
	btst	#JOY0_3,d0
	bne.s	.ok
	or.w	#1<<GAME_ENTER_NUM,d7
	rts
.test_4:
	btst	#JOY0_4,d0
	bne.s	.ok
	or.w	#1<<GAME_ENTER_NUM,d7
	rts
.test_5:
	btst	#JOY0_5,d0
	bne.s	.ok
	or.w	#1<<GAME_ENTER_NUM,d7
	rts
.test_6:
	btst	#JOY0_6,d0
	bne.s	.ok
	or.w	#1<<GAME_ENTER_NUM,d7
	rts
.test_7:
	btst	#JOY0_7,d0
	bne.s	.ok
	or.w	#1<<GAME_ENTER_NUM,d7
	rts
.test_8:
	btst	#JOY0_8,d0
	bne.s	.ok
	or.w	#1<<GAME_ENTER_NUM,d7
	rts
.ok:	
	moveq	#0,d0
	move.w	go_level_num,d0
	mulu.w	#10,d0
	add.w	d1,d0
	move.w	d0,go_level_num
	rts
	
game_validate:	
	move.w	go_level_num,d1
	bge.s	.ok_0
	clr.w	go_level_num
	clr.w	go_level_next_digit
	rts
.ok_0:
	cmp.w	nb_levels,d1
	blt.s	.ok
	clr.w	go_level_num
	clr.w	go_level_next_digit
	rts
.ok:	
	move.w	d1,current_level
	move.w	#LOAD_LEVEL_STATE,current_state
	rts


game_screen:
	;; mise a jour de la liste de sprites
	move.l	level_sprites_list_adr,d0
	swap	d0
	move.l	d0,OLP
	move.l	level_sprites_adr,a1
	move.w	level_nb_sprites,d0
	subq.w	#1,d0
.refresh_level:
	move.l	(a1)+,a0
	fast_refresh_nonscaled_sprite_object	a0
	dbf	d0,.refresh_level
	move.l	#up_sprite,a0
	fast_refresh_nonscaled_sprite_object	a0
	move.l	#down_sprite,a0
	fast_refresh_nonscaled_sprite_object	a0
	move.l	#left_sprite,a0
	fast_refresh_nonscaled_sprite_object	a0
	move.l	#right_sprite,a0
	fast_refresh_nonscaled_sprite_object	a0
	move.l	#nb_moves_sprite,a0
	fast_refresh_nonscaled_sprite_object	a0
	move.l	#time_sprite,a0
	fast_refresh_nonscaled_sprite_object	a0
	;; rafraichissement du temps
	bsr	refresh_time
	;; gestion du jeu
	move.l	joypad_state,d0
	move.w	game_state,d7
	move.l	#game_actions,a0
	move.w	#GAME_NB_ACTION_IDLE,(a0)
	move.w	#(1<<GAME_GO_LEFT)|(1<<GAME_GO_RIGHT)|(1<<GAME_GO_UP)|(1<<GAME_GO_DOWN),d6
	and.w	d7,d6
	beq.s	.ok_actions
	move.w	#GAME_NB_ACTION_MOVING,(a0)
.ok_actions:	
	bsr	exec_actions
	move.w	d7,game_state
	move.w	#(1<<GAME_GO_LEFT)|(1<<GAME_GO_RIGHT)|(1<<GAME_GO_UP)|(1<<GAME_GO_DOWN),d6
	and.w	d7,d6
	beq	.no_move
.move_it:	
	move.l	active_atom_sprite,a0
	move.w	active_atom_xpos,d3
	move.w	active_atom_ypos,d4
	move.w	active_atom_dest_xpos,d5
	move.w	active_atom_dest_ypos,d6
	add.w	active_atom_inc_xpos,d3
	add.w	active_atom_inc_ypos,d4
	move.w	d3,active_atom_xpos
	move.w	d4,active_atom_ypos
	move.w	d3,SPRITE_XPOS(a0)
	move.w	d4,SPRITE_YPOS(a0)
	bsr	refresh_coords_sprite_object
.tst_end_move:	
	cmp.w	d3,d5
	bne	.no_end_move
	cmp.w	d4,d6
	bne	.no_end_move
.end_move:
	move.w	#~((1<<GAME_GO_LEFT)|(1<<GAME_GO_RIGHT)|(1<<GAME_GO_UP)|(1<<GAME_GO_DOWN)),d6
	and.w	d7,d6
	move.w	d6,game_state
	move.l	#level_map,a0
	move.l	a0,a1
	move.w	active_atom_x,d0
	lsl.w	#3,d0
	add.w	d0,a0
	move.w	active_atom_y,d0
	lsl.w	#3+4,d0
	add.w	d0,a0		; on est cale sur l'atome qui a bouge
	move.w	active_atom_dest_x,d0
	move.w	d0,active_atom_x
	lsl.w	#3,d0
	add.w	d0,a1
	move.w	active_atom_dest_y,d0
	move.w	d0,active_atom_y
	lsl.w	#3+4,d0
	add.w	d0,a1		; son nouvel emplacement
	move.l	(a0),(a1)+	; copie les valeurs
	clr.l	(a0)+		; efface
	move.l	(a0),(a1)+
	clr.l	(a0)+
	bsr	compute_auth_moves
	addq.w	#1,nb_moves	; un mouvement de plus!
	bsr	draw_nb_moves
	bsr	tst_level_solved
	tst.w	d0
	beq.s	.not_solved
	bsr	play_applause_sound
	bsr	game_go_next_action
.not_solved:	
.no_end_move:	
.no_move:		
	rts

play_applause_sound:
	.if	SOUND_ON
	move.l	#applause,a0
	move.l	#applause_end-applause,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	moveq	#0,d4
	move.l	#0,a1
	jsr	player+$c
	.endif
	rts
	
game_go_pause_action:
*	and.l	#~((1<<GAME_GO_PREV) | (1<<GAME_GO_NEXT)),d7
	move.w	#PAUSE_SCREEN_STATE,current_state
	rts

game_reinit_action:
	move.w	#LOAD_LEVEL_STATE,current_state
	rts
	
game_go_prev_action:
	bsr	previous_level
	move.w	#LOAD_LEVEL_STATE,current_state
	rts

game_go_next_action:
	bsr	next_level
	move.w	#LOAD_LEVEL_STATE,current_state
	rts

game_reset:
	jmp	start
	
no_action:
	rts
	
	.data
	;; tableau des actions possibles
	;; le premier mot donne le nombre d'actions
	;; une action se decompose en
	;; un mot long qui donne le masque des boutons qu'on veut tester
	;; on doit aussi mettre le bit JOY_COMBO si on veut un match exact
	;; ensuite, le mot suivant indique le numero de bit a basculer dans l'etat (l'etat est sur 16 bits ici)
	;; suivent ensuite l'adresse des deux routines suivant qu'on teste
	;; le front montant ou descendant...
game_actions:
	dc.w	GAME_NB_ACTION_IDLE
	;;
	dc.l	(1<<JOY_COMBO)|(1<<JOY0_STAR)|(1<<JOY0_SHARP)
	dc.w	GAME_GO_RESET
	dc.l	game_reset,no_action
	;; 
	dc.l	1<<JOY0_PAUSE
	dc.w	GAME_GO_PAUSE
	dc.l	no_action,game_go_pause_action
	;;
	dc.l	1<<JOY0_STAR
	dc.w	GAME_REINIT
	dc.l	no_action,game_reinit_action
	;;
*	dc.l	(1<<JOY_COMBO)|(1<<JOY0_B)|(1<<JOY0_STAR)
*	dc.w	GAME_GO_PREV
*	dc.l	no_action,game_go_prev_action
	;;
*	dc.l	(1<<JOY_COMBO)|(1<<JOY0_B)|(1<<JOY0_SHARP)
*	dc.w	GAME_GO_NEXT
*	dc.l	no_action,game_go_next_action
	;;
	dc.l	(1<<JOY_COMBO)|(1<<JOY0_0)
	dc.w	GAME_ENTER_NUM
	dc.l	game_enter,no_game_enter
	;; 
	dc.l	(1<<JOY_COMBO)|(1<<JOY0_1)
	dc.w	GAME_ENTER_NUM
	dc.l	game_enter,no_game_enter
	;; 
	dc.l	(1<<JOY_COMBO)|(1<<JOY0_2)
	dc.w	GAME_ENTER_NUM
	dc.l	game_enter,no_game_enter
	;; 
	dc.l	(1<<JOY_COMBO)|(1<<JOY0_3)
	dc.w	GAME_ENTER_NUM
	dc.l	game_enter,no_game_enter
	;; 
	dc.l	(1<<JOY_COMBO)|(1<<JOY0_4)
	dc.w	GAME_ENTER_NUM
	dc.l	game_enter,no_game_enter
	;; 
	dc.l	(1<<JOY_COMBO)|(1<<JOY0_5)
	dc.w	GAME_ENTER_NUM
	dc.l	game_enter,no_game_enter
	;; 
	dc.l	(1<<JOY_COMBO)|(1<<JOY0_6)
	dc.w	GAME_ENTER_NUM
	dc.l	game_enter,no_game_enter
	;; 
	dc.l	(1<<JOY_COMBO)|(1<<JOY0_7)
	dc.w	GAME_ENTER_NUM
	dc.l	game_enter,no_game_enter
	;; 
	dc.l	(1<<JOY_COMBO)|(1<<JOY0_8)
	dc.w	GAME_ENTER_NUM
	dc.l	game_enter,no_game_enter
	;; 
	dc.l	(1<<JOY_COMBO)|(1<<JOY0_9)
	dc.w	GAME_ENTER_NUM
	dc.l	game_enter,no_game_enter
	;; 
	dc.l	(1<<JOY_COMBO)|(1<<JOY0_SHARP)
	dc.w	GAME_VALIDATE_NUM
	dc.l	no_action,game_validate
	;; 
	dc.l	1<<JOY0_A
	dc.w	GAME_CHG_BACK
	dc.l	no_action,game_atom_backward_action
	;; 
	dc.l	1<<JOY0_C
	dc.w	GAME_CHG_FORW
	dc.l	no_action,game_atom_forward_action
	;; 
	dc.l	1<<JOY0_L
	dc.w	GAME_GO_LEFT
	dc.l	game_go_left_action,no_action
	;; 
	dc.l	1<<JOY0_R
	dc.w	GAME_GO_RIGHT
	dc.l	game_go_right_action,no_action
	;; 
	dc.l	1<<JOY0_U
	dc.w	GAME_GO_UP
	dc.l	game_go_up_action,no_action
	;; 
	dc.l	1<<JOY0_D
	dc.w	GAME_GO_DOWN
	dc.l	game_go_down_action,no_action
game_actions_end:

	.if	(((game_actions_end-game_actions-2))/14)<>GAME_NB_ACTION_IDLE
	.print	"GAME_NB_ACTION_IDLE is wrong"
	.fail
	.endif
	
	.text
	
game_atom_forward_action:
	move.w	active_atom_x,d2
	move.w	active_atom_y,d3
	move.l	#level_map,a1
	bsr	compute_next_atom
	move.w	d2,active_atom_x
	move.w	d3,active_atom_y
	bsr	compute_auth_moves
	rts

game_atom_backward_action:
	move.w	active_atom_x,d2
	move.w	active_atom_y,d3
	move.l	#level_map,a1
	bsr	compute_previous_atom
	move.w	d2,active_atom_x
	move.w	d3,active_atom_y
	bsr	compute_auth_moves
	rts

; play_launch_sound:
; 	movem.l	d0-d7/a0-a6,-(sp)
; 	move.l	#launch,a0
; 	move.l	#launch_end-launch,d0
; 	moveq	#0,d1
; 	moveq	#0,d2
; 	moveq	#0,d3
; 	moveq	#0,d4
; 	move.l	#0,a1
; 	jsr	player+$c
; 	movem.l	(sp)+,d0-d7/a0-a6
; 	rts
		
game_go_left_action:
	move.w	active_atom_auth_moves,d0
.valid_move:	
	btst	#ATOM_CAN_GO_LEFT,d0
	bne.s	.invalid_move
	move.l	#level_map,a0
	move.w	active_atom_x,d0
	move.w	d0,d1		; sauve x
	lsl.w	#3,d0		; 8 octets par element
	add.w	d0,a0
	move.w	active_atom_y,d0
	move.w	d0,active_atom_dest_y ; on ne bouge pas en ordonnee
	lsl.w	#3+4,d0		; 128 octets par ligne
	add.w	d0,a0		; se cale sur le sprite
	move.l	4(a0),a1	; adresse du sprite
	move.l	a1,active_atom_sprite ; on sauve
	;; calcul de la destination
	move.w	#-INCX,active_atom_inc_xpos	; -1 (pour aller a gauche)
	clr.w	active_atom_inc_ypos	; on reste a le meme ordonnee 
	move.w	SPRITE_XPOS(a1),d2 ; abscisse actuelle
	moveq	#16,d3		; pour le sub
	move.w	d2,active_atom_xpos
.search_dest_x:
	tst.w	-8(a0)		; quelque chose a gauche?
	bne.s	.found		; oui, on s'arrete
	subq.w	#1,d1
	subq.w	#8,a0
	sub.w	d3,d2
	bra.s	.search_dest_x
.found:
	move.w	d1,active_atom_dest_x
	move.w	d2,active_atom_dest_xpos
	move.w	SPRITE_YPOS(a1),d2
	move.w	d2,active_atom_ypos
	move.w	d2,active_atom_dest_ypos
	bra	hide_arrows
.invalid_move:
	bclr	#GAME_GO_LEFT,d7
	rts

game_go_right_action:
	move.w	active_atom_auth_moves,d0
.valid_move:	
	btst	#ATOM_CAN_GO_RIGHT,d0
	bne.s	.invalid_move
	move.l	#level_map,a0
	move.w	active_atom_x,d0
	move.w	d0,d1		; sauve x
	lsl.w	#3,d0		; 8 octets par element
	add.w	d0,a0
	move.w	active_atom_y,d0
	move.w	d0,active_atom_dest_y ; on ne bouge pas en ordonnee
	lsl.w	#3+4,d0		; 128 octets par ligne
	add.w	d0,a0		; se cale sur le sprite
	move.l	4(a0),a1	; adresse du sprite
	move.l	a1,active_atom_sprite ; on sauve
	;; calcul de la destination
	move.w	#INCX,active_atom_inc_xpos	; +1 (pour aller a droite)
	clr.w	active_atom_inc_ypos	; on reste a le meme ordonnee 
	move.w	SPRITE_XPOS(a1),d2 ; abscisse actuelle
	moveq	#16,d3		; pour le add
	move.w	d2,active_atom_xpos
.search_dest_x:
	tst.w	8(a0)		; quelque chose a droite?
	bne.s	.found		; oui, on s'arrete
	addq.w	#1,d1
	addq.w	#8,a0
	add.w	d3,d2
	bra.s	.search_dest_x
.found:
	move.w	d1,active_atom_dest_x
	move.w	d2,active_atom_dest_xpos
	move.w	SPRITE_YPOS(a1),d2
	move.w	d2,active_atom_ypos
	move.w	d2,active_atom_dest_ypos
	bra	hide_arrows
.invalid_move:
	bclr	#GAME_GO_RIGHT,d7
	rts

game_go_down_action:
	move.w	active_atom_auth_moves,d0
.valid_move:	
	btst	#ATOM_CAN_GO_DOWN,d0
	bne.s	.invalid_move
	move.l	#level_map,a0
	move.w	active_atom_x,d0
	move.w	d0,active_atom_dest_x	; on ne bouge pas en abscisse
	lsl.w	#3,d0		; 8 octets par element
	add.w	d0,a0
	move.w	active_atom_y,d0
	move.w	d0,d1		; sauve y
	lsl.w	#3+4,d0		; 128 octets par ligne
	add.w	d0,a0		; se cale sur le sprite
	move.l	4(a0),a1	; adresse du sprite
	move.l	a1,active_atom_sprite ; on sauve
	;; calcul de la destination
	clr.w	active_atom_inc_xpos	; on reste a la meme abscisse
	move.w	#INCY,active_atom_inc_ypos	; +1 pour aller en bas
	move.w	SPRITE_XPOS(a1),d2 ; abscisse actuelle
	move.w	d2,active_atom_xpos
	move.w	d2,active_atom_dest_xpos
	move.w	SPRITE_YPOS(a1),d2 ; ordonnee actuelle
	move.w	d2,active_atom_ypos
	moveq	#16,d3		; pour le add 
.search_dest_x:
	tst.w	128(a0)		; quelque chose a en bas?
	bne.s	.found		; oui, on s'arrete
	addq.w	#1,d1
	lea	128(a0),a0
	add.w	d3,d2
	bra.s	.search_dest_x
.found:
	move.w	d1,active_atom_dest_y
	move.w	d2,active_atom_dest_ypos
	bra	hide_arrows
.invalid_move:
	bclr	#GAME_GO_DOWN,d7
	rts

game_go_up_action:
	move.w	active_atom_auth_moves,d0
.valid_move:	
	btst	#ATOM_CAN_GO_UP,d0
	bne.s	.invalid_move
	move.l	#level_map,a0
	move.w	active_atom_x,d0
	move.w	d0,active_atom_dest_x	; on ne bouge pas en abscisse
	lsl.w	#3,d0		; 8 octets par element
	add.w	d0,a0
	move.w	active_atom_y,d0
	move.w	d0,d1		; sauve y
	lsl.w	#3+4,d0		; 128 octets par ligne
	add.w	d0,a0		; se cale sur le sprite
	move.l	4(a0),a1	; adresse du sprite
	move.l	a1,active_atom_sprite ; on sauve
	;; calcul de la destination
	clr.w	active_atom_inc_xpos	; on reste a la meme abscisse
	move.w	#-INCY,active_atom_inc_ypos	; +1 pour aller en haut
	move.w	SPRITE_XPOS(a1),d2 ; abscisse actuelle
	move.w	d2,active_atom_xpos
	move.w	d2,active_atom_dest_xpos
	move.w	SPRITE_YPOS(a1),d2 ; ordonnee actuelle
	move.w	d2,active_atom_ypos
	moveq	#16,d3		; pour le add 
.search_dest_x:
	tst.w	-128(a0)		; quelque chose a en bas?
	bne.s	.found		; oui, on s'arrete
	subq.w	#1,d1
	lea	-128(a0),a0
	sub.w	d3,d2
	bra.s	.search_dest_x
.found:
	move.w	d1,active_atom_dest_y
	move.w	d2,active_atom_dest_ypos
	bra.s	hide_arrows
.invalid_move:
	bclr	#GAME_GO_UP,d7
	rts

tst_level_solved:
	move.l	#level_map,a1
	bsr	compute_downer_right_atom
	move.w	d2,d6		; on sauve
	move.w	d3,d7
	move.l	#mole_map,a1
	bsr	compute_downer_right_atom
	move.l	#level_map,a0
	move.w	d6,d0
	lsl.w	#3,d0		; *8
	add.w	d0,a0
	move.w	d7,d0
	lsl.w	#3+4,d0		; *8*16
	add.w	d0,a0		; on est cale sur l'atome le plus en bas a droite dans le niveau
	move.l	#mole_map,a1
	move.w	d2,d0
	lsl.w	#3,d0		; *8
	add.w	d0,a1
	move.w	d3,d0
	lsl.w	#3+4,d0		; *8*16
	add.w	d0,a1		; on est cale sur l'atome le plus en bas a droite dans la molecule
	moveq	#0,d0		; par defaut, pas resolu
.cmp_line:
.cmp_column:
	move.w	(a1),d5		; un atome ici?
	beq.s	.no_atom
.atom:
	tst.w	d6		; on teste si on est dans la bonne fenetre
	blt.s	.not_solved
	cmp.w	#16-1,d6
	bgt.s	.not_solved
	tst.w	d7
	blt.s	.not_solved
	cmp.w	#16-1,d7
	bgt.s	.not_solved
	cmp.w	(a0),d5		; on compare
	bne.s	.not_solved
.no_atom:
	subq.w	#8,a1
	subq.w	#8,a0
	subq.w	#1,d6
	dbf	d2,.cmp_column
	moveq	#16-1,d2	; toute la largeur
	add.w	#16,d6		; pas sur...
	subq.w	#1,d7
	dbf	d3,.cmp_line
	moveq	#-1,d0		; si on arrive la, c'est resolu
.not_solved:	
	rts
	
hide_arrows:
	move.l	#down_sprite,a0
	clr.w	SPRITE_HEIGHT(a0)
	bsr	update_sprite_object
	move.l	#up_sprite,a0
	clr.w	SPRITE_HEIGHT(a0)
	bsr	update_sprite_object
	move.l	#left_sprite,a0
	clr.w	SPRITE_HEIGHT(a0)
	bsr	update_sprite_object
	move.l	#right_sprite,a0
	clr.w	SPRITE_HEIGHT(a0)
	bsr	update_sprite_object
; 	bsr	play_launch_sound 
	rts
	
pause_actions:
	dc.w	2
	;; 
	dc.l	(1<<JOY_COMBO)|(1<<JOY0_STAR)|(1<<JOY0_SHARP)
	dc.w	PAUSE_GO_RESET
	dc.l	game_reset,no_action
	;; 
	dc.l	1<<JOY0_PAUSE
	dc.w	PAUSE_GO_GAME
	dc.l	no_action,pause_go_game_action

	.text
				
pause_screen:
	move.l	mole_sprites_list_adr,d0
	swap	d0
	move.l	d0,OLP
	move.l	mole_sprites_adr,a1
	move.w	mole_nb_sprites,d0
	subq.w	#1,d0
.refresh_level:
	move.l	(a1)+,a0
	fast_refresh_nonscaled_sprite_object	a0
	dbf	d0,.refresh_level
	move.l	#mole_name_sprite,a0
	fast_refresh_nonscaled_sprite_object	a0
	move.l	#level_num_sprite,a0
	fast_refresh_nonscaled_sprite_object	a0
	move.l	joypad_state,d0
	move.w	pause_state,d7
	move.l	#pause_actions,a0
	bsr	exec_actions
	move.w	d7,pause_state
	rts

pause_go_game_action:
	move.w	#GAME_SCREEN_STATE,current_state
	rts

init_game:
	move.w	#START_LEVEL,current_level
	move.w	#INTRO_SCREEN_STATE,current_state
	clr.w	intro_screen_init_done
	rts

go_intro:
	bsr	mm_reset
	move.w	#INTRO_SCREEN_STATE,current_state
	clr.w	intro_screen_init_done
	rts
	
init_active_atom:
	move.l	#level_map,a1
	bsr.s	compute_upper_left_atom
	move.w	d2,active_atom_x
	move.w	d3,active_atom_y
	bsr	compute_auth_moves
	rts

compute_upper_left_atom:
	;; modifie d0,d1,d2,d3,a0
	;; renvoie x dans d2 et y dans d3
	;; a1 contient l'adresse de la carte
	moveq	#-1,d2
	moveq	#0,d3
compute_next_atom:
	;; d2 contient x
	;; d3 contient y
	;; a1 contient l'adresse de la carte	
	;; a la fin d2 et d3 sont modifies pour etre sur l'atome suivant
	move.l	a1,a0
	addq.w	#1,d2
.tst_next_line:	
	cmp.w	#16,d2
	bne.s	.ok_next_line
	clr.w	d2
	addq.w	#1,d3
.tst_go_begin:
	cmp.w	#16,d3
	beq.s	.not_found
.ok_next_line:	
	move.w	d2,d0
	lsl.w	#3,d0		; *8
	add.w	d0,a0
	move.w	d3,d0
	lsl.w	#3+4,d0		; *8*16
	add.w	d0,a0		; on est cale sur l'atome en cours (enfin juste apres)
	move.w	level_h,d0
	sub.w	d3,d0		; nb de lignes jusqu'a la fin du tableau
	moveq	#16-1,d1
	sub.w	d2,d1		; nb d'atomes sur le reste de la ligne
.search_line:
.search_column:	
	tst.w	(a0)+
	bgt.s	.found
	addq.w	#6,a0
	addq.w	#1,d2
	dbf	d1,.search_column
	addq.w	#1,d3
	moveq	#0,d2		; x a zero
	moveq	#16-1,d1	; toute la largeur
	dbf	d0,.search_line
.not_found:
	bra	compute_upper_left_atom
.found:	
	rts

compute_downer_right_atom:
	;; modifie d0,d1,d2,d3,a0
	;; renvoie x dans d2 et y dans d3
	moveq	#16,d2
	moveq	#15,d3
compute_previous_atom:	
	;; d2 contient x
	;; d3 contient y
	;; a1 contient l'adresse de la carte
	;; a la fin d2 et d3 sont modifies pour etre sur l'atome precedent
	move.l	a1,a0
	subq.w	#1,d2
.tst_prev_line:	
	bge.s	.ok_prev_line
	moveq	#16-1,d2
	subq.w	#1,d3
	blt.s	.not_found
.ok_prev_line:	
	move.w	d2,d0
	lsl.w	#3,d0		; *8
	add.w	d0,a0
	move.w	d3,d0
	lsl.w	#3+4,d0		; *8*16
	add.w	d0,a0		; on est cale sur l'atome en cours (enfin juste avant)
.search_line:
.search_column:	
	tst.w	(a0)
	bgt.s	.found
	subq.w	#8,a0
	dbf	d2,.search_column
	moveq	#16-1,d2
	dbf	d3,.search_line
.not_found:	
	bra	compute_downer_right_atom
.found:	
	rts	
		
next_level:
	move.w	current_level,d0
	addq.w	#1,d0
	cmp.w	nb_levels,d0
	bne.s	.ok
	clr.w	d0
.ok:
	move.w	d0,current_level
	rts

compute_auth_moves:
	;; modifie a0, a1, a2, d0, d1, d2, d3
	move.l	#level_map,a0
	move.w	active_atom_x,d0
	lsl.w	#3,d0		; *8 (deux mots longs par element)
	add.w	d0,a0
	move.w	active_atom_y,d0
	lsl.w	#3+4,d0		; *8*16 = 128 (pour une ligne entiere)
	add.w	d0,a0		; on est cale sur l'atome actif
	move.l	4(a0),a1	; adresse du sprite
	move.w	SPRITE_XPOS(a1),d1
	move.w	SPRITE_YPOS(a1),d2
	move.l	#left_sprite,a2
	move.w	d2,SPRITE_YPOS(a2)
	move.w	d1,d3
	sub.w	#16,d3
	move.w	d3,SPRITE_XPOS(a2)
	move.w	#16,SPRITE_HEIGHT(a2)
	moveq	#0,d0
.tst_left:	
	tst.w	-8(a0)		; quelque chose a gauche ?
	beq.s	.tst_right
	bset	#ATOM_CAN_GO_LEFT,d0
	clr.w	SPRITE_HEIGHT(a2)
.tst_right:
	move.l	#right_sprite,a2
	move.w	d2,SPRITE_YPOS(a2)
	move.w	d1,d3
	add.w	#16,d3
	move.w	d3,SPRITE_XPOS(a2)
	move.w	#16,SPRITE_HEIGHT(a2)
	tst.w	8(a0)
	beq.s	.tst_down
	bset	#ATOM_CAN_GO_RIGHT,d0
	clr.w	SPRITE_HEIGHT(a2)
.tst_down:
	move.l	#down_sprite,a2
	move.w	d1,SPRITE_XPOS(a2)
	move.w	d2,d3
	add.w	#16,d3
	move.w	d3,SPRITE_YPOS(a2)
	move.w	#16,SPRITE_HEIGHT(a2)
	tst.w	128(a0)
	beq.s	.tst_up
	bset	#ATOM_CAN_GO_DOWN,d0
	clr.w	SPRITE_HEIGHT(a2)
.tst_up:
	move.l	#up_sprite,a2
	move.w	d1,SPRITE_XPOS(a2)
	move.w	d2,d3
	sub.w	#16,d3
	move.w	d3,SPRITE_YPOS(a2)
	move.w	#16,SPRITE_HEIGHT(a2)
	tst.w	-128(a0)
	beq.s	.tst_done
	bset	#ATOM_CAN_GO_UP,d0
	clr.w	SPRITE_HEIGHT(a2)
.tst_done:
	move.w	d0,active_atom_auth_moves
	move.l	#left_sprite,a0
	bsr	update_sprite_object
	move.l	#right_sprite,a0
	bsr	update_sprite_object
	move.l	#down_sprite,a0
	bsr	update_sprite_object
	move.l	#up_sprite,a0
	bsr	update_sprite_object
	rts
	
previous_level:
	move.w	current_level,d0
	bne.s	.ok
	move.w	nb_levels,d0
.ok:
	subq.w	#1,d0
	move.w	d0,current_level
	rts
	
load_level:
	movem.l	d0-d7/a0-a6,-(sp)
	move.w	current_level,d0
	move.l	#levels,a0
	lsl.w	#2,d0		; *4
	move.l	(a0,d0.w),a0	; adresse du niveau
	;; copie du niveau
	;; remise  zero
	move.l	#level_map,a1
	move.w	#(16*16*2*4)/4-1,d0
.clear_level:	
	clr.l	(a1)+
	dbf	d0,.clear_level
	;; copie proprement dite
	move.l	#level_map,a1
	move.w	(a0)+,level_nb_sprites	; nb sprites en tout
	move.w	(a0)+,level_w	; level_w
	move.w	(a0)+,d0
	move.w	d0,level_h	; level_h
.copy_level_line:
	move.l	a1,a2
	add.w	#16*2*4,a1	; passe a la prochaine ligne
	move.w	level_w,d1
.copy_level_column:
	move.w	(a0)+,(a2)+
	clr.w	(a2)+		; ?
	clr.l	(a2)+		; pas de sprite pour l'instant
	dbf	d1,.copy_level_column
	dbf	d0,.copy_level_line
	;; copie de la molecule
	;; remise a zero
	move.l	#mole_map,a1
	move.w	#(16*16*2*4)/4-1,d0
.clear_mole:
	clr.l	(a1)+
	dbf	d0,.clear_mole
	;; copie proprement dite
	move.l	#mole_map,a1
	move.w	(a0)+,mole_nb_sprites ; nb sprites pour la molcule elle mme
	move.w	(a0)+,mole_w
	move.w	(a0)+,d0
	move.w	d0,mole_h
.copy_mole_line:
	move.l	a1,a2
	add.w	#16*2*4,a1	; passe a la prochaine ligne
	move.w	mole_w,d1
.copy_mole_column:
	move.w	(a0)+,(a2)+
	clr.w	(a2)+		; ?
	clr.l	(a2)+		; pas de sprite pour l'instant
	dbf	d1,.copy_mole_column
	dbf	d0,.copy_mole_line
	moveq	#0,d0
	move.w	(a0)+,d0	; nombre d'atomes differents
	move.w	d0,nb_atoms
	move.l	a0,-(sp)
	lsl.l	#3,d0		; *8 car un atome consiste en ses caractristiques (un long)
				; et un pointeur sur son image
	bsr	mm_alloc	; alloue autant de places que d'atomes
	move.l	a0,atoms_adr
	move.l	(sp)+,a1
	move.w	nb_atoms,d0
	subq.w	#1,d0		; pour le dbf
.copy_atoms:
	move.l	(a1)+,(a0)+
	clr.l	(a0)+		; pour l'instant pas d'image
	dbf	d0,.copy_atoms
	move.l	#mole_name,a0
	moveq	#MOLE_NAME_WIDTH-1,d0
.copy_name:
	move.b	(a1)+,(a0)+
	dbeq	d0,.copy_name
	moveq	#MOLE_NAME_WIDTH-1,d1
	sub.w	d0,d1
	move.w	d1,mole_name_length	
	movem.l	(sp)+,d0-d7/a0-a6
	rts

init_gfx_level:
	;; construction des images des atomes utilises
	move.w	nb_atoms,d7
	subq.w	#1,d7		; pour le dbf
	move.l	atoms_adr,a3
.create_atoms:
	move.w	(a3)+,d3	; numero d'atome
	move.w	(a3)+,d4	; liaisons
	move.l	#16*16*2,d0	; taille d'un sprite
	bsr	mm_alloc
	move.l	a0,(a3)+	; on sauve l'adresse des donnees
	move.l	a0,a1
	move.l	#atoms,a4	; les atomes
	subq.w	#1,d3		; -1 car on commence a zero
	lsl.w	#2,d3		; numero*4
	.if	BLITTER
	wait_blitter	d0
	move.l	a0,A1_BASE	; destination
	move.l	#0,A1_PIXEL
	move.l	#PIXEL16|XADDPHR|PITCH1,A1_FLAGS
	move.l	(a4,d3.w),A2_BASE ; source
	move.l	#0,A2_PIXEL
	move.l	#PIXEL16|XADDPHR|PITCH1,A2_FLAGS
	moveq	#1,d0
	swap	d0
	move.w	#16*16,d0
	move.l	d0,B_COUNT
	move.l	#LFU_REPLACE|SRCEN,B_CMD
	.else
	move.l	(a4,d3.w),a4	; on est au debut de l'atome
	move.w	#16*16-1,d0
	;; copie l'image de l'atome
.copy_atom:
	move.w	(a4)+,(a1)+
	dbf	d0,.copy_atom
	.endif
	move.l	#connections,a4	; debut des connections
	moveq	#16-1,d0	; 16 connections possibles
.make_links:
	move.l	(a4)+,a5	; a5 pointe au debut du lien actuellement considere
	lsl.w	#1,d4
	bcc.s	.no_link
	.if	BLITTER
	wait_blitter	d2
	move.l	a0,A1_BASE	; destination
	move.l	#0,A1_PIXEL
	move.l	#PIXEL16|XADDPHR|PITCH1,A1_FLAGS
	move.l	a5,A2_BASE	; source
	move.l	#0,A2_PIXEL
	move.l	#PIXEL16|XADDPHR|PITCH1,A2_FLAGS
	moveq	#1,d2
	swap	d2
	move.w	#16*16,d2
	move.l	d2,B_COUNT
	move.l	#LFU_SXORD|DSTEN|SRCEN,B_CMD
	.else
	move.l	a0,a1
	move.w	#16*16-1,d2
.xor_link:
	move.w	(a5)+,d1
	eor.w	d1,(a1)+
	dbf	d2,.xor_link
	.endif
.no_link:
	dbf	d0,.make_links
	dbf	d7,.create_atoms
	;; construction de la liste des sprites pour le level en cours
	move.w	level_nb_sprites,d0 ; nombre de sprites
	move.l	#level_map,a2	; le tableau
*	move.w	#XMIN,d2	; xmin	
	move.w	width,d2
	lsr.w	#2,d2		; divise par 4 (pixel divisor)
	move.w	level_w,d3	; largeur en sprites du tableau
	lsl.l	#4,d3		; *16 pour l'avoir en pixels
	sub.w	d3,d2		; on soustrait
	lsr.w	#1,d2		; image centree en largeur
*	move.w	#YMIN,d3	; ymin	
	move.w	height,d3
	move.w	level_h,d4	; hauteur en sprites du tableau
	lsl.w	#4,d4		; *16 pour l'avoir en pixel
	sub.w	d4,d3		; on soustrait
	lsr.w	#1,d3		; on centre
	move.w	a_vdb,d4	; ajoute a_vdb
	lsr.w	#1,d4		; il est en demi lignes
	add.w	d4,d3		; voila
	move.l	atoms_adr,a3
	move.w	level_h,d7
	move.l	#right_sprite,a6	; queue de liste
	bsr	gen_board_sprite_and_sprite_list
	move.l	a0,level_sprites_adr
	move.l	a1,level_sprites_list_adr
	move.l	#right_sprite,a0
	move.l	#left_sprite,a1
	bsr	finalize_sprite_object
	move.l	#left_sprite,a0
	move.l	#down_sprite,a1
	bsr	finalize_sprite_object
	move.l	#down_sprite,a0
	move.l	#up_sprite,a1
	bsr	finalize_sprite_object
	move.l	#up_sprite,a0
	move.l	#nb_moves_sprite,a1
	bsr	finalize_sprite_object
	move.l	#nb_moves_sprite,a0
	move.w	width,d2
	lsr.w	#2,d2
	sub.w	#NB_MOVES_WIDTH*8+16,d2
	move.w	d2,SPRITE_XPOS(a0)
	move.w	height,d2
	sub.w	#20,d2
	move.w	a_vdb,d4
	lsr.w	#1,d4		; ajoute a_vdb (en demi-lignes)
	add.w	d4,d2
	move.w	d2,SPRITE_YPOS(a0)
	move.l	#time_sprite,a1
	bsr	finalize_sprite_object
	move.l	#time_sprite,a0
	move.w	#16,SPRITE_XPOS(a0)
	move.w	height,d2
	sub.w	#20,d2
	move.w	a_vdb,d4
	lsr.w	#1,d4		; ajoute a_vdb (en demi-lignes)
	add.w	d4,d2
	move.w	d2,SPRITE_YPOS(a0)
	move.l	#stop_object,a1
	bsr	finalize_sprite_object
	;; construction de la liste des sprites pour la molecule en cours
	move.w	mole_nb_sprites,d0 ; nombre de sprites
	move.l	#mole_map,a2	; le tableau
*	move.w	#XMIN,d2	; xmin
	move.w	width,d2
	lsr.w	#2,d2		; divise par 4 (pixel divisor)
	move.w	mole_w,d3	; largeur en sprites de la molecule
	lsl.l	#4,d3		; *16 pour l'avoir en pixels
	sub.w	d3,d2		; on soustrait
	lsr.w	#1,d2		; image centree en largeur
*	move.w	#YMIN,d3	; ymin
	move.w	height,d3
	move.w	mole_h,d4	; hauteur en sprites de la molecule
	lsl.w	#4,d4		; *16 pour l'avoir en pixel
	sub.w	d4,d3		; on soustrait
	lsr.w	#1,d3		; on centre
	move.w	a_vdb,d4	; ajoute a_vdb
	lsr.w	#1,d4		; il est en demi lignes
	add.w	d4,d3		; voila
	move.l	atoms_adr,a3
	move.w	mole_h,d7
	move.l	#mole_name_sprite,a6	; queue de liste
	bsr	gen_board_sprite_and_sprite_list
	move.l	a0,mole_sprites_adr
	move.l	a1,mole_sprites_list_adr
	;; on ajoute le nom et le numero de niveau
	move.l	#mole_name_sprite,a0	
	move.w	height,d7
	sub.w	#16,d7		; laisse 8 lignes de vide en dessous
	move.w	a_vdb,d4
	lsr.w	#1,d4		; ajoute a_vdb (en demi-lignes)
	add.w	d4,d7
	move.w	d7,SPRITE_YPOS(a0)
	move.w	width,d7
	lsr.w	#2,d7		; divise par 4 (pixel divisor)
	sub.w	#8*MOLE_NAME_WIDTH,d7	; 32 caracteres
	lsr.w	#1,d7		; on centre
	move.w	d7,SPRITE_XPOS(a0)
	move.l	#level_num_sprite,a1
	bsr	finalize_sprite_object
	move.l	#level_num_sprite,a0
	move.w	#24,SPRITE_YPOS(a0)
	move.w	width,d7
	lsr.w	#2,d7		; divise par 4 (pixel divisor)
	sub.w	#8*LEVEL_NUM_WIDTH,d7	; 32 caracteres
	lsr.w	#1,d7		; on centre
	move.w	d7,SPRITE_XPOS(a0)
	move.l	#stop_object,a1
	bsr	finalize_sprite_object
	;; calcul du nom
	move.w	mole_name_length,d7 ; longueur du nom
	moveq	#MOLE_NAME_WIDTH,d6
	sub.w	d7,d6		; 32-n
	lsr.w	#1,d6		; divise par 2
	move.w	d6,d5
	moveq	#MOLE_NAME_WIDTH,d6
	sub.w	d7,d6
	sub.w	d5,d6		; restant
	subq.w	#1,d5
	move.l	#mole_name_gfx,a1
	move.l	#fonte+8,a2	
	move.w	#' '*8,d1	; espace = 32
	lea	(a2,d1.w),a0	; caractere espace
	move.w	#MOLE_NAME_WIDTH*8*2,d1	; pour passer a la ligne suivante dans mole_name_gfx		
	move.w	#WHITE,d0	; couleur
.left_spaces:
	bsr	draw_char
	add.w	#16,a1
	dbf	d5,.left_spaces
	move.l	#mole_name,a3
	subq.w	#1,d7
.gen_name:
	moveq	#0,d5	
	move.b	(a3)+,d5	; caractere
	lsl.w	#3,d5		; *8
	lea	(a2,d5.w),a0	; adresse du caractere
	bsr	draw_char
	add.w	#16,a1		; avance dans l'image
	dbf	d7,.gen_name
	move.w	#' '*8,d5	; espace = 32
	lea	(a2,d5.w),a0	; caractere espace
.right_spaces:
	bsr	draw_char
	add.w	#16,a1
	dbf	d6,.right_spaces
	bsr	draw_nb_moves
	move.l	#level_num_gfx,a0
	moveq	#LEVEL_NUM_WIDTH,d3
	move.w	current_level,d5
	move.w	#YELLOW,d0
	bra	draw_word

gen_board_sprite_and_sprite_list:
	;; d0.w: nombre de sprites 
	;; a2.l: board map
	;; d2.w: x_min
	;; d3.w: y_min
	;; a3: adresse d'un tableau contenant la definition des atomes
	;; a6: adresse de la queue de liste
	;; et un pointeur vers leur image 
	;; d7.w: hauteur du board (dbf ready!)
	move.w	d0,-(sp)	; sauve le nombre de sprites
	swap	d0
	clr.w	d0		; efface le poids fort
	swap	d0
	lsl.w	#2,d0		; un pointeur pour chaque sprite
	movem.l	d2/a2,-(sp)
	bsr	mm_alloc
	movem.l	(sp)+,d2/a2
	move.l	a0,-(sp)
	move.l	a0,a1
	move.w	d2,-(sp)
	move.w	#O_DEPTH16,d4	; profondeur des sprites
.gen_board_line:
	move.w	(sp),d2		; recupere x_min
	moveq	#16-1,d6	; plus simple d'iterer sur toute la largeur
.gen_board_column:
	move.w	(a2)+,d5
	beq.s	.gen_board_skip
	bmi.s	.gen_board_wall
.gen_board_atom:
	subq.w	#1,d5		; -1 car on commence a zero
	lsl.w	#3,d5		; tableau de phrases
	move.l	4(a3,d5.w),a0
	bra.s	.gen_ok
.gen_board_wall:
	move.l	#brick_2_gfx,a0
.gen_ok:
	moveq	#(16*2)/8,d0	; largeur en phrases
	moveq	#16,d1		; hauteur
	bsr	new_simple_sprite ; cree le sprite
	move.l	a0,(a1)+	; sauve l'adresse du sprite dans le tableau
	addq.w	#2,a2
	move.l	a0,(a2)+	; et dans le board
	bra.s	.gen_board_loop
.gen_board_skip:
	addq.w	#6,a2
.gen_board_loop:
	add.w	#16,d2		; x = x + 16
	dbf	d6,.gen_board_column
	add.w	#16,d3		; y = y + 16
	dbf	d7,.gen_board_line
	addq.w	#2,sp		; on peut oublier x_min maintenant
	;; construction de la liste
	move.l	a1,a2		; fin du tableau des sprites
	move.l	a6,a1		; queue de liste
	move.w	4(sp),d0	; nombre de sprites
	subq.w	#1,d0		; pour le dbf
.gen_board_list:
	move.l	-(a2),a0
	bsr	finalize_sprite_object
	move.l	a0,a1
	dbf	d0,.gen_board_list
	;; a1 pointe sur la liste de sprites
	move.l	#stop_object,a0
	move.w	a_vde,d0
	move.w	#O_BRLT,d1
	bsr	new_branch_object
	move.l	a0,a1
	move.l	#stop_object,a0
	move.w	a_vdb,d0
	move.w	#O_BRGT,d1
	bsr	new_branch_object
	move.l	a0,a1		; adresse de la liste
	move.l	(sp)+,a0	; recupere l'adresse du tableau de sprites
	addq.w	#2,sp		; oublie le nombre de sprites
	rts
	
wait_vbl:
	move.l	#vbl_flag,a0
	sf	(a0)
.wait:
	tst.b	(a0)
	beq.s	.wait
	rts
	
vbl_rout:	
	st	vbl_flag
	.if	SOUND_ON
	jsr	player+$8
	.endif
	move.w	#$101,INT1
	move.w	#0,INT2
	rte

draw_char:	
	;; a0: adresse du caractere
	;; a1: adresse de l'image
	;; d0: couleur
	;; d1: pour passer a la ligne suivante dans l'image
	movem.l	d1-d5/a0-a1,-(sp)
	sub.w	#16,d1
	moveq	#8-1,d2
.one_line:
	move.b	(a0)+,d3
	moveq	#8-1,d4
.one_pixel:
	moveq	#0,d5	
	lsl.b	#1,d3
	bcc.s	.draw
	move.w	d0,d5
.draw:
	move.w	d5,(a1)+
	dbf	d4,.one_pixel
	add.w	d1,a1
	dbf	d2,.one_line
	movem.l	(sp)+,d1-d5/a0-a1
	rts
	
	;; routines d'initialisation
	include	"init.s"

	;; memory manager
	include	"memory.s"

	.if	SOUND_ON
	;; player de modules
player:	
	include	"play.s"
	.endif
	
	.data
	.phrase
stop_object:
	dc.l	0,STOPOBJ

	include	"levels.s"
	;; les briques
	include	"gfx/sources/brick_2.s"
	;; les fleches
	include	"gfx/sources/up.s"
	include	"gfx/sources/down.s"
	include	"gfx/sources/left.s"
	include	"gfx/sources/right.s"
	;; les atomes
	include	"gfx/sources/atom_1.s"
	include	"gfx/sources/atom_2.s"
	include	"gfx/sources/atom_3.s"
	include	"gfx/sources/atom_4.s"
	include	"gfx/sources/atom_5.s"
	include	"gfx/sources/atom_6.s"
	include	"gfx/sources/atom_7.s"		
	include	"gfx/sources/atom_8.s"		
	include	"gfx/sources/atom_9.s"		
	include	"gfx/sources/atom_10.s"
	include	"gfx/sources/crystal.s"
	include	"gfx/sources/horizontal.s"
	include	"gfx/sources/bottomleft2topright.s"
	include	"gfx/sources/vertical.s"
	include	"gfx/sources/topleft2bottomright.s"
	;; les connections
	include "gfx/sources/conn_1.s"
	include "gfx/sources/conn_2.s"
	include "gfx/sources/conn_3.s"
	include "gfx/sources/conn_4.s"
	include "gfx/sources/conn_5.s"
	include "gfx/sources/conn_6.s"
	include "gfx/sources/conn_7.s"
	include "gfx/sources/conn_8.s"
	include "gfx/sources/conn_9.s"
	include "gfx/sources/conn_10.s"
	include "gfx/sources/conn_11.s"
	include "gfx/sources/conn_12.s"
	include "gfx/sources/conn_13.s"
	include "gfx/sources/conn_14.s"
	include "gfx/sources/conn_15.s"
	include "gfx/sources/conn_16.s"
arrows:
	dc.l	up_gfx,down_gfx,left_gfx,right_gfx
atoms:
	dc.l	atom_1_gfx,atom_2_gfx,atom_3_gfx,atom_4_gfx,atom_5_gfx
	dc.l	atom_6_gfx,atom_7_gfx,atom_8_gfx,atom_9_gfx,atom_10_gfx
	dc.l	crystal_gfx,horizontal_gfx,bottomleft2topright_gfx,vertical_gfx,topleft2bottomright_gfx
connections:
	dc.l	conn_1_gfx,conn_2_gfx,conn_3_gfx,conn_4_gfx
	dc.l	conn_5_gfx,conn_6_gfx,conn_7_gfx,conn_8_gfx
	dc.l	conn_9_gfx,conn_10_gfx,conn_11_gfx,conn_12_gfx
	dc.l	conn_13_gfx,conn_14_gfx,conn_15_gfx,conn_16_gfx

	include	"gfx/sources/removers.s"
	
	include	"gfx/sources/jagware.s"

	.qphrase
removers_sprite:
	dc.l	0,0,0,0,0,0	; object header
	dc.l	0,0,0		; sauvegarde
	dc.w	BITOBJ		; Bitmap Object
	dc.l	removers_gfx	; image
	dc.w	O_DEPTH16	; 16 bits
	dc.w	(256*2)/8	; 
	dc.l	O_NOGAP		; 
	dc.w	0		; x
	dc.w	0		; y
	dc.w	(256*2)/8
	dc.w	64		; hauteur
	dc.w	0		; index CLUT
	dc.l	O_TRANS		; transparent
	dc.w	0		; premier pixel
	dc.w	0		; hscale
	dc.w	0		; vscale
	dc.w	0		; remainder

	.qphrase
jagware_sprite:
	dc.l	0,0,0,0,0,0	; object header
	dc.l	0,0,0		; sauvegarde
	dc.w	BITOBJ		; Bitmap Object
	dc.l	jagware_gfx	; image
	dc.w	O_DEPTH16	; 16 bits
	dc.w	(256*2)/8	; 
	dc.l	O_NOGAP		; 
	dc.w	0		; x
	dc.w	0		; y
	dc.w	(256*2)/8
	dc.w	51		; hauteur
	dc.w	0		; index CLUT
	dc.l	O_TRANS		; transparent
	dc.w	0		; premier pixel
	dc.w	0		; hscale
	dc.w	0		; vscale
	dc.w	0		; remainder

	.qphrase
intro_text_sprite:
	dc.l	0,0,0,0,0,0	; object header
	dc.l	0,0,0		; sauvegarde
	dc.w	BITOBJ		; Bitmap Object
	dc.l	intro_text_gfx	; image
	dc.w	O_DEPTH16	; 16 bits
	dc.w	(8*INTRO_TEXT_WIDTH*2)/8	; 40 caracteres
	dc.l	O_NOGAP		; 
	dc.w	0		; x
	dc.w	0		; y
	dc.w	(8*INTRO_TEXT_WIDTH*2)/8
	dc.w	8		; hauteur
	dc.w	0		; index CLUT
	dc.l	O_TRANS		; transparent
	dc.w	0		; premier pixel
	dc.w	0		; hscale
	dc.w	0		; vscale
	dc.w	0		; remainder

	.qphrase
nb_moves_sprite:
	dc.l	0,0,0,0,0,0	; object header
	dc.l	0,0,0		; sauvegarde
	dc.w	BITOBJ		; Bitmap Object
	dc.l	nb_moves_gfx	; image
	dc.w	O_DEPTH16	; 16 bits
	dc.w	(8*NB_MOVES_WIDTH*2)/8	; 6 caracteres
	dc.l	O_NOGAP		; 
	dc.w	0		; x
	dc.w	0		; y
	dc.w	(8*NB_MOVES_WIDTH*2)/8
	dc.w	8		; hauteur
	dc.w	0		; index CLUT
	dc.l	O_TRANS		; transparent
	dc.w	0		; premier pixel
	dc.w	0		; hscale
	dc.w	0		; vscale
	dc.w	0		; remainder

	.qphrase
level_num_sprite:
	dc.l	0,0,0,0,0,0	; object header
	dc.l	0,0,0		; sauvegarde
	dc.w	BITOBJ		; Bitmap Object
	dc.l	level_num_gfx	; image
	dc.w	O_DEPTH16	; 16 bits
	dc.w	(8*LEVEL_NUM_WIDTH*2)/8	; 6 caracteres
	dc.l	O_NOGAP		; 
	dc.w	0		; x
	dc.w	0		; y
	dc.w	(8*LEVEL_NUM_WIDTH*2)/8
	dc.w	8		; hauteur
	dc.w	0		; index CLUT
	dc.l	O_TRANS		; transparent
	dc.w	0		; premier pixel
	dc.w	0		; hscale
	dc.w	0		; vscale
	dc.w	0		; remainder

	.qphrase
time_sprite:
	dc.l	0,0,0,0,0,0	; object header
	dc.l	0,0,0		; sauvegarde
	dc.w	BITOBJ		; Bitmap Object
	dc.l	time_gfx	; image
	dc.w	O_DEPTH16	; 16 bits
	dc.w	(8*TIME_WIDTH*2)/8	; 6 caracteres
	dc.l	O_NOGAP		; 
	dc.w	0		; x
	dc.w	0		; y
	dc.w	(8*TIME_WIDTH*2)/8
	dc.w	8		; hauteur
	dc.w	0		; index CLUT
	dc.l	O_TRANS		; transparent
	dc.w	0		; premier pixel
	dc.w	0		; hscale
	dc.w	0		; vscale
	dc.w	0		; remainder
			
	.qphrase
mole_name_sprite:
	dc.l	0,0,0,0,0,0	; object header
	dc.l	0,0,0		; sauvegarde
	dc.w	BITOBJ		; Bitmap Object
	dc.l	mole_name_gfx	; image
	dc.w	O_DEPTH16	; 16 bits
	dc.w	(8*MOLE_NAME_WIDTH*2)/8	; 32 caracteres
	dc.l	O_NOGAP		; 
	dc.w	0		; x
	dc.w	0		; y
	dc.w	(8*MOLE_NAME_WIDTH*2)/8
	dc.w	8		; hauteur
	dc.w	0		; index CLUT
	dc.l	O_TRANS		; transparent
	dc.w	0		; premier pixel
	dc.w	0		; hscale
	dc.w	0		; vscale
	dc.w	0		; remainder

	.qphrase
up_sprite:
	dc.l	0,0,0,0,0,0	; object header
	dc.l	0,0,0		; sauvegarde
	dc.w	BITOBJ		; Bitmap Object
	dc.l	up_gfx		; image
	dc.w	O_DEPTH16	; 16 bits
	dc.w	(16*2)/8	; 
	dc.l	O_NOGAP		; 
	dc.w	50		; x
	dc.w	50		; y
	dc.w	(16*2)/8
	dc.w	16		; hauteur
	dc.w	0		; index CLUT
	dc.l	O_TRANS		; transparent
	dc.w	0		; premier pixel
	dc.w	0		; hscale
	dc.w	0		; vscale
	dc.w	0		; remainder

	.qphrase
down_sprite:
	dc.l	0,0,0,0,0,0	; object header
	dc.l	0,0,0		; sauvegarde
	dc.w	BITOBJ		; Bitmap Object
	dc.l	down_gfx	; image
	dc.w	O_DEPTH16	; 16 bits
	dc.w	(16*2)/8	; 
	dc.l	O_NOGAP		; 
	dc.w	50		; x
	dc.w	70		; y
	dc.w	(16*2)/8
	dc.w	16		; hauteur
	dc.w	0		; index CLUT
	dc.l	O_TRANS		; transparent
	dc.w	0		; premier pixel
	dc.w	0		; hscale
	dc.w	0		; vscale
	dc.w	0		; remainder

		.qphrase
left_sprite:
	dc.l	0,0,0,0,0,0	; object header
	dc.l	0,0,0		; sauvegarde
	dc.w	BITOBJ		; Bitmap Object
	dc.l	left_gfx	; image
	dc.w	O_DEPTH16	; 16 bits
	dc.w	(16*2)/8	; 
	dc.l	O_NOGAP		; 
	dc.w	70		; x
	dc.w	50		; y
	dc.w	(16*2)/8
	dc.w	16		; hauteur
	dc.w	0		; index CLUT
	dc.l	O_TRANS		; transparent
	dc.w	0		; premier pixel
	dc.w	0		; hscale
	dc.w	0		; vscale
	dc.w	0		; remainder

		.qphrase
right_sprite:
	dc.l	0,0,0,0,0,0	; object header
	dc.l	0,0,0		; sauvegarde
	dc.w	BITOBJ		; Bitmap Object
	dc.l	right_gfx	; image
	dc.w	O_DEPTH16	; 16 bits
	dc.w	(16*2)/8	; 
	dc.l	O_NOGAP		; 
	dc.w	70		; x
	dc.w	70		; y
	dc.w	(16*2)/8
	dc.w	16		; hauteur
	dc.w	0		; index CLUT
	dc.l	O_TRANS		; transparent
	dc.w	0		; premier pixel
	dc.w	0		; hscale
	dc.w	0		; vscale
	dc.w	0		; remainder

	.phrase
fonte:
	incbin	"gfx/ascii8x8.fnt"

	.if	SOUND_ON
	.phrase
musique:
	incbin	"snd/dreams_of_love.mod"

	.phrase
applause:
	incbin	"snd/applause.raw"
applause_end:
	.endif
; 	.phrase
; launch:
; 	incbin	"launch.raw"
; launch_end:

	.bss
Bss_start:	
	;; videos
height:	ds.w	1 
a_vdb:	ds.w	1
a_vde:	ds.w	1
width:	ds.w	1
a_hdb:	ds.w	1
a_hde:	ds.w	1
vbl_flag:	ds.w	1
	;; jeu
current_level:	ds.w	1

nb_moves:	ds.w	1

time_counter:	ds.w	1
nb_seconds:	ds.w	1
		
	;; donne la position dans level_map de l'atome actuellement actif
active_atom_x:	ds.w	1
active_atom_y:	ds.w	1
active_atom_auth_moves:	ds.w	1
active_atom_sprite:	ds.l	1
active_atom_xpos:	ds.w	1
active_atom_ypos:	ds.w	1
active_atom_dest_x:	ds.w	1
active_atom_dest_y:	ds.w	1
active_atom_dest_xpos:	ds.w	1
active_atom_dest_ypos:	ds.w	1
active_atom_inc_xpos:	ds.w	1
active_atom_inc_ypos:	ds.w	1
	;; decrit le niveau actuel
	;; la carte est constitue de 16*16 phrases
	;; le premier mot donne le contenu de la cellule
	;; le deuxieme mot, pour l'instant, rien
	;; les deux derniers mots forment un pointeur vers le sprite representant cette cellule
level_w:	ds.w	1
level_h:	ds.w	1
level_map:	ds.l	16*16*2
level_nb_sprites:	ds.w	1
level_sprites_adr:	ds.l	1
level_sprites_list_adr:	ds.l	1
	
mole_w:		ds.w	1
mole_h:		ds.w	1
mole_map:	ds.l	16*16*2
mole_nb_sprites:	ds.w	1
mole_sprites_adr:	ds.l	1
mole_sprites_list_adr:	ds.l	1
	
nb_atoms:	ds.w	1
atoms_adr:	ds.l	1

	.even
mole_name:	ds.b	MOLE_NAME_WIDTH
	.even
mole_name_length:	ds.w	1

	.phrase
mole_name_gfx:
	ds.w	8*8*MOLE_NAME_WIDTH

	.phrase
intro_text_gfx:
	ds.w	8*8*INTRO_TEXT_WIDTH

	.phrase
nb_moves_gfx:	
	ds.w	8*8*NB_MOVES_WIDTH
	.phrase
time_gfx:
	ds.w	8*8*TIME_WIDTH
	.phrase
level_num_gfx:
	ds.w	8*8*LEVEL_NUM_WIDTH
	.phrase
Bss_end:
