; Memory manager v 1.0
; Copyright (C) 2006 Seb/The Removers
; http://removers.atari.org	

; This library is free software; you can redistribute it and/or
; modify it under the terms of the GNU Lesser General Public
; License as published by the Free Software Foundation; either
; version 2.1 of the License, or (at your option) any later version.

; This library is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; Lesser General Public License for more details.

; You should have received a copy of the GNU Lesser General Public
; License along with this library; if not, write to the Free Software
; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
	;; gestionnaire de memoire
	;; utilise la technique du first-fit (voir par exemple Tanenbaum)
	;; les blocs libres font partie d'une liste chainee
	;; pour initialiser le gestionnaire, appeler mm_init
	;; ensuite, pour allouer de la memoire, appeler mm_alloc
	;; et pour liberer de la memoire, appeler mm_free
	;; (aucune verification n'est faite sur l'adresse des
	;;  blocs  liberer)
	;; on peut aussi reinitialiser le gestionnaire avec mm_reset 
	;; c'est pratique pour tout liberer d'un coup
	
MM_OK		equ	0
MM_ERROR	equ	-1

	.offset	0
	;; header des cellules de mmoire
MM_CELL_NEXT:	ds.l	1
MM_CELL_SIZE:	ds.l	1
MM_CELL_SIZEOF:	ds.l	0	

	.text

MM_ALIGN	equ	5	; aligne sur 32 octets
MM_ALIGN_BYTES	equ	1<<MM_ALIGN	
MM_ALIGN_MASK	equ	~(MM_ALIGN_BYTES-1)

MM_CELL_SIZEOF_ALIGNED	equ	(MM_CELL_SIZEOF+MM_ALIGN_BYTES-1)&MM_ALIGN_MASK

	.macro	mm_align
	add.l	#MM_ALIGN_BYTES-1,\1
	and.l	#MM_ALIGN_MASK,\1
	.endm

mm_init:
	;; input
	;; a0: adresse debut memoire libre
	;; a1: adresse fin memoire libre
	;; output
	;; d0: MM_OK ou MM_ERROR
	;; registres utilises:	d0-d2,a0-a1
	move.l	a0,d0
	mm_align d0	; aligne au multiple superieur
	move.l	a1,d1
	mm_align d1
	sub.l	#MM_ALIGN_BYTES,d1 ; aligne au multiple inferieur
	move.l	d0,d2
	add.l	#MM_CELL_SIZEOF_ALIGNED,d2
	cmp.l	d2,d1	; a-t-on assez de place pour au moins une cellule?
	bls.s	.mm_init_error
.mm_init_ok:
	move.l	d0,mm_start_address
	move.l	d1,mm_end_address
	move.l	d0,mm_free_blocks
	move.l	d0,a0
	clr.l	MM_CELL_NEXT(a0) ; ni apres
	sub.l	d0,d1		;  taille du bloc (> taille d'une cellule)
	move.l	d1,MM_CELL_SIZE(a0) ; taille du bloc
	moveq	#MM_OK,d0
	rts
.mm_init_error:
	clr.l	mm_free_blocks
	clr.l	mm_start_address
	clr.l	mm_end_address
	moveq	#MM_ERROR,d0
	rts

mm_reset:
	;; input
	;; aucun
	;; output
	;; d0:	MM_OK ou MM_ERROR
	;; registres utilises:	d0-d2,a0-a1
	move.l	mm_start_address(pc),a0
	move.l	mm_end_address(pc),a1
	bra.s	mm_init
	
mm_alloc:
	;; input
	;; d0: taille a allouer
	;; output
	;; a0: adresse du bloc alloue ou 0 si impossible
	;; registres utiliss:	d0-d2,a0-a2
	mm_align	d0
	add.l	#MM_CELL_SIZEOF_ALIGNED,d0 ;  taille reelle a allouer
	move.l	mm_free_blocks(pc),d1
	beq.s	.mm_alloc_not_found
	sub.l	a1,a1
.mm_alloc_find_loop:
	move.l	d1,a0
	cmp.l	MM_CELL_SIZE(a0),d0
	bls.s	.mm_alloc_found
	move.l	a0,a1
	move.l	MM_CELL_NEXT(a0),d1
	bne.s	.mm_alloc_find_loop
.mm_alloc_not_found:
	sub.l	a0,a0
	illegal
	rts
.mm_alloc_found:
	;; ici, on a trouve un bloc assez grand
	;; son adresse est contenue dans a0
	;; la cellule precedente est pointe par a1
	move.l	MM_CELL_SIZE(a0),d1 	;  taille du bloc
	move.l	MM_CELL_NEXT(a0),a2	; cellule suivante	
	sub.l	d0,d1			; taille restante
	cmp.l	#MM_CELL_SIZEOF_ALIGNED,d1 	; > taille d'une cellule ?
	bhi.s	.mm_alloc_split_cell
.mm_ok_next:
	;; ici, la taille restante serait plus petite que la taille
	;; d'une cellule, on alloue donc toute la cellule
	add.l	d1,d0		; corrige la taille allouee
	bra.s	.mm_alloc_set_previous
.mm_alloc_split_cell:
	;; ici, on est oblige de couper le bloc en 2
	lea	(a0,d0.l),a2	; adresse de la prochaine cellule
	move.l	MM_CELL_NEXT(a0),MM_CELL_NEXT(a2) ; next
	move.l	d1,MM_CELL_SIZE(a2) ; taille
	cmp.l	#0,a1
	bne.s	.mm_alloc_ok_fix
	bra.s	.mm_alloc_chg_hd
.mm_alloc_set_previous:
	;; ici, a1 pointe sur la precedente
	;; et a2 sur la suivante	
	cmp.l	#0,a1
	beq.s	.mm_alloc_chg_hd
	move.l	a2,MM_CELL_NEXT(a1)	; next(previous) = next
	bra.s	.mm_alloc_ok_fix
.mm_alloc_chg_hd:
	move.l	a2,mm_free_blocks
.mm_alloc_ok_fix:
	;; ici, la liste est corrige
	;; la cellule courante a ete retire
	move.l	d0,MM_CELL_SIZE(a0) ; corrige la taille de la cellule
	clr.l	MM_CELL_NEXT(a0)
	add.l	#MM_CELL_SIZEOF_ALIGNED,a0 ; ajoute la taille de l'entete
	rts			; on est bon!

mm_free:
	;; input
	;; a0: adresse du bloc a liberer (pas de verifications poussees de consistance)
	;; output
	;; aucun
	;; registres utilises:	d0-d2,a0-a2
	sub.l	#MM_CELL_SIZEOF_ALIGNED,a0
	move.l	mm_free_blocks(pc),d2
	beq.s	.mm_free_found_head
	cmp.l	d2,a0		; si a1 > a0, la liste des blocs libres commence apres le bloc a liberer
	blo.s	.mm_free_found_head
.mm_free_find:
	move.l	d2,a1
	;; ici, on sait que a1 <= a0
	cmp.l	MM_CELL_NEXT(a1),a0 ; si next(a1) > a0, on a trouve l'endroit o inserer la cellule a liberer
	blo.s	.mm_free_found
	move.l	MM_CELL_NEXT(a1),d2 ; sinon, on continue a parcourir la liste
	bne.s	.mm_free_find
.mm_free_found_tail:
	;; ici, on doit inserer (fusionner) en toute fin de liste
	;; a1 pointe sur la derniere cellule (non nulle)
	move.l	MM_CELL_SIZE(a1),d0
	lea	(a1,d0.l),a2
	cmp.l	a0,a2
	bne.s	.mm_free_found_tail_no_fusion
	add.l	MM_CELL_SIZE(a0),d0
	move.l	d0,MM_CELL_SIZE(a1)
	rts
.mm_free_found_tail_no_fusion:
	move.l	a0,MM_CELL_NEXT(a1)
	clr.l	MM_CELL_NEXT(a0) ; derniere cellule de la liste
	rts
.mm_free_found_head:	
	;; ici, on doit inserer (fusionner) en tete
	move.l	d2,a1			; tete de la liste
	move.l	a0,mm_free_blocks	; nouvelle tete de liste
	move.l	MM_CELL_SIZE(a0),d0
	lea	(a0,d0.l),a2
	cmp.l	a1,a2
	bne.s	.mm_free_found_head_no_fusion
	add.l	MM_CELL_SIZE(a1),d0
	move.l	d0,MM_CELL_SIZE(a0)
	move.l	MM_CELL_NEXT(a1),MM_CELL_NEXT(a0)
	rts
.mm_free_found_head_no_fusion:
	move.l	a1,MM_CELL_NEXT(a0)
	rts
.mm_free_found:
	;; ici, on doit inserer (fusionner) au milieu
	;; a1 pointe sur la cellule precedente
	move.l	MM_CELL_SIZE(a1),d0
	lea	(a1,d0.l),a2
	move.l	MM_CELL_NEXT(a1),d2	; cellule suivante
	cmp.l	a0,a2			; est-ce la fin de la precedente?
	bne.s	.mm_free_found_no_fusion_left
.mm_free_found_fusion_left:
	move.l	a0,MM_CELL_NEXT(a1)
	add.l	MM_CELL_SIZE(a0),d0
	move.l	d0,MM_CELL_SIZE(a1)
	move.l	a1,a0
.mm_free_found_no_fusion_left:	
	move.l	d2,a2
	move.l	MM_CELL_SIZE(a0),d0
	lea	(a0,d0.l),a1		; va-t-on jusqu'au debut de la
	cmp.l	a1,a2			; cellule suivante?
	bne.s	.mm_free_found_no_fusion_right
.mm_free_found_fusion_right:
	move.l	MM_CELL_NEXT(a2),a1
	move.l	a1,MM_CELL_NEXT(a0)
	add.l	MM_CELL_SIZE(a2),d0
	move.l	d0,MM_CELL_SIZE(a0)	
.mm_free_found_no_fusion_right:	
	rts
	
mm_free_blocks:		dc.l	0
mm_start_address:	dc.l	0
mm_end_address:		dc.l	0
