; **************************************************************
; *                    JAZ Developer Library
; *                      Macro definitions
; *                           8/24/95
; *                       Andreas Binner
; *                    (c) 1995 Atari Corp.
; **************************************************************

	.extern	_SFireEffect
	.extern	_SFireEffectwPan
	.extern	_SVoiceOn
	.extern	_SVoiceOff
	.extern	_SVoiceStatus
	.extern	_SSync
	.extern	_SSetScore1
	.extern	_SSetScore2
	.extern	_SSetPerf
	.extern _SSetVolAbs
	.extern _SSetVolRel
	.extern _SSetPitch
	.extern _SSetPan
	.extern _SSetRear
	.extern _STurnOn
	.extern _STurnOff
	.extern _SInit
	.extern _SSurround
	.extern _SMainVolume
	.extern _SSFXVolume

.macro SynthFireEffect patch, volume, pitch, prior
	move.w	\prior,-(sp)
	move.w	\pitch,-(sp)
	move.w	\volume,-(sp)
	move.w	\patch,-(sp)
	jsr	_SFireEffect
	addq.l	#8,sp
.endm


.macro SynthFireEffectwPan patch, volume, pitch, prior, pan
	move.w	\pan,-(sp)
	move.w	\prior,-(sp)
	move.w	\pitch,-(sp)
	move.w	\volume,-(sp)
	move.w	\patch,-(sp)
	jsr	_SFireEffectwPan
	addq.l	#8,sp
.endm

.macro SynthVoiceOn patch, volume, pitch, prior
	move.w	\prior,-(sp)
	move.w	\pitch,-(sp)
	move.w	\volume,-(sp)
	move.w	\patch,-(sp)
	jsr	_SVoiceOn
	addq.l	#8,sp
.endm

.macro SynthVoiceOff voice
	move.w	\voice,-(sp)
	jsr	_SVoiceOff
	addq.l	#2,sp
.endm

.macro SynthVoiceStatus voice
	move.w	\voice,-(sp)
	jsr	_SVoiceStatus
	addq.l	#2,sp
.endm

.macro SynthSync ticks
	move.l	\ticks,-(sp)
	jsr	_SSync
	addq.l	#4,sp
.endm

.macro SynthSetScore1 score
	move.l	\score,-(sp)
	jsr	_SSetScore1
	addq.l	#4,sp
.endm

.macro SynthSetScore2 score
	move.l	\score,-(sp)
	jsr	_SSetScore2
	addq.l	#4,sp
.endm

.macro SynthSetVolAbs voice, vol
	move.w	\vol,-(sp)
	move.w	\voice,-(sp)
	jsr	_SSetVolAbs
	addq.l	#4,sp
.endm

.macro SynthSetVolRel voice, vol
	move.w	\vol,-(sp)
	move.w	\voice,-(sp)
	jsr	_SSetVolRel
	addq.l	#4,sp
.endm

.macro SynthSetPan voice, pan
	move.w	\pan,-(sp)
	move.w	\voice,-(sp)
	jsr	_SSetPan
	addq.l	#4,sp
.endm

.macro SynthSetPitch voice, pitch
	move.w	\pitch,-(sp)
	move.w	\voice,-(sp)
	jsr	_SSetPitch
	addq.l	#4,sp
.endm

.macro SynthSetRear rear
	move.w	\rear,-(sp)
	move.w	#13,-(sp)
	jsr	_SSetVolume
	addq.l	#4,sp
.endm

.macro SynthSetPerf prf, song
	move.w \song,-(sp)
	move.w \prf,-(sp)
	jsr	_SSetPerf
	add.l	#4,sp
.endm

.macro SynthTurnOn prf, song, redbook
	move.w \redbook,-(sp)
	move.w \song,-(sp)
	move.w \prf,-(sp)
	jsr	_STurnOn
	add.l	#6,sp
.endm

.macro SynthTurnOff
	jsr	_STurnOff
.endm

.macro SynthInit
	jsr	_SInit
.endm

.macro SynthSurround flag
	move.l \flag,-(sp)
	jsr	_SSurround
	addq.l	#4,sp
.endm

.macro SynthMainVolume vol
	move.l	\vol,-(sp)
	jsr	_SMainVolume
	addq.l	#4,sp
.endm

.macro SynthSFXVolume vol
	move.l	\vol,-(sp)
	jsr	_SSFXVolume
	addq.l	#4,sp
.endm
