/*******************************************************************
 *
 *    TITLE:		b2k_game.h
 *
 *    DESCRIPTION:	Header file for b2k_game.c
 *
 *    AUTHOR:		Mario Perdue & Richard Degler
 *
 *    HISTORY:    
 *
 *
 *           COPYRIGHT 1994, 1995 MP Graphics Systems         
 *      UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
 *      PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
 *     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
 *                        ALL RIGHTS RESERVED.               
 *******************************************************************/

#ifndef __B2K_GAME__H
#define __B2K_GAME__H

/* Game Modes */
enum 
	{
	modeTITLE, modeSTARTGAME, modeENDGAME, 
	modeSTARTSCREEN, modeRESUMESCREEN, modeENDSCREEN, 
	modeDOBONUS, modeSHOOT, modePLAY,
	modeKILLSCREEN, modeREVIVESCREEN, modeHIGHSCORE, modeIDLE,
	modePONGSTART, modePONGSHOOT, modePONGPLAY, modePONGEND,
	modeTARGETSTART, modeTARGETPLAY, modeTARGETEND
	};

enum
	{
	pauseIDLE, pauseMUSIC_ADJUST, pauseEFFECTS_ADJUST
	};


enum
	{
	roundCATCH=5, roundATTRACT=10, roundKILLSCREEN=10, roundGUN=15, roundSUPERBALL=20
	};

/* Prototypes */

void PlayGame( void );
void HandlePlayer( short who );
void CheckKeypad( short who );
void CheckButtons( short who );
void MoveSprites( short who );
void EraseSprites( void );
void DrawSprites( void );
void DisplaySprites( void );
void InitPlayer( short who);
char SpritesAreActive();
void DoTitle( void );

void HandleMusicPopup( short who );
void HandleEffectsPopup( short who );
#endif
