;*======================================================================*
;*   TITLE:       B2K_STRT.S                                            *
;*                                                                      *
;*   Function:    Startup Routines and Main Loop                        *
;*                                                                      *
;*   Programmer:  Mario Perdue                                          *
;*                                                                      *
;*              COPYRIGHT 1994, 1995 MP Graphics Systems                *
;*          UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,         *
;*          PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR          *
;*        THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.       *
;*                            ALL RIGHTS RESERVED.                      *
;*                                                                      *
;*======================================================================*
    .title  "B2K_START.S - System Startup Routines"

BAR_ON EQU  0

; include files

    .include    '/jaguar/include/jaguar.inc'
	.include	'synthlib.inc'

; external symbols

	.extern _ObjectListFlag
    .extern _ObjectList
	.extern olp2set
	.extern _a_vdb
	.extern _a_vde

; external routines

	.extern _InitGame
    .extern _main
    .extern VblInit
	.extern gSetOLP
	.extern _RefreshObjectList
	.extern _ticks

	.extern delzss

; public symbols
	.globl _IMG_Screen

; public routines

    .globl  _start



;    .text
.data


_start:
	move.l #EndOfCode-StartOfCode,-(a7)
	move.l #StartOfCode,-(a7)
	move.l #$4000,-(a7)

	jsr _vmemcpy

	adda.w	#12,a7

	SynthInit
	SynthSurround #0
	SynthTurnOn #0,#0,#0

	move.w	#0, _ObjectListFlag
	jsr _InitGame

    jsr VblInit				; Initialize VBlank routine
    
	move.w  #$6C1,VMODE		; Configure Video
	jsr		SetB2KOLP

    jsr _main


_illegal::
    illegal


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; A call to this label is always automatically inserted into the main()
; function by GCC to init the runtime library.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 
___main::
    rts

;*======================================================================*
;*  VBLANK   Vertical Sync and Timer Interrupt Handler
;*======================================================================*
vblank:
    movem.l d0-d7/a0-a6,-(sp)	; Save the registers

    move.w  INT1,d0				; Test for VB interupt
	btst	#0,d0
    beq 	timer

	jsr		_RefreshObjectList	; Restore Object List

    move.w  #$109,INT1      	; Enable PIT and Video interrupts
	bra		odone

timer:
	move.w	INT1,d0				; Test for TIMER interupt
	btst	#3,d0
	beq		odone

	add.l   #1, _ticks          ; Increment ticks semaphore
    move.w  #$809,INT1      	; Enable PIT and Video interrupts

odone:
    move.w  #0,INT2

    movem.l (sp)+,d0-d7/a0-a6	; Restore the registers

    rte

;*======================================================================*
;*  VBLINIT   Initialize Vertical Sync Interrupt Handler
;*======================================================================*
VblInit:
	movem.l d0,-(sp)     

	move.w	#$FFFF, VI			; Disable interupts

	move.l	#vblank, LEVEL0		; Set up the interupt vector

	move.w	_a_vde, d0
	or.w	#1, d0
	move.w	d0, VI				; Get the maximum vblank time

	move.w	#9, PIT0   			; Set up programmable timer
	move.w	#2658, PIT1

	move.w	#$909, INT1			; Enable PIT and VI

	move.w	sr, d0
	and.w	#$F8FF, d0			; Lower the 68K IPL
	move.w	d0, sr

	move.l  (sp)+,d0
    rts



;*======================================================================*
;*  SETB2KOLP   Set up object list pointer
;*======================================================================*
SetB2KOLP:
	move.l  #_ObjectList,d0        		; * Set up ptr to Object List
    swap    d0
    move.l  d0,olp2set

	move.l	#gSetOLP, G_PC
	move.l	#RISCGO, G_CTRL
	
waitgpudone:
	move.l	G_CTRL, d0
	andi.l	#$1, d0
	bne		waitgpudone
	rts


;	This code is stuck here for lack of a better place to put it.
;
;	vea gemlib memcpy
;	a very fast memory copy
;
;	call: 	vmemcpy(to, from, count)
;
;		char	*to;
;		char	*from;
;		long	count;


		.globl _vmemcpy

_vmemcpy:
		movem.l	d1-d7/a0-a6,-(sp)	; 14 regs @ 4 bytes each = 56 bytes

; Grab parameters off stack... (reg save area is 56 bytes long)

		movea.l	60(sp),a0		; to:     4 + 56 = 60
		movea.l	64(sp),a1		; from:   8 + 56 = 64
		move.l	68(sp),d1		; count: 12 + 56 = 68

		cmp.l	#$7,d1
		ble		blt7e

		move.w	a0,d0
		and.w	#$1,d0
		move.w	a1,d2
		and.w	#$1,d2
		cmp.w	d2,d0
		bne		blt7e

		tst.w	d0
		beq		blt3c

		move.b	(a1)+,(a0)+
		subq.l	#$1,d1
blt3c:
		move.l	d1,d0
		asr.l	#$2,d0
		and.l	#$3,d1
		sub.l	#$d,d0
		blt		blt70

		movem.l	d1-d7/a2-a6,-(sp)
blt54:
		movem.l	(a1)+,d1-d7/a2-a6
		movem.l	d1-d7/a2-a6,(a0)
		adda.l	#$30,a0
		sub.l	#$c,d0
		bge		blt54

		movem.l	(sp)+,d1-d7/a2-a6
blt70:
		add.l	#$c,d0
blt76:
		move.l	(a1)+,(a0)+
		subq.l	#$1,d0
		bge		blt76

blt7e:
		tst.l	d1
		ble		blt8c

blt84:
		move.b	(a1)+,(a0)+
		subq.l	#$1,d1
		bgt		blt84

		move.l	4(sp),d0
blt8c:
		movem.l	(sp)+,d1-d7/a0-a6	; restore regs
		rts

								 


_InitMemory::
blitwait1:
		move.l	B_CMD,d0	; Make sure blitter is idle
		andi.l	#1,d0
		beq	blitwait1

	move.l	#$4000,A1_BASE	
	move.l	#$4028,A1_FLAGS
	move.l	#$0,A1_CLIP	; Required for Blitter Bug
	move.l	#$0,A1_PIXEL
	move.l	#$1FF00,A1_STEP

	move.l	#$07A00100,B_COUNT
	move.l	#$0,B_PATD
	move.l	#$0,B_PATD+4
	move.l	#$10200,B_CMD

blitwait2:
		move.l	B_CMD,d0	; Make sure blitter is idle
		andi.l	#1,d0
		beq	blitwait2

	move.l	#$F03000,A1_BASE	
	move.l	#$4028,A1_FLAGS
	move.l	#$0,A1_CLIP	; Required for Blitter Bug
	move.l	#$0,A1_PIXEL
	move.l	#$1FF00,A1_STEP

	move.l	#$40100,B_COUNT
	move.l	#$0,B_PATD
	move.l	#$0,B_PATD+4
	move.l	#$10200,B_CMD

blitwait3:
		move.l	B_CMD,d0	; Make sure blitter is idle
		andi.l	#1,d0
		beq	blitwait3

	move.l	#$F1B000,A1_BASE	
	move.l	#$4028,A1_FLAGS
	move.l	#$0,A1_CLIP	; Required for Blitter Bug
	move.l	#$0,A1_PIXEL
	move.l	#$1FF00,A1_STEP

	move.l	#$80100,B_COUNT
	move.l	#$0,B_PATD
	move.l	#$0,B_PATD+4
	move.l	#$10200,B_CMD

blitwait4:
		move.l	B_CMD,d0	; Make sure blitter is idle
		andi.l	#1,d0
		beq	blitwait4
	rts

	.phrase
StartOfCode::
	.incbin	"b2k.tx"
EndOfCode::

     
     .bss
    .phrase
_IMG_Screen:
	.ds.w	92160			 ; memory for the screen

    .end

	.phrase
