/*******************************************************************
 *
 *    TITLE:        ball.h
 *
 *    DESCRIPTION:	Header file for ball.c
 *
 *    AUTHOR:		Mario Perdue & Richard Degler
 *
 *    HISTORY:    
 *
 *
 *           COPYRIGHT 1994, 1995 MP Graphics Systems         
 *      UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
 *      PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
 *     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
 *                        ALL RIGHTS RESERVED.               
 *******************************************************************/

#ifndef __BALL__H
#define __BALL__H

#include "support.h"

#define BALL_SHADOW_WIDTH 	12
#define BALL_SHADOW_HEIGHT	6

#define	BALL_SHADOW_FLAGS	PITCH1 | PIXEL16 | WID80 | XADDPIX

#define	BALL_Y				3488

#define BALL_WIDTH			11
#define BALL_HEIGHT			11

#define BALL_W				416
#define BALL_H				416
#define BALL_R				208
#define CLASSIC_R			135

#define BALL_LAUNCH_WIDTH 	64
#define BALL_LAUNCH_HEIGHT	12

#define MAX_BALLS			2
#define BALL_NORMAL_FLAGS	PITCH1 | PIXEL16 | WID80 | XADDPIX
#define BALL_SUPER_FLAGS	PITCH1 | PIXEL16 | WID80 | XADDPIX
#define BALL_EXPLODE_FLAGS	PITCH1 | PIXEL16 | WID80 | XADDPIX
#define BALL_LAUNCH_FLAGS	PITCH1 | PIXEL16 | WID80 | XADDPIX

#define BALL_SPEED_LIMIT_1 	225
#define BALL_SPEED_LIMIT_2 	265

#define BALL_MIN_SPEED		96
#define BALL_DECELERATION	16
#define SKILL_SPEED_INCR  	48

#define SPEED_BACK_WALL		265

enum {ballLAUNCH, ballNORMAL, ballSUPER, ballEXPLODE, ballCLASSIC, ballBREAKTHRU};

enum {sectorBOTTOM, sectorBACK, sectorTOP};

/* Type definitions */
typedef struct
	{
	BYTE 	Active;

	WORD	X;
	WORD	Y;
	WORD	Z;

	UWORD	ScreenX;
	UWORD	ScreenY;
	UWORD	Width;
	UWORD	Height;

	UWORD	OldX;
	UWORD	OldY;
	UWORD	OldW;
	UWORD	OldH;

	WORD	SpeedX;
	WORD	SpeedY;
	WORD	SpeedZ;
	WORD	OldSpeedZ;

	WORD	ShadowX;
	WORD	ShadowY;

	WORD	OldShadowX;
	WORD	OldShadowY;

	UWORD	Size;
	WORD	Step;
	WORD	Hits;
	WORD	GoldHits;
	BYTE	Style;
	BYTE	Caught;

	BYTE	Sector;

	LONG	*Image;
	} DEF_BALL;

/* Function Prototypes */					 

void   	SetBallSpeed( short who, short which, int x, int y, int z );
void	ApplyAttract( short who, short which );
void  	LimitBallSpeed( short who, short which );
void  	SetBallImage( short who, short which );
void  	ExplodeBall( short ballwho, short ballwhich, short paddlewho );
void  	BlankBall( short who, short which );
UWORD	LaunchBalls( short who );
void  	MoveBall( short who, short which );
void  	CheckBallLimits( short who, short which );
BYTE   	CheckBrickCollision( short who, short which, char sideflag );
void  	CheckPaddleCollision( short ballwho, short ballwhich );
void	CheckBallCollision( short who1, short which1, short who2, short which2 );
void	EraseBall( short who, short which );
void	DrawBall( short who, short which );
void	DisplayBall( short who, short which );


#endif