/*******************************************************************
 *
 *	TITLE:			Bomb.h
 *
 *	DESCRIPTION:	Header file for Bomb.c
 *
 *	AUTHOR:			Mario Perdue  Richard Degler
 *
 *	HISTORY:		06-28-95	New File
 *
 *
 *		   COPYRIGHT 1994, 1995 MP Graphics Systems		 
 *	  UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
 *	  PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
 *	 THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
 *						ALL RIGHTS RESERVED.			   
 *******************************************************************/

#ifndef __BOMB__H
#define __BOMB__H

#include "support.h"

#define BOMB_Y				3200
#define BOMB_OFFSET_Y		256

#define BOMB_WIDTH			11
#define BOMB_HEIGHT			11

#define BOMB_W				352
#define BOMB_H				352

#define BOMB_LAUNCH_WIDTH	64
#define BOMB_LAUNCH_HEIGHT	16

#define BOMB_LAUNCH_W		2560
#define BOMB_LAUNCH_H		512

#define BOMB_EXPLODE_WIDTH	64
#define BOMB_EXPLODE_HEIGHT	38

#define BOMB_EXPLODE_W		2048
#define BOMB_EXPLODE_H		950

#define BOMB_MAX_SPEED		96

#define BOMB_FLAGS			PITCH1 | PIXEL16 | WID12 | XADDINC
#define BOMB_LAUNCH_FLAGS	PITCH1 | PIXEL16 | WID64 | XADDINC
#define BOMB_EXPLODE_FLAGS	PITCH1 | PIXEL16 | WID64 | XADDINC

enum {bombLAUNCH, bombNORMAL, bombEXPLODE};

/* Type definitions */
typedef struct
	{
	BYTE 	Active;
	BYTE	Style;

	WORD 	X;
	WORD	Y;
	WORD	Z;

	UWORD 	ScreenX;
	UWORD 	ScreenY;
	UWORD 	OldX;
	UWORD	OldY;

	UWORD	Width;
	UWORD	Height;
	UWORD 	OldWidth;
	UWORD	OldHeight;

	WORD	SpeedX;
	WORD	SpeedY;
	WORD	SpeedZ;
	
	WORD	IncrY;

	UWORD	Scale;
	WORD	Step;
	} DEF_BOMB;


/* Function Prototypes */

void LimitBombSpeed( short who );
void SetBombSpeed(short who, int speedx, int speedy, int speedz);
void AnimateBomb( short who );
void LaunchBomb(short who);
void MoveBomb(short who);
void CheckBombCollision(short who);

void ExplodeBomb(short who);
void ExplodeBrick(short who);

void BlankBomb(short who);
void EraseBomb(short who);
void DrawBomb(short who);
void DisplayBomb(short who);


#endif
