/*******************************************************************
 *
 *    TITLE:        brick.h
 *
 *    DESCRIPTION:	Header file for brick.c
 *
 *    AUTHOR:		Mario Perdue & Richard Degler
 *
 *    HISTORY:    
 *
 *
 *           COPYRIGHT 1994, 1995 MP Graphics Systems         
 *      UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
 *      PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
 *     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
 *                        ALL RIGHTS RESERVED.               
 *******************************************************************/

#ifndef __BRICK__H
#define __BRICK__H

#include "support.h"

#define BRICK_IMAGES	3
#define BRICK_COLORS	12
#define BRICK_SIZES		5

#define BRICK_ROWS		10
#define BRICK_COLS		13
#define BRICK_TIERS		3

#define CENTER_BRICK	6

#define BRICK_WIDTH	  	20
#define BRICK_HEIGHT 	10

#define BRICK_ORIGIN_Z	4660

#define BRICK_AWIDTH	640
#define BRICK_AHEIGHT	492 
#define BRICK_ADEPTH	320

#define BRICK_BUFFER_HEIGHT		200
#define BRICK_BUFFER_WIDTH		320

#define BRICK_BUFFER_FLAGS			PITCH2 | PIXEL16 | WID320 | XADDPIX | ZOFFS1
#define BRICK_ERASE_BUFFER_FLAGS	PITCH2 | PIXEL16 | WID20 | XADDPIX | ZOFFS1
#define BRICK_IMAGE_FLAGS			PITCH1 | PIXEL16 | WID20 | XADDPIX
#define DROPBRICK_FLAGS				PITCH1 | PIXEL16 | WID80 | XADDPIX

#define	MAX_DROPBRICKS		4
#define DROP_STEPS			4


typedef struct
	{
	unsigned char Brick[BRICK_TIERS][BRICK_ROWS][BRICK_COLS];
	} DEF_SCREEN;

enum {RED, ORANGE, YELLOW, LT_GREEN, DK_GREEN, LT_BLUE, DK_BLUE, VIOLET, 
	  PURPLE, GOLD, SILVER1, SILVER2, SILVER3, SILVER4, SILVER5, SILVER6, 
	  SILVER7, SILVER8, SILVER9, FRAME=SILVER2, 
	  DROP=0xFE, NONE=0xFF};

enum {NO_DECREMENT, DECREMENT};

/* Type definitions */
typedef struct
	{
	BYTE 	Style;
	BYTE	Index;
	BYTE	Size;

	SCREENLOC	Screen;

	UWORD	Width;
	UWORD	Height;

	UWORD	Depth;
	} DEF_BRICK;

typedef struct
	{
	BYTE	Active;
	BYTE	Who;
	BYTE	Tier;
	BYTE	Row;
	BYTE	Col;

	BYTE 	OldStyle;

	SCREENLOC	Screen;

	BYTE	Size;
	BYTE	Step;

	UWORD	Depth;
	} DEF_DROPBRICK;

typedef struct
	{
	BYTE			AddIndex;
	BYTE			UseIndex;
	DEF_DROPBRICK	Data[128];
	} DEF_DROPBRICK_BUFFER;



/* Function Prototypes */					 

void InitBrickArray( short who );
void LoadBricks(void );
void PlaceBrickFrames( void );
void PlaceBricks( void );
void RestoreBrick( short who, int tier, int col, int row );
void EraseBrick( short who, int tier, int col, int row );
void BlankBrick( short who, int tier, int col, int row );
BYTE ClearBrick( short who, int tier, int col, int row, char DecFlag );
void DrawBrick( short who, int tier, int col, int row, char frame );
void DisplayBricks( short who, int tier, int col, int row, int cnt );

void ClearBrickBuffer( void );
void DoBrickPenalty( short who );

void StartDropBrick(short who, short tier, short col, short row);
void AnimateDropBricks( void );
void EraseDropBrick( short which );
void DrawDropBrick( short which );
void DisplayDropBrick( short which );

#endif
