/*******************************************************************
 *
 *    TITLE:        displays.c
 *
 *    DESCRIPTION:	Routines to handle the text, numeric and bar 
 *					displays for ball count, score, etc.
 *
 *    AUTHOR:		Mario Perdue & Richard Degler
 *
 *    HISTORY:    
 *
 *
 *           COPYRIGHT 1994, 1995 MP Graphics Systems         
 *      UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
 *      PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
 *     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
 *                        ALL RIGHTS RESERVED.               
 *******************************************************************/

/** include files **/
#include "\jaguar\include\jaguar.h"
#include "displays.h"
#include "jagobj.h"
#include "player.h"
#include "option.h"							
#include "b2k_game.h"


/** external data **/
extern	DEF_PLAYER		Player[2];

extern	int		 		ScreenOrgX;

extern	char			ROM_Background;   
extern	char			END_Background;   
extern	char			IMG_Background[][];
   
extern	WORD			IMG_Playfield[];
extern	WORD			IMG_PlayfieldBuffer[];
extern	WORD			IMG_Level[];
extern 	long 			IMG_Digit[3][11][40];
extern 	long 			IMG_BigDigit[10][128];

extern	WORD			ROM_Message[7][26][160];

extern	WORD			ROM_Title[];

extern	WORD			ROM_ScoreIcon[8][10][16];

extern	WORD			ROM_PopUpMusic[];
extern	WORD			ROM_PopUpEffects[];

extern	ULONG			ticks;

extern	DEF_OPTION		Option;

extern 	BYTE			PlayerOnTop;	

extern	DEF_BLIT_DATA	Blit[];
extern	LONG			BlitAddIndex;
extern	LONG			BlitUseIndex;

extern	ULONG			DemoTimer;

extern	int				ScreenCount;

extern	int		  		ScreenOrgY;
extern	WORD			IMG_Screen[];

extern	int				Screen;
/* public data */


/** internal functions **/
/*********************************************************************
 *  FUNCTION:		RefreshIcons
 *
 *  PARAMETERS:		char
 *
 *  DESCRIPTION:	Display the new score
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void RefreshIcons(short who)
	{
	if(Option.GameMode == gameCLASSIC)
		return;

	if(who == PLAYER_RED)
		{
		if(Player[PLAYER_RED].BallStyle==ballSUPER)
			DrawIcon(iconBLUEBALL, SUPERBALL_RED_X, SUPERBALL_RED_Y, ON);
		else
			DrawIcon(iconBLUEBALL, SUPERBALL_RED_X, SUPERBALL_RED_Y, OFF);
		DrawIcon(iconGUN, GUN_RED_X, GUN_RED_Y, Player[PLAYER_RED].Paddle.Gun);
		if(Player[PLAYER_RED].Paddle.Attract > 0)
			DrawIcon(iconATTRACT, ATTRACT_RED_X, ATTRACT_RED_Y, ON);
		else if(Player[PLAYER_RED].Paddle.Attract < 0)
			DrawIcon(iconREPEL, ATTRACT_RED_X, ATTRACT_RED_Y, ON);
		else
			DrawIcon(iconATTRACT, ATTRACT_RED_X, ATTRACT_RED_Y, OFF);
		DrawIcon(iconCATCH, CATCH_RED_X, CATCH_RED_Y, Player[PLAYER_RED].Paddle.Catch);
		}
	else
		{
		if(Player[PLAYER_GREEN].BallStyle==ballSUPER)
			DrawIcon(iconCYANBALL, SUPERBALL_GREEN_X, SUPERBALL_GREEN_Y, ON);
		else
			DrawIcon(iconCYANBALL, SUPERBALL_GREEN_X, SUPERBALL_GREEN_Y, OFF);
		DrawIcon(iconGUN, GUN_GREEN_X, GUN_GREEN_Y, Player[PLAYER_GREEN].Paddle.Gun);
		if(Player[PLAYER_GREEN].Paddle.Attract > 0)
			DrawIcon(iconATTRACT, ATTRACT_GREEN_X, ATTRACT_GREEN_Y, ON);
		else if(Player[PLAYER_RED].Paddle.Attract < 0)
			DrawIcon(iconREPEL, ATTRACT_GREEN_X, ATTRACT_GREEN_Y, ON);
		else
			DrawIcon(iconATTRACT, ATTRACT_GREEN_X, ATTRACT_GREEN_Y, OFF);
		DrawIcon(iconCATCH, CATCH_GREEN_X, CATCH_GREEN_Y, Player[PLAYER_GREEN].Paddle.Catch);
		}
	}

/*********************************************************************
 *  FUNCTION:		RefreshScoreBoard
 *
 *  PARAMETERS:		char
 *
 *  DESCRIPTION:	Display the new score
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void RefreshScoreBoard()
	{
	short who;

	if(Option.GameMode != gameCLASSIC)
		{
		DrawIcon(iconREDBALL, BALL_RED_X, BALL_RED_Y, ON);
		DrawIcon(iconREDBRICK, BRICK_RED_X, BRICK_RED_Y, ON);

		DrawIcon(iconGREENBALL, BALL_GREEN_X, BALL_GREEN_Y, Option.NumPlayers-1);
		DrawIcon(iconGREENBRICK, BRICK_GREEN_X, BRICK_GREEN_Y, Option.NumPlayers-1);
		}

	for(who=0; who<2; who++)
		{
		RefreshIcons(who);
		UpdateBallCount(who);
		UpdateScore(who, TRUE);
		UpdateBrickCount(who);
		}
	
	DisplayLevelBox();
	}

/*********************************************************************
 *  FUNCTION:		DrawIcon
 *
 *  PARAMETERS:		short which, int col, int row, int brightness
 *
 *  DESCRIPTION:	Display icon in Score Board
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void DrawIcon(short which, int col, int row, int bright)
	{
	int b_iinc;

	if(Option.GameMode == gameCLASSIC)
		return;

	if(bright)
		b_iinc  = 0x0L;
	else
		b_iinc  = (-127&0xFF)<<16;

	Blit[BlitAddIndex].Type		= blitBITMAP;

	Blit[BlitAddIndex].A1_Base  = (long)IMG_Background;
	Blit[BlitAddIndex].A1_Flags = BACKGROUND_FLAGS;
	Blit[BlitAddIndex].A1_Pixel	= (row<<16L) | (col & 0x0FFFFL);
	Blit[BlitAddIndex].A1_Step	= (1<<16L) | (-ICON_WIDTH & 0x0FFFFL);
										 
	Blit[BlitAddIndex].A2_Base	= (long)ROM_ScoreIcon[which];
	Blit[BlitAddIndex].A2_Flags	= PITCH1 | PIXEL16 | WID16 | XADDPIX;
	Blit[BlitAddIndex].A2_Pixel	= 0x0L;
	Blit[BlitAddIndex].A2_Step	= Blit[BlitAddIndex].A1_Step;

	Blit[BlitAddIndex].B_Count	= (ICON_HEIGHT<<16L) | 
										  (ICON_WIDTH & 0x0FFFFL);
	Blit[BlitAddIndex].B_Iinc	= b_iinc;
	Blit[BlitAddIndex].B_Patd	= 0x0L;
	Blit[BlitAddIndex].B_Cmd	= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN |
								  DSTEN | DCOMPEN | SRCSHADE | ZBUFF;
	
	QueBlit();
	}


/*********************************************************************
 *  FUNCTION:		UpdateScore
 *
 *  PARAMETERS:		short who
 *
 *  DESCRIPTION:	Display the new score
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void UpdateScore(short who, char DrawAll)
	{
	int i;
	char digit;
	static char odigit[2][8];
	int Bright;
	int Color;
	int X, Y;
	int DigitCount;

	if((Option.Skill[who] == skillNONE) && !DemoTimer)
		Player[who].Score = 0;

	if(Player[who].Score < 0)
		Player[who].Score = 0;

	if(Player[who].Score > 9999999L)
		Player[who].Score = 9999999L;

	if(!DrawAll && (Player[who].Score == Player[who].OldScore))
		return;

	switch(Option.GameMode)
		{
		case game2000:
		default:
			DigitCount = SCORE_DIGITS;

			if(who == PLAYER_RED)
				{
				X = SCORE_CNT_RED_X;
				Y = SCORE_CNT_RED_Y;
				Color = digitRED; 
				}
			else
				{
				X = SCORE_CNT_GREEN_X;
				Y = SCORE_CNT_GREEN_Y;
				Color = digitGREEN; 
				}
			break;

		case gameCLASSIC:
			if(who == PLAYER_GREEN)
				return;
			
			Color = 0;
			DigitCount = 3;
			X = 80;
			Y = 22;
			break;
		}
	Player[who].OldScore = Player[who].Score;

	for(i=DigitCount-1; i>=0; i--)
		{
		digit = GetDigit(Player[who].Score, i);
		if(who == PLAYER_RED)
			{
 			Bright = ON;
	   		if((pow10(i) > Player[who].Score) && (i>0))
	   			Bright = OFF;
			}
		else
			{
			if(Option.Skill[PLAYER_GREEN] == skillNONE)
				Bright = OFF;
			else
				Bright = ON;

	   		if((pow10(i) > Player[who].Score) && (i>0))
	   			Bright = OFF;
			}

		if(DrawAll || (digit != odigit[who][i]))
			{
			switch(Option.GameMode)
				{
				case game2000:
					PlaceHudDigit(digit, X-DIGIT_WIDTH*i, Y, Color, Bright);
					break;

				case gameCLASSIC:
					PlaceBigDigit(digit, X-18*i, Y);
					break;
				}
			odigit[who][i]=digit;
			}
		}
	}
	
/*********************************************************************
 *  FUNCTION:		UpdateBallCount
 *
 *  PARAMETERS:		short who
 *
 *  DESCRIPTION:	Display ball count
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void UpdateBallCount(short who)
	{
	int i;
	char digit;
	int Bright;
	int X, Y;
	int Color;
	int DigitCount;

	switch(Option.GameMode)
		{
		case game2000:
		default:
			DigitCount = BALL_DIGITS;
			if(who == PLAYER_RED)
				{
				X = BALL_CNT_RED_X;
				Y = BALL_CNT_RED_Y;
				Color = digitRED; 
				}
			else
				{
				X = BALL_CNT_GREEN_X;
				Y = BALL_CNT_GREEN_Y;
				Color = digitGREEN; 
				}
			break;

		case gameCLASSIC:
			if(who == PLAYER_GREEN)
				return;

			Color = 0;
			DigitCount = 1;
			X = 250;
			Y = 22;
			break;
		}

	if((Option.Skill[who] == skillNONE) && !DemoTimer)
		Player[who].BallCount = 0;

	if(Player[who].BallCount < 0)
		Player[who].BallCount = 0;

	if(Player[who].BallCount > 99)
		Player[who].BallCount = 99;

	for(i=DigitCount-1; i>=0; i--)
		{
		digit = GetDigit(Player[who].BallCount, i);
		if(who == PLAYER_RED)
			{
 			Bright = ON;
	   		if((pow10(i) > Player[who].BallCount) && (i>0))
	   			Bright = OFF;
			}
		else
			{
			if(Option.Skill[PLAYER_GREEN] == skillNONE)
				Bright = OFF;
			else
				Bright = ON;
	   		if((pow10(i) > Player[who].BallCount) && (i>0))
	   			Bright = OFF;
			}

		switch(Option.GameMode)
			{
			case game2000:
				PlaceHudDigit(digit, X-DIGIT_WIDTH*i, Y, Color, Bright);
				break;

			case gameCLASSIC:
				PlaceBigDigit(digit, X-18*i, Y);
				break;
			}
		}
	}
	
/*********************************************************************
 *  FUNCTION:		UpdateBrickCount
 *
 *  PARAMETERS:		short who
 *
 *  DESCRIPTION:	Display Brick count
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void UpdateBrickCount(short who)
	{
	int i;
	char digit;
	int Bright;
	int X, Y;
	int Color;

	if(Option.GameMode == gameCLASSIC)
		return;

	if(who == PLAYER_RED)
		{
		X = BRICK_CNT_RED_X;
		Y = BRICK_CNT_RED_Y;
		Color = digitRED; 
		}
	else
		{
		X = BRICK_CNT_GREEN_X;
		Y = BRICK_CNT_GREEN_Y;
		Color = digitGREEN; 
		}

	if(Player[who].BrickCount < 0)
		Player[who].BrickCount = 0;

	for(i=BRICK_DIGITS-1; i>=0; i--)
		{
		digit = GetDigit(Player[who].BrickCount, i);
		if(who == PLAYER_RED)
			{
 			Bright = ON;
	   		if((pow10(i) > Player[who].BrickCount) && (i>0))
	   			Bright = OFF;
			}
		else
			{
			Bright = Option.NumPlayers-1;
	   		if((pow10(i) > Player[who].BrickCount) && (i>0))
	   			Bright = OFF;
			}

		PlaceHudDigit(digit, X-DIGIT_WIDTH*i, Y, Color, Bright);
		}
	}
	
/*********************************************************************
 *  FUNCTION:		PlaceHudDigit
 *
 *  PARAMETERS:		short who, char hud, char digit, int col, int row
 *
 *  DESCRIPTION:	Draw a numeric digit at the specified screen loc.
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void PlaceHudDigit(short digit, int col, int row, short color, int bright)
	{
	if(!bright)
		digit = 10;

	Blit[BlitAddIndex].Type		= blitBITMAP;

	Blit[BlitAddIndex].A1_Base	= (long)IMG_Background;
	Blit[BlitAddIndex].A1_Flags	= BACKGROUND_FLAGS;
	Blit[BlitAddIndex].A1_Pixel	= (row<<16L) | (col & 0x0FFFFL);
	Blit[BlitAddIndex].A1_Step	= (1<<16L) | (-(DIGIT_WIDTH+1) & 0x0FFFFL);
										 
	Blit[BlitAddIndex].A2_Base	= (long)IMG_Digit[color][digit];
	Blit[BlitAddIndex].A2_Flags	= PITCH1 | PIXEL16 | WID8 | XADDPIX;
	Blit[BlitAddIndex].A2_Pixel	= 0x0L;
	Blit[BlitAddIndex].A2_Step	= Blit[BlitAddIndex].A1_Step;

	Blit[BlitAddIndex].B_Count	= (DIGIT_HEIGHT<<16L) | 
										  ((DIGIT_WIDTH+1) & 0x0FFFFL);
										 
	Blit[BlitAddIndex].B_Patd	= 0x0L;
	Blit[BlitAddIndex].B_Cmd	= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;
	
	QueBlit();
	}

/*********************************************************************
 *  FUNCTION:		PlaceBigDigit
 *
 *  PARAMETERS:		short who, char digit, int col, int row
 *
 *  DESCRIPTION:	Draw a numeric digit at the specified screen loc.
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void PlaceBigDigit(short digit, int col, int row)
	{
	Blit[BlitAddIndex].Type		= blitBITMAP;

	Blit[BlitAddIndex].A1_Base	= (long)IMG_Background;
	Blit[BlitAddIndex].A1_Flags	= BACKGROUND_FLAGS;
	Blit[BlitAddIndex].A1_Pixel	= (row<<16L) | (col & 0x0FFFFL);
	Blit[BlitAddIndex].A1_Step	= (1<<16L) | (-16 & 0x0FFFFL);
										 
	Blit[BlitAddIndex].A2_Base	= (long)IMG_BigDigit[digit];
	Blit[BlitAddIndex].A2_Flags	= PITCH1 | PIXEL16 | WID16 | XADDPIX;
	Blit[BlitAddIndex].A2_Pixel	= 0x0L;
	Blit[BlitAddIndex].A2_Step	= Blit[BlitAddIndex].A1_Step;

	Blit[BlitAddIndex].B_Count	= (16<<16L) | (16 & 0x0FFFFL);
										 
	Blit[BlitAddIndex].B_Patd	= 0x0L;

	Blit[BlitAddIndex].B_Cmd	= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;
	
	QueBlit();
	}

/*********************************************************************
 *  FUNCTION:		GetDigit
 *														   
 *  PARAMETERS:		int value, int digit
 *
 *  DESCRIPTION:	Get the specified digit from a numeric value
 *
 *  RETURNS:		void
 *
 *********************************************************************/
int GetDigit( int value, int digit)
	{
	int temp;

	value = abs(value);
	temp = (value/pow10(digit+1))*pow10(digit+1);

	return( (value-temp)/pow10(digit) );
	}

/*********************************************************************
 *  FUNCTION:		pow10
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	return 10 raised to the specified power.
 *
 *  RETURNS:		void
 *
 *********************************************************************/
int pow10(int exponent)
	{
	int i;
	int value;

	value = 1;
	for(i=0; i<exponent; i++)
		value *= 10;

	return(value);
	}



/*********************************************************************
 *  FUNCTION:		EraseMessage
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	Erase the message from the buffer
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void HideMessage()
	{
	/* Clear the old image */
	Blit[BlitAddIndex].Type		= blitBITMAP;

	Blit[BlitAddIndex].A1_Base	= (long)IMG_Playfield;
	Blit[BlitAddIndex].A1_Flags	= PLAYFIELD_FLAGS;
	Blit[BlitAddIndex].A1_Pixel	= ((MESSAGE_Y+20)<<16L) | (MESSAGE_X & 0x0FFFFL);
	Blit[BlitAddIndex].A1_Step	= (1<<16L)|(-MESSAGE_WIDTH & 0x0FFFFL);
										 
	Blit[BlitAddIndex].A2_Base	= (long)IMG_PlayfieldBuffer;
	Blit[BlitAddIndex].A2_Flags	= PLAYFIELD_BUFFER_FLAGS;
	Blit[BlitAddIndex].A2_Pixel	= (MESSAGE_Y<<16L) | (MESSAGE_X & 0x0FFFFL);
	Blit[BlitAddIndex].A2_Step	= Blit[BlitAddIndex].A1_Step;

	Blit[BlitAddIndex].B_Count	= (MESSAGE_HEIGHT<<16L) | MESSAGE_WIDTH;
										 
	Blit[BlitAddIndex].B_Patd	= 0x0L;
	Blit[BlitAddIndex].B_Cmd	= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;
	
	QueBlit();
	}

/*********************************************************************
 *  FUNCTION:		DrawMessage
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	Draw the message to the buffer
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void ShowMessage(short message)
	{
	Blit[BlitAddIndex].Type		= blitBITMAP;

	Blit[BlitAddIndex].A1_Base	= (long)IMG_Playfield;
	Blit[BlitAddIndex].A1_Flags	= PLAYFIELD_FLAGS;
	Blit[BlitAddIndex].A1_Pixel	= ((MESSAGE_Y+20)<<16L) | (MESSAGE_X & 0x0FFFFL);
	Blit[BlitAddIndex].A1_Step	= (1<<16L) | (-MESSAGE_WIDTH & 0x0FFFFL);
											 
	Blit[BlitAddIndex].A2_Base	= (long)ROM_Message[message];
	Blit[BlitAddIndex].A2_Flags	= MESSAGE_FLAGS;
	Blit[BlitAddIndex].A2_Pixel	= 0x0L;
	Blit[BlitAddIndex].A2_Step	= (1<<16L) | (-MESSAGE_WIDTH & 0x0FFFFL);

	Blit[BlitAddIndex].B_Count	= (MESSAGE_HEIGHT<<16L) | (MESSAGE_WIDTH & 0x0FFFFL);
											 
	Blit[BlitAddIndex].B_Patd	= 0x0L;

	Blit[BlitAddIndex].B_Cmd	= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN | 
								  DSTEN | DCOMPEN;
	QueBlit();
  	}


/*********************************************************************
 *  FUNCTION:		ShowTitle
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	Run display seq for title
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void ShowTitle()
	{
	/* Expand compressed images from ROM to RAM */
	ExpandLzjag(IMG_PlayfieldBuffer, ROM_Title);

	Blit[BlitAddIndex].Type		= blitBITMAP;

	Blit[BlitAddIndex].A1_Base	= (long)IMG_Playfield;
	Blit[BlitAddIndex].A1_Flags	= PLAYFIELD_FLAGS;
	Blit[BlitAddIndex].A1_Pixel	= 0x0L;
	Blit[BlitAddIndex].A1_Step	= (1<<16L)|(-PLAYFIELD_WIDTH & 0x0FFFFL);
										 
	Blit[BlitAddIndex].A2_Base	= (long)IMG_PlayfieldBuffer;
	Blit[BlitAddIndex].A2_Flags	= Blit[BlitAddIndex].A1_Flags;
	Blit[BlitAddIndex].A2_Pixel	= Blit[BlitAddIndex].A1_Pixel;
	Blit[BlitAddIndex].A2_Step	= Blit[BlitAddIndex].A1_Step;

	Blit[BlitAddIndex].B_Count	= (PLAYFIELD_HEIGHT<<16L) | 
								  (PLAYFIELD_WIDTH & 0x0FFFFL);
										 
	Blit[BlitAddIndex].B_Patd	= 0x0L;
	Blit[BlitAddIndex].B_Cmd	= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;
	
	QueBlit();
	}


/*********************************************************************
 *  FUNCTION:	  ShowPopup
 *
 *  PARAMETERS:	  
 *
 *  DESCRIPTION:  
 *
 *  RETURNS:	  
 *
 *********************************************************************/
void ShowPopup(int which)
	{
	if(which == popupMUSIC)
		Blit[BlitAddIndex].A2_Base	= (long)ROM_PopUpMusic;
	else
		Blit[BlitAddIndex].A2_Base	= (long)ROM_PopUpEffects;
	
	Blit[BlitAddIndex].Type		= blitBITMAP;

	Blit[BlitAddIndex].A1_Base	= (long)IMG_Playfield;
	Blit[BlitAddIndex].A1_Flags	= PLAYFIELD_FLAGS;
	Blit[BlitAddIndex].A1_Pixel	= (POPUP_Y<<16) | (POPUP_X&0xFFFFL);
	Blit[BlitAddIndex].A1_Step	= (1<<16L)|(-POPUP_WIDTH & 0xFFFFL);
										 
	Blit[BlitAddIndex].A2_Flags	= POPUP_FLAGS;
	Blit[BlitAddIndex].A2_Pixel	= 0x0L;
	Blit[BlitAddIndex].A2_Step	= Blit[BlitAddIndex].A1_Step;

	Blit[BlitAddIndex].B_Count	= (POPUP_HEIGHT<<16L) | (POPUP_WIDTH & 0xFFFFL);
										 
	Blit[BlitAddIndex].B_Patd	= 0x0L;
	Blit[BlitAddIndex].B_Cmd	= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;
	
	QueBlit();
	}


void HidePopup()
	{
	Blit[BlitAddIndex].Type		= blitBITMAP;

	Blit[BlitAddIndex].A1_Base	= (long)IMG_Playfield;
	Blit[BlitAddIndex].A1_Flags	= PLAYFIELD_FLAGS;
	Blit[BlitAddIndex].A1_Pixel	= ((POPUP_Y)<<16L) | (POPUP_X & 0x0FFFFL);
	Blit[BlitAddIndex].A1_Step	= (1<<16L)|(-POPUP_WIDTH & 0x0FFFFL);
										 
	Blit[BlitAddIndex].A2_Base	= (long)IMG_PlayfieldBuffer;
	Blit[BlitAddIndex].A2_Flags	= PLAYFIELD_BUFFER_FLAGS;
	Blit[BlitAddIndex].A2_Pixel	= ((POPUP_Y-20)<<16L) | (POPUP_X & 0x0FFFFL);
	Blit[BlitAddIndex].A2_Step	= Blit[BlitAddIndex].A1_Step;

	Blit[BlitAddIndex].B_Count	= (POPUP_HEIGHT<<16L) | POPUP_WIDTH;
										 
	Blit[BlitAddIndex].B_Patd	= 0x0L;
	Blit[BlitAddIndex].B_Cmd	= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;
	
	QueBlit();
	}

void DisplayLevelBox()
	{
	if(Option.GameMode == gameCLASSIC)
		return;

	Blit[BlitAddIndex].Type		= blitBITMAP;

	Blit[BlitAddIndex].A1_Base	= (long)IMG_Background;
	Blit[BlitAddIndex].A1_Flags	= BACKGROUND_FLAGS;
	Blit[BlitAddIndex].A1_Pixel	= ((LEVEL_Y)<<16L) | (LEVEL_X & 0x0FFFFL);
	Blit[BlitAddIndex].A1_Step	= (1<<16L)|(-LEVEL_WIDTH & 0x0FFFFL);
										 
	Blit[BlitAddIndex].A2_Base	= (long)IMG_Level;
	Blit[BlitAddIndex].A2_Flags	= LEVEL_FLAGS;
	Blit[BlitAddIndex].A2_Pixel	= 0x0L;
	Blit[BlitAddIndex].A2_Step	= Blit[BlitAddIndex].A1_Step;

	Blit[BlitAddIndex].B_Count	= (LEVEL_HEIGHT<<16L) | LEVEL_WIDTH;
										 
	Blit[BlitAddIndex].B_Patd	= 0x0L;
	Blit[BlitAddIndex].B_Cmd	= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;
	
	QueBlit();


	PlaceHudDigit(Screen/5, LEVEL_X+4, LEVEL_Y+2, digitBLUE, ON);
	PlaceHudDigit(Screen%5, LEVEL_X+17, LEVEL_Y+2, digitBLUE, ON);
	}