/*******************************************************************
 *
 *    TITLE:        displays.h
 *
 *    DESCRIPTION:	header file for displays.c
 *
 *    AUTHOR:		Mario Perdue & Richard Degler
 *
 *    HISTORY:    
 *
 *
 *           COPYRIGHT 1994, 1995 MP Graphics Systems         
 *      UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
 *      PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
 *     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
 *                        ALL RIGHTS RESERVED.               
 *******************************************************************/

#ifndef __DISPLAYS__H
#define __DISPLAYS__H

#include "support.h"

#define DIGIT_WIDTH			6
#define DIGIT_HEIGHT 		10

#define MESSAGE_WIDTH		160
#define MESSAGE_HEIGHT		26
#define MESSAGE_X			80
#define MESSAGE_Y			86
#define MESSAGE_FLAGS		PITCH1 | PIXEL16 | WID160 | XADDPIX


#define SCORE_DIGITS		8
#define BALL_DIGITS			2
#define BRICK_DIGITS		3

#define	SCORE_CNT_RED_X		138
#define	SCORE_CNT_RED_Y		129
#define SCORE_RED_X			96
#define SCORE_RED_Y			129
#define	BALL_CNT_RED_X		112
#define BALL_CNT_RED_Y		115
#define BALL_RED_X			91
#define BALL_RED_Y			115
#define BRICK_CNT_RED_X		150
#define BRICK_CNT_RED_Y		115
#define BRICK_RED_X			121
#define BRICK_RED_Y			115
#define SUPERBALL_RED_X		92
#define SUPERBALL_RED_Y		101
#define GUN_RED_X 			109
#define GUN_RED_Y 			101
#define ATTRACT_RED_X		126
#define ATTRACT_RED_Y		101
#define CATCH_RED_X			142
#define CATCH_RED_Y			101

#define	SCORE_CNT_GREEN_X	218
#define	SCORE_CNT_GREEN_Y	129
#define SCORE_GREEN_X		208
#define SCORE_GREEN_Y		129
#define	BALL_CNT_GREEN_X   	207
#define BALL_CNT_GREEN_Y   	115
#define	BALL_GREEN_X   		213
#define BALL_GREEN_Y   		115
#define BRICK_CNT_GREEN_X	176
#define BRICK_CNT_GREEN_Y	115
#define BRICK_GREEN_X	 	182
#define BRICK_GREEN_Y	 	115
#define SUPERBALL_GREEN_X	213
#define SUPERBALL_GREEN_Y	101
#define GUN_GREEN_X    		196
#define GUN_GREEN_Y    		101
#define ATTRACT_GREEN_X		180
#define ATTRACT_GREEN_Y		101
#define CATCH_GREEN_X	   	164
#define CATCH_GREEN_Y	   	101

#define TITLE_X 			64
#define TITLE_Y 			60
#define TITLE_WIDTH			192
#define TITLE_HEIGHT		56
#define TITLE_FLAGS			PITCH1 | PIXEL16 | WID192 | XADDPIX

#define ICON_WIDTH			16
#define ICON_HEIGHT			10

#define POPUP_X				80
#define POPUP_Y				136
#define POPUP_WIDTH			160
#define POPUP_HEIGHT		40
#define POPUP_FLAGS			PITCH1 | PIXEL16 | WID160 | XADDPIX

#define LEVEL_X 			146
#define LEVEL_Y 			127
#define LEVEL_WIDTH			28
#define LEVEL_HEIGHT		14
#define LEVEL_FLAGS			PITCH1 | PIXEL16 | WID28 | XADDPIX

enum {msgPAUSED, msgDEMO, msgLOAD, msgPONG, msgTARGET, msgOVER, msgCLEAR};

enum {digitRED, digitGREEN, digitBLUE};

enum {PLUS=10, MINUS};

enum {iconREDBALL, iconGREENBALL, iconBLUEBALL, iconCYANBALL, 
	  iconGUN, iconATTRACT, iconREPEL, iconCATCH, 
	  iconREDBRICK, iconGREENBRICK,
	  iconREDSCORE, iconGREENSCORE};

enum {popupMUSIC, popupEFFECTS};

/* Function Prototypes */

void	RefreshIcons( short who );
void	RefreshScoreBoard( void );
void	DrawIcon(short which, int col, int row, int bright);

void 	UpdateScore( short who, char DrawAll );
void 	UpdateBallCount( short who );
void	UpdateBrickCount( short who );

void 	PlaceHudDigit( short digit, int col, int row, short color, int bright );
void	PlaceBigDigit( short digit, int col, int row);
int 	GetDigit( int value, int digit );

int 	pow10( int exponent );

void	ShowMessage( short message );
void	HideMessage( void );

void	ShowTitle( void );

void	ShowPopup(int which);
void	HidePopup();

void	DisplayLevelBox( void );
#endif