/*******************************************************************
 *
 *    TITLE:        droid.c
 *
 *    DESCRIPTION:	Routines for handleing goodies
 *
 *    AUTHOR:		Mario Perdue & Richard Degler
 *
 *    HISTORY:    
 *
 *
 *           COPYRIGHT 1994, 1995 MP Graphics Systems         
 *      UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
 *      PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
 *     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
 *                        ALL RIGHTS RESERVED.               
 *******************************************************************/

/** include files **/
#include "\jaguar\include\jaguar.h"
#include "droid.h"
#include "support.h"
#include "paddle.h"
#include "player.h"
#include "ripple.h"
#include "goody.h"
#include "b2k_game.h"
#include "option.h"


/** external data **/
extern	WORD		ROM_Droid_1[3][13][29][56];
extern	WORD		ROM_Droid_2[3][13][41][40];
extern	WORD		ROM_Droid_3[3][13][25][48];
extern	WORD		IMG_Droid[];

extern	WORD		IMG_Playfield[];
extern	WORD  		IMG_PlayfieldBuffer[];
extern	WORD  		IMG_BrickBuffer[];

extern	DEF_PLAYER	Player[2];

extern 	int 		ScreenOrgX;
extern 	int			ScreenOrgY;

extern 	int			BallMaxSpeedX;
extern 	int			BallMaxSpeedY;
extern 	int			BallMaxSpeedZ;

extern 	BYTE 		PlayerOnTop;	
extern	DEF_BLIT_DATA	Blit[];
extern	LONG			BlitAddIndex;
extern	LONG			BlitUseIndex;

extern	DEF_DROID_PATH	ROM_DroidPath[5][12];
extern	int				ScreenCount;

extern	DEF_OPTION			Option;

DEF_DROID			Droid;

/** internal functions **/
/*********************************************************************
 *  FUNCTION: 	   SetDroidImage
 *
 *  PARAMETERS:	   short which
 *
 *  DESCRIPTION:   Blits the Active droid image into ram
 *
 *  RETURNS:	   void
 *
 *********************************************************************/
void SetDroidImage(  )
	{
	int a1_flags;
	long a2_base;

	switch(Droid.Style)
		{
		case droidSTINGER:
			a1_flags = PITCH1 | PIXEL16 | WID56 | XADDPHR;
			a2_base  = (long)ROM_Droid_1[0];
			break;

		case droidROBOT:
			a1_flags = PITCH1 | PIXEL16 | WID40 | XADDPHR;
			a2_base  = (long)ROM_Droid_2[0];
			break;

		case droidSHOEBOX:
		default:
			a1_flags = PITCH1 | PIXEL16 | WID48 | XADDPHR;
			a2_base  = (long)ROM_Droid_3[0];
			break;
		}

	Blit[BlitAddIndex].Type = blitBITMAP;

	Blit[BlitAddIndex].A1_Base  = (long)IMG_Droid;
	Blit[BlitAddIndex].A1_Flags = a1_flags;
	Blit[BlitAddIndex].A1_Pixel = 0x0L;
	Blit[BlitAddIndex].A1_Step  = (1<<16L) | (-Droid.Width&0xFFFFL);

	Blit[BlitAddIndex].A2_Base  = a2_base;
	Blit[BlitAddIndex].A2_Flags = Blit[BlitAddIndex].A1_Flags;
	Blit[BlitAddIndex].A2_Pixel = Blit[BlitAddIndex].A1_Pixel;
	Blit[BlitAddIndex].A2_Step  = Blit[BlitAddIndex].A1_Step;

	Blit[BlitAddIndex].B_Count  = ((Droid.Height*39)<<16L) | 
										 (Droid.Width&0xFFFFL);
	Blit[BlitAddIndex].B_Patd   = 0x0L;

	Blit[BlitAddIndex].B_Cmd    = LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;
	
	QueBlit();
	}

/*********************************************************************
 *  FUNCTION:		SetDroidLocation
 *
 *  PARAMETERS:		int X
 *					int Y
 *					int Z
 *
 *  DESCRIPTION:	Place the droid at the specified 3D location
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void  SetDroidLocation( int X, int Y, int Z )
	{
	SCREENLOC Loc;

	Droid.Loc.X = X;
	Droid.Loc.Y = Y;
	Droid.Loc.Z = Z;

	Loc = PlayfieldToScreen(Droid.Loc.X, Droid.Loc.Y, Droid.Loc.Z);

	Droid.Screen.X = Loc.X;
	Droid.Screen.Y = Loc.Y;

	Droid.Old.X = Loc.X;
	Droid.Old.Y = Loc.Y;

	Droid.Scale = GetDepthScale(Droid.Loc.Z);
	}

/*********************************************************************
 *  FUNCTION:		SetDroidDestination
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	Set the direction, speed and location to the next
 *					point in the path.
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void SetDroidDestination()
	{
	Droid.NewHeading = ROM_DroidPath[Droid.Path][Droid.Index].Direction;
	Droid.Shoot		 = ROM_DroidPath[Droid.Path][Droid.Index].Shoot;

	Droid.Dest.X	 = ROM_DroidPath[Droid.Path][Droid.Index].X;
	Droid.Dest.Y	 = ROM_DroidPath[Droid.Path][Droid.Index].Y;
	Droid.Dest.Z	 = ROM_DroidPath[Droid.Path][Droid.Index].Z;

	Droid.SpeedX = (Droid.Dest.X-Droid.Loc.X)/ROM_DroidPath[Droid.Path][Droid.Index].Steps;
	Droid.SpeedY = (Droid.Dest.Y-Droid.Loc.Y)/ROM_DroidPath[Droid.Path][Droid.Index].Steps;
	Droid.SpeedZ = (Droid.Dest.Z-Droid.Loc.Z)/ROM_DroidPath[Droid.Path][Droid.Index].Steps;
	}
	
		
/*********************************************************************
 *  FUNCTION:		StartDroid
 *
 *  PARAMETERS:		int which
 *
 *  DESCRIPTION:	Start a droid at random path from the Vanishing Point
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void  StartDroid(int which)
	{
	if(Droid.Active)
		return;

	if(Option.GameMode != game2000)
		return;

	if((Player[PLAYER_RED].Mode == modeKILLSCREEN) ||
	   (Player[PLAYER_GREEN].Mode == modeKILLSCREEN))
		return;

	if((Player[PLAYER_RED].Mode == modeREVIVESCREEN) ||
	   (Player[PLAYER_GREEN].Mode == modeREVIVESCREEN))
		return;

	Droid.Style = which;

	if(Droid.Style >= droidLAST)
		{
		Droid.Active = FALSE;
		Droid.Style = 0;
		return;
		}

	Droid.Index = 0;
	Droid.Step = 0;
	Droid.Path = Random(5);
	Droid.Active = TRUE;

	switch(Droid.Style)
		{
		case droidSTINGER:
			Droid.Width = 56;
			Droid.Height = 29;
			Droid.Flags = DROID_1_FLAGS;
			break;

		case droidROBOT:
			Droid.Width = 40;
			Droid.Height = 41;
			Droid.Flags = DROID_2_FLAGS;
			break;

		case droidSHOEBOX:
			Droid.Width = 48;
			Droid.Height = 25;
			Droid.Flags = DROID_3_FLAGS;
			break;
		}

	SetDroidDestination();
	SetDroidLocation(0, 0, 400);

	SetDroidImage();
	}

/*********************************************************************
 *  FUNCTION:		AbortDroid
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	Sets droid destination and speed for exit
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void AbortDroid()
	{
	if(!Droid.Active)
		return;

	if(!Droid.Dest.X &&	!Droid.Dest.Y && !Droid.Dest.Z)
		return;

	Droid.NewHeading = 12;
	Droid.Dest.X	 = 0;
	Droid.Dest.Y	 = 0;
	Droid.Dest.Z	 = 0;

	Droid.SpeedX = -MAX(1,Droid.Loc.X/25);
	Droid.SpeedY = -MAX(1,Droid.Loc.Y/25);
	Droid.SpeedZ = -MAX(1,Droid.Loc.Z/25);
	}
	
		

/*********************************************************************
 *  FUNCTION:		MoveDroid
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	Move the Droid to the next screen location
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void  MoveDroid()
	{
	SCREENLOC Loc;
	int DeltaX, DeltaY, DeltaZ;
	char goody;
	char player;
	
	if(Droid.Active)
		{
		Droid.Old.X = Droid.Screen.X;
		Droid.Old.Y = Droid.Screen.Y;

		Droid.Direction += 24;

		if(((Droid.Direction-Droid.NewHeading)%24)>12)
			Droid.Direction++;
		else if((Droid.Direction-Droid.NewHeading)%24)
			Droid.Direction--;

		Droid.Direction %= 24;

		/* Apply the Droid movement */
		DeltaX = abs(Droid.Dest.X-Droid.Loc.X);
		DeltaY = abs(Droid.Dest.Y-Droid.Loc.Y);
		DeltaZ = abs(Droid.Dest.Z-Droid.Loc.Z);

		if(DeltaX <= MAX(16, abs(Droid.SpeedX)) )
			Droid.Loc.X = Droid.Dest.X;
		else
			Droid.Loc.X += Droid.SpeedX;

		if(DeltaY <= MAX(16, abs(Droid.SpeedY)) )
			Droid.Loc.Y = Droid.Dest.Y;
		else
			Droid.Loc.Y += Droid.SpeedY;

		if(DeltaZ <= MAX(16, abs(Droid.SpeedZ))	)
			Droid.Loc.Z = Droid.Dest.Z;
		else
			Droid.Loc.Z += Droid.SpeedZ;

		Droid.Scale = GetDepthScale(Droid.Loc.Z);

		CheckDroidLimits();

		Loc = PlayfieldToScreen(Droid.Loc.X, Droid.Loc.Y, Droid.Loc.Z);
		Droid.Screen.X = Loc.X - Droid.Width*Droid.Scale/200;
		Droid.Screen.Y = Loc.Y - Droid.Height*Droid.Scale/200;

		DeltaX = abs(Droid.Dest.X-Droid.Loc.X);
		DeltaY = abs(Droid.Dest.Y-Droid.Loc.Y);
		DeltaZ = abs(Droid.Dest.Z-Droid.Loc.Z);
		
		if(++Droid.Step > 100)
			AbortDroid();

		if(!DeltaX && !DeltaY && !DeltaZ)
			{
			Droid.Step = 0;

			if(Droid.Shoot)
				{
				switch (Droid.Style)
					{
					case droidSTINGER:
						if(Droid.Loc.Y <= 0)
							LaunchStinger(PLAYER_ON_TOP, Droid.Loc.X,
									Droid.Loc.Y, Droid.Loc.Z);
						if(Droid.Loc.Y >= 0)
							LaunchStinger(PLAYER_ON_BOTTOM, Droid.Loc.X, 
									Droid.Loc.Y, Droid.Loc.Z);
						break;

					case droidROBOT:
					case droidSHOEBOX:
						goody = Random(goodyLAST);

						if(Droid.Loc.Y < 0)
							player = PLAYER_ON_TOP;
						else if(Droid.Loc.Y > 0)
							player = PLAYER_ON_BOTTOM;
						else
							player = Random(2);
							
						LaunchGoody(player, goody, Droid.Loc.X, Droid.Loc.Y, Droid.Loc.Z);
						break;
				  	}
				}
			Droid.Index++;
			SetDroidDestination();
			}
		}
	}

/*********************************************************************
 *  FUNCTION:		CheckDroidLimits
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	Keep the Droid in the playfield
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void  CheckDroidLimits()
	{
	if (!Droid.Active)
		return;
		  
	if(Droid.Loc.Z < 400)	  
		{
		EraseDroid();
		DisplayDroid();

		Droid.Active = FALSE;
		}
	}
	

/*********************************************************************
 *  FUNCTION:		EraseDroid
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	Remove a droid from the buffer
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void EraseDroid( )
	{
	int EndX;
	int Offset;
	int StepWidth;

	if(!Droid.Active)
		return;

	EndX = Droid.Old.X+Droid.Width;
	Offset = EndX & 3;
	if(Offset)
		StepWidth = Droid.Width+4-Offset;
	else
		StepWidth = Droid.Width;

	Blit[BlitAddIndex].Type = blitBITMAP;

	Blit[BlitAddIndex].A1_Base  = (long)IMG_PlayfieldBuffer;
	Blit[BlitAddIndex].A1_Flags = PITCH2 | PIXEL16 | WID320 | XADDPHR |
										 ZOFFS1;
	Blit[BlitAddIndex].A1_Pixel = (Droid.Old.Y<<16) | 
										 (Droid.Old.X & 0xFFFFL);
	Blit[BlitAddIndex].A1_Step  = (1<<16) | (-StepWidth & 0xFFFFL);

	Blit[BlitAddIndex].A2_Base  = (long)IMG_BrickBuffer;
	Blit[BlitAddIndex].A2_Flags = Blit[BlitAddIndex].A1_Flags;
	Blit[BlitAddIndex].A2_Pixel = Blit[BlitAddIndex].A1_Pixel;
	Blit[BlitAddIndex].A2_Step  = Blit[BlitAddIndex].A1_Step;

	Blit[BlitAddIndex].B_Count  = (Droid.Height<<16) | 
										 (Droid.Width & 0xFFFFL);
	Blit[BlitAddIndex].B_Patd   = 0xFFFFL;

	Blit[BlitAddIndex].B_Cmd    = LFU_REPLACE | UPDA1 | UPDA2 | SRCEN | 
								  SRCENZ | DSTWRZ;
	
	QueBlit();
	}


/*********************************************************************
 *  FUNCTION:		DrawDroid
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	Draw a droid in the buffer
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void DrawDroid()
	{
	int Angle;
	int Index;

	int ScaledWidth;
	int ScaledHeight;
	LONG Increment;
	int	Fraction;

	int Direction;

	int a2_flags;
	int a2_pixel;
	int a2_step;

	if(!Droid.Active)
		return;

	Direction = Droid.Direction+24;

	if(Droid.Loc.X < -2000)
		Direction -= 1;
	if(Droid.Loc.X > 2000)
		Direction += 1;

	Direction %= 24;
	
	if(Droid.Loc.Y < -DROID_Y_LIMIT/3)
		Angle = 0;
	else if(Droid.Loc.Y > DROID_Y_LIMIT/3)
		Angle = 2;
	else 
		Angle = 1;

	if(Direction > 12)
		Index = (Angle*13+24-Direction)*Droid.Height*Droid.Width;
	else
		Index = (Angle*13+Direction)*Droid.Height*Droid.Width;

	ScaledWidth = (Droid.Width*Droid.Scale/100) & 0x0FFFFL;
	ScaledHeight = (Droid.Height*Droid.Scale/100) & 0x0FFFFL;

 	Increment = 0x10000*Droid.Width/ScaledWidth;
	Fraction = Increment & 0x0FFFF;
 	Increment /= 0x010000;

	if(Direction > 12)
		{
		a2_flags	= PLAYFIELD_BUFFER_FLAGS | XSIGNSUB;
		a2_pixel	= (Droid.Screen.Y<<16) | ((Droid.Screen.X+ScaledWidth)&0xFFFFL);
		a2_step		= (1<<16) | (ScaledWidth & 0xFFFFL);
		}
	else
		{
		a2_flags	= PLAYFIELD_BUFFER_FLAGS;
		a2_pixel	= (Droid.Screen.Y<<16) | (Droid.Screen.X&0xFFFFL);
		a2_step	= (1<<16) | (-ScaledWidth & 0xFFFFL);
		}

	Blit[BlitAddIndex].Type		= blitSCALED;

	Blit[BlitAddIndex].A1_Base	= (long)&IMG_Droid[Index];
	Blit[BlitAddIndex].A1_Flags	= Droid.Flags;
	Blit[BlitAddIndex].A1_Clip	= (Droid.Height<<16) | 
										  (Droid.Width & 0xFFFFL);
	Blit[BlitAddIndex].A1_Pixel	= 0x0L;
	Blit[BlitAddIndex].A1_Fpixel	= 0x0L;
	Blit[BlitAddIndex].A1_Step	= (Increment<<16) | 
										  (-Droid.Width & 0xFFFFL);
	Blit[BlitAddIndex].A1_Fstep	= Fraction<<16;
	Blit[BlitAddIndex].A1_Inc	= Increment & 0xFFFFL;
	Blit[BlitAddIndex].A1_Finc	= Fraction & 0xFFFFL;
										 
	Blit[BlitAddIndex].A2_Base	= (long)IMG_PlayfieldBuffer;
	Blit[BlitAddIndex].A2_Flags	= a2_flags;
	Blit[BlitAddIndex].A2_Pixel	= a2_pixel;
	Blit[BlitAddIndex].A2_Step	= a2_step;

	Blit[BlitAddIndex].B_Count	= (ScaledHeight<<16) | ScaledWidth;
										 
	Blit[BlitAddIndex].B_Patd	= 0x0L;
	Blit[BlitAddIndex].B_Srcz1	= Droid.Loc.Z;

	Blit[BlitAddIndex].B_Cmd	= LFU_REPLACE | UPDA1 | UPDA1F | UPDA2 | 
								  DSTA2 | SRCEN | DSTEN | DCOMPEN | 
								  /*DSTENZ | DSTWRZ | ZMODELT | ZMODEEQ |*/ 
								  CLIP_A1;
	
	QueBlit();
	}


/*********************************************************************
 *  FUNCTION:		DisplayDroid
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	Display a Droid from the buffer
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void DisplayDroid()
	{
	SCREENLOC Loc;
	int DeltaX, DeltaY;
	int Width, Height;

	ULONG step;

	int EndX;
	int Offset;
	int StepWidth;

	if(!Droid.Active)
		return;

	DeltaX = abs(Droid.Screen.X-Droid.Old.X);
	DeltaY = abs(Droid.Screen.Y-Droid.Old.Y);

	Width = Droid.Width+DeltaX;
	Height = Droid.Height+DeltaY;

	Loc.X = MIN(Droid.Screen.X, Droid.Old.X);

	EndX = Loc.X+Width;
	Offset = EndX & 3;
	if(Offset)
		StepWidth = Width+4-Offset;
	else
		StepWidth = Width;
	
	step  = (1<<16) | (-StepWidth & 0xFFFFL);
	Loc.Y = MIN(Droid.Screen.Y, Droid.Old.Y);

	Blit[BlitAddIndex].Type		= blitBITMAP;

	Blit[BlitAddIndex].A1_Base	= (long)IMG_Playfield;
	Blit[BlitAddIndex].A1_Flags	= PITCH1 | PIXEL16 | WID320 | XADDPHR;
	Blit[BlitAddIndex].A1_Pixel	= ((Loc.Y+20)<<16) | (Loc.X & 0xFFFFL);
	Blit[BlitAddIndex].A1_Step	= step;
										 
	Blit[BlitAddIndex].A2_Base	= (long)IMG_PlayfieldBuffer;
	Blit[BlitAddIndex].A2_Flags	= PITCH2 | PIXEL16 | WID320 | XADDPHR | 
										  ZOFFS1;
	Blit[BlitAddIndex].A2_Pixel	= (Loc.Y<<16) | (Loc.X & 0xFFFFL);
	Blit[BlitAddIndex].A2_Step	= step;

	Blit[BlitAddIndex].B_Count	= (Height<<16) | (Width & 0xFFFFL);
										 
	Blit[BlitAddIndex].B_Patd	= 0x0L;
	Blit[BlitAddIndex].B_Cmd		= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;
	
	QueBlit();
	}

			
