/*******************************************************************
 *
 *    TITLE:        droid.h
 *
 *    DESCRIPTION:	Header file for droid.c
 *
 *    AUTHOR:		Mario Perdue & Richard Degler
 *
 *    HISTORY:    
 *
 *
 *           COPYRIGHT 1994, 1995 MP Graphics Systems         
 *      UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
 *      PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
 *     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
 *                        ALL RIGHTS RESERVED.               
 *******************************************************************/

#include "support.h"

#ifndef __DROID__H
#define __DROID__H

#define DROID_Y_LIMIT  		960

#define DROID_MAX_SPEED		50


#define DROID_1_FLAGS		PITCH1 | PIXEL16 | WID56 | XADDINC
#define DROID_2_FLAGS		PITCH1 | PIXEL16 | WID40 | XADDINC
#define DROID_3_FLAGS		PITCH1 | PIXEL16 | WID48 | XADDINC

enum
	{
	droidSTINGER, droidROBOT, droidSHOEBOX, droidLAST
	};

/* Type definitions */
typedef struct
	{
	BYTE 	Active;
	BYTE	Style;

	BYTE	Direction;
	BYTE	NewHeading;

	REALLOC	Loc;
	REALLOC	Dest;
	
	WORD	SpeedX;
	WORD	SpeedY;
	WORD	SpeedZ;
	
	SCREENLOC 	Screen;
	SCREENLOC 	Old;

	UWORD	Scale;

	UWORD	Width;
	UWORD	Height;

	ULONG	Flags;

	BYTE	Step;
	BYTE	Index;
	BYTE	Path;
	BYTE	Shoot;
	} DEF_DROID;


typedef struct
	{
	WORD	Shoot;
	WORD	Direction;

	WORD	X;
	WORD	Y;
	WORD	Z;

	WORD	Steps;
	} DEF_DROID_PATH;


/* Function Prototypes */					 

void	SetDroidImage( void );
void	SetDroidLocation( int locx, int locy, int locz );
void	SetDroidDestination( void );
void	StartDroid( int which );
void	AbortDroid( void );
void	MoveDroid( void );
void	CheckDroidLimits( void );

void 	EraseDroid( void );
void	DrawDroid( void );
void	DisplayDroid( void );

#endif