/*******************************************************************
 *
 *    TITLE:        gameinit.c
 *
 *    DESCRIPTION:	Routines to initialize the game data
 *
 *    AUTHOR:		Mario Perdue & Richard Degler
 *
 *    HISTORY:    
 *
 *
 *           COPYRIGHT 1994, 1995 MP Graphics Systems         
 *      UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
 *      PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
 *     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
 *                        ALL RIGHTS RESERVED.               
 *******************************************************************/

/** include files **/
#include "/jaguar/include/jaguar.h"
#include "gameinit.h"
#include "jagobj.h"
#include "brick.h"
#include "ball.h"
#include "paddle.h"
#include "support.h"
#include "displays.h"
#include "star.h"
#include "player.h"
#include "option.h"


void InitGpuCode(void);

/** external data **/
/* From images.s */
extern	WORD		 	IMG_BrickObject[12][3328];
extern	WORD			IMG_Playfield[];

extern  WORD			ROM_Background0[];
extern	WORD			IMG_Background[];
extern	WORD			IMG_PlayfieldBuffer[];
extern	WORD			IMG_BackgroundBuffer[];

extern	WORD			ROM_Brick[];
extern	WORD			ROM_Brick1[];
extern	WORD			ROM_Brick2[];
extern	WORD			ROM_Brick3[];
extern	WORD			ROM_Brick4[];
extern	WORD			IMG_Brick[];
extern	WORD			IMG_Brick1[];
extern	WORD			IMG_Brick2[];
extern	WORD			IMG_Brick3[];
extern	WORD			IMG_Brick4[];

extern	WORD			ROM_BrickClassic[];
extern	WORD			IMG_BrickClassic[];

extern	WORD			ROM_DropBrick[];
extern	WORD			IMG_DropBrick[];

extern	WORD			ROM_Level[];
extern	WORD			IMG_Level[];

extern	WORD			ROM_Digit[];
extern	WORD			IMG_Digit[];

extern	WORD			ROM_BigDigit[];
extern	WORD			IMG_BigDigit[];

extern  WORD			ROM_Screen[];
extern  WORD			IMG_Screen[];

/* From im_glass.s */
extern	WORD			ROM_GlassSide[];
extern	WORD			IMG_GlassSide[];

extern	WORD			ROM_BarrierGlass[];
extern	WORD			IMG_BarrierGlass[];

/* From Sprite1.s */
extern  WORD			ROM_BallNormal[];
extern  WORD			IMG_BallNormal[];

extern  WORD			ROM_BallSuper[];
extern  WORD			IMG_BallSuper[];

extern  WORD			ROM_BallExplode[];
extern  WORD			IMG_BallExplode[];

extern  WORD			ROM_BallShadow[];
extern  WORD			IMG_BallShadow[];

extern  WORD			ROM_BallClassic[];
extern  WORD			IMG_BallClassic[];

extern	WORD			ROM_Bomb[];
extern	WORD			IMG_Bomb[];

extern	WORD			ROM_BombExplode[];
extern	WORD			IMG_BombExplode[];

extern	WORD			ROM_Ripple[];
extern	WORD			IMG_Ripple[];

extern WORD				ROM_SinTab[91];
extern WORD				SinTab[91];
extern WORD				ROM_CosTab[91];
extern WORD				CosTab[91];

extern WORD				ROM_BallZTab[35];
extern WORD				BallZTab[35];

extern WORD				ROM_ExplodeOffsetTab[7];
extern WORD				ExplodeOffsetTab[7];
extern WORD				ROM_ExplodeWidthTab[7];
extern WORD				ExplodeWidthTab[7];

extern WORD				ROM_BallOffsetTab[7];
extern WORD				BallOffsetTab[7];
extern WORD				ROM_BallWidthTab[7];
extern WORD				BallWidthTab[7];

extern WORD				ROM_RippleOffsetTab[8];
extern WORD				RippleOffsetTab[8];
extern WORD				ROM_RippleWidthTab[8];
extern WORD				RippleWidthTab[8];

extern WORD				ROM_DropWidthTab[5];
extern WORD				DropWidthTab[5];
extern WORD				ROM_DropOffsetTab[5];
extern WORD				DropOffsetTab[5];

extern WORD				ROM_PaddleWidthTab[5];
extern WORD				PaddleWidthTab[5];

extern WORD				ROM_PaddleOffsetTab[5];
extern WORD				PaddleOffsetTab[5];

extern WORD				ROM_Title[];

extern	WORD			ROM_Goody00[];
extern	WORD			ROM_Goody01[];
extern	WORD			ROM_Goody02[];
extern	WORD			ROM_Goody03[];
extern	WORD			ROM_Goody04[];
extern	WORD			ROM_Goody05[];
extern	WORD			ROM_Goody06[];
extern	WORD			ROM_Goody07[];
extern	WORD			ROM_Goody08[];
extern	WORD			ROM_Goody09[];
extern	WORD			ROM_Goody10[];
extern	WORD			ROM_Goody11[];
extern	WORD			ROM_Goody12[];
extern	WORD			ROM_Goody13[];
extern	WORD			ROM_Goody14[];
extern	WORD			ROM_Goody15[];
extern	WORD			IMG_Goody[16][8][220];

extern	WORD			ROM_GoodyLaunch[];
extern	WORD			IMG_GoodyLaunch[];

extern	WORD			ROM_GoodyExplode[];
extern	WORD			IMG_GoodyExplode[];

extern	WORD			ROM_Stinger[];
extern	WORD			IMG_Stinger[];

extern	DEF_BLIT_DATA	Blit[];
extern	LONG			BlitAddIndex;
extern	LONG			BlitUseIndex;

extern	char			TitleExpand;
/* public data */
int						ScreenHeight;
int						ScreenOrgX;
int 					ScreenOrgY;

/** internal functions **/

/*********************************************************************
 *  FUNCTION:		InitGame
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	Initialize the game data
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void InitGame(void)
	{
	BlitAddIndex = 0;
	BlitUseIndex = 0;

	InitGpuCode();

	ExpandLzjag(IMG_Level, ROM_Level);
	ExpandLzjag(IMG_Digit, ROM_Digit);
	ExpandLzjag(IMG_BigDigit, ROM_BigDigit);
	ExpandLzjag(IMG_Screen, ROM_Screen);

	ExpandLzjag(IMG_Brick, ROM_Brick);
	ExpandLzjag(IMG_Brick1, ROM_Brick1);
	ExpandLzjag(IMG_Brick2, ROM_Brick2);
	ExpandLzjag(IMG_Brick3, ROM_Brick3);
	ExpandLzjag(IMG_Brick4, ROM_Brick4);

	ExpandLzjag(IMG_BrickClassic, ROM_BrickClassic);

	ExpandLzjag(IMG_DropBrick, ROM_DropBrick);

 	ExpandLzjag(IMG_BallNormal, ROM_BallNormal);   
 	ExpandLzjag(IMG_BallSuper, ROM_BallSuper);     
 	ExpandLzjag(IMG_BallExplode, ROM_BallExplode); 
 	ExpandLzjag(IMG_BallShadow, ROM_BallShadow);   
 	ExpandLzjag(IMG_BallClassic, ROM_BallClassic);   
 	ExpandLzjag(IMG_Bomb, ROM_Bomb);               
 	ExpandLzjag(IMG_BombExplode, ROM_BombExplode); 
 	ExpandLzjag(IMG_Ripple, ROM_Ripple);           
  	ExpandLzjag(IMG_GlassSide, ROM_GlassSide);     

	ExpandLzjag(IMG_BarrierGlass, ROM_BarrierGlass);

	ExpandLzjag(IMG_Goody[0][0], ROM_Goody00);    
	ExpandLzjag(IMG_Goody[1][0], ROM_Goody01);    
	ExpandLzjag(IMG_Goody[2][0], ROM_Goody02);    
	ExpandLzjag(IMG_Goody[3][0], ROM_Goody03);    
	ExpandLzjag(IMG_Goody[4][0], ROM_Goody04);    
	ExpandLzjag(IMG_Goody[5][0], ROM_Goody05);    
	ExpandLzjag(IMG_Goody[6][0], ROM_Goody06);    
	ExpandLzjag(IMG_Goody[7][0], ROM_Goody07);    
	ExpandLzjag(IMG_Goody[8][0], ROM_Goody08);    
	ExpandLzjag(IMG_Goody[9][0], ROM_Goody09);    
	ExpandLzjag(IMG_Goody[10][0], ROM_Goody10);    
	ExpandLzjag(IMG_Goody[11][0], ROM_Goody11);    
	ExpandLzjag(IMG_Goody[12][0], ROM_Goody12);    
	ExpandLzjag(IMG_Goody[13][0], ROM_Goody13);    
	ExpandLzjag(IMG_Goody[14][0], ROM_Goody14);    
	ExpandLzjag(IMG_Goody[15][0], ROM_Goody15);    
	ExpandLzjag(IMG_GoodyLaunch, ROM_GoodyLaunch);    
 	ExpandLzjag(IMG_GoodyExplode, ROM_GoodyExplode); 
 	ExpandLzjag(IMG_Stinger, ROM_Stinger);                

	/* Copy data tables from ROM to RAM */
 	vmemcpy((long *)SinTab, (long *)ROM_SinTab, sizeof(ROM_SinTab));                                
 	vmemcpy((long *)CosTab, (long *)ROM_CosTab, sizeof(ROM_CosTab));                                
                                                                                    
  	vmemcpy((long *)BallZTab, (long *)ROM_BallZTab, sizeof(ROM_BallZTab));                          
  	vmemcpy((long *)ExplodeOffsetTab, (long *)ROM_ExplodeOffsetTab, sizeof(ROM_ExplodeOffsetTab));  
  	vmemcpy((long *)ExplodeWidthTab, (long *)ROM_ExplodeWidthTab, sizeof(ROM_ExplodeWidthTab));     
  	vmemcpy((long *)BallOffsetTab, (long *)ROM_BallOffsetTab, sizeof(ROM_BallOffsetTab));           
  	vmemcpy((long *)BallWidthTab, (long *)ROM_BallWidthTab, sizeof(ROM_BallWidthTab));              
  	vmemcpy((long *)RippleOffsetTab, (long *)ROM_RippleOffsetTab, sizeof(ROM_RippleOffsetTab));     
  	vmemcpy((long *)RippleWidthTab, (long *)ROM_RippleWidthTab, sizeof(ROM_RippleWidthTab));        
                                                                                    
 	vmemcpy((long *)DropWidthTab, (long *)ROM_DropWidthTab, sizeof(ROM_DropWidthTab));              
 	vmemcpy((long *)DropOffsetTab, (long *)ROM_DropOffsetTab, sizeof(ROM_DropOffsetTab));           
                                                                                    
 	vmemcpy((long *)PaddleWidthTab, (long *)ROM_PaddleWidthTab, sizeof(ROM_PaddleWidthTab));        
 	vmemcpy((long *)PaddleOffsetTab, (long *)ROM_PaddleOffsetTab, sizeof(ROM_PaddleOffsetTab));     

	ExpandLzjag(IMG_Playfield, ROM_Title);
	TitleExpand = FALSE;

 	BuildObjectList(listBUFFER);
 	BuildObjectList(listDISPLAY);

	Blit[BlitAddIndex].Type = blitSTOP;
	QueBlit();

	while(*G_CTRL & 0x1L);

	ReadOptions();
	StartMusic(songTITLE);
	}	



