/*******************************************************************
 *
 *    TITLE:        goody.h
 *
 *    DESCRIPTION:	Header file for goody.c
 *
 *    AUTHOR:		Mario Perdue & Richard Degler
 *
 *    HISTORY:    
 *
 *
 *           COPYRIGHT 1994, 1995 MP Graphics Systems         
 *      UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
 *      PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
 *     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
 *                        ALL RIGHTS RESERVED.               
 *******************************************************************/

#include "support.h"

#ifndef __GOODY__H
#define __GOODY__H

#define GOODY_WIDTH			20
#define GOODY_HEIGHT 		11

#define GOODY_LAUNCH_WIDTH	32
#define GOODY_LAUNCH_HEIGHT	33

#define GOODY_EXPLODE_WIDTH		32
#define GOODY_EXPLODE_HEIGHT	33

#define	GOODY_W				640
#define GOODY_H				352

#define GOODY_Y				3200

#define GOODY_MAX_SPEED		64

#define GOODY_FLAGS			PITCH1 | PIXEL16 | WID20 | XADDINC
#define GOODY_LAUNCH_FLAGS	PITCH1 | PIXEL16 | WID32 | XADDINC
#define GOODY_EXPLODE_FLAGS	PITCH1 | PIXEL16 | WID32 | XADDINC

#define	STINGER_WIDTH		24
#define STINGER_HEIGHT		21

#define	STINGER_MAX_SPEED	100

#define	STINGER_FLAGS		PITCH1 | PIXEL16 | WID24 | XADDINC

enum 
	{
	goodyBALL_FREE, goodyBALL_KILL,
	goodyBALL_SLOW, goodyBALL_FAST, goodyBALL_SPLIT, 
	goodyPADDLE_WIDE, goodyPADDLE_NARROW, 
	goodyCATCH_ON, goodyCATCH_OFF, 
	goodyATTRACT_UP, goodyATTRACT_DOWN, 
	goodySCREEN_KILL, goodySCREEN_REVIVE,
	goodyGUN_ON, goodyGUN_OFF,
	goodyBALL_SUPER, 
	goodyLAST,
	goodySTINGER
	};

enum
	{
	phaseLAUNCH, phaseNORMAL, phaseEXPLODE
	};


/* Type definitions */
typedef struct
	{
	BYTE 	Active;
	WORD 	X;
	WORD	Y;
	WORD	Z;

	UWORD 	ScreenX;
	UWORD 	ScreenY;
	UWORD	Width;
	UWORD	Height;

	UWORD 	OldX;
	UWORD	OldY;
	UWORD	OldWidth;
	UWORD	OldHeight;

	WORD	MaxSpeed;
	WORD	SpeedX;
	WORD	SpeedY;
	WORD	SpeedZ;
	
	UWORD	Scale;
	UWORD	Step;
	BYTE	Style;
	BYTE	Phase;
	} DEF_GOODY;

/* Function Prototypes */					 

void	SetGoodyLocation( short who, int, int, int );
void	SetGoodySpeed( short who, int, int, int );
void	LaunchGoody( short who, short which, int, int, int );
void	MoveGoody( short who );
void	CheckGoodyLimits( short who );
void	CheckGoodyCaught( short who );
void	ExplodeGoody( short who );

void	BlankGoody( short who );
void	EraseGoody( short who );
void	DrawGoody( short who );
void	DisplayGoody( short who );

void	ActivateGoody( short who );
void 	DoKillBall( short who );
void 	DoFastBall( short who  );
void	DoSplitBall( short who );
void	DoFreeBall( short who );
void	DoSuperBall( short who );
void	DoSlowBall( short who );

void	DoKillScreen( short who );
void	DoReviveScreen( short who );

void	LaunchStinger( short who, int x, int y, int z );
void	DoStinger( short who );

#endif