/*******************************************************************
 *
 *    TITLE:        hiscore.c
 *
 *    DESCRIPTION:	Routines for handleing entry and display of
 *					high scores.
 *
 *    AUTHOR:		Mario Perdue & Richard Degler
 *
 *    HISTORY:    
 *
 *
 *           COPYRIGHT 1994, 1995 MP Graphics Systems         
 *      UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
 *      PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
 *     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
 *                        ALL RIGHTS RESERVED.               
 *******************************************************************/


#include "\jaguar\include\jaguar.h"

#include "hiscore.h"

#include "support.h"
#include "option.h"
#include "player.h"
#include "displays.h"


extern	DEF_EEPROM		EepromBuffer;
extern	DEF_OPTION		Option;
extern	DEF_PLAYER		Player[];

extern	DEF_BLIT_DATA	Blit[];
extern	LONG			BlitAddIndex;
extern	LONG			BlitUseIndex;

extern	ULONG			ticks;

extern	WORD			IMG_Playfield[];
extern	WORD			ROM_ScoreAlpha[44][16][8];

extern	WORD			ROM_Panel[];
extern	WORD			IMG_PlayfieldBuffer[];
extern	WORD			IMG_Playfield[];
extern	WORD			IMG_Background[];

extern	WORD			ROM_ScoreTitle[];
extern	WORD			ROM_ScoreCongrats[];
extern	WORD			ROM_ScorePlayer[2][864];
extern	WORD			ROM_ScoreUse[];

extern 	int				Screen;
extern	char			ROM_Congrats[5][22];

extern BYTE		ROM_HighScoreTab[MAX_HIGH_SCORES][MAX_NAME_LENGTH+6];
DEF_HIGHSCORE	HiScore[MAX_HIGH_SCORES];



/*********************************************************************
 *  FUNCTION:	  ReadHighScores
 *
 *  PARAMETERS:	  
 *
 *  DESCRIPTION:  
 *
 *  RETURNS:	  
 *
 *********************************************************************/
void ReadHighScores()
	{
	int i, j;

	/* Only valid from ReadOptions() */

	for(i=0; i<MAX_HIGH_SCORES; i++)
		{
		HiScore[i].Entry = i;
		HiScore[i].Difficulty = EepromBuffer.Entry[i].Difficulty;
		HiScore[i].Level = EepromBuffer.Entry[i].Level;
		HiScore[i].Score = EepromBuffer.Entry[i].Score;
		for(j=0; j<MAX_NAME_LENGTH; j++)
			HiScore[i].Name[j] = EepromBuffer.Entry[i].Name[j];
		}

	SortHighScores();
	}


/*********************************************************************
 *  FUNCTION:	  ResetHighScores
 *
 *  PARAMETERS:	  
 *
 *  DESCRIPTION:  
 *
 *  RETURNS:	  
 *
 *********************************************************************/
void ResetHighScores(int write)
	{
	int i;

	vmemcpy((long *)HiScore, (long *)ROM_HighScoreTab, sizeof(ROM_HighScoreTab));

	SortHighScores();

	for(i=0; i<MAX_HIGH_SCORES; i++)
		{
		HiScore[i].Entry = i;
		if(write)
			WriteHighScore(i);
		}
	}


/*********************************************************************
 *  FUNCTION:	  WriteHighScore
 *
 *  PARAMETERS:	  
 *
 *  DESCRIPTION:  
 *
 *  RETURNS:	  
 *
 *********************************************************************/
void WriteHighScore( int which )
	{
	int i;
	int slot;
	WORD *Buffer;

	if(HiScore[which].Score > 9999999L)
		HiScore[which].Score = 9999999L;

	Buffer = (WORD *)&EepromBuffer;

	slot = HiScore[which].Entry;
	EepromBuffer.Entry[slot].Difficulty = HiScore[which].Difficulty;
	EepromBuffer.Entry[slot].Level 		= HiScore[which].Level;
	EepromBuffer.Entry[slot].Score 		= HiScore[which].Score & 0xFFFFFFL;
	for(i=0; i<MAX_NAME_LENGTH; i++)
		EepromBuffer.Entry[slot].Name[i] = HiScore[which].Name[i];
	
	for(i=slot*ENTRY_WORDS; i<(slot+1)*ENTRY_WORDS; i++)
		eeWriteWord(Buffer[i], i);

	eeUpdateChecksum();
	eeValidateChecksum();
	}


/*********************************************************************
 *  FUNCTION:	  SortHighScores
 *
 *  PARAMETERS:	  
 *
 *  DESCRIPTION:  
 *
 *  RETURNS:	  
 *
 *********************************************************************/
void SortHighScores()
	{
	int i;
	int j;
	DEF_HIGHSCORE	Temp;

	for(i=0; i<MAX_HIGH_SCORES-1; i++)
		{
		for(j=i+1; j<MAX_HIGH_SCORES; j++)
			{
			if(HiScore[j].Score > HiScore[i].Score)
				{
				Temp = HiScore[i];
				HiScore[i] = HiScore[j];
				HiScore[j] = Temp;
				}
			}
		}
	}

/*********************************************************************
 *  FUNCTION:	  ShowHighScores
 *
 *  PARAMETERS:	  
 *
 *  DESCRIPTION:  
 *
 *  RETURNS:	  
 *
 *********************************************************************/
void ShowHighScores()
	{
	int i;
	int c;
	char digit;
	int Bright;

	DisplayExpandedImage(IMG_Playfield, IMG_PlayfieldBuffer);
	DisplayHighScoreTitle();

	for(i=0; i<MAX_HIGH_SCORES; i++)
		{
		for(c=0; c<MAX_NAME_LENGTH; c++)
			{
			PlaceScoreText((HiScore[i].Name[c]&0x1F)+10, 46+c*10, 92+i*18, ON);
			}

		Bright = OFF;
		for(c=SCORE_LENGTH-1; c>=0; c--)
			{
			digit = GetDigit(HiScore[i].Score, c);
	   		if(digit || !c)
	   			Bright = ON;
			PlaceScoreText(digit, 264-c*9, 92+i*18, Bright);
			}
		}
	}


/*********************************************************************
 *  FUNCTION:	  EnterHighScore
 *
 *  PARAMETERS:	  
 *
 *  DESCRIPTION:  
 *
 *  RETURNS:	  
 *
 *********************************************************************/
void EnterHighScore( int who )
	{
	int i, j;
	int row, col;
	int oldrow, oldcol;
	int selection;
	ULONG BlinkTicks;
	int blink;

	ExpandImage(IMG_PlayfieldBuffer, ROM_Panel);

	if(Player[who].Score <= HiScore[MAX_HIGH_SCORES-1].Score)
		return;

	if(Player[who].AutoPilot)
		return;
	
	DisplayExpandedImage(IMG_Playfield, IMG_PlayfieldBuffer);
	DisplayHighScoreCongrats(who);

	for(i=0; i<MAX_NAME_LENGTH; i++)
		{
		HiScore[MAX_HIGH_SCORES-1].Name[i] = BLANK;
		PlaceScoreText((((Player[who].Name[i]-1)&0x1F)+1)+HS_OFFSET,
						HIGH_SCORE_X+i*HS_OFFSET, HIGH_SCORE_Y, OFF);
		}
	PlaceScoreText(CURSOR+HS_OFFSET, HIGH_SCORE_X, CURSOR_Y, ON);
	PlaceScoreText(ARROW+HS_OFFSET, HIGH_SCORE_X, ARROW_Y, ON);

	selection = BLANK;
	PlaceScoreText(SPACE+HS_OFFSET, HS_SELECT_X, HS_SELECT_Y, ON);

	for(i=LETTER_A; i<=ENTER; i++)
		{
		row = i/15;
		col = i%15;
		PlaceScoreText(i+HS_OFFSET, (col*12)+HS_SELECT_X, (row*20)+HS_SELECT_Y, OFF);
		}

	row = 0;
	col = 0;

	while(ReadButtons(who) & BUTTON_FIRE)
		{
		};				

	BlinkTicks = ticks;
	blink = OFF;

	/* Enter new name here */
	i = 0;
	while(i <= MAX_NAME_LENGTH)
		{
		oldcol = col;
		oldrow = row;

		Player[who].Joypad=ReadJoyStick(who);
		if(Player[who].Joypad & JOYPAD_ANY)
			{
			if(selection == BLANK)
				PlaceScoreText(SPACE+HS_OFFSET, (col*12)+HS_SELECT_X,
								(row*20)+HS_SELECT_Y, OFF);
			else
				PlaceScoreText(selection+HS_OFFSET, (col*12)+HS_SELECT_X,
								(row*20)+HS_SELECT_Y, OFF);

			if(Player[who].Joypad & JOYPAD_UP)
				row = MAX(0, row-1);
			if(Player[who].Joypad & JOYPAD_DOWN)
				row = MIN(1, row+1);

			if(Player[who].Joypad & JOYPAD_LEFT)
				if((col == 0) && (row == 1))
					{
					row = 0;
					col = 14;
					}
				else
					col = MAX(0, col-1);

			if(Player[who].Joypad & JOYPAD_RIGHT)
				if((col == 14) && (row == 0))
					{
					row = 1;
					col = 0;
					}
				else
					col = MIN(14, col+1);

			selection = row*15 + col;
			if(selection == BLANK)
				PlaceScoreText(SPACE+HS_OFFSET, (col*12)+HS_SELECT_X,
								(row*20)+HS_SELECT_Y, ON);
			else
				PlaceScoreText(selection+HS_OFFSET, (col*12)+HS_SELECT_X,
								(row*20)+HS_SELECT_Y, ON);

			if((oldcol!=col) || (oldrow!=row))
				PlaySound(sndCRACK, 127, 0, 7);

			Delay(100);
			}

		Player[who].Button=ReadButtons(who);
		if(Player[who].Button & BUTTON_FIRE)
			{
			PlaySound(sndBRICK2, 127, 4, 7);
			if(selection == ENTER)
				{
				if(i == 0)
					{
					for(j=0; j<MAX_NAME_LENGTH; j++)
						HiScore[MAX_HIGH_SCORES-1].Name[j] = Player[who].Name[j];
					}
				else
					{
					for(j=0; j<MAX_NAME_LENGTH; j++)
						Player[who].Name[j] = HiScore[MAX_HIGH_SCORES-1].Name[j];
					}
				break;
				}
			else 
				{
				PlaceScoreText(BLANK+HS_OFFSET, HIGH_SCORE_X+i*HS_OFFSET, CURSOR_Y, ON);
				PlaceScoreText(BLANK+HS_OFFSET, HIGH_SCORE_X+i*HS_OFFSET, ARROW_Y, ON);

				if(selection == RUBOUT)
					{
					if(i > 0)
						{
						i--;
						HiScore[MAX_HIGH_SCORES-1].Name[i] = BOX;
						PlaceScoreText(BOX+HS_OFFSET, HIGH_SCORE_X+i*HS_OFFSET,
										HIGH_SCORE_Y, OFF);
						if(i == 0)
							for(j=0; j<MAX_NAME_LENGTH; j++)
								{
								PlaceScoreText((((Player[who].Name[j]-1)&0x1F)+1)+HS_OFFSET,
											HIGH_SCORE_X+j*HS_OFFSET, HIGH_SCORE_Y, OFF);
								}
						}
					PlaceScoreText(CURSOR+HS_OFFSET, HIGH_SCORE_X+i*HS_OFFSET, CURSOR_Y, ON);
					PlaceScoreText(ARROW+HS_OFFSET, HIGH_SCORE_X+i*HS_OFFSET, ARROW_Y, ON);
					}
				else
					{
					if(i == 0)
						for(j=0; j<MAX_NAME_LENGTH; j++)
							{
							PlaceScoreText(BOX+HS_OFFSET, HIGH_SCORE_X+j*HS_OFFSET,
											HIGH_SCORE_Y, OFF);
							}
					if(i < MAX_NAME_LENGTH)
						{
						HiScore[MAX_HIGH_SCORES-1].Name[i] = selection;
						i++;
						}
					else
						HiScore[MAX_HIGH_SCORES-1].Name[MAX_NAME_LENGTH-1] = selection;

					PlaceScoreText((HiScore[MAX_HIGH_SCORES-1].Name[i-1]&0x1F)+HS_OFFSET,
									HIGH_SCORE_X+(i-1)*HS_OFFSET, HIGH_SCORE_Y, ON);

					if(i < MAX_NAME_LENGTH)
						{
						PlaceScoreText(CURSOR+HS_OFFSET, HIGH_SCORE_X+i*HS_OFFSET,
										CURSOR_Y, ON);
						PlaceScoreText(ARROW+HS_OFFSET, HIGH_SCORE_X+i*HS_OFFSET,
										ARROW_Y, blink);
						}
					else
						{
						PlaceScoreText(CURSOR+HS_OFFSET,
									HIGH_SCORE_X+(MAX_NAME_LENGTH-1)*HS_OFFSET,
									CURSOR_Y, ON);
						PlaceScoreText(ARROW+HS_OFFSET,
									HIGH_SCORE_X+(MAX_NAME_LENGTH-1)*HS_OFFSET,
									ARROW_Y, blink);
						}
					}
				}

			while(ReadButtons(who) & BUTTON_FIRE);				
			}

		if((ticks-BlinkTicks)<500)
			continue;

		BlinkTicks = ticks;
		blink = !blink;

		if(i < MAX_NAME_LENGTH)
 			PlaceScoreText(ARROW+HS_OFFSET, HIGH_SCORE_X+i*HS_OFFSET, ARROW_Y, blink);
		else
			PlaceScoreText(ARROW+HS_OFFSET,
						HIGH_SCORE_X+(MAX_NAME_LENGTH-1)*HS_OFFSET, ARROW_Y, blink);
		};

	HiScore[MAX_HIGH_SCORES-1].Difficulty = Option.Skill[who];
	HiScore[MAX_HIGH_SCORES-1].Level = Screen;
	HiScore[MAX_HIGH_SCORES-1].Score = Player[who].Score;

	WriteHighScore(MAX_HIGH_SCORES-1);

	SortHighScores();
	}



/*********************************************************************
 *  FUNCTION:		PlaceScoreText
 *
 *  PARAMETERS:		short who, char hud, char digit, int col, int row
 *
 *  DESCRIPTION:	Draw a alphanumeric at the specified screen loc.
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void PlaceScoreText(short which, int col, int row, int bright)
	{
	int b_iinc;

	if(!bright && !which)
		which = 10;

	/* Fisrt erase the character cell */
	Blit[BlitAddIndex].Type		= blitBITMAP;

	Blit[BlitAddIndex].A1_Base	= (long)IMG_Playfield;
	Blit[BlitAddIndex].A1_Flags	= PLAYFIELD_FLAGS;
	Blit[BlitAddIndex].A1_Pixel	= (row<<16L) | (col & 0x0FFFFL);
	Blit[BlitAddIndex].A1_Step	= (1<<16L) | (-10 & 0x0FFFFL);
										 
	Blit[BlitAddIndex].A2_Base	= (long)IMG_PlayfieldBuffer;
	Blit[BlitAddIndex].A2_Flags	= Blit[BlitAddIndex].A1_Flags;
	Blit[BlitAddIndex].A2_Pixel	= Blit[BlitAddIndex].A1_Pixel;
	Blit[BlitAddIndex].A2_Step	= Blit[BlitAddIndex].A1_Step;

	Blit[BlitAddIndex].B_Count	= (17<<16L) | (10 & 0x0FFFFL);
										 
	Blit[BlitAddIndex].B_Patd	= 0x0L;
	Blit[BlitAddIndex].B_Cmd	= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;
	
	QueBlit();



	/* Then place the character in the cell */
	if(bright)
		b_iinc  = 0x0L;
	else
		b_iinc  = (-100&0xFF)<<16;
	
	Blit[BlitAddIndex].Type		= blitBITMAP;

	Blit[BlitAddIndex].A1_Base	= (long)IMG_Playfield;
	Blit[BlitAddIndex].A1_Flags	= PLAYFIELD_FLAGS;
	Blit[BlitAddIndex].A1_Pixel	= (row<<16L) | (col & 0x0FFFFL);
	Blit[BlitAddIndex].A1_Step	= (1<<16L) | (-8 & 0x0FFFFL);
										 
	Blit[BlitAddIndex].A2_Base	= (long)ROM_ScoreAlpha[which][0];
	Blit[BlitAddIndex].A2_Flags	= HS_ALPHA_FLAGS;
	Blit[BlitAddIndex].A2_Pixel	= 0x0L;
	Blit[BlitAddIndex].A2_Step	= Blit[BlitAddIndex].A1_Step;

	Blit[BlitAddIndex].B_Count	= (16<<16L) | (8 & 0x0FFFFL);
										 
	Blit[BlitAddIndex].B_Patd	= 0x0L;
	Blit[BlitAddIndex].B_Iinc	= b_iinc;

	Blit[BlitAddIndex].B_Cmd	= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN |
								  DSTEN | DCOMPEN | SRCSHADE | ZBUFF;
	
	QueBlit();
	}



/*********************************************************************
 *  FUNCTION:	  DisplayHighScoreTitle
 *
 *  PARAMETERS:	  
 *
 *  DESCRIPTION:  
 *
 *  RETURNS:	  
 *
 *********************************************************************/
void DisplayHighScoreTitle()
	{
	Blit[BlitAddIndex].Type		= blitBITMAP;

	Blit[BlitAddIndex].A1_Base	= (long)IMG_Playfield;
	Blit[BlitAddIndex].A1_Flags	= PLAYFIELD_FLAGS;
	Blit[BlitAddIndex].A1_Pixel	= (HS_TITLE_Y<<16L) | (HS_TITLE_X & 0x0FFFFL);
	Blit[BlitAddIndex].A1_Step	= (1<<16L) | (-HS_TITLE_WIDTH & 0x0FFFFL);
										 
	Blit[BlitAddIndex].A2_Base	= (long)ROM_ScoreTitle;
	Blit[BlitAddIndex].A2_Flags	= HS_TITLE_FLAGS;
	Blit[BlitAddIndex].A2_Pixel	= 0x0L;
	Blit[BlitAddIndex].A2_Step	= Blit[BlitAddIndex].A1_Step;

	Blit[BlitAddIndex].B_Count	= (HS_TITLE_HEIGHT<<16L) | (HS_TITLE_WIDTH & 0x0FFFFL);
										 
	Blit[BlitAddIndex].B_Patd	= 0x0L;

	Blit[BlitAddIndex].B_Cmd	= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN |
								  DSTEN | DCOMPEN;
	
	QueBlit();
	}



/*********************************************************************
 *  FUNCTION:	  DisplayHighScoreCongrats
 *
 *  PARAMETERS:	  
 *
 *  DESCRIPTION:  
 *
 *  RETURNS:	  
 *
 *********************************************************************/
void DisplayHighScoreCongrats( short who )
	{
	Blit[BlitAddIndex].Type		= blitBITMAP;

	Blit[BlitAddIndex].A1_Base	= (long)IMG_Playfield;
	Blit[BlitAddIndex].A1_Flags	= PLAYFIELD_FLAGS;
	Blit[BlitAddIndex].A1_Pixel	= (HS_CONGRATS_Y<<16L) | 
										  (HS_CONGRATS_X & 0x0FFFFL);
	Blit[BlitAddIndex].A1_Step	= (1<<16L) | 
										  (-HS_CONGRATS_WIDTH & 0x0FFFFL);
										 
	Blit[BlitAddIndex].A2_Base	= (long)ROM_ScoreCongrats;
	Blit[BlitAddIndex].A2_Flags	= HS_CONGRATS_FLAGS;
	Blit[BlitAddIndex].A2_Pixel	= 0x0L;
	Blit[BlitAddIndex].A2_Step	= Blit[BlitAddIndex].A1_Step;

	Blit[BlitAddIndex].B_Count	= (HS_CONGRATS_HEIGHT<<16L) | 
										  (HS_CONGRATS_WIDTH & 0x0FFFFL);
										 
	Blit[BlitAddIndex].B_Patd	= 0x0L;

	Blit[BlitAddIndex].B_Cmd	= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN |
								  DSTEN | DCOMPEN;
	
	QueBlit();


	Blit[BlitAddIndex].Type		= blitBITMAP;

	Blit[BlitAddIndex].A1_Base	= (long)IMG_Playfield;
	Blit[BlitAddIndex].A1_Flags	= PLAYFIELD_FLAGS;
	Blit[BlitAddIndex].A1_Pixel	= (HS_PLAYER_Y<<16L) | 
										  (HS_PLAYER_X & 0x0FFFFL);
	Blit[BlitAddIndex].A1_Step	= (1<<16L) | 
										  (-HS_PLAYER_WIDTH & 0x0FFFFL);
										 
	Blit[BlitAddIndex].A2_Base	= (long)ROM_ScorePlayer[who];
	Blit[BlitAddIndex].A2_Flags	= HS_PLAYER_FLAGS;
	Blit[BlitAddIndex].A2_Pixel	= 0x0L;
	Blit[BlitAddIndex].A2_Step	= Blit[BlitAddIndex].A1_Step;

	Blit[BlitAddIndex].B_Count	= (HS_PLAYER_HEIGHT<<16L) | 
										  (HS_PLAYER_WIDTH & 0x0FFFFL);
										 
	Blit[BlitAddIndex].B_Patd	= 0x0L;

	Blit[BlitAddIndex].B_Cmd	= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN |
								  DSTEN | DCOMPEN;
	
	QueBlit();


	Blit[BlitAddIndex].Type		= blitBITMAP;

	Blit[BlitAddIndex].A1_Base	= (long)IMG_Playfield;
	Blit[BlitAddIndex].A1_Flags	= PLAYFIELD_FLAGS;
	Blit[BlitAddIndex].A1_Pixel	= (HS_USE_Y<<16L) | (HS_USE_X & 0x0FFFFL);
	Blit[BlitAddIndex].A1_Step	= (1<<16L) | (-HS_USE_WIDTH & 0x0FFFFL);
										 
	Blit[BlitAddIndex].A2_Base	= (long)ROM_ScoreUse;
	Blit[BlitAddIndex].A2_Flags	= HS_USE_FLAGS;
	Blit[BlitAddIndex].A2_Pixel	= 0x0L;
	Blit[BlitAddIndex].A2_Step	= Blit[BlitAddIndex].A1_Step;

	Blit[BlitAddIndex].B_Count	= (HS_USE_HEIGHT<<16L) | 
								  (HS_USE_WIDTH & 0x0FFFFL);
										 
	Blit[BlitAddIndex].B_Patd	= 0x0L;

	Blit[BlitAddIndex].B_Cmd	= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN |
								  DSTEN | DCOMPEN;
	
	QueBlit();
	}



/*********************************************************************
 *  FUNCTION:	  ShowCongrats
 *
 *  PARAMETERS:	  
 *
 *  DESCRIPTION:  
 *
 *  RETURNS:	  
 *
 *********************************************************************/
void ShowLastScreenCongrats()
	{
	int x;
	int y;
	ULONG Timer;

	ExpandImage(IMG_PlayfieldBuffer, ROM_Panel);
	DisplayExpandedImage(IMG_Playfield, IMG_PlayfieldBuffer);

	for(y=0; y<3; y++)
		{
		for(x=0; x<22; x++)
			PlaceScoreText((ROM_Congrats[y][x]&0x1F)+10, 46+x*10, 60+y*20, ON);
		}

	for(y=3; y<5; y++)
		{
		for(x=0; x<22; x++)
			PlaceScoreText((ROM_Congrats[y][x]&0x1F)+10, 46+x*10, 75+y*20, ON);
		}

	if(Option.Skill[PLAYER_RED] < skillEXPERT)
		Option.Skill[PLAYER_RED] = skillEXPERT;

	if(Option.Skill[PLAYER_GREEN] < skillEXPERT)
		Option.Skill[PLAYER_GREEN] = skillEXPERT;

	Timer = ticks;

	while((ticks-Timer) < 5000)
		{
		if(ReadButtons(PLAYER_RED) || ReadButtons(PLAYER_GREEN))
			return;
		}
/*
	ClearPlayfieldBuffer();
	ClearPlayfield();
*/
	}
