/*******************************************************************
 *
 *    TITLE:        hiscore.h
 *
 *    DESCRIPTION:	header file for hiscore.c
 *
 *    AUTHOR:		Mario Perdue & Richard Degler
 *
 *    HISTORY:    
 *
 *
 *           COPYRIGHT 1994, 1995 MP Graphics Systems         
 *      UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
 *      PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
 *     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
 *                        ALL RIGHTS RESERVED.               
 *******************************************************************/

#ifndef __HISCORE__H
#define __HISCORE__H

#include "support.h"
#include "option.h"

#define BLANK			0
#define LETTER_A		1
#define RUBOUT			28
#define	ENTER			29
#define SPACE			30
#define CURSOR			31
#define BOX				32
#define ARROW			33

#define HIGH_WHO_X		219
#define HIGH_WHO_Y		50

#define HIGH_SCREEN_X	210
#define HIGH_SCREEN_Y	70

#define HIGH_SCORE_X	80
#define HIGH_SCORE_Y	100

#define CURSOR_Y		(HIGH_SCORE_Y+20)
#define ARROW_Y			(CURSOR_Y+4)

#define HS_SELECT_X		70
#define HS_SELECT_Y		170

#define	HS_OFFSET		10

#define HS_TITLE_X		64
#define HS_TITLE_Y		28
#define HS_TITLE_WIDTH	192
#define HS_TITLE_HEIGHT	53
#define	HS_TITLE_FLAGS	PITCH1 | PIXEL16 | WID192 | XADDPIX

#define HS_CONGRATS_X		64
#define	HS_CONGRATS_Y		36
#define	HS_CONGRATS_WIDTH	192
#define	HS_CONGRATS_HEIGHT	36
#define	HS_CONGRATS_FLAGS	PITCH1 | PIXEL16 | WID192 | XADDPIX

#define HS_PLAYER_X			180
#define	HS_PLAYER_Y			54
#define	HS_PLAYER_WIDTH		48
#define	HS_PLAYER_HEIGHT	18
#define	HS_PLAYER_FLAGS		PITCH1 | PIXEL16 | WID48 | XADDPIX

#define HS_USE_X			98
#define	HS_USE_Y			142
#define	HS_USE_WIDTH		128
#define	HS_USE_HEIGHT		23
#define	HS_USE_FLAGS		PITCH1 | PIXEL16 | WID128 | XADDPIX

#define	HS_ALPHA_FLAGS		PITCH1 | PIXEL16 | WID8 | XADDPIX

typedef struct
	{
	UINT	Entry	   : 8;

	UINT	Difficulty : 2;
	UINT	Level	   : 6;

	LONG	Score;
	char	Name[MAX_NAME_LENGTH];
	} DEF_HIGHSCORE;

void ReadHighScores( void );
void ResetHighScores( int write );
void WriteHighScore( int which );

void SortHighScores( void );
void ShowHighScores( void );

void EnterHighScore( int who );

void PlaceScoreText(short which, int col, int row, int bright);

void DisplayHighScoreTitle( void );
void DisplayHighScoreCongrats( short who );

void ShowLastScreenCongrats( void );

#endif

