;*==========================================================*
;* TITLE:        IMAGES.S                                   *
;* Function:     Defines game images                        *
;*                                                          *
;* Project:      Breakout 2000                              *
;*                                                          *
;* Programmer:   Mario Perdue                               *
;*                                                          *
;* COPYRIGHT 1995 MP Graphics Systems                       *
;*                                                          *
;* UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,      *
;* PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR       *
;* THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.  *
;* ALL RIGHTS RESERVED.                                     *
;*                                                          *
;*==========================================================*

   	.globl  _ROM_Background0
   	.globl  _ROM_Background1
   	.globl  _ROM_Background2
   	.globl  _ROM_Background3
   	.globl  _ROM_Background4
   	.globl  _ROM_Background5
   	.globl  _ROM_Background6
   	.globl  _ROM_Background7
   	.globl  _ROM_Background8
   	.globl  _ROM_Background9
	.globl	_IMG_Background

    .globl  _ROM_Brick
    .globl  _ROM_Brick1
    .globl  _ROM_Brick2
    .globl  _ROM_Brick3
    .globl  _ROM_Brick4
	.globl	_IMG_Brick
	.globl	_IMG_Brick1
	.globl	_IMG_Brick2
	.globl	_IMG_Brick3
	.globl	_IMG_Brick4

	.globl	_ROM_BrickClassic
	.globl	_IMG_BrickClassic

	.globl	_ROM_DropBrick
	.globl	_IMG_DropBrick
														 
	.globl	_ROM_Level
	.globl	_IMG_Level

 	.globl	_ROM_Digit
	.globl	_IMG_Digit

 	.globl	_ROM_BigDigit
	.globl	_IMG_BigDigit

	.globl	_ROM_Title

   	.globl  _ROM_Transition

	.globl	_ROM_OptionGame
	.globl	_ROM_OptionText
	.globl	_ROM_OptionButton
	.globl	_ROM_OptionStart
	.globl	_ROM_OptionStartButton
	.globl	_ROM_OptionUsage
	.globl	_ROM_OptionPlayer
	.globl	_ROM_OptionSound
	.globl	_ROM_OptionSlide

	.globl	_ROM_PopUpMusic
	.globl	_ROM_PopUpEffects

	.globl	_ROM_Panel
	
	.globl	_ROM_Screen

	.globl	_ROM_Message

	.globl	_IMG_Playfield
	.globl	_IMG_PlayfieldBuffer
	.globl	_IMG_BrickBuffer
	.globl	_IMG_BrickEraseBuffer
	.globl	_IMG_BackgroundBuffer
	.globl	_IMG_ExpandBuffer
	.globl	_IMG_TransitionBuffer

	.globl	_ROM_ScoreAlpha
	.globl	_ROM_ScoreIcon
	.globl	_ROM_ScoreTitle
	.globl	_ROM_ScoreCongrats
	.globl	_ROM_ScorePlayer
	.globl	_ROM_ScoreUse

    .data
    .phrase
_ROM_Background0:
	.incbin 		"images/b2k_bkg0.lzj"

    .phrase
_ROM_Background1:
	.incbin 		"images/b2k_bkg1.lzj"

    .phrase
_ROM_Background2:
	.incbin 		"images/b2k_bkg2.lzj"

    .phrase
_ROM_Background3:
	.incbin 		"images/b2k_bkg3.lzj"

    .phrase
_ROM_Background4:
	.incbin 		"images/b2k_bkg4.lzj"

    .phrase
_ROM_Background5:
	.incbin 		"images/b2k_bkg5.lzj"

    .phrase
_ROM_Background6:
	.incbin 		"images/b2k_bkg6.lzj"

    .phrase
_ROM_Background7:
	.incbin 		"images/b2k_bkg7.lzj"

    .phrase
_ROM_Background8:
	.incbin 		"images/b2k_bkg8.lzj"

    .phrase
_ROM_Background9:
	.incbin 		"images/b2k_bkg9.lzj"

	.phrase
_ROM_Brick:
	.incbin			"images/brick_0.lzj"

	.phrase
_ROM_Brick1:
	.incbin			"images/brick_1.lzj"

	.phrase
_ROM_Brick2:
	.incbin			"images/brick_2.lzj"

	.phrase
_ROM_Brick3:
	.incbin			"images/brick_3.lzj"

	.phrase
_ROM_Brick4:
	.incbin			"images/brick_4.lzj"

	.phrase
_ROM_BrickClassic:
	.incbin			"images/brk_clas.lzj"

	.phrase
_ROM_DropBrick:
	.incbin			"images/brk_drop.lzj"


	.phrase
_ROM_Level:
	.incbin			"images/level.lzj"
	
	.phrase
_ROM_Digit:
	.incbin			"images/digits.lzj"

	.phrase
_ROM_BigDigit:
	.incbin			"images/dig_clas.lzj"

	.phrase
_ROM_Screen:
	.incbin			"images/nebula.lzj"

	.phrase
_ROM_Title:
	.incbin			"images/title.lzj"

	.phrase
_ROM_Transition:
	.incbin			"images/transit.lzj"

	.phrase
_ROM_Message:
	.incbin			"images/message.cry"


	.phrase
_ROM_OptionGame:
	.incbin			"images/opt_game.cry"
	
	.phrase
_ROM_OptionText:
	.incbin			"images/opt_text.cry"

	.phrase
_ROM_OptionButton:
	.incbin			"images/opt_butn.cry"

	.phrase
_ROM_OptionStart:
	.incbin			"images/optstart.cry"

	.phrase
_ROM_OptionStartButton:
	.incbin			"images/opt_strt.cry"

	.phrase
_ROM_OptionUsage:
	.incbin			"images/opt_use.cry"

	.phrase
_ROM_OptionPlayer:
	.incbin			"images/opt_plyr.cry"

	.phrase
_ROM_OptionSound:
	.incbin			"images/opt_snds.cry"

	.phrase
_ROM_OptionSlide:
	.incbin			"images/opt_vol2.cry"



	.phrase
_ROM_PopUpMusic:
	.incbin			"images/pu_music.cry"

	.phrase
_ROM_PopUpEffects:
	.incbin			"images/pu_fx.cry"


	.phrase
_ROM_Panel:
	.incbin			"images/panel.lzj"


	.phrase
_ROM_ScoreAlpha:
	.incbin			"images/hs_alpha.cry"

_ROM_ScoreIcon:
	.incbin			"images/icons.cry"

_ROM_ScoreTitle:
	.incbin			"images/hs_title.cry"

_ROM_ScoreCongrats:
	.incbin			"images/hs_congr.cry"

_ROM_ScorePlayer:
	.incbin			"images/hs_playr.cry"

_ROM_ScoreUse:
	.incbin			"images/hs_use.cry"




    .bss
	.phrase
_IMG_Background:
	.ds.w	76800

	.phrase
_IMG_Brick:
	.ds.w	7200
_IMG_Brick1:
	.ds.w	7200
_IMG_Brick2:
	.ds.w	7200
_IMG_Brick3:
	.ds.w	7200
_IMG_Brick4:
	.ds.w	7200

	.phrase
_IMG_BrickClassic:
	.ds.w	2400
	
	.phrase
_IMG_DropBrick:
	.ds.w	11520

	.phrase
_IMG_Playfield:
	.ds.w	76800

	.phrase
_IMG_PlayfieldBuffer:		; Playfield buffer stops at Brick Buffer
_IMG_BackgroundBuffer:		; Background buffer is used for image expansion
	.ds.w	76800			; when the playfield is not displayed.
_IMG_ExpandBuffer:			; Expand buffer is 1/4 screen area for delzjag
	.ds.w	19200
_IMG_TransitionBuffer:		; Transition buffer is array for level transition
	.ds.w	32000			; effect. Area includes the Brick buffer.

_IMG_BrickBuffer:
	.ds.w	128000

	.phrase
_IMG_BrickEraseBuffer:
	.ds.w	400


	.phrase
_IMG_Level:
	.ds.w	392

	.phrase
_IMG_Digit:
	.ds.w	2640

	.phrase
_IMG_BigDigit:
	.ds.w	2560



