/*******************************************************************
 *
 *    TITLE:        jagobj.c
 *
 *    DESCRIPTION:	Routines to initialize the game data
 *
 *    AUTHOR:		Mario Perdue & Richard Degler
 *
 *    HISTORY:    
 *
 *
 *           COPYRIGHT 1994, 1995 MP Graphics Systems         
 *      UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
 *      PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
 *     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
 *                        ALL RIGHTS RESERVED.               
 *******************************************************************/

/** include files **/
#include "jagobj.h"
#include "support.h"
#include "player.h"
#include "displays.h"
#include "option.h"
#include "b2k_game.h"
#include "star.h"


extern DEF_OPTION		Option;

extern int				ScreenHeight;
extern int				ScreenOrgX;
extern int				ScreenOrgY;

extern	WORD			ObjectListFlag;
extern	DEF_OBJECTLIST	ObjectList[2];

extern 	unsigned short 	a_vdb;
extern 	unsigned short 	a_vde;
extern 	unsigned short	width;
extern	unsigned short	height;

extern	WORD			IMG_Playfield[];
extern	WORD			IMG_Background[];
extern	WORD			IMG_GlassBack[];
extern	WORD			IMG_GlassSide[];
extern  WORD			IMG_Screen[];
extern	WORD			IMG_BarrierGlass[];
extern	WORD			IMG_PaddleFace[MAX_PLAYERS][768];
extern	WORD			IMG_PaddleFrame[MAX_PLAYERS][1280];

extern	DEF_PLAYER 		Player[MAX_PLAYERS];

extern 	BYTE			PlayerOnTop;	

/*********************************************************************
 *  FUNCTION:		InitBranchObject
 *
 *  PARAMETERS:		PBRAOBJ *Object
 *					int ypos
 *					int cc
 *					ULONG link
 *
 *  DESCRIPTION:	Set up a branch object in the object list
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void InitBranchObject(PBRAOBJ *Object, int ypos, int cc, ULONG link)
	{
	Object->ph1[0] = 0L;
	Object->ph1[1] = 0L;

	oset_type(Object, T_BRAOBJ);
	oset_ypos(Object, ypos);
	oset_cc(Object, cc);
	oset_link(Object, link);
	}

/*********************************************************************
 *  FUNCTION:		InitBitmapObject
 *
 *  PARAMETERS:		PBITMOBJ *Object
 *					int xpos
 *					int ypos
 *					int height
 *					ULONG link
 *					ULONG data
 *					int depth
 *					int dwidth
 *					int iwidth
 *					int trans
 *
 *  DESCRIPTION:	Set up a bitmap object in the object list
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void InitBitmapObject(PBITMOBJ *Object, int xpos, int ypos, int height, 
		ULONG link, ULONG data, int depth, int dwidth, int iwidth, 
		int trans, int rmw, int reflect, int release)
	{
	Object->ph1[0] = 0L;
	Object->ph1[1] = 0L;
	Object->ph2[0] = 0L;
	Object->ph2[1] = 0L;

	oset_type(Object,		T_BITMOBJ);
	oset_ypos(Object,		ypos);
	oset_height(Object,		height);
	oset_link(Object, 		link);
	oset_data(Object, 		data);
	oset_xpos(Object, 		xpos);
	oset_depth(Object, 		depth);
	oset_pitch(Object, 		1);
	oset_dwidth(Object,		dwidth);
	oset_iwidth(Object,		iwidth);
	oset_trans(Object,		trans);
	oset_reflect(Object,	reflect);
	oset_rmw(Object,		rmw);
	oset_release(Object,	release);
	}


/*********************************************************************
 *  FUNCTION:		InitBitmapObject
 *
 *  PARAMETERS:		PBITMOBJ *Object
 *					int xpos
 *					int ypos
 *					int height
 *					ULONG link
 *					ULONG data
 *					int depth
 *					int dwidth
 *					int iwidth
 *					int trans
 *					int scale
 *
 *  DESCRIPTION:	Set up a bitmap object in the object list
 *
 *  RETURNS:		void
 *
 *********************************************************************/
/*
void InitSBitmapObject(PSBITMOBJ *Object, int xpos, int ypos, int height, 
	   	ULONG link, ULONG data, int depth, int dwidth, int iwidth, int trans,
		int scale)
	{
	Object->ph1[0] = 0L;
	Object->ph1[1] = 0L;
	Object->ph2[0] = 0L;
	Object->ph2[1] = 0L;
	Object->ph3[0] = 0L;
	Object->ph3[1] = 0L;

	oset_type(Object,		T_SBITMOBJ);
	oset_ypos(Object,		ypos);
	oset_height(Object,		height);
	oset_link(Object, 		link);
	oset_data(Object, 		data);
	oset_xpos(Object, 		xpos);
	oset_depth(Object, 		depth);
	oset_pitch(Object, 		1);
	oset_dwidth(Object,		dwidth);
	oset_iwidth(Object,		iwidth);
	oset_trans(Object,		trans);
	oset_hscale(Object,		scale);
	oset_vscale(Object,		scale);
	}
*/

/*********************************************************************
 *  FUNCTION:		InitStopObject
 *
 *  PARAMETERS:		PSTOPOBJ *Object
 *
 *  DESCRIPTION:	Set up a bitmap object in the object list
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void InitStopObject(PSTOPOBJ *Object)
	{
	Object->ph1[0] = 0L;
	Object->ph1[1] = 0L;

	oset_type(Object, T_STOPOBJ);
	}


/*********************************************************************
 *  FUNCTION:		BuildObjectList
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	Builds the game object list
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void BuildObjectList(int which)
	{
	ScreenHeight = height;
	ScreenOrgX = (width/4-320)/2;
	ScreenOrgY = (a_vdb+(height-240))&0xFFFFFFFE;

	Option.NumPlayers = 0;

	Player[0].Mode = modeTITLE;
	Player[1].Mode = modeIDLE;

	/* Initialize the Screen branch objects */
	InitBranchObject(&ObjectList[which].ScreenBranch[0], a_vde, YPOS_LT_VC,
									(ULONG) &ObjectList[listDISPLAY].Stop);
	InitBranchObject(&ObjectList[which].ScreenBranch[1], a_vdb, YPOS_GT_VC,
									(ULONG) &ObjectList[listDISPLAY].Stop);

	/* Initialize the starfield objects */
	InitBitmapObject(&ObjectList[which].Starfield1, ScreenOrgX, a_vdb, 288, 
					(ULONG) &ObjectList[listDISPLAY].SFDummy, (ULONG) IMG_Screen,
					4, 80, 40, 0, 0, 0, 0);
	InitBitmapObject(&ObjectList[which].SFDummy, ScreenOrgX+400, a_vdb, 288, 
					(ULONG) &ObjectList[listDISPLAY].Starfield2, (ULONG) IMG_Screen,
					4, 1, 1, 0, 0, 0, 1);
	InitBitmapObject(&ObjectList[which].Starfield2, ScreenOrgX+160, a_vdb, 288, 
					(ULONG) &ObjectList[listDISPLAY].GlassBranch[0], (ULONG) IMG_Screen+320,
					4, 80, 40, 0, 0, 0, 0);

	/* Initialize the Glass branch objects */
	InitBranchObject(&ObjectList[which].GlassBranch[0], ScreenOrgY+GLASS_BACK_Y+(GLASS_BACK_H*2), 
					YPOS_LT_VC, (ULONG) &ObjectList[listDISPLAY].Background1);
	InitBranchObject(&ObjectList[which].GlassBranch[1], ScreenOrgY+GLASS_BACK_Y, 
					YPOS_GT_VC, (ULONG) &ObjectList[listDISPLAY].Background1);

	/* Initialize the Back Glass object */
 	InitBitmapObject(&ObjectList[which].GlassBack, ScreenOrgX+GLASS_BACK_X, 
 					ScreenOrgY+GLASS_BACK_Y, 104, 
					(ULONG) &ObjectList[listDISPLAY].Background1, (ULONG) IMG_GlassBack,
 					4, 40, 40, 1, 1, 0, 0);

	/* Initialize the Background objects */
	InitBitmapObject(&ObjectList[which].Background1, ScreenOrgX, ScreenOrgY, 240, 
					(ULONG) &ObjectList[listDISPLAY].BGDummy, (ULONG) IMG_Background,
					4, 80, 40, 1, 0, 0, 0);
	InitBitmapObject(&ObjectList[which].BGDummy, ScreenOrgX+400, ScreenOrgY, 240, 
					(ULONG) &ObjectList[listDISPLAY].Background2, (ULONG) IMG_Background,
					4, 1, 1, 1, 0, 0, 1);
	InitBitmapObject(&ObjectList[which].Background2, ScreenOrgX+160, ScreenOrgY, 240, 
					(ULONG) &ObjectList[listDISPLAY].GlassLeft, (ULONG) IMG_Background+320,
					4, 80, 40, 1, 0, 0, 0);

	/* Initialize the Left Glass object */
 	InitBitmapObject(&ObjectList[which].GlassLeft, ScreenOrgX+GLASS_LEFT_X, 
 					ScreenOrgY+GLASS_LEFT_Y, 189, 
					(ULONG) &ObjectList[listDISPLAY].GlassRight, (ULONG) IMG_GlassSide,
 					4, 16, 16, 1, 1, 0, 1);

	/* Initialize the Right Glass object */
	InitBitmapObject(&ObjectList[which].GlassRight, ScreenOrgX+GLASS_RIGHT_X, 
					ScreenOrgY+GLASS_RIGHT_Y, 189, 
					(ULONG) &ObjectList[listDISPLAY].Playfield1, (ULONG) IMG_GlassSide,
					4, 16, 16, 1, 1, 1, 0);

	/* Initialize the Playfield object2 */
	InitBitmapObject(&ObjectList[which].Playfield1, ScreenOrgX, ScreenOrgY, 240, 
				(ULONG) &ObjectList[listDISPLAY].PFDummy, (ULONG) IMG_Playfield,
				4, 80, 40, 1, 0, 0, 0);
	InitBitmapObject(&ObjectList[which].PFDummy, ScreenOrgX+400, ScreenOrgY, 240, 
				(ULONG) &ObjectList[listDISPLAY].Playfield2, (ULONG) IMG_Playfield,
				4, 1, 1, 1, 0, 0, 1);
	InitBitmapObject(&ObjectList[which].Playfield2, ScreenOrgX+160, ScreenOrgY, 240, 
				(ULONG) &ObjectList[listDISPLAY].Stop, (ULONG) IMG_Playfield+320,
				4, 80, 40, 1, 0, 0, 0);

	/* Initialize Top Barrier Object */
	InitBitmapObject(&ObjectList[which].BarrierTop, ScreenOrgX+BARRIER_TOP_X, 
				ScreenOrgY+BARRIER_TOP_Y, BARRIER_H,
				(ULONG) &ObjectList[listDISPLAY].BarrierBottom, (ULONG) IMG_BarrierGlass,
				4, 64, 64, 1, 1, 0, 0);

	InitBitmapObject(&ObjectList[which].PaddleFaceTop, ScreenOrgX, 
				ScreenOrgY, PADDLE_FACE_HEIGHT,
				(ULONG) &ObjectList[listDISPLAY].PaddleFrameTop, (ULONG) IMG_PaddleFace[0],
				4, 16, 16, 1, 1, 0, 0);
	InitBitmapObject(&ObjectList[which].PaddleFrameTop, ScreenOrgX, 
				ScreenOrgY, PADDLE_HEIGHT,
				(ULONG) &ObjectList[listDISPLAY].Stop, (ULONG) IMG_PaddleFrame[0],
				4, 16, 16, 1, 0, 0, 0);

	/* Initialize Bottom Barrier Object */
	InitBitmapObject(&ObjectList[which].BarrierBottom, ScreenOrgX+BARRIER_BOT_X, 
				ScreenOrgY+BARRIER_BOT_Y, BARRIER_H,
				(ULONG) &ObjectList[listDISPLAY].Stop, (ULONG) IMG_BarrierGlass,
				4, 64, 64, 1, 1, 0, 0);

	InitBitmapObject(&ObjectList[which].PaddleFaceBottom, ScreenOrgX, 
				ScreenOrgY, PADDLE_FACE_HEIGHT,
				(ULONG) &ObjectList[listDISPLAY].PaddleFrameBottom, (ULONG) IMG_PaddleFace[1],
				4, 16, 16, 1, 1, 0, 0);
	InitBitmapObject(&ObjectList[which].PaddleFrameBottom, ScreenOrgX, 
				ScreenOrgY, PADDLE_HEIGHT,
				(ULONG) &ObjectList[listDISPLAY].Stop, (ULONG) IMG_PaddleFrame[1],
				4, 16, 16, 1, 0, 0, 0);

	/* Initialize the Stop Object */
	InitStopObject(&ObjectList[listDISPLAY].Stop);
	}


/*********************************************************************
 *  FUNCTION:		UpdateObjectList
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	Restore object data for next display
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void UpdateObjectList()
	{
	if(!ObjectListFlag)
		return;

	switch(Option.GameMode)
		{
		case gameCLASSIC:
			oclr_xpos(&ObjectList[listBUFFER].Starfield1);
			oset_xpos(&ObjectList[listBUFFER].Starfield1, (ScreenOrgX+500));
			oclr_xpos(&ObjectList[listBUFFER].Starfield2);
			oset_xpos(&ObjectList[listBUFFER].Starfield2, (ScreenOrgX+500));
			oclr_link(&ObjectList[listBUFFER].Starfield2);
			oset_link(&ObjectList[listBUFFER].Starfield2, &ObjectList[listDISPLAY].Background1);
			oclr_link(&ObjectList[listBUFFER].Background2);
			oset_link(&ObjectList[listBUFFER].Background2, &ObjectList[listDISPLAY].Playfield1);
			break;
			
		case game2000:
			oclr_xpos(&ObjectList[listBUFFER].Starfield1);
			oset_xpos(&ObjectList[listBUFFER].Starfield1, ScreenOrgX);
			oclr_xpos(&ObjectList[listBUFFER].Starfield2);
			oset_xpos(&ObjectList[listBUFFER].Starfield2, (ScreenOrgX+160));
			oclr_link(&ObjectList[listBUFFER].Starfield2);
			oset_link(&ObjectList[listBUFFER].Starfield2, &ObjectList[listDISPLAY].GlassBranch[0]);
			oclr_link(&ObjectList[listBUFFER].Background2);
			oset_link(&ObjectList[listBUFFER].Background2, &ObjectList[listDISPLAY].GlassLeft);
			break;
		}

	switch(Player[PLAYER_RED].Mode)
		{
		case modeTITLE:
		case modeHIGHSCORE:
		case modeSTARTGAME:
		case modeSTARTSCREEN:
		case modePONGSTART:
		case modeTARGETSTART:
			oclr_link(&ObjectList[listBUFFER].Playfield2);
			oset_link(&ObjectList[listBUFFER].Playfield2, &ObjectList[listDISPLAY].Stop);
			return;
			break;
		}

	/* If there are two players */
	if(Option.NumPlayers == 2)
		{
		if(Player[PLAYER_ON_TOP].Mode == modeENDGAME)
			{
			oclr_link(&ObjectList[listBUFFER].Playfield2);
			oset_link(&ObjectList[listBUFFER].Playfield2, &ObjectList[listDISPLAY].BarrierTop);

			if(Player[PLAYER_ON_BOTTOM].Paddle.Active)
				{
				oclr_link(&ObjectList[listBUFFER].BarrierTop);
				oset_link(&ObjectList[listBUFFER].BarrierTop,&ObjectList[listDISPLAY].PaddleFaceBottom);
				}
			else
				{
				oclr_link(&ObjectList[listBUFFER].BarrierTop);
				oset_link(&ObjectList[listBUFFER].BarrierTop,&ObjectList[listDISPLAY].BarrierBottom);
				}
			}
		else if(Player[PLAYER_ON_TOP].Mode == modeIDLE)
			{
			if(Player[PLAYER_ON_BOTTOM].Paddle.Active)
				{
				oclr_link(&ObjectList[listBUFFER].Playfield2);
				oset_link(&ObjectList[listBUFFER].Playfield2, &ObjectList[listDISPLAY].PaddleFaceBottom);
				}
			else
				{
				oclr_link(&ObjectList[listBUFFER].Playfield2);
				oset_link(&ObjectList[listBUFFER].Playfield2, &ObjectList[listDISPLAY].BarrierBottom);
				}
			}
		else if(Player[PLAYER_ON_BOTTOM].Mode == modeENDGAME)
		  	{
			oclr_link(&ObjectList[listBUFFER].Playfield2);
			oset_link(&ObjectList[listBUFFER].Playfield2,&ObjectList[listDISPLAY].PaddleFaceTop);
			oclr_link(&ObjectList[listBUFFER].PaddleFrameTop);
			oset_link(&ObjectList[listBUFFER].PaddleFrameTop,&ObjectList[listDISPLAY].BarrierBottom);
		  	}
		else
			{
			oclr_link(&ObjectList[listBUFFER].Playfield2);
			oset_link(&ObjectList[listBUFFER].Playfield2,&ObjectList[listDISPLAY].PaddleFaceTop);
			oclr_link(&ObjectList[listBUFFER].PaddleFrameTop);
			oset_link(&ObjectList[listBUFFER].PaddleFrameTop,&ObjectList[listDISPLAY].PaddleFaceBottom);
			}
		}

	/* If there is only one player */
	else
		{
		if(Option.GameMode == gameCLASSIC)
			{
			oclr_link(&ObjectList[listBUFFER].Playfield2);
			oset_link(&ObjectList[listBUFFER].Playfield2,&ObjectList[listDISPLAY].PaddleFaceBottom);
			}
		else if(!Player[PLAYER_ON_BOTTOM].Paddle.Active)
			{
			if(Player[PLAYER_ON_BOTTOM].BallCount <= 0 )
				{
				oclr_link(&ObjectList[listBUFFER].Playfield2);
				oset_link(&ObjectList[listBUFFER].Playfield2,&ObjectList[listDISPLAY].BarrierBottom);
				}
			else
				{
				oclr_link(&ObjectList[listBUFFER].Playfield2);
				oset_link(&ObjectList[listBUFFER].Playfield2,&ObjectList[listDISPLAY].Stop);
				}
			}
		else
			{
			oclr_link(&ObjectList[listBUFFER].Playfield2);
			oset_link(&ObjectList[listBUFFER].Playfield2,&ObjectList[listDISPLAY].PaddleFaceBottom);
			}
		}

	oclr_ypos(&ObjectList[listBUFFER].PaddleFaceTop);
	oset_ypos(&ObjectList[listBUFFER].PaddleFaceTop, ((Player[PLAYER_ON_TOP].Paddle.ScreenY+8)*2+ScreenOrgY));
	oclr_xpos(&ObjectList[listBUFFER].PaddleFaceTop);
	oset_xpos(&ObjectList[listBUFFER].PaddleFaceTop, (Player[PLAYER_ON_TOP].Paddle.ScreenX+ScreenOrgX));

	oclr_ypos(&ObjectList[listBUFFER].PaddleFrameTop);
	oset_ypos(&ObjectList[listBUFFER].PaddleFrameTop, ((Player[PLAYER_ON_TOP].Paddle.ScreenY)*2+ScreenOrgY));
	oclr_xpos(&ObjectList[listBUFFER].PaddleFrameTop);
	oset_xpos(&ObjectList[listBUFFER].PaddleFrameTop, (Player[PLAYER_ON_TOP].Paddle.ScreenX+ScreenOrgX));


	oclr_ypos(&ObjectList[listBUFFER].PaddleFaceBottom);
	oset_ypos(&ObjectList[listBUFFER].PaddleFaceBottom, ((Player[PLAYER_ON_BOTTOM].Paddle.ScreenY+20)*2+ScreenOrgY));
	oclr_xpos(&ObjectList[listBUFFER].PaddleFaceBottom);
	oset_xpos(&ObjectList[listBUFFER].PaddleFaceBottom, (Player[PLAYER_ON_BOTTOM].Paddle.ScreenX+ScreenOrgX));

	oclr_ypos(&ObjectList[listBUFFER].PaddleFrameBottom);
	oset_ypos(&ObjectList[listBUFFER].PaddleFrameBottom, ((Player[PLAYER_ON_BOTTOM].Paddle.ScreenY+20)*2+ScreenOrgY));
	oclr_xpos(&ObjectList[listBUFFER].PaddleFrameBottom);
	oset_xpos(&ObjectList[listBUFFER].PaddleFrameBottom, (Player[PLAYER_ON_BOTTOM].Paddle.ScreenX+ScreenOrgX));

	ObjectListFlag = FALSE;
	}


/*********************************************************************
 *  FUNCTION:		ResfreshObjectList
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	Restore object data for next display
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void RefreshObjectList()
	{
	ObjectList[listDISPLAY].Starfield1 = ObjectList[listBUFFER].Starfield1;
	ObjectList[listDISPLAY].SFDummy = ObjectList[listBUFFER].SFDummy;
	ObjectList[listDISPLAY].Starfield2 = ObjectList[listBUFFER].Starfield2;
	ObjectList[listDISPLAY].GlassBack = ObjectList[listBUFFER].GlassBack;
	ObjectList[listDISPLAY].Background1 = ObjectList[listBUFFER].Background1;
	ObjectList[listDISPLAY].BGDummy = ObjectList[listBUFFER].BGDummy;
	ObjectList[listDISPLAY].Background2 = ObjectList[listBUFFER].Background2;
	ObjectList[listDISPLAY].GlassLeft = ObjectList[listBUFFER].GlassLeft;
	ObjectList[listDISPLAY].GlassRight = ObjectList[listBUFFER].GlassRight;
	ObjectList[listDISPLAY].Playfield1 = ObjectList[listBUFFER].Playfield1;
	ObjectList[listDISPLAY].PFDummy = ObjectList[listBUFFER].PFDummy;
	ObjectList[listDISPLAY].Playfield2 = ObjectList[listBUFFER].Playfield2;
	ObjectList[listDISPLAY].BarrierTop = ObjectList[listBUFFER].BarrierTop;
	ObjectList[listDISPLAY].PaddleFaceTop = ObjectList[listBUFFER].PaddleFaceTop;
	ObjectList[listDISPLAY].PaddleFrameTop = ObjectList[listBUFFER].PaddleFrameTop;
	ObjectList[listDISPLAY].BarrierBottom = ObjectList[listBUFFER].BarrierBottom;
	ObjectList[listDISPLAY].PaddleFaceBottom = ObjectList[listBUFFER].PaddleFaceBottom;
	ObjectList[listDISPLAY].PaddleFrameBottom = ObjectList[listBUFFER].PaddleFrameBottom;

	UpdateObjectList();

	UpdateStarfield();
	}

