/*******************************************************************
 *
 *    TITLE:        jagobj.h
 *
 *    DESCRIPTION:	Header file for Jaguar Objects
 *
 *    AUTHOR:		Mario Perdue & Richard Degler
 *					Based on code provided by Atari Corp.
 *
 *    HISTORY:    
 *
 *
 *           COPYRIGHT 1994, 1995 MP Graphics Systems         
 *      UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
 *      PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
 *     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
 *                        ALL RIGHTS RESERVED.               
 *******************************************************************/


#ifndef __JAGOBJ__H
#define __JAGOBJ__H

#define T_BITMOBJ   0
#define T_SBITMOBJ  1
#define T_GPUOBJ	2
#define T_BRAOBJ	3
#define T_STOPOBJ   4

#define LINK_ADDR   0xfff90L

#define ULONG	unsigned long



/* 
 *  Packed Objects
 */

typedef struct
	{
	ULONG ph1[2];
	ULONG ph2[2];
	} PBITMOBJ;

typedef struct
	{
	ULONG ph1[2];
	ULONG ph2[2];
	ULONG ph3[2];
	ULONG dmy[2];
	} PSBITMOBJ;

typedef struct
	{
	ULONG ph1[2];
	} PSTOPOBJ;

typedef struct 
	{
	ULONG ph1[2];
	} PGPUOBJ;

typedef struct 
	{
	ULONG ph1[2];
	} PBRAOBJ;

typedef struct
	{
	PBRAOBJ			ScreenBranch[2];
	
	PBITMOBJ		Starfield1;
	PBITMOBJ		SFDummy;
	PBITMOBJ		Starfield2;

	PBRAOBJ			GlassBranch[2];
	PBITMOBJ		GlassBack;

	PBITMOBJ		Background1;
	PBITMOBJ		BGDummy;
	PBITMOBJ		Background2;

	PBITMOBJ		GlassLeft;
	PBITMOBJ		GlassRight;

	PBITMOBJ		Playfield1;
	PBITMOBJ		PFDummy;
	PBITMOBJ		Playfield2;

	PBRAOBJ			BarrierBranchTop[2];
	PBITMOBJ		BarrierTop;
	PBITMOBJ		PaddleFaceTop;
	PBITMOBJ		PaddleFrameTop;

	PBRAOBJ			BarrierBranchBottom[2];
	PBITMOBJ		BarrierBottom;
	PBITMOBJ		PaddleFaceBottom;
	PBITMOBJ		PaddleFrameBottom;

	PSTOPOBJ		Stop;
	} DEF_OBJECTLIST;

enum { listDISPLAY, listBUFFER };

/*
 *  Clear fields in packed objects
 */
#define oclr_type(o)		((o)->ph1[1]  &= ((ULONG) 0xFFFFFFF8L))
#define oclr_ypos(o)		((o)->ph1[1]  &= ((ULONG) 0xFFFFC007L))
#define oclr_height(o)	  	((o)->ph1[1]  &= ((ULONG) 0xFF003FFFL))
#define oclr_link(o)		(((o)->ph1[1] &= ((ULONG) 0x00FFFFFFL)),\
							((o)->ph1[0]  &= ((ULONG) 0xFFFFF800L)))
#define oclr_data(o)		((o)->ph1[0]  &= ((ULONG) 0x000007ffL))

#define oclr_xpos(o)		((o)->ph2[1]  &= ((ULONG) 0xFFFFF000L))
#define oclr_depth(o)	   	((o)->ph2[1]  &= ((ULONG) 0xFFFF8FFFL))
#define oclr_pitch(o)	   	((o)->ph2[1]  &= ((ULONG) 0xFFFC7FFFL))
#define oclr_dwidth(o)	  	((o)->ph2[1]  &= ((ULONG) 0xF003FFFFL))
#define oclr_iwidth(o)	  	((((o)->ph2[1] &= ((ULONG) 0x0FFFFFFFL))),\
							((o)->ph2[0]  &= ((ULONG) 0xFFFFFFC0L)))
#define oclr_index(o)	   	((o)->ph2[0]  &= ((ULONG) 0xFFFFFE3FL))
#define oclr_reflect(o)	 	((o)->ph2[0]  &= ((ULONG) 0xFFFFDFFFL))
#define oclr_rmw(o)		 	((o)->ph2[0]  &= ((ULONG) 0xFFFFBFFFL))
#define oclr_trans(o)	   	((o)->ph2[0]  &= ((ULONG) 0xFFFF7FFFL))
#define oclr_release(o)	 	((o)->ph2[0]  &= ((ULONG) 0xFFFEFFFFL))
#define oclr_firstpix(o)	((o)->ph2[0]  &= ((ULONG) 0xFFF9FFFFL))
#define oclr_unused2(o)	 	((o)->ph2[0]  &= ((ULONG) 0xFF800000L)) 

#define oclr_hscale(o)	  	((o)->ph3[1]  &= ((ULONG) 0xFFFFFF00L))
#define oclr_vscale(o)	  	((o)->ph3[1]  &= ((ULONG) 0xFFFF00FFL))
#define oclr_remainder(o)   ((o)->ph3[1]  &= ((ULONG) 0xFF00FFFFL))
#define oclr_unused3(o)	 	(((o)->ph3[1] &= ((ULONG) 0xFF000000L)), \
							((o)->ph3[0] = 0L)) 


#define oclr_gpu(o)	 		(((o)->ph1[1] &= ((ULONG) 0xFF003FFFL)), \
							((o)->ph1[0] = 0L ))

#define oclr_cc(o)	  		((o)->ph1[1] &= ((ULONG) 0xFFFF3FFFL))


/*
 *  Get data from unpacked objects into packed objects
 */

/* some defines changed from original to minimize shifts */
#define oset_type(o, v)	 	((o)->ph1[1] |= ((ULONG)v & 0x07L))

#define oset_ypos(o, v)	 	((o)->ph1[1] |= (((ULONG)v & 0x07FFL) << 3L))

#define oset_height(o, v)   ((o)->ph1[1] |= (((ULONG)v & 0x03FFL) << 14L))

#define oset_link(o, v)	 	(((o)->ph1[1] |= (((ULONG)v & 0x07F8) << 21L)), \
							((o)->ph1[0] |= (((ULONG)v >> 11L) & 0x0007FFL)))

#define oset_data(o, v)	 	((o)->ph1[0] |= (((ULONG)v & 0xFFFFF4L) << 8L))

#define oset_xpos(o, v)	 	((o)->ph2[1] |= ((ULONG)v & 0x0FFFL))

#define oset_depth(o, v)	((o)->ph2[1] |= (((ULONG)v & 0x07L) << 12L))

#define oset_pitch(o, v)	((o)->ph2[1] |= (((ULONG)v & 0x07L) << 15L))

#define oset_dwidth(o, v)   ((o)->ph2[1] |= (((ULONG)v & 0x03FFL) << 18L))

#define oset_iwidth(o, v)   ((((o)->ph2[1] |= (((ULONG)v & 0x0FL) << 28L))),\
							((o)->ph2[0] |= (((ULONG)v >> 4L) & 0x003FL)))

#define oset_index(o, v)	((o)->ph2[0] |= (((ULONG)v & 0x07FL) << 6L))

#define oset_reflect(o, v)  ((o)->ph2[0] |= (((ULONG)v & 0x01L) << 13L))

#define oset_rmw(o, v)	  	((o)->ph2[0] |= (((ULONG)v & 0x01L) << 14L))

#define oset_trans(o, v)	((o)->ph2[0] |= (((ULONG)v & 0x01L) << 15L))

#define oset_release(o, v)  ((o)->ph2[0] |= (((ULONG)v & 0x01L) << 16L))

#define oset_firstpix(o, v) ((o)->ph2[0] |= (((ULONG)v & 0x03FL) << 17L))

#define oset_unused2(o, v)  ((o)->ph2[0] |= (((ULONG)v & 0x01FFL) << 23L))

#define oset_hscale(o, v)   ((o)->ph3[1] |= ((ULONG)v & 0x0FFL))

#define oset_vscale(o, v)   ((o)->ph3[1] |= (((ULONG)v & 0x0FFL) << 8L))

#define oset_remainder(o, v)	((o)->ph3[1] |= (((ULONG)v & 0x0FFL) << 16L))

#define oset_unused3(o, v)  (((o)->ph3[1] |= (((ULONG)v & 0x0FFL) << 24L)), \
							((o)->ph3[0] = 0L))


#define oset_gpu(o, v, w)   (((o)->ph1[1] |= (((ULONG)w & 0x03FFL) << 14L)), \
							((o)->ph1[0] |= ((ULONG)v & 0xFFFFFFFFL))))

#define oset_cc(o, v)	   	((o)->ph1[1] |= (((ULONG)v & 0x0003L) << 14L))



#define YPOS_EQ_VC	  	0
#define YPOS_GT_VC	  	1
#define YPOS_LT_VC	  	2
#define OBJ_FLAG_SET	3
#define HC10_SET		4   


/*
 * Prototypes
 */

void InitBranchObject(PBRAOBJ *Object, int ypos, int cc, ULONG link);
void InitBitmapObject(PBITMOBJ *Object, int xpos, int ypos, int height, 
					  ULONG link, ULONG data, int depth, int dwidth, 
					  int iwidth, int trans, int rmw, int reflect, int release);
void InitSBitmapObject(PSBITMOBJ *Object, int xpos, int ypos, int height, 
					  ULONG link, ULONG data, int depth, int dwidth, 
					  int iwidth, int trans, int scale );
void InitStopObject(PSTOPOBJ *Object);


void BuildObjectList( int which );
void UpdateObjectList( void );
void RefreshObjectList( void );

#endif