/*******************************************************************
 *
 *    TITLE:        main.c
 *
 *    DESCRIPTION:	Starting point for all the 'C' stuff
 *
 *    AUTHOR:		Mario Perdue & Richard Degler
 *
 *    HISTORY:    
 *
 *
 *           COPYRIGHT 1994, 1995 MP Graphics Systems         
 *      UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
 *      PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
 *     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
 *                        ALL RIGHTS RESERVED.               
 *******************************************************************/

/** include files **/
#include "jagobj.h"
#include "support.h"
#include "displays.h"
#include "star.h"
#include "player.h"
#include "b2k_game.h"
#include "option.h"


void InitGpuCode(void);

/** external data **/
extern	DEF_OPTION	Option;
extern 	ULONG		ticks;
extern 	ULONG		OldTicks;

extern	DEF_PLAYER	Player[2];

extern	ULONG		DemoTimer;

extern	BYTE		PlayerOnTop;

extern	int			_DoGpuBlit;
extern 	long		BlitAddIndex;
extern	long		BlitUseIndex;


/* public data */

/** internal functions **/
/*********************************************************************
 *  FUNCTION:		main
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	Starting point for the game
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void main( void )
	{
	int i;

	BlitAddIndex = 0;
	BlitUseIndex = 0;

	InitGpuCode();

	/* Initialize Misc. data */
	PlayerOnTop		 			= PLAYER_GREEN;

	OldTicks = ticks;

	DemoTimer = ticks;

	Player[PLAYER_RED].Mode = modeTITLE;
	Player[PLAYER_GREEN].Mode = modeIDLE;

	for(i=0; i<MAX_NAME_LENGTH; i++)
		{
		Player[PLAYER_RED].Name[i] = 0;
		Player[PLAYER_GREEN].Name[i] = 0;
		}

	InitBrickArray(PLAYER_RED);
	InitBrickArray(PLAYER_GREEN);

	InitStarfield();

	while(1)
		{
		PlayGame();
		}
	
	return;
	}
