;******************************************************************
;
;    TITLE:			num_tab.s
;
;    DESCRIPTION:	Numeric tables
;
;    AUTHOR:		Mario Perdue & Richard Degler
;
;    HISTORY:    	04/30/95	New file
;
;
;           COPYRIGHT 1994, 1995 MP Graphics Systems         
;      UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
;      PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
;     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
;                        ALL RIGHTS RESERVED.               
;******************************************************************/

	.globl	_ROM_SinTab
	.globl	_SinTab
	.globl	_ROM_CosTab
	.globl	_CosTab

	.globl	_BrickScreenXTab
	.globl	_BrickScreenYTab
	.globl	_BrickWidthTab
	.globl	_BrickHeightTab
	.globl	_BrickIndexTab
	.globl	_BrickSizeTab

	.globl	_ROM_ExplodeOffsetTab
	.globl	_ExplodeOffsetTab
	.globl	_ROM_ExplodeWidthTab
	.globl	_ExplodeWidthTab

	.globl	_ROM_BallOffsetTab
	.globl	_BallOffsetTab
	.globl	_ROM_BallWidthTab
	.globl	_BallWidthTab

	.globl	_ROM_RippleOffsetTab
	.globl	_RippleOffsetTab
	.globl	_ROM_RippleWidthTab
	.globl	_RippleWidthTab

	.globl	_ROM_BallZTab
	.globl	_BallZTab

	.globl	_ROM_DropWidthTab
	.globl	_DropWidthTab
	.globl	_ROM_DropOffsetTab
	.globl	_DropOffsetTab

	.globl	_ROM_HighScoreTab
	.globl	_ROM_Congrats

	.globl	_ROM_PaddleWidthTab
	.globl	_PaddleWidthTab
	.globl	_ROM_PaddleOffsetTab
	.globl	_PaddleOffsetTab

	.globl	_ROM_DroidPath

_ROM_SinTab:
	.dc.w	0000, 0018, 0035, 0052, 0070
	.dc.w	0087, 0105, 0122, 0139, 0156
	.dc.w	0174, 0191, 0208, 0225, 0242
	.dc.w	0259, 0276, 0292, 0309, 0326
	.dc.w	0342, 0358, 0375, 0391, 0407
	.dc.w	0423, 0438, 0454, 0470, 0485
	.dc.w	0500, 0515, 0530, 0545, 0559
	.dc.w	0574, 0588, 0602, 0616, 0629
	.dc.w	0643, 0656, 0669, 0682, 0695
	.dc.w	0707, 0719, 0731, 0743, 0755
	.dc.w	0766, 0777, 0788, 0799, 0809
	.dc.w	0819, 0829, 0839, 0848, 0857
	.dc.w	0866, 0875, 0883, 0891, 0899
	.dc.w	0906, 0914, 0921, 0927, 0934
	.dc.w	0940, 0946, 0951, 0956, 0961
	.dc.w	0966, 0970, 0974, 0978, 0982
	.dc.w	0985, 0988, 0990, 0993, 0995
	.dc.w	0996, 0998, 0999, 0999, 1000
	.dc.w	1000



_ROM_CosTab:
	.dc.w	1000, 1000, 0999, 0999, 0998
	.dc.w	0996, 0995, 0993, 0990, 0988
	.dc.w	0985, 0982, 0978, 0974, 0970
	.dc.w	0966, 0961, 0956, 0951, 0946
	.dc.w	0940, 0934, 0927, 0921, 0914
	.dc.w	0906, 0899, 0891, 0883, 0875
	.dc.w	0866, 0857, 0848, 0839, 0829
	.dc.w	0819, 0809, 0799, 0788, 0777
	.dc.w	0766, 0755, 0743, 0731, 0719
	.dc.w	0707, 0695, 0682, 0669, 0656
	.dc.w	0643, 0629, 0616, 0602, 0588
	.dc.w	0574, 0559, 0545, 0503, 0515
	.dc.w	0500, 0485, 0470, 0454, 0438
	.dc.w	0423, 0407, 0391, 0375, 0358
	.dc.w	0342, 0326, 0309, 0292, 0276
	.dc.w	0259, 0242, 0225, 0208, 0191
	.dc.w	0174, 0156, 0139, 0122, 0105
	.dc.w	0087, 0070, 0052, 0035, 0018
	.dc.w	0000


_BrickScreenXTab:
	.dc.w	89, 100, 111, 122, 133, 144, 155, 166, 177, 188, 199, 210, 221
	.dc.w	86, 97, 108, 120, 131, 143, 154, 166, 177, 189, 200, 212, 224
	.dc.w	82, 94, 106, 118, 130, 142, 154, 166, 178, 190, 202, 214, 226
	.dc.w	78, 90, 104, 117, 129, 142, 154, 166, 179, 192, 204, 217, 230
	.dc.w	73, 87, 100, 113, 126, 140, 153, 167, 180, 193, 207, 220, 233
	.dc.w	68, 82, 97, 111, 125, 139, 153, 167, 181, 196, 210,	224, 238
	.dc.w	62, 77, 92, 107, 122, 137, 152, 168, 183, 198, 213,	228, 243
	.dc.w	56, 72, 88, 104, 120, 136, 152, 168, 184, 200, 216,	232, 248
	.dc.w	50, 67, 84, 101, 118, 135, 152, 169, 186, 203, 220,	237, 254
	.dc.w	43, 61, 79, 97, 115, 133, 151, 169, 187, 205, 223, 241, 259

_BrickScreenYTab:
	.dc.w	140, 142, 144, 146, 148, 151, 154, 157, 160, 163
	.dc.w	135, 136, 138, 139, 141, 143, 146, 148, 151, 153
	.dc.w	130, 131, 132, 133, 134, 135, 138, 139, 142, 143
;	.dc.w	133, 135, 136, 138, 139, 142, 144, 147, 149, 152 
;	.dc.w	126, 127, 128, 130, 131, 133, 134, 137, 138, 141 

_BrickWidthTab:
	.dc.w	14, 14, 15, 15, 17, 17, 19, 19, 20, 20

_BrickHeightTab:
	.dc.w	7, 7, 8, 8, 9, 9, 10, 10, 10, 10

_BrickIndexTab:
	.dc.w	0, 0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 2, 2
	.dc.w	0, 0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 2, 2

_BrickSizeTab:
	.dc.w	4, 4, 3, 3, 2, 2, 1, 1, 0, 0

_ROM_ExplodeOffsetTab:
	.dc.w	8, 8, 24, 24, 24, 48, 48
_ROM_ExplodeWidthTab:
	.dc.w	16, 16, 24, 24, 24, 32, 32

_ROM_BallOffsetTab:
	.dc.w	0, 8, 16, 28, 40, 52, 64
_ROM_BallWidthTab:
	.dc.w	6, 7, 8, 9, 10, 11, 12

_ROM_RippleOffsetTab:
	.dc.w	0, 8, 20, 7, 19, 35, 36, 52
_ROM_RippleWidthTab:
	.dc.w	8, 12, 16, 8, 12, 16, 16, 32

_ROM_BallZTab:
	.dc.w	3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100
	.dc.w	3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100
	.dc.w	3100, 3291, 3439, 3582, 3836, 3942, 4032, 4104, 4157, 4189, 4200

_ROM_DropWidthTab:
	.dc.w	12, 13, 14, 15, 16

_ROM_DropOffsetTab:
	.dc.w	0, 12, 25, 39, 54

_ROM_HighScoreTab:
	.dc.b	0, 0, $00,$00,$27,$10, 'MARIO PERDUE    '
	.dc.b	1, 0, $00,$00,$23,$28, 'RICHARD DEGLER  '
	.dc.b	2, 0, $00,$00,$1F,$40, 'MIKE PERDUE     '
	.dc.b	3, 0, $00,$00,$1B,$58, 'T GARY DEGLER   '
	.dc.b	4, 0, $00,$00,$17,$70, 'PAM PERDUE      '
	.dc.b	5, 0, $00,$00,$13,$88, 'DOUG PERDUE     '

_ROM_Congrats:
	.dc.b	'   CONGRATULATIONS    '
	.dc.b	'YOU HAVE COMPLETED ALL'
	.dc.b	'    FIFTY LEVELS      '
	.dc.b	'GET READY TO TRY IT ON'
	.dc.b	'A HARDER SKILL SETTING'

_ROM_PaddleWidthTab:
	.dc.w	32, 40, 48, 56, 64

_ROM_PaddleOffsetTab:
	.dc.w	0, 16, 36, 60, 88

_ROM_DroidPath:
;		  Sht  Dir	   X	  Y		 Z	  Steps
	.dc.w	1,   0, -4000,     0,  5500,     50
	.dc.w	0,   0, -4000,  -960,  8000,     50
	.dc.w	0,   6,  4000,   960,  8000,     60
	.dc.w   0,  12,  4000,     0,  5000,     20
	.dc.w   0,  18,     0,     0,  5000,     50
	.dc.w	1,   0,     0,     0,  6500,     20
	.dc.w   0,  12,     0,     0,     0,     70
	.dc.w   0,   0,     0,     0,     0,      0
	.dc.w   0,   0,     0,     0,     0,      0
	.dc.w   0,   0,     0,     0,     0,      0
	.dc.w   0,   0,     0,     0,     0,      0
	.dc.w   0,   0,     0,     0,     0,      0


	.dc.w	1,   0,     0,  -960,  6500,     70
	.dc.w	0,  18, -3000,     0,  6500,     21
	.dc.w	1,   0, -3000,     0,  7000,     15
	.dc.w   0,  12, -3000,     0,  5500,     15
	.dc.w   0,   6,  3000,   960,  5500,     42
	.dc.w	1,   0,  3000,   960,  7000,     20
	.dc.w   0,  16, -3000,     0,  5500,     46
	.dc.w   0,  12,     0,     0,     0,     70
	.dc.w   0,   0,     0,     0,     0,      0
	.dc.w   0,   0,     0,     0,     0,      0
	.dc.w   0,   0,     0,     0,     0,      0
	.dc.w   0,   0,     0,     0,     0,      0


	.dc.w	1,   0,  4000,   960,  7000,	 65
	.dc.w   0,  14,  3000,   720,  5500,     20
	.dc.w	1,  23,  2000,   480,  7000,     20
	.dc.w   0,  14,  1000,   240,  5500,     20
	.dc.w	1,  23,     0,     0,  7000,     20
	.dc.w	0,  14, -1000,  -240,  5500,     20
	.dc.w   1,  23, -2000,  -480,  7000,     20
	.dc.w	0,  14, -3000,  -720,  5500,     20
	.dc.w	1,  23, -4000,  -960,  7000,     20
	.dc.w	0,  12,		0,	   0,	  0,	 70
	.dc.w   0,   0,     0,     0,     0,      0
	.dc.w   0,   0,     0,     0,     0,      0


	.dc.w	1,   0,  4000,     0,  6000,     65
	.dc.w	0,   0,  4000,     0,  8000,     30
	.dc.w	0,	14, -4000,     0,  5000,     45
	.dc.w	1,   0, -4000,     0,  6000,     15
	.dc.w	0,   0, -4000,     0,  8000,     30
	.dc.w	0,   8,  4000,     0,  5000,     45
	.dc.w   0,  12,	    0,     0,     0,     60
	.dc.w   0,   0,     0,     0,     0,      0
	.dc.w   0,   0,     0,     0,     0,      0
	.dc.w   0,   0,     0,     0,     0,      0
	.dc.w   0,   0,     0,     0,     0,      0
	.dc.w   0,   0,     0,     0,     0,      0


	.dc.w	1,   0, -4000,  -960,  5500,     65
	.dc.w	0,   6,  4000,   960,  5500,     45
	.dc.w	1,   0,  4000,   960,  6000,     20
	.dc.w	0,  18, -4000,     0,  6000,     45
	.dc.w	1,   0, -4000,     0,  6500,     20
	.dc.w   0,   6,  4000,     0,  6500,     45
	.dc.w	1,   0,  4000,     0,  7000,     20
	.dc.w	0,  12,     0,     0,     0,     75
	.dc.w   0,   0,     0,     0,     0,      0
	.dc.w   0,   0,     0,     0,     0,      0
	.dc.w   0,   0,     0,     0,     0,      0
	.dc.w   0,   0,     0,     0,     0,      0

	.bss	

_SinTab:
	.ds.w	91

_CosTab:
	.ds.w	91

_ExplodeOffsetTab:
	.ds.w	7
_ExplodeWidthTab:
	.ds.w	7

_BallOffsetTab:
	.ds.w	7
_BallWidthTab:
	.ds.w	7

_RippleOffsetTab:
	.ds.w	8
_RippleWidthTab:
	.ds.w	8

_BallZTab:
	.ds.w	35

_DropWidthTab:
	.ds.w	5

_DropOffsetTab:
	.ds.w	5

_PaddleWidthTab:
	.ds.w	5

_PaddleOffsetTab:
	.ds.w	5


;	.phrase
;_Blit::
;	.ds.l	10000