/*******************************************************************
 *
 *    TITLE:        option.h
 *
 *    DESCRIPTION:	Header file for option.c
 *
 *    AUTHOR:		Mario Perdue & Richard Degler
 *
 *    HISTORY:    
 *
 *
 *           COPYRIGHT 1994, 1995 MP Graphics Systems         
 *      UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
 *      PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
 *     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
 *                        ALL RIGHTS RESERVED.               
 *******************************************************************/

#ifndef __OPTION__H
#define __OPTION__H

#include "support.h"

#define OPT_MAX_VOLUME			128
#define OPT_TEXT_OFFSET_X		24
#define	OPT_TEXT_OFFSET_Y		0


/* Object sizes */
#define OPT_TEXT_WIDTH			64
#define OPT_TEXT_HEIGHT			15

#define OPT_BUTTON_WIDTH		16
#define OPT_BUTTON_HEIGHT		16

#define OPT_START_WIDTH			96
#define OPT_START_HEIGHT		32
#define OPT_START_BUTTON_WIDTH 	32
#define OPT_START_BUTTON_HEIGHT	16

#define OPT_PLAYER_WIDTH		224
#define OPT_PLAYER_HEIGHT		80

#define OPT_SOUND_WIDTH			224
#define OPT_SOUND_HEIGHT		56

#define OPT_SLIDE_WIDTH			56
#define OPT_SLIDE_HEIGHT		2

#define OPT_GAME_WIDTH			112
#define OPT_GAME_HEIGHT			32

#define OPT_METER_WIDTH			160
#define OPT_METER_HEIGHT		16

#define OPT_LABEL_WIDTH			40
#define OPT_LABEL_HEIGHT		16

#define OPT_USAGE_WIDTH			256
#define OPT_USAGE_HEIGHT		14


/* Object locations */
#define OPT_BASE_X				159
#define OPT_BASE_Y				24

#define OPT_GAME_X				(OPT_BASE_X-106)
#define OPT_GAME_Y				OPT_BASE_Y
#define OPT_GAME_BUTTON_X		(OPT_GAME_X+8)
#define OPT_GAME_BUTTON_Y		(OPT_GAME_Y+8)

#define	OPT_START_X				(OPT_GAME_X+116)
#define	OPT_START_Y				OPT_GAME_Y
#define OPT_START_BUTTON_X		(OPT_START_X+56)
#define OPT_START_BUTTON_Y		(OPT_START_Y+7)

#define OPT_PLAYER_X			(OPT_BASE_X-112)
#define OPT_PLAYER_Y			(OPT_BASE_Y+36)
#define OPT_SKILL_RED_X			(OPT_PLAYER_X+16)
#define OPT_SKILL_RED_Y			(OPT_PLAYER_Y+10)
#define OPT_PADDLE_RED_X		(OPT_PLAYER_X+16)
#define OPT_PADDLE_RED_Y		(OPT_PLAYER_Y+42)
#define OPT_SKILL_GREEN_X		(OPT_PLAYER_X+122)
#define OPT_SKILL_GREEN_Y		(OPT_PLAYER_Y+10)
#define OPT_PADDLE_GREEN_X		(OPT_PLAYER_X+122)
#define OPT_PADDLE_GREEN_Y		(OPT_PLAYER_Y+42)
#define OPT_CATCH_X				OPT_SKILL_GREEN_X
#define OPT_CATCH_Y				OPT_SKILL_GREEN_Y
#define OPT_BREAKTHRU_X			OPT_PADDLE_GREEN_X
#define OPT_BREAKTHRU_Y			OPT_PADDLE_GREEN_Y


#define	OPT_SLIDE_OFFSET_X		35
#define	OPT_SLIDE_OFFSET_Y		8

#define OPT_SOUND_X				(OPT_BASE_X-112)
#define OPT_SOUND_Y				(OPT_BASE_Y+120)
#define OPT_MUSIC_SLIDE_X		(OPT_SOUND_X+72)
#define OPT_MUSIC_SLIDE_Y		(OPT_SOUND_Y+12)

#define OPT_EFFECTS_SLIDE_X		(OPT_SOUND_X+72)
#define OPT_EFFECTS_SLIDE_Y		(OPT_SOUND_Y+34)

#define OPT_USAGE_X				(OPT_BASE_X-127)
#define OPT_USAGE_Y				(OPT_BASE_Y+180)


/* Object Blitter Flags */
#define OPT_PLAYER_FLAGS		PITCH1 | PIXEL16 | WID224 | XADDPIX
#define OPT_SOUND_FLAGS			PITCH1 | PIXEL16 | WID224 | XADDPIX
#define OPT_GAME_FLAGS			PITCH1 | PIXEL16 | WID112 | XADDPIX
#define OPT_START_FLAGS			PITCH1 | PIXEL16 | WID96 | XADDPIX
#define OPT_START_BUTTON_FLAGS	PITCH1 | PIXEL16 | WID32 | XADDPIX

#define OPT_USAGE_FLAGS			PITCH1 | PIXEL16 | WID256 | XADDPIX
#define OPT_LABEL_FLAGS			PITCH1 | PIXEL16 | WID40 | XADDPIX
#define OPT_METER_FLAGS			PITCH1 | PIXEL16 | WID160 | XADDPIX
#define OPT_TEXT_FLAGS			PITCH1 | PIXEL16 | WID64 | XADDPIX
#define OPT_BUTTON_FLAGS		PITCH1 | PIXEL16 | WID16 | XADDPIX
#define OPT_SLIDE_FLAGS			PITCH1 | PIXEL16 | WID56 | XADDPIX

#define MAX_HIGH_SCORES			6

#define SCORE_LENGTH			7
#define ENTRY_WORDS				((MAX_NAME_LENGTH+4) / 2)

#define FLAG_WORD				60
#define VOLUME_WORD				61
#define MAGIC_WORD	  			62
#define CHECKSUM_WORD			63

#define MAGIC_NUMBER			1130


typedef struct
	{
	char NumPlayers;
	char Skill[2];
	char PaddleResponse[2];
	char ScreenWrapOn;
	short GameMode;
	char Catch;
	char Breakthru;
	char MusicOn;
	int  MusicVolume;
	int  EffectsVolume;

	}DEF_OPTION;

typedef struct
	{
	UINT	Difficulty : 2;
	UINT	Level	   : 6;
	UINT	Score	   : 24;
	char	Name[MAX_NAME_LENGTH];
	} DEF_SCORE;

typedef struct
	{
	DEF_SCORE	Entry[MAX_HIGH_SCORES];

	UINT	NumPlayers	 : 2;
	UINT	Skill1		 : 2;
	UINT	Skill2		 : 3;
	UINT	PaddleSpeed1 : 2;
	UINT	PaddleSpeed2 : 2;
	UINT	GameMode	 : 2;
	UINT	Catch  	 	 : 1;
	UINT	Breakthru	 : 1;
	UINT	MusicOn		 : 1;
	BYTE	MusicVolume;
	BYTE	EffectVolume;
	WORD	Magic;
	WORD	Checksum;
	}DEF_EEPROM;									  

enum { itemGAMEMODE, itemSTART, itemSKILL_RED, itemPADDLE_RED, itemSKILL_GREEN,
	   itemPADDLE_GREEN, itemMUSIC_VOL, itemEFFECTS_VOL};

enum { textNOVICE, textNORMAL, textEXPERT, textCOMPUTER, textNONE,
	   textSLOW, textMEDIUM, textFAST, textOFF, textON };

enum { skillNOVICE, skillNORMAL, skillEXPERT, skillCOMPUTER, skillNONE };

enum { paddleSLOW, paddleMEDIUM, paddleFAST }; 

enum { gameCLASSIC, game2000 };

enum { btnRED=0, btnGREEN=2, btnBLUE=4, btnDISABLED=6 };

enum { labelSKILL, labelSPEED, labelMUSIC, labelEFFECTS };


void ReadOptions( void );
void ResetOptions( int write );
void WriteOptions( void );

void DoOptions( void );

int	GetSelectedItem( int CurrentItem );

void DisplaySkillOption(short state, short skillwho);
void DisplayPaddleOption(short state, short paddlewho);
void DisplayMasterVolOption(short state, int volume);
void DisplayMusicVolOption(short state, int volume);

void DisplayOptionScreen( void );
void RefreshPlayerOptions( int DrawBkg );
void DisplayPlayerOptions( void );
void DisplaySoundOptions( void );
void DisplayUsage( void );

void DisplayOptionText( int which, int x, int y );
void DisplayButton( int x, int y, int color, int state );
void DisplayStartOption();
void DisplayStartButton( int state );
void DisplayMeterLevel( int state, int x, int y, int level );
void DisplayGameOption();
void DisplayLabel( int label, int x, int y );
void DisplayBreakthruOption( int state );
void DisplayCatchOption( int state );


void HandleGameOption();
void HandleSkillOption( short skillwho );
void HandlePaddleOption( short paddlewho );
void HandleCatchOption( void );
void HandleBreakthruOption( void );
void HandleMusicVolOption( void );
void HandleEffectsVolOption( void );

WORD eeWriteWord( WORD data, WORD address );
WORD eeWriteBank( DEF_EEPROM * );
WORD eeReadWord( WORD address );
WORD eeReadBank( DEF_EEPROM * );
WORD eeUpdateChecksum( void );
WORD eeValidateChecksum( void );

#endif