/*******************************************************************
 *
 *    TITLE:        paddle.c  
 *
 *    DESCRIPTION:	Routines to support the paddle
 *
 *    AUTHOR:		Mario Perdue & Richard Degler
 *
 *    HISTORY:    
 *
 *
 *           COPYRIGHT 1994, 1995 MP Graphics Systems         
 *      UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
 *      PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
 *     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
 *                        ALL RIGHTS RESERVED.               
 *******************************************************************/

/** include files **/
#include "d:\jaguar\include\jaguar.h"
#include "paddle.h"
#include "jagobj.h"
#include "ball.h"
#include "brick.h"
#include "support.h"
#include "player.h"
#include "option.h"
#include "b2k_game.h"
#include "displays.h"

/** external data **/
extern	long	  		Score;

extern unsigned	short  	flagJlist;

extern	DEF_OBJECTLIST		ObjectList[2];

extern int		  		ScreenOrgX;
extern int		  		ScreenOrgY;

extern DEF_PLAYER		Player[MAX_PLAYERS];

extern DEF_ROM_PADDLE	ROM_Paddle;
extern DEF_RAM_PADDLE	IMG_Paddle[MAX_PLAYERS];
extern WORD				IMG_PaddleBuffer[];
extern WORD				IMG_PaddleFace[MAX_PLAYERS][768];
extern WORD				IMG_PaddleFrame[MAX_PLAYERS][1280];

extern WORD				IMG_Playfield[];
extern WORD				IMG_PlayfieldBuffer[];
extern WORD				IMG_BrickBuffer[];
extern WORD				IMG_Background[];
extern DEF_OPTION		Option;

extern BYTE				PlayerOnTop;	

extern	DEF_BLIT_DATA	Blit[];
extern	LONG			BlitAddIndex;
extern	LONG			BlitUseIndex;

extern WORD				PaddleWidthTab[5];
extern WORD				PaddleOffsetTab[5];

/** internal functions **/
/*********************************************************************
 *  FUNCTION:		SetPaddleSize
 *
 *  PARAMETERS:		short who
 *					int size
 *
 *  DESCRIPTION:	Sets the players paddle to the specified size
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void SetPaddleSize(short who, int size)
	{
	int width;
	int offset;

	long a2_base;

	if(!Player[who].Paddle.Cracks)
		{
		if(size	> PADDLE_MAX_SIZE)
			size = PADDLE_MAX_SIZE;
		
		if(size	< 0)
			size = 0;

		Player[who].Paddle.Size	= size;

		width = PaddleWidthTab[size];
		offset = PaddleOffsetTab[size];

		if(who==PLAYER_RED)
			a2_base	= (long)ROM_Paddle.RedFace;
		else
			a2_base	= (long)ROM_Paddle.GreenFace;

		/* Blit the paddle face */
		Blit[BlitAddIndex].Type		= blitBITMAP;

		Blit[BlitAddIndex].A1_Base	= (long)IMG_Paddle[who].Face;
		Blit[BlitAddIndex].A1_Flags	= PITCH1 | PIXEL16 | WID64 | XADDPHR;
		Blit[BlitAddIndex].A1_Pixel	= 0x0L;
		Blit[BlitAddIndex].A1_Step	= (1<<16L) | ((-width/2)&0xFFFFL);
											 
		Blit[BlitAddIndex].A2_Base	= a2_base;
		Blit[BlitAddIndex].A2_Flags	= PITCH1 | PIXEL16 | WID128 | XADDPHR;
		Blit[BlitAddIndex].A2_Pixel	= offset&0xFFFFL;
		Blit[BlitAddIndex].A2_Step	= Blit[BlitAddIndex].A1_Step;

		Blit[BlitAddIndex].B_Count	= (24<<16L) | ((width/2)&0xFFFFL);
											 
		Blit[BlitAddIndex].B_Patd	= 0x0L;
		Blit[BlitAddIndex].B_Cmd	= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;
		
		QueBlit();

		/* Blit the paddle shatter */
		Blit[BlitAddIndex].Type		= blitBITMAP;

		Blit[BlitAddIndex].A1_Base	= (long)IMG_Paddle[who].Shatter;
		Blit[BlitAddIndex].A1_Flags	= PITCH1 | PIXEL16 | WID64 | XADDPHR;
		Blit[BlitAddIndex].A1_Pixel	= 0x0L;
		Blit[BlitAddIndex].A1_Step	= (1<<16L) | ((-width/2)&0xFFFFL);
											 
		Blit[BlitAddIndex].A2_Base	= (long)ROM_Paddle.Shatter;
		Blit[BlitAddIndex].A2_Flags	= PITCH1 | PIXEL16 | WID128 | XADDPHR;
		Blit[BlitAddIndex].A2_Pixel	= offset&0xFFFFL;
		Blit[BlitAddIndex].A2_Step	= Blit[BlitAddIndex].A1_Step;

		Blit[BlitAddIndex].B_Count	= (96<<16L) | ((width/2)&0xFFFFL);
											 
		Blit[BlitAddIndex].B_Patd	= 0x0L;
		Blit[BlitAddIndex].B_Cmd	= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;
		
		QueBlit();


		/* Blit the paddle strobe and ball launch sequence */
		if(who==PLAYER_RED)
			a2_base	= (long)ROM_Paddle.RedStrobe;
		else
			a2_base	= (long)ROM_Paddle.GreenStrobe;

		Blit[BlitAddIndex].Type		= blitBITMAP;

		Blit[BlitAddIndex].A1_Base	= (long)IMG_Paddle[who].Strobe;
		Blit[BlitAddIndex].A1_Flags	= PITCH1 | PIXEL16 | WID64 | XADDPHR;
		Blit[BlitAddIndex].A1_Pixel	= 0x0L;
		Blit[BlitAddIndex].A1_Step	= (1<<16L) | ((-width/2)&0xFFFFL);
											 
		Blit[BlitAddIndex].A2_Base	= a2_base;
		Blit[BlitAddIndex].A2_Flags	= PITCH1 | PIXEL16 | WID128 | XADDPHR;
		Blit[BlitAddIndex].A2_Pixel	= offset&0xFFFFL;
		Blit[BlitAddIndex].A2_Step	= Blit[BlitAddIndex].A1_Step;

		Blit[BlitAddIndex].B_Count	= (112<<16L) | ((width/2)&0xFFFFL);
											 
		Blit[BlitAddIndex].B_Patd	= 0x0L;
		Blit[BlitAddIndex].B_Cmd	= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;
		
		QueBlit();


		/* Blit the Paddle Frame */
		Blit[BlitAddIndex].Type		= blitBITMAP;

		Blit[BlitAddIndex].A1_Base	= (long)IMG_Paddle[who].Frame;
		Blit[BlitAddIndex].A1_Flags	= PITCH1 | PIXEL16 | WID64 | XADDPHR;
		Blit[BlitAddIndex].A1_Pixel	= 0x0L;
		Blit[BlitAddIndex].A1_Step	= (1<<16L) | ((-width/2)&0xFFFFL);
								
		if(Option.GameMode == gameCLASSIC)
			Blit[BlitAddIndex].A2_Base	= (long)ROM_Paddle.ClassicFrame;
		else
			Blit[BlitAddIndex].A2_Base	= (long)ROM_Paddle.Frame;
		Blit[BlitAddIndex].A2_Flags	= PITCH1 | PIXEL16 | WID128 | XADDPHR;
		Blit[BlitAddIndex].A2_Pixel	= offset&0xFFFFL;
		Blit[BlitAddIndex].A2_Step	= Blit[BlitAddIndex].A1_Step;

		Blit[BlitAddIndex].B_Count	= (20<<16L) | ((width/2)&0xFFFFL);
											 
		Blit[BlitAddIndex].B_Patd	= 0x0L;
		Blit[BlitAddIndex].B_Cmd	= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;
		
		QueBlit();


		/* Blit the Paddle Frame and Bomb launch graphics */
		Blit[BlitAddIndex].Type		= blitBITMAP;

		Blit[BlitAddIndex].A1_Base	= (long)IMG_Paddle[who].Gun;
		Blit[BlitAddIndex].A1_Flags	= PITCH1 | PIXEL16 | WID64 | XADDPHR;
		Blit[BlitAddIndex].A1_Pixel	= 0x0L;
		Blit[BlitAddIndex].A1_Step	= (1<<16L) | ((-width/2)&0xFFFFL);
											 
		Blit[BlitAddIndex].A2_Base	= (long)ROM_Paddle.Gun;
		Blit[BlitAddIndex].A2_Flags	= PITCH1 | PIXEL16 | WID128 | XADDPHR;
		Blit[BlitAddIndex].A2_Pixel	= offset&0xFFFFL;
		Blit[BlitAddIndex].A2_Step	= Blit[BlitAddIndex].A1_Step;

		Blit[BlitAddIndex].B_Count	= (144<<16L) | ((width/2)&0xFFFFL);
											 
		Blit[BlitAddIndex].B_Patd	= 0x0L;
		Blit[BlitAddIndex].B_Cmd	= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;
		
		QueBlit();


		/* Mirror the whole shooting match */
		Blit[BlitAddIndex].Type		= blitBITMAP;

		Blit[BlitAddIndex].A1_Base	= (long)IMG_Paddle[who].Face;
		Blit[BlitAddIndex].A1_Flags	= PITCH1 | PIXEL16 | WID64 | XADDPIX | XSIGNSUB;
		Blit[BlitAddIndex].A1_Pixel	= (width-1) & 0xFFFFL;
		Blit[BlitAddIndex].A1_Step	= (1<<16L) | ((width/2)&0xFFFFL);
											 
		Blit[BlitAddIndex].A2_Base	= (long)IMG_Paddle[who].Face;

		Blit[BlitAddIndex].A2_Flags	= PITCH1 | PIXEL16 | WID64 | XADDPIX;
		Blit[BlitAddIndex].A2_Pixel	= 0x0L;
		Blit[BlitAddIndex].A2_Step	= (1<<16L) | ((-width/2)&0xFFFFL);

		Blit[BlitAddIndex].B_Count	= (408<<16L) | ((width/2)&0xFFFFL);
											 
		Blit[BlitAddIndex].B_Patd	= 0x0L;
		Blit[BlitAddIndex].B_Cmd	= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;
		
		QueBlit();
		}

	DrawPaddleFace(who);
	DrawPaddleFrame(who);
	DrawPaddleStrobe(who);
	DrawPaddleGun(who);
	DrawPaddlePower(who);
	}
	
/*********************************************************************
 *  FUNCTION:		MovePaddle
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	Moves the players paddle to a new location
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void MovePaddle(short who)
	{
	SCREENLOC Loc;
	int	width;
	int DeltaX;

	int TrackX, TrackZ;
	int b, p;
	int Psector;

	if(Option.GameMode == gameCLASSIC)
		Player[who].Paddle.Z = PADDLE_Z+512;
	else
		Player[who].Paddle.Z = PADDLE_Z;

	/* Handle paddle Y (hover) motion */
	DoPaddleHover(who);
	
	DoPaddleGun(who);

	if(Player[who].AutoPilot == ON)
		{
		int maxspeed;
		int Comp;

		Comp = Player[who].Score-Player[who^1].Score;

		if(Comp > 500)
			maxspeed = Player[who].Paddle.MaxSpeedX/2;
		else if(Comp <-500)
			maxspeed = Player[who].Paddle.MaxSpeedX*2;
		else
			maxspeed = Player[who].Paddle.MaxSpeedX;
		

		TrackX = Player[who].Paddle.X;
		TrackZ = 0;

		if(Player[who].Goody.Active)
			TrackX = Player[who].Goody.X;

		for(p=0; p<Option.NumPlayers; p++)
			{
			for(b=0; b<MAX_BALLS; b++)
			  	{
				if(!Player[p].Ball[b].Active)
					continue;

				if(Player[p].Ball[b].Z < 6000)
					continue;
				
				if(who == PLAYER_ON_TOP)
					Psector = sectorTOP;
				else
					Psector = sectorBOTTOM;

				if(Psector != Player[p].Ball[b].Sector)
					continue;

				if(Player[p].Ball[b].Z > TrackZ)
					{
					TrackX = Player[p].Ball[b].X;
					TrackZ = Player[p].Ball[b].Z;
					}
			  	}
		  	}


		DeltaX = TrackX-Player[who].Paddle.X;
		if(DeltaX > 64)
 			Player[who].Paddle.SpeedX =  MIN(DeltaX,maxspeed);

		else if(DeltaX < -64)
 			Player[who].Paddle.SpeedX =  MAX(DeltaX,-maxspeed);

		else
			Player[who].Paddle.SpeedX /= 8;
		}
	else
		{
		if(Player[who].Joypad & JOYPAD_RIGHT)
			Player[who].Paddle.SpeedX =  Player[who].Paddle.MaxSpeedX;

		else if(Player[who].Joypad & JOYPAD_LEFT)
			Player[who].Paddle.SpeedX = -Player[who].Paddle.MaxSpeedX;
		else
			Player[who].Paddle.SpeedX /= 4;

		if(Player[who].Keypad & (KEYPAD_4 | KEYPAD_6))
			Player[who].Paddle.SpeedX *= 2;
		}

	Player[who].Paddle.X += Player[who].Paddle.SpeedX;

	/* Calculate the width of the Paddle. This value is used to determine 
	   if a paddle collision has occured, and what english should be applied */
	width =	Player[who].Paddle.Size*PADDLE_STEP_W+PADDLE_MIN_W;

	/* Position the paddle between its limits */
	if(Option.GameMode == gameCLASSIC)
		{
		if(Player[who].Paddle.X > PLAYFIELD_RIGHT-PADDLE_MARGIN)
			{
			Player[who].Paddle.X = PLAYFIELD_RIGHT-PADDLE_MARGIN;
			Player[who].Paddle.SpeedX = 0;
			}
		}
	else
		{
		if(Player[who].Paddle.X > PLAYFIELD_RIGHT-PADDLE_MARGIN-width/2)
			{
			Player[who].Paddle.X = PLAYFIELD_RIGHT-PADDLE_MARGIN-width/2;
			Player[who].Paddle.SpeedX = 0;
			}
		}
	
	if(Player[who].Paddle.X < PLAYFIELD_LEFT+PADDLE_MARGIN+width/2)
		{
		Player[who].Paddle.X = PLAYFIELD_LEFT+PADDLE_MARGIN+width/2;
		Player[who].Paddle.SpeedX = 0;
		}

	/* Animate face when shattered */
	if(Player[who].Paddle.Cracks >= MAX_CRACKS)
		{
		if(Player[who].Paddle.Step < 7)
			{
			Player[who].Paddle.Step += 1;
			DrawPaddleFace(who);
			}
		}

	/* Strobe the paddle */
	if (++Player[who].Paddle.IndexCnt > 1)
		{
		Player[who].Paddle.IndexCnt = 0;

		if(Player[who].Paddle.Attract > 0)
			{
			if(Player[who].Paddle.Index == 0)
				Player[who].Paddle.Index = 8;
			Player[who].Paddle.Index--;
			}
		else if (Player[who].Paddle.Attract < 0)
			{
			if(++Player[who].Paddle.Index > 7)
				Player[who].Paddle.Index = 0;
			}
		else
			{
			Player[who].Paddle.Index = 0;
			}
		DrawPaddleStrobe(who);
		}

	Player[who].Paddle.OldX = Player[who].Paddle.ScreenX;
	Player[who].Paddle.OldY = Player[who].Paddle.ScreenY;

	/* Calculate the 2D Screen Position for the 3D Paddle Position */	
	Loc = PlayfieldToScreen(Player[who].Paddle.X, Player[who].Paddle.Y, 
							Player[who].Paddle.Z);
	Player[who].Paddle.ScreenX = Loc.X-PaddleWidthTab[Player[who].Paddle.Size]/2;
	Player[who].Paddle.ScreenY = Loc.Y;
	}
	


/*********************************************************************
 *  FUNCTION: 	   SetPaddleHover
 *
 *  PARAMETERS:	   short who
 *                 int speed
 *
 *  DESCRIPTION:   Starts paddle hover effect
 *
 *  RETURNS:	   void
 *
 *********************************************************************/
void SetPaddleHover(short who, int speed)
	{
	if(who == PLAYER_ON_TOP)
		{
		Player[who].Paddle.IncSpeedY = -speed;
		Player[who].Paddle.MaxY = -PADDLE_MAX_Y;
		Player[who].Paddle.MinY = -PADDLE_MIN_Y;
		}
	else
		{
		Player[who].Paddle.IncSpeedY = speed;
		Player[who].Paddle.MaxY = PADDLE_MAX_Y;
		Player[who].Paddle.MinY = PADDLE_MIN_Y;
		}
	}




/*********************************************************************
 *  FUNCTION: 	   DoPaddleHover
 *
 *  PARAMETERS:	   short who
 *
 *  DESCRIPTION:   Bobs paddle up and down for hover effect
 *
 *  RETURNS:	   void
 *
 *********************************************************************/
void DoPaddleHover(short who)
	{
	WORD Delta;
	Player[who].Paddle.Y += Player[who].Paddle.IncSpeedY;
	
	if(who == PLAYER_ON_TOP)
		{
		if(Player[who].Paddle.Y <= Player[who].Paddle.MaxY)
			{
			Delta = abs(-Player[who].Paddle.MaxY - PADDLE_MID_Y);
			if(Delta >= 64)
				Player[who].Paddle.MaxY += 16;
			else
				Player[who].Paddle.MaxY = -PADDLE_MID_Y;

			Player[who].Paddle.Y = Player[who].Paddle.MaxY;
			Player[who].Paddle.IncSpeedY = Delta/8;
			}
		else if (Player[who].Paddle.Y >= Player[who].Paddle.MinY)
			{
			Delta = abs(-Player[who].Paddle.MinY - PADDLE_MID_Y);
			if(Delta >= 64)
				Player[who].Paddle.MinY -= 16;
			else
				Player[who].Paddle.MinY = -PADDLE_MID_Y;

			Player[who].Paddle.Y = Player[who].Paddle.MinY;
			Player[who].Paddle.IncSpeedY = -(Delta/8);
			}
		}
	else
		{
		if(Player[who].Paddle.Y > Player[who].Paddle.MaxY)
			{
			Delta = abs(Player[who].Paddle.MaxY - PADDLE_MID_Y);
			if(Delta >= 64)
				Player[who].Paddle.MaxY -= 16;
			else
				Player[who].Paddle.MaxY = PADDLE_MID_Y;

			Player[who].Paddle.Y = Player[who].Paddle.MaxY;

			Delta = abs(Player[who].Paddle.MaxY - PADDLE_MID_Y);
			Player[who].Paddle.IncSpeedY = -(Delta/8);
			}
		else if (Player[who].Paddle.Y < Player[who].Paddle.MinY)
			{
			Delta = abs(Player[who].Paddle.MinY - PADDLE_MID_Y);
			if(Delta >= 64)
				Player[who].Paddle.MinY += 16;
			else
				Player[who].Paddle.MinY = PADDLE_MID_Y;

			Player[who].Paddle.Y = Player[who].Paddle.MinY;
			Delta = abs(Player[who].Paddle.MinY - PADDLE_MID_Y);
			Player[who].Paddle.IncSpeedY = Delta/8;
			}
		}
  	}


/*********************************************************************
 *  FUNCTION: 	   DoPaddleGun
 *
 *  PARAMETERS:	   short who
 *
 *  DESCRIPTION:   Handle Paddle gun effects
 *
 *  RETURNS:	   void
 *
 *********************************************************************/
void DoPaddleGun(short who)
	{
	if(!Player[who].Paddle.Gun)
		return;

	if(Player[who].Button & BUTTON_A)
		{
		if(Player[who].Paddle.GunPower < 15)
			{
			Player[who].Paddle.GunPower++;
			DrawPaddlePower(who);
			}
		}
	else
		{
		if(Player[who].Paddle.GunPower > 0)
			{
			if(Player[who].Bomb.Active)
				Player[who].Paddle.GunPower/=2;
			else
				LaunchBomb(who);
			DrawPaddlePower(who);
			}
		}
	}


/*********************************************************************
 *  FUNCTION:		DrawPaddleFace
 *
 *  PARAMETERS:		short who
 *
 *  DESCRIPTION:	Draw paddle face in paddle face buffer
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void DrawPaddleFace(short who)
	{
	long a1_base;
	long a2_base;
	int width;
	int catch;

	if(!Player[who].Paddle.Active)
		return;

	if(Option.GameMode == gameCLASSIC)
		width = 0;
	else
		width = PaddleWidthTab[Player[who].Paddle.Size];

	if(who == PLAYER_ON_TOP)
		a1_base = (long)IMG_PaddleFace[0];
	else
		a1_base = (long)IMG_PaddleFace[1];

	catch = Player[who].Paddle.Catch;

	/* First Erase the old face */
	if(width < PADDLE_FACE_WIDTH)
		{
		Blit[BlitAddIndex].Type 		= blitPATTERN;

		Blit[BlitAddIndex].A1_Base  	= a1_base;
		Blit[BlitAddIndex].A1_Flags 	= PITCH1 | PIXEL16 | WID64 | XADDPHR;

		Blit[BlitAddIndex].A1_Pixel 	= width & 0x0FFFFL;

		Blit[BlitAddIndex].A1_Step 		= (1<<16L)|(-(PADDLE_FACE_WIDTH-width) & 0x0FFFFL);
		Blit[BlitAddIndex].B_Count 		= (PADDLE_FACE_HEIGHT<<16L) | 
												((PADDLE_FACE_WIDTH-width) & 0x0FFFFL);
		Blit[BlitAddIndex].B_Patd 		= 0x0L;
		Blit[BlitAddIndex].B_Cmd 		= PATDSEL | UPDA1;
	
		QueBlit();
		}

	if(Option.GameMode == gameCLASSIC)
		return;

	/* Then Blit the Paddle Face absolute */
	if(Player[who].Paddle.Cracks < MAX_CRACKS)
		a2_base	= (long)IMG_Paddle[who].Face[catch];
	else
		a2_base	= (long)IMG_Paddle[who].Shatter[Player[who].Paddle.Step];

	Blit[BlitAddIndex].Type		= blitBITMAP;

	Blit[BlitAddIndex].A1_Base  = a1_base;
	Blit[BlitAddIndex].A1_Flags = PITCH1 | PIXEL16 | WID64 | XADDPHR;

	Blit[BlitAddIndex].A1_Pixel	= 0x0L;
	Blit[BlitAddIndex].A1_Step	= (1<<16) | (-width & 0x0FFFFL);
										 
	Blit[BlitAddIndex].A2_Base	= a2_base;
	Blit[BlitAddIndex].A2_Flags	= PITCH1 | PIXEL16 | WID64 | XADDPHR;
	Blit[BlitAddIndex].A2_Pixel	= 0x0L;
	Blit[BlitAddIndex].A2_Step	= (1<<16) | (-width & 0x0FFFFL);

	Blit[BlitAddIndex].B_Count	= (PADDLE_FACE_HEIGHT<<16) | 
										  (width & 0xFFFFL);
										 
	Blit[BlitAddIndex].B_Patd	= 0x0L;
	Blit[BlitAddIndex].B_Srcz1	= 0x0L;

	Blit[BlitAddIndex].B_Cmd   	= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;
	
	QueBlit();
	}
	
/*********************************************************************
 *  FUNCTION:		DrawPaddleFrame
 *
 *  PARAMETERS:		short who
 *
 *  DESCRIPTION:	Draw paddle frame in paddle frame buffer
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void DrawPaddleFrame(short who)
	{
	int width;
	long base;
	int pixel;
	int step1, step2;

	if(!Player[who].Paddle.Active)
		return;

	width = PaddleWidthTab[Player[who].Paddle.Size];

	if(who == PLAYER_ON_TOP)
		{
		base = (long)IMG_PaddleFrame[0];
		pixel = (PADDLE_HEIGHT-1)<<16L;
		step1 = (-1<<16) | (-width & 0x0FFFFL);
		}
	else
		{
		base = (long)IMG_PaddleFrame[1];
		pixel = 0x0L;
		step1 = (1<<16) | (-width & 0xFFFFL);
		}

	step2 = (1<<16) | (-width & 0xFFFFL);
	
	/* First Erase the paddle buffer */
	Blit[BlitAddIndex].Type 		= blitPATTERN;

	Blit[BlitAddIndex].A1_Base  	= (long)IMG_PaddleBuffer;
	Blit[BlitAddIndex].A1_Flags 	= PITCH1 | PIXEL16 | WID64 | XADDPHR;

	Blit[BlitAddIndex].A1_Pixel 	= 0x0L;
	Blit[BlitAddIndex].A1_Step 		= (1<<16L) | (-PADDLE_WIDTH & 0x0FFFFL);

	Blit[BlitAddIndex].B_Count 		= (PADDLE_HEIGHT<<16L) | 
												(PADDLE_WIDTH & 0x0FFFFL);
	Blit[BlitAddIndex].B_Patd 		= 0x0L;
	Blit[BlitAddIndex].B_Cmd 		= PATDSEL | UPDA1;
	
	QueBlit();


	/* Blit the Paddle Frame into the paddle buffer correctly */
	Blit[BlitAddIndex].Type			= blitBITMAP;

	Blit[BlitAddIndex].A1_Base  	= (long)IMG_PaddleBuffer;
	Blit[BlitAddIndex].A1_Flags 	= PITCH1 | PIXEL16 | WID64 | XADDPHR;

	Blit[BlitAddIndex].A1_Pixel		= pixel;
	Blit[BlitAddIndex].A1_Step		= step1;
										 
	Blit[BlitAddIndex].A2_Base		= (long)IMG_Paddle[who].Frame;
	Blit[BlitAddIndex].A2_Flags		= PITCH1 | PIXEL16 | WID64 | XADDPHR;
	Blit[BlitAddIndex].A2_Pixel		= 0x0L;
	Blit[BlitAddIndex].A2_Step		= step2;

	Blit[BlitAddIndex].B_Count		= (PADDLE_HEIGHT<<16) | (width & 0xFFFFL);
											 
	Blit[BlitAddIndex].B_Patd		= 0x0L;
	Blit[BlitAddIndex].B_Srcz1		= 0x0L;

	Blit[BlitAddIndex].B_Cmd   		= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN | 
									  DSTEN | DCOMPEN;
		
	QueBlit();


	/* Then Blit the paddle buffer to the Paddle Frame absolute */
	Blit[BlitAddIndex].Type			= blitBITMAP;

	Blit[BlitAddIndex].A1_Base  	= base;
	Blit[BlitAddIndex].A1_Flags 	= PITCH1 | PIXEL16 | WID64 | XADDPHR;

	Blit[BlitAddIndex].A1_Pixel		= 0x0L;
	Blit[BlitAddIndex].A1_Step		= (1<<16L) | (-PADDLE_WIDTH & 0x0FFFFL);
										 
	Blit[BlitAddIndex].A2_Base		= (long)IMG_PaddleBuffer;
	Blit[BlitAddIndex].A2_Flags		= PITCH1 | PIXEL16 | WID64 | XADDPHR;
	Blit[BlitAddIndex].A2_Pixel		= 0x0L;
	Blit[BlitAddIndex].A2_Step		= (1<<16L) | (-PADDLE_WIDTH & 0x0FFFFL);

	Blit[BlitAddIndex].B_Count		= (PADDLE_HEIGHT<<16) | (PADDLE_WIDTH & 0xFFFFL);
											 
	Blit[BlitAddIndex].B_Patd		= 0x0L;
	Blit[BlitAddIndex].B_Srcz1		= 0x0L;

	Blit[BlitAddIndex].B_Cmd   		= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;
		
	QueBlit();
	}
	

/*********************************************************************
 *  FUNCTION:		DrawPaddleStrobe
 *
 *  PARAMETERS:		short who
 *
 *  DESCRIPTION:	Draw paddle strobe in paddle frame buffer
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void DrawPaddleStrobe(short who)
	{
	int width;
	long base;
	int pixel;
	int step1, step2;

	if(!Player[who].Paddle.Active)
		return;

	if(Option.GameMode == gameCLASSIC)
		return;

	width = PaddleWidthTab[Player[who].Paddle.Size];

	if(who == PLAYER_ON_TOP)
		{
		base = (long)IMG_PaddleFrame[0];
		pixel = (PADDLE_HEIGHT-PADDLE_STROBE_Y-1)<<16L;
		step1 = (-1<<16) | (-width & 0x0FFFFL);
		}
	else
		{
		base = (long)IMG_PaddleFrame[1];
		pixel = PADDLE_STROBE_Y<<16L;
		step1 = (1<<16) | (-width & 0xFFFFL);
		}

	step2 = (1<<16) | (-width & 0xFFFFL);
	
	/* Blit the Strobe image */
	Blit[BlitAddIndex].Type			= blitBITMAP;

	Blit[BlitAddIndex].A1_Base  	= base;
	Blit[BlitAddIndex].A1_Flags 	= PITCH1 | PIXEL16 | WID64 | XADDPHR;

	Blit[BlitAddIndex].A1_Pixel		= pixel;
	Blit[BlitAddIndex].A1_Step		= step1;
										 
	Blit[BlitAddIndex].A2_Base		= (long)IMG_Paddle[who].Strobe[Player[who].Paddle.Index];
	Blit[BlitAddIndex].A2_Flags		= PITCH1 | PIXEL16 | WID64 | XADDPHR;
	Blit[BlitAddIndex].A2_Pixel		= 0x0L;
	Blit[BlitAddIndex].A2_Step		= step2;

	Blit[BlitAddIndex].B_Count		= (PADDLE_STROBE_HEIGHT<<16) | 
											  (width & 0xFFFFL);
											 
	Blit[BlitAddIndex].B_Patd		= 0x0L;
	Blit[BlitAddIndex].B_Srcz1		= 0x0L;

	Blit[BlitAddIndex].B_Cmd   		= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN | 
										DSTEN | DCOMPEN;
		
	QueBlit();
	}
	

/*********************************************************************
 *  FUNCTION:		DrawPaddleGun
 *
 *  PARAMETERS:		short who
 *
 *  DESCRIPTION:	Draw paddle gun in paddle frame buffer
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void DrawPaddleGun(short who)
	{
	int width;
	long base;
	int pixel;
	int step1, step2;

	if(!Player[who].Paddle.Active)
		return;

	if(!Player[who].Paddle.Gun)
		return;

	if(Option.GameMode == gameCLASSIC)
		return;

	width = PaddleWidthTab[Player[who].Paddle.Size];

	if(who == PLAYER_ON_TOP)
		{
		base = (long)IMG_PaddleFrame[0];
		pixel = (PADDLE_HEIGHT-PADDLE_GUN_Y-1)<<16L;
		step1 = (-1<<16) | (-width & 0x0FFFFL);
		}
	else
		{
		base = (long)IMG_PaddleFrame[1];
		pixel = PADDLE_GUN_Y<<16L;
		step1 = (1<<16) | (-width & 0xFFFFL);
		}

	step2 = (1<<16) | (-width & 0xFFFFL);
	
	/* Blit the gun */
	Blit[BlitAddIndex].Type		= blitBITMAP;

	Blit[BlitAddIndex].A1_Base	= base;
	Blit[BlitAddIndex].A1_Flags	= PITCH1 | PIXEL16 | WID64 | XADDPHR;

	Blit[BlitAddIndex].A1_Pixel	= pixel;
	Blit[BlitAddIndex].A1_Step	= step1;
										 
	Blit[BlitAddIndex].A2_Base	= (long)IMG_Paddle[who].Gun;
	Blit[BlitAddIndex].A2_Flags	= PITCH1 | PIXEL16 | WID64 | XADDPHR;
	Blit[BlitAddIndex].A2_Pixel	= 0x0L;
	Blit[BlitAddIndex].A2_Step	= step2;

	Blit[BlitAddIndex].B_Count	= (PADDLE_GUN_HEIGHT<<16) | (width & 0xFFFFL);
										 
	Blit[BlitAddIndex].B_Patd	= 0x0L;
	Blit[BlitAddIndex].B_Srcz1	= Player[who].Paddle.Z;

	Blit[BlitAddIndex].B_Cmd	= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN | 
								  DSTEN | DCOMPEN;
	
	QueBlit();
	}
	

/*********************************************************************
 *  FUNCTION:		DrawPaddlePower
 *
 *  PARAMETERS:		short who
 *
 *  DESCRIPTION:	Draw paddle gunpowder in paddle frame buffer
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void DrawPaddlePower(short who)
	{
	int width;
	long base;
	int pixel;
	int step1, step2;

	if(!Player[who].Paddle.Active)
		return;

	if(!Player[who].Paddle.Gun)
		return;

	if(Option.GameMode == gameCLASSIC)
		return;

	width = PaddleWidthTab[Player[who].Paddle.Size];

	if(who == PLAYER_ON_TOP)
		{
		base = (long)IMG_PaddleFrame[0];
		pixel = (PADDLE_HEIGHT-PADDLE_GUNSTROBE_Y-1)<<16L;
		step1 = (-1<<16) | (-width & 0x0FFFFL);
		}
	else
		{
		base = (long)IMG_PaddleFrame[1];
		pixel = PADDLE_GUNSTROBE_Y<<16L;
		step1 = (1<<16) | (-width & 0xFFFFL);
		}

	step2 = (1<<16) | (-width & 0xFFFFL);
	
	/* Then Blit the gun strobe */
	Blit[BlitAddIndex].Type		= blitBITMAP;

	Blit[BlitAddIndex].A1_Base	= base;
	Blit[BlitAddIndex].A1_Flags	= PITCH1 | PIXEL16 | WID64 | XADDPHR;

	Blit[BlitAddIndex].A1_Pixel	= pixel;
	Blit[BlitAddIndex].A1_Step	= step1;
										 
	Blit[BlitAddIndex].A2_Base	= (long)IMG_Paddle[who].GunStrobe[Player[who].Paddle.GunPower/2];
	Blit[BlitAddIndex].A2_Flags	= PITCH1 | PIXEL16 | WID64 | XADDPHR;
	Blit[BlitAddIndex].A2_Pixel	= 0x0L;
	Blit[BlitAddIndex].A2_Step	= step2;

	Blit[BlitAddIndex].B_Count	= (PADDLE_GUNSTROBE_HEIGHT<<16) | (width & 0xFFFFL);
										 
	Blit[BlitAddIndex].B_Patd	= 0x0L;
	Blit[BlitAddIndex].B_Srcz1	= Player[who].Paddle.Z;

	Blit[BlitAddIndex].B_Cmd	= LFU_REPLACE | UPDA1 | UPDA2 | SRCEN | 
								  DSTEN | DCOMPEN;

	QueBlit();
	}
	


void AddPaddleBonus( short who )
	{
	int i;

	for (i=0; i<Player[who].Paddle.Hits; i++)
	  {
	  Player[who].Score += 10;
	  UpdateScore(who, TRUE);

	  if(i%4 == 0)
		  PlaySound(sndBRICK1, 127, 12, 5);
	  /* Add delay here */
	  }
	}