/*******************************************************************
 *
 *    TITLE:        paddle.h
 *
 *    DESCRIPTION:	Header file for paddle.c
 *
 *    AUTHOR:		Mario Perdue & Richard Degler
 *
 *    HISTORY:    
 *
 *
 *           COPYRIGHT 1994, 1995 MP Graphics Systems         
 *      UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
 *      PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
 *     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
 *                        ALL RIGHTS RESERVED.               
 *******************************************************************/

#ifndef __PADDLE__H
#define __PADDLE__H

#include "support.h"

#define PADDLE_IMAGES			8
#define PADDLE_SIZES			5

#define	PADDLE_WIDTH   			64
#define PADDLE_HEIGHT			20

#define PADDLE_FACE_WIDTH 		64
#define PADDLE_FACE_HEIGHT		12

#define PADDLE_STROBE_HEIGHT	2
#define PADDLE_STROBE_Y			14

#define PADDLE_GUN_HEIGHT		8
#define PADDLE_GUN_Y			9

#define PADDLE_GUNSTROBE_HEIGHT	1
#define PADDLE_GUNSTROBE_Y		12

#define PADDLE_MIN_W  			1024
#define PADDLE_MAX_W			2048
#define PADDLE_H		 		384
#define PADDLE_STEP_W  			256
#define PADDLE_MAX_SIZE			4

#define PADDLE_MARGIN			32

#define	PADDLE_MAX_SPEED_X		200
#define	PADDLE_MAX_SPEED_Y	 	32

#define PADDLE_MIN_Y			3136
#define PADDLE_MID_Y			3200
#define PADDLE_MAX_Y			3264

#define PADDLE_Z				PLAYFIELD_FRONT

#define	MAX_CRACKS				4
#define CRACK_WIDTH				12
#define CRACK_HEIGHT			12
#define CRACK_FLAGS				PITCH1 | PIXEL16 | WID12 | XADDPIX


/*#define PADDLE_FLAGS			PITCH1 | PIXEL16 | WID64 | XADDPIX*/

enum {lightRED, lightGREEN, lightOFF};


/* Type definitions */
typedef struct
	{
	WORD 	X;
	WORD	Y;
	WORD	Z;

	UWORD	ScreenX;
	UWORD	ScreenY;
	UWORD	OldX;
	UWORD	OldY;

	WORD	SpeedX;
	WORD	SpeedY;

	WORD	MaxSpeedX;
	WORD	IncSpeedY;

	WORD	MaxY;
	WORD	MinY;

	UWORD	Hits;

	char	Attract;
	BYTE 	Active;
	BYTE 	Size;
	BYTE 	Small;
	BYTE 	Catch;

	BYTE	Gun;
	BYTE	GunPower;

	BYTE 	Index;
	BYTE	IndexCnt;

	BYTE	Cracks;
	BYTE	Step;
	} DEF_PADDLE;


typedef struct
	{
	}DEF_ROM_PADDLE_FACE;

typedef struct
	{
	WORD	RedFace[2][12][128];
	WORD	GreenFace[2][12][128];
	WORD	Shatter[8][12][128];
	WORD	RedStrobe[8][2][128];
	WORD	RedLaunch[8][12][128];
	WORD	GreenStrobe[8][2][128];
	WORD	GreenLaunch[8][12][128];
	WORD	Frame[20][128];
	WORD	Gun[8][128];
	WORD	GunStrobe[8][128];
	WORD	BombLaunch[8][16][128];
	WORD	ClassicFrame[20][128];
	} DEF_ROM_PADDLE;

typedef struct
	{
	WORD	Face[2][12][64];
	WORD	Shatter[8][12][64];
	WORD	Strobe[8][2][64];
	WORD	BallLaunch[8][12][64];
	WORD	Frame[20][64];
	WORD	Gun[8][64];
	WORD	GunStrobe[8][64];
	WORD	BombLaunch[8][16][64];
	} DEF_RAM_PADDLE;

/* Function Prototypes */					 

void SetPaddleSize( short who, int );
void MovePaddle( short who );

void SetPaddleHover(short who, int speed); 
void DoPaddleHover(short who);
void DoPaddleGun(short who);

void DrawPaddleFace( short who );
void DrawPaddleFrame( short who );
void DrawPaddleStrobe( short who );
void DrawPaddleGun( short who );
void DrawPaddlePower( short who );

void AddPaddleBonus( short who );

#endif