/*******************************************************************
 *
 *	  TITLE:		player.c
 *
 *    DESCRIPTION:	Routines to support playfield and 2 player
 *
 *    AUTHOR:		Mario Perdue
 *
 *    HISTORY:    
 *
 *
 *           COPYRIGHT 1994, 1995 MP Graphics Systems         
 *      UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
 *      PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
 *     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
 *                        ALL RIGHTS RESERVED.               
 *******************************************************************/

/** include files **/
#include "\jaguar\include\jaguar.h"
#include "support.h"
#include "player.h"
#include "option.h"
#include "displays.h"
#include "hiscore.h"

/** external data **/
extern	WORD	IMG_Playfield[PLAYFIELD_HEIGHT][PLAYFIELD_WIDTH];
extern	WORD	IMG_PlayfieldBuffer[PLAYFIELD_BUFFER_HEIGHT][PLAYFIELD_BUFFER_WIDTH];
extern	WORD	IMG_BrickBuffer[];
extern	WORD	IMG_BackgroundBuffer[];
extern	WORD	IMG_TransitionBuffer[2][76800];
extern	WORD	IMG_ExpandBuffer[];

extern	WORD	ROM_GlassBack[2][104][80];
extern	WORD	IMG_GlassBack[104][160];

extern  WORD 	ROM_Background0[];
extern  WORD 	ROM_Background1[];
extern  WORD 	ROM_Background2[];
extern  WORD 	ROM_Background3[];
extern  WORD 	ROM_Background4[];
extern  WORD 	ROM_Background5[];
extern  WORD 	ROM_Background6[];
extern  WORD 	ROM_Background7[];
extern  WORD 	ROM_Background8[];
extern  WORD 	ROM_Background9[];
extern	WORD 	IMG_Background[];

extern	WORD 	ROM_Transition[];

extern	int		Screen;
extern	int		ScreenCount;
extern	int		OldBkg;

extern	DEF_OPTION		Option;
extern	DEF_BLIT_DATA	Blit[];
extern	LONG			BlitAddIndex;
extern	LONG			BlitUseIndex;

extern	int				BallMaxSpeedZ;	

extern	ULONG 			DemoTimer;



/** global data **/
DEF_PLAYER	Player[2];
BYTE 		PlayerOnTop;	

/** internal functions **/
/*********************************************************************
 *  FUNCTION:		PlayfieldToScreen
 *
 *  PARAMETERS:		int X
 *					int Y
 *					int Z
 *
 *  DESCRIPTION:	Converts a 3D location to a screen location
 *
 *  RETURNS:		void
 *
 *********************************************************************/
SCREENLOC	PlayfieldToScreen(int X, int Y, int Z)
	{
	SCREENLOC Loc;

	switch(Option.GameMode)
		{
		case game2000:
			/* Map to 3D perspective */
			Loc.X = TOTAL_RANGE*X/(PLAYFIELD_FRONT-Z+HALF_RANGE);
			Loc.X = Loc.X*133/TOTAL_RANGE+PLAYFIELD_ORG_X;

			Loc.Y = TOTAL_RANGE*Y/(PLAYFIELD_FRONT-Z+HALF_RANGE);
			Loc.Y = Loc.Y*100/TOTAL_RANGE+PLAYFIELD_ORG_Y;
			break;

		case gameCLASSIC:
			/* Mape to 2D Plane */
			Loc.X = (X+abs(PLAYFIELD_LEFT))/32+30;

			Loc.Y = Z/32-86;
			break;
		}

	return(Loc);
	}


/*********************************************************************
 *  FUNCTION:		ClearBackground
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void ClearBackground( void )
	{
	Blit[BlitAddIndex].Type 	= blitPATTERN;

	Blit[BlitAddIndex].A1_Base  = (long)IMG_Background;
	Blit[BlitAddIndex].A1_Flags = BACKGROUND_FLAGS;
	Blit[BlitAddIndex].A1_Pixel = 0x0L;
	Blit[BlitAddIndex].A1_Step 	= (1<<16L)|(-BACKGROUND_WIDTH & 0x0FFFFL);

	Blit[BlitAddIndex].B_Count 	= (BACKGROUND_HEIGHT<<16L) | 
								  (BACKGROUND_WIDTH & 0x0FFFFL);

	Blit[BlitAddIndex].B_Patd 	= 0x0L;
	Blit[BlitAddIndex].B_Cmd 	= PATDSEL | UPDA1;
	
	QueBlit();
	}

/*********************************************************************
 *  FUNCTION:		ClearPlayfield
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void ClearPlayfield( void )
	{
	Blit[BlitAddIndex].Type		= blitPATTERN;

	Blit[BlitAddIndex].A1_Base  = (long)IMG_Playfield;
	Blit[BlitAddIndex].A1_Flags = PLAYFIELD_FLAGS;

	Blit[BlitAddIndex].A1_Pixel = 0x0L;

	Blit[BlitAddIndex].A1_Step 	= (1<<16L)|(-PLAYFIELD_WIDTH & 0x0FFFFL);
	Blit[BlitAddIndex].B_Count 	= (PLAYFIELD_HEIGHT<<16L) | 
								  (PLAYFIELD_WIDTH & 0x0FFFFL);
	Blit[BlitAddIndex].B_Patd 	= 0x0L;
	Blit[BlitAddIndex].B_Cmd 	= PATDSEL | UPDA1;

	QueBlit();
	}

/*********************************************************************
 *  FUNCTION:		ClearPlayfieldBuffer
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void ClearPlayfieldBuffer( void )
	{
	Blit[BlitAddIndex].Type 	= blitPATTERN;

	Blit[BlitAddIndex].A1_Base  = (long)IMG_PlayfieldBuffer;
	Blit[BlitAddIndex].A1_Flags = PLAYFIELD_BUFFER_FLAGS;

	Blit[BlitAddIndex].A1_Pixel = 0x0L;

	Blit[BlitAddIndex].A1_Step 	= (1<<16L)|(-PLAYFIELD_BUFFER_WIDTH & 0x0FFFFL);
	Blit[BlitAddIndex].B_Count 	= (PLAYFIELD_BUFFER_HEIGHT<<16L) | 
								  (PLAYFIELD_BUFFER_WIDTH & 0x0FFFFL);
	Blit[BlitAddIndex].B_Patd 	= 0x0L;
	Blit[BlitAddIndex].B_Srcz1 	= 0x0L;
	Blit[BlitAddIndex].B_Cmd 	= PATDSEL | UPDA1 | DSTWRZ;

	QueBlit();
	}

/*********************************************************************
 *  FUNCTION: 	   RestorePlayfield
 *
 *  PARAMETERS:	   short who
 *
 *  DESCRIPTION:   Displays Playfield after Options
 *
 *  RETURNS:	   void
 *
 *********************************************************************/
void RestorePlayfield( short who )
	{
	int a1_pixel;
	int a2_pixel;

	if(who == PLAYER_ON_TOP)
		a1_pixel = 0x0L;
	else
		a1_pixel = (PLAYFIELD_BUFFER_HEIGHT/2)<<16L;

	Blit[BlitAddIndex].Type 	= blitBITMAP;

	Blit[BlitAddIndex].A1_Base  = (long)IMG_PlayfieldBuffer;
	Blit[BlitAddIndex].A1_Flags = PLAYFIELD_BUFFER_FLAGS;
	Blit[BlitAddIndex].A1_Pixel = a1_pixel;
	Blit[BlitAddIndex].A1_Step  = (1<<16L)|(-PLAYFIELD_BUFFER_WIDTH & 0x0FFFFL);


	Blit[BlitAddIndex].A2_Base  = (long)IMG_BrickBuffer;
	Blit[BlitAddIndex].A2_Flags = BRICK_BUFFER_FLAGS;
	Blit[BlitAddIndex].A2_Step  = Blit[BlitAddIndex].A1_Step;
	Blit[BlitAddIndex].A2_Pixel = Blit[BlitAddIndex].A1_Pixel;

	Blit[BlitAddIndex].B_Count  = ((PLAYFIELD_BUFFER_HEIGHT/2)<<16L) | 
								  (PLAYFIELD_BUFFER_WIDTH & 0x0FFFFL);

	Blit[BlitAddIndex].B_Cmd    = LFU_REPLACE | UPDA1 | UPDA2 | SRCEN | 
								  SRCENZ | DSTWRZ;

	QueBlit();


	if(who == PLAYER_ON_TOP)
		{
		a1_pixel = 20<<16L;
		a2_pixel = 0x0L;
		}
	else
		{
		a1_pixel = ((PLAYFIELD_BUFFER_HEIGHT/2)+20)<<16L;
		a2_pixel = (PLAYFIELD_BUFFER_HEIGHT/2)<<16L;
		}

	Blit[BlitAddIndex].Type = blitBITMAP;

	Blit[BlitAddIndex].A1_Base  = (long)IMG_Playfield;
	Blit[BlitAddIndex].A1_Flags = PLAYFIELD_FLAGS;
	Blit[BlitAddIndex].A1_Pixel = a1_pixel;
	Blit[BlitAddIndex].A1_Step  = (1<<16L)|(-PLAYFIELD_BUFFER_WIDTH & 0x0FFFFL);

	Blit[BlitAddIndex].A2_Base  = (long)IMG_PlayfieldBuffer;
	Blit[BlitAddIndex].A2_Flags = PLAYFIELD_BUFFER_FLAGS;
	Blit[BlitAddIndex].A2_Pixel = a2_pixel;
	Blit[BlitAddIndex].A2_Step  = Blit[BlitAddIndex].A1_Step;

	Blit[BlitAddIndex].B_Count  = ((PLAYFIELD_BUFFER_HEIGHT/2)<<16L) | 
								  (PLAYFIELD_BUFFER_WIDTH & 0x0FFFFL);

	Blit[BlitAddIndex].B_Cmd    = LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;

	QueBlit();
	}


void ExpandBackground( int which )
	{
	if(Option.GameMode == gameCLASSIC)
		{
		/* Clear the background Buffer */
		Blit[BlitAddIndex].Type 	= blitPATTERN;

		Blit[BlitAddIndex].A1_Base  = (long)IMG_BackgroundBuffer;
		Blit[BlitAddIndex].A1_Flags = BACKGROUND_FLAGS;
		Blit[BlitAddIndex].A1_Pixel = 0x0L;
		Blit[BlitAddIndex].A1_Step 	= (1<<16L)|(-BACKGROUND_WIDTH & 0x0FFFFL);

		Blit[BlitAddIndex].B_Count 	= (BACKGROUND_HEIGHT<<16L) | 
									  (BACKGROUND_WIDTH & 0x0FFFFL);

		Blit[BlitAddIndex].B_Patd 	= 0x0L;
		Blit[BlitAddIndex].B_Cmd 	= PATDSEL | UPDA1;
		
		QueBlit();

		/* Draw top of game area */
		Blit[BlitAddIndex].Type 	= blitPATTERN;

		Blit[BlitAddIndex].A1_Base  = (long)IMG_BackgroundBuffer;
		Blit[BlitAddIndex].A1_Flags = BACKGROUND_FLAGS;

		Blit[BlitAddIndex].A1_Pixel = (46<<16) | (20&0xFFFFL);

		Blit[BlitAddIndex].A1_Step 	= (1<<16L)|(-280 & 0xFFFFL);
		Blit[BlitAddIndex].B_Count 	= (10<<16L) | (280 & 0xFFFFL);
		Blit[BlitAddIndex].B_Patd 	= 0x88BBL;
		Blit[BlitAddIndex].B_Cmd 	= PATDSEL | UPDA1;
		
		QueBlit();

		/* Draw left side of game area */
		Blit[BlitAddIndex].Type 	= blitPATTERN;

		Blit[BlitAddIndex].A1_Base  = (long)IMG_BackgroundBuffer;
		Blit[BlitAddIndex].A1_Flags = BACKGROUND_FLAGS;

		Blit[BlitAddIndex].A1_Pixel = (56<<16) | (20&0xFFFFL);

		Blit[BlitAddIndex].A1_Step 	= (1<<16L)|(-10 & 0xFFFFL);
		Blit[BlitAddIndex].B_Count 	= (148<<16L) | (10 & 0xFFFFL);
		Blit[BlitAddIndex].B_Patd 	= 0x88BBL;
		Blit[BlitAddIndex].B_Cmd 	= PATDSEL | UPDA1;
		
		QueBlit();

		/* Draw right side of game area */
		Blit[BlitAddIndex].Type 	= blitPATTERN;

		Blit[BlitAddIndex].A1_Base  = (long)IMG_BackgroundBuffer;
		Blit[BlitAddIndex].A1_Flags = BACKGROUND_FLAGS;

		Blit[BlitAddIndex].A1_Pixel = (56<<16) | (290&0xFFFFL);

		Blit[BlitAddIndex].A1_Step 	= (1<<16L)|(-10 & 0xFFFFL);
		Blit[BlitAddIndex].B_Count 	= (148<<16L) | (10 & 0xFFFFL);
		Blit[BlitAddIndex].B_Patd 	= 0x88BBL;
		Blit[BlitAddIndex].B_Cmd 	= PATDSEL | UPDA1;
		
		QueBlit();

		/* Draw left side foot of game area */
		Blit[BlitAddIndex].Type 	= blitPATTERN;

		Blit[BlitAddIndex].A1_Base  = (long)IMG_BackgroundBuffer;
		Blit[BlitAddIndex].A1_Flags = BACKGROUND_FLAGS;

		Blit[BlitAddIndex].A1_Pixel = (204<<16) | (20&0xFFFFL);

		Blit[BlitAddIndex].A1_Step 	= (1<<16L)|(-10 & 0xFFFFL);
		Blit[BlitAddIndex].B_Count 	= (20<<16L) | (10 & 0xFFFFL);
		Blit[BlitAddIndex].B_Patd 	= 0x4BFFL;
		Blit[BlitAddIndex].B_Cmd 	= PATDSEL | UPDA1;
		
		QueBlit();

		/* Draw right side foot of game area */
		Blit[BlitAddIndex].Type 	= blitPATTERN;

		Blit[BlitAddIndex].A1_Base  = (long)IMG_BackgroundBuffer;
		Blit[BlitAddIndex].A1_Flags = BACKGROUND_FLAGS;

		Blit[BlitAddIndex].A1_Pixel = (204<<16) | (290&0xFFFFL);

		Blit[BlitAddIndex].A1_Step 	= (1<<16L)|(-10 & 0xFFFFL);
		Blit[BlitAddIndex].B_Count 	= (20<<16L) | (10 & 0xFFFFL);
		Blit[BlitAddIndex].B_Patd 	= 0xF0FFL;
		Blit[BlitAddIndex].B_Cmd 	= PATDSEL | UPDA1;
		
		QueBlit();
		}
	else
		{
		switch(which)
			{
			case 0:
				ExpandImage(IMG_BackgroundBuffer, ROM_Background0);
				break;

			case 1:
				ExpandImage(IMG_BackgroundBuffer, ROM_Background1);
				break;

			case 2:
				ExpandImage(IMG_BackgroundBuffer, ROM_Background2);
				break;

			case 3:
				ExpandImage(IMG_BackgroundBuffer, ROM_Background3);
				break;

			case 4:
				ExpandImage(IMG_BackgroundBuffer, ROM_Background4);
				break;

			case 5:
				ExpandImage(IMG_BackgroundBuffer, ROM_Background5);
				break;

			case 6:
				ExpandImage(IMG_BackgroundBuffer, ROM_Background6);
				break;

			case 7:
				ExpandImage(IMG_BackgroundBuffer, ROM_Background7);
				break;

			case 8:
				ExpandImage(IMG_BackgroundBuffer, ROM_Background8);
				break;

			case 9:
				ExpandImage(IMG_BackgroundBuffer, ROM_Background9);
				break;
			}
		}
	}


/*********************************************************************
 *  FUNCTION: 	   ExpandImage
 *
 *  PARAMETERS:	   WORD *Dest, WORD *Src
 *
 *  DESCRIPTION:   Expands the source image to the destination.
 *
 *  RETURNS:	   void
 *
 *********************************************************************/
void ExpandImage(WORD *Dest, WORD *Src)
	{
	ExpandLzjag(IMG_ExpandBuffer, Src);
	
	/* Blit image to upper left corner of screen */
	Blit[BlitAddIndex].Type = blitBITMAP;

	Blit[BlitAddIndex].A1_Base  = (long) Dest;
	Blit[BlitAddIndex].A1_Flags = PITCH1 | PIXEL16 | WID320 | XADDPIX;
	Blit[BlitAddIndex].A1_Step  = (1<<16L) | (-160&0xFFFFL);
	Blit[BlitAddIndex].A1_Pixel = 0x0L;

	Blit[BlitAddIndex].A2_Base  = (long) IMG_ExpandBuffer;
	Blit[BlitAddIndex].A2_Flags = PITCH1 | PIXEL16 | WID160 | XADDPIX;
	Blit[BlitAddIndex].A2_Step  = Blit[BlitAddIndex].A1_Step;
	Blit[BlitAddIndex].A2_Pixel = Blit[BlitAddIndex].A1_Pixel;
	
	Blit[BlitAddIndex].B_Count  = (120<<16L) | (160&0xFFFFL);
	Blit[BlitAddIndex].B_Cmd    = LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;

	QueBlit();

	/* Blit image to lower left corner of screen */
	Blit[BlitAddIndex].Type = blitBITMAP;

	Blit[BlitAddIndex].A1_Base  = (long) Dest;
	Blit[BlitAddIndex].A1_Flags = PITCH1 | PIXEL16 | WID320 | XADDPIX;
	Blit[BlitAddIndex].A1_Step  = (-1<<16L) | (-160&0xFFFFL);
	Blit[BlitAddIndex].A1_Pixel = (239<<16L);

	Blit[BlitAddIndex].A2_Base  = (long) Dest;
	Blit[BlitAddIndex].A2_Flags = PITCH1 | PIXEL16 | WID320 | XADDPIX;
	Blit[BlitAddIndex].A2_Step  = (1<<16L) | (-160&0xFFFFL);
	Blit[BlitAddIndex].A2_Pixel = 0x0L;
	
	Blit[BlitAddIndex].B_Count  = (120<<16L) | (160&0xFFFFL);
	Blit[BlitAddIndex].B_Cmd    = LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;

	QueBlit();

	/* Mirror Left side image to right side of screen */
	Blit[BlitAddIndex].Type = blitBITMAP;

	Blit[BlitAddIndex].A1_Base  = (long) Dest;
	Blit[BlitAddIndex].A1_Flags = PITCH1 | PIXEL16 | WID320 | XADDPIX | 
										 XSIGNSUB;
	Blit[BlitAddIndex].A1_Step  = (1<<16L) | (160&0xFFFFL);
	Blit[BlitAddIndex].A1_Pixel = (319&0xFFFFL);

	Blit[BlitAddIndex].A2_Base  = (long) Dest;
	Blit[BlitAddIndex].A2_Flags = PITCH1 | PIXEL16 | WID320 | XADDPIX;
	Blit[BlitAddIndex].A2_Step  = (1<<16L) | (-160&0xFFFFL);
	Blit[BlitAddIndex].A2_Pixel = 0x0L;
	
	Blit[BlitAddIndex].B_Count  = (240<<16L) | (160&0xFFFFL);
	Blit[BlitAddIndex].B_Cmd    = LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;

	QueBlit();
	}

/*********************************************************************
 *  FUNCTION: 	   DisplayExpandedImage
 *
 *  PARAMETERS:	   long Dest, long Src
 *
 *  DESCRIPTION:   Displays the image in Scr in Dest.
 *
 *  RETURNS:	   void
 *
 *********************************************************************/
void DisplayExpandedImage( WORD *Dest, WORD *Src )
	{
	/* Blit Source to the Destination */
	Blit[BlitAddIndex].Type = blitBITMAP;

	Blit[BlitAddIndex].A1_Base  = (long) Dest;
	Blit[BlitAddIndex].A1_Flags = PITCH1 | PIXEL16 | WID320 | XADDPIX;
	Blit[BlitAddIndex].A1_Step  = (1<<16L) | (-320&0xFFFFL);
	Blit[BlitAddIndex].A1_Pixel = 0x0L;

	Blit[BlitAddIndex].A2_Base  = (long) Src;
	Blit[BlitAddIndex].A2_Flags = Blit[BlitAddIndex].A1_Flags;
	Blit[BlitAddIndex].A2_Step  = Blit[BlitAddIndex].A1_Step;
	Blit[BlitAddIndex].A2_Pixel = Blit[BlitAddIndex].A1_Pixel;
		
	Blit[BlitAddIndex].B_Count  = (240<<16L) | (320&0xFFFFL);
	Blit[BlitAddIndex].B_Cmd    = LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;

	QueBlit();
	}




/*********************************************************************
 *  FUNCTION: 	   SetPlayfieldBack
 *
 *  PARAMETERS:	   int back
 *
 *  DESCRIPTION:   Sets the back glass image
 *
 *  RETURNS:	   void
 *
 *********************************************************************/
void SetPlayfieldBack(int back)
	{
	Blit[BlitAddIndex].Type = blitBITMAP;

	Blit[BlitAddIndex].A1_Base  = (long)IMG_GlassBack;
	Blit[BlitAddIndex].A1_Flags = PITCH1 | PIXEL16 | WID160 | XADDPIX;
	Blit[BlitAddIndex].A1_Step  = (1<<16L) | (-80&0xFFFFL);
	Blit[BlitAddIndex].A1_Pixel = 0x0L;

	Blit[BlitAddIndex].A2_Base  = (long)ROM_GlassBack[back];
	Blit[BlitAddIndex].A2_Flags = PITCH1 | PIXEL16 | WID80 | XADDPIX;
	Blit[BlitAddIndex].A2_Step  = Blit[BlitAddIndex].A1_Step;
	Blit[BlitAddIndex].A2_Pixel = Blit[BlitAddIndex].A1_Pixel;
	
	Blit[BlitAddIndex].B_Count  = (104<<16L) | (80&0xFFFFL);
	Blit[BlitAddIndex].B_Cmd    = LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;

	QueBlit();

	Blit[BlitAddIndex].Type = blitBITMAP;

	Blit[BlitAddIndex].A1_Base  = (long)IMG_GlassBack;
	Blit[BlitAddIndex].A1_Flags = PITCH1 | PIXEL16 | WID160 | XADDPIX | XSIGNSUB;
	Blit[BlitAddIndex].A1_Step  = (1<<16L) | (80&0xFFFFL);
	Blit[BlitAddIndex].A1_Pixel = 158;

	Blit[BlitAddIndex].A2_Base  = (long)IMG_GlassBack;
	Blit[BlitAddIndex].A2_Flags = PITCH1 | PIXEL16 | WID160 | XADDPIX;
	Blit[BlitAddIndex].A2_Step  = (1<<16L) | (-80&0xFFFFL);
	Blit[BlitAddIndex].A2_Pixel = 0x0L;
	
	Blit[BlitAddIndex].B_Count  = (104<<16L) | (80&0xFFFFL);
	Blit[BlitAddIndex].B_Cmd    = LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;

	QueBlit();
	}



/*********************************************************************
 *  FUNCTION: 	   DoTransition
 *
 *  PARAMETERS:	   void
 *
 *  DESCRIPTION:   Prepare and bring up next Screen.
 *
 *  RETURNS:	   void
 *
 *********************************************************************/
void DoTransition( void )
	{
	int scale;
	int backgnd;

	backgnd = (ScreenCount/5)%10;
 	if(backgnd == OldBkg)
		{
		RefreshScoreBoard();
		return;
		}

	ClearPowerUps(PLAYER_RED);
	ClearPowerUps(PLAYER_GREEN);
	RefreshScoreBoard();
	OldBkg = backgnd;

	if((Screen == 0)&& (ScreenCount > 0))
		ShowLastScreenCongrats();

	if((ScreenCount == 0) || DemoTimer)
		{
		ExpandBackground(MIN(10,backgnd));
		DisplayExpandedImage(IMG_Background, IMG_BackgroundBuffer);
		ClearPlayfieldBuffer();
		ClearPlayfield();
		RefreshScoreBoard();
		return;
		}

	ExpandImage(IMG_TransitionBuffer[0], ROM_Transition);
	for(scale=100; scale>0; scale-=MAX(1,12*scale/100))
		{
		DisplayTransition(IMG_Playfield[0], IMG_TransitionBuffer[0], 
						  scale, TRANSPARENT);

		while(BlitAddIndex != BlitUseIndex);
		PlaySound(sndSLAM, scale+27, 0, 6);

		Delay(30);
		}

	ClearBackground();
	ExpandBackground(MIN(10,backgnd));

	DisplayExpandedImage(IMG_TransitionBuffer[1], IMG_BackgroundBuffer);
	ClearBackground();

	DisplayTransition(IMG_TransitionBuffer[1], IMG_TransitionBuffer[0], 
					  100, TRANSPARENT);

	for(scale=2; scale<100; scale+=MAX(1,12*scale/100))
		{
		DisplayTransition(IMG_Playfield[0], IMG_TransitionBuffer[1], 
						  scale, OPAQUE);

		while(BlitAddIndex != BlitUseIndex);
		PlaySound(sndSLAM, scale+27, 0, 6);

		Delay(30);
		}

	DisplayExpandedImage(IMG_Background, IMG_BackgroundBuffer);
	if(Player[PLAYER_RED].BallCount > 0)
		Player[PLAYER_RED].BallCount = 5;
	if(Player[PLAYER_GREEN].BallCount > 0)
		Player[PLAYER_GREEN].BallCount = 5;

	RefreshScoreBoard();
	ClearPlayfieldBuffer();
	ClearPlayfield();
	}


/*********************************************************************
 *  FUNCTION: 	   DisplayTransition
 *
 *  PARAMETERS:	   WORD *Dest, WORD *Src, int Scale, int Transparent
 *
 *  DESCRIPTION:   Displays the image in Scr in Dest.
 *
 *  RETURNS:	   void
 *
 *********************************************************************/
void DisplayTransition( WORD *Dest, WORD *Src, int Scale, int Transparent )
	{
	long ScaledWidth;
	long ScaledHeight;
	LONG Increment;
	int Fraction;

	ScaledWidth = (PLAYFIELD_WIDTH*Scale/100) & 0x0FFFFL;
	ScaledHeight = (PLAYFIELD_HEIGHT*Scale/100) & 0x0FFFFL;

 	Increment = 0x10000*PLAYFIELD_WIDTH/ScaledWidth;
	Fraction = Increment & 0x0FFFF;
 	Increment /= 0x010000;

	Blit[BlitAddIndex].Type		= blitSCALED;

	Blit[BlitAddIndex].A1_Base	= (long)Src;
	Blit[BlitAddIndex].A1_Flags	= PITCH1 | PIXEL16 | WID320 | XADDINC;
	Blit[BlitAddIndex].A1_Clip	= (PLAYFIELD_HEIGHT<<16) | 
										  (PLAYFIELD_WIDTH & 0xFFFFL);
	Blit[BlitAddIndex].A1_Pixel	= 0x0L;
	Blit[BlitAddIndex].A1_Fpixel	= 0x0L;
	Blit[BlitAddIndex].A1_Step	= (Increment<<16) | 
								  (-PLAYFIELD_WIDTH & 0xFFFFL);
	Blit[BlitAddIndex].A1_Fstep	= Fraction<<16;
	Blit[BlitAddIndex].A1_Inc	= Increment & 0xFFFFL;
	Blit[BlitAddIndex].A1_Finc	= Fraction & 0xFFFFL;
										 
	Blit[BlitAddIndex].A2_Base	= (long)Dest;
	Blit[BlitAddIndex].A2_Flags	= PITCH1 | PIXEL16 | WID320 | XADDPIX;
	Blit[BlitAddIndex].A2_Pixel	= ((PLAYFIELD_HEIGHT-ScaledHeight)/2<<16) |
								  ((PLAYFIELD_WIDTH-ScaledWidth)/2 & 0xFFFFL);
	Blit[BlitAddIndex].A2_Step	= (1<<16) | (-ScaledWidth & 0xFFFFL);

	Blit[BlitAddIndex].B_Count	= (ScaledHeight<<16) | ScaledWidth;
										 
	Blit[BlitAddIndex].B_Patd	= 0x0L;

	Blit[BlitAddIndex].B_Iinc	= ((Scale-100)&0xFF)<<16;

	Blit[BlitAddIndex].B_Cmd	= LFU_REPLACE | UPDA1 | UPDA1F | UPDA2 | 
								  DSTA2 | SRCEN |  CLIP_A1 | 
								  SRCSHADE | ZBUFF;
	if(Transparent)
		Blit[BlitAddIndex].B_Cmd |=  (DSTEN | DCOMPEN);

	QueBlit();
	}


void ClearPowerUps( short who )
	{
	int player;
	int ball;
	int paddlewho;

	SetPaddleSize(who, PADDLE_MAX_SIZE-Option.Skill[who]);

/*
	Player[who].Ball[0].Style = ballNORMAL;
	Player[who].Ball[1].Style = ballNORMAL;
*/
	Player[who].BallStyle = ballNORMAL;
 	Player[who].Paddle.Gun = FALSE;
 	Player[who].Paddle.Catch = FALSE;
 	Player[who].Paddle.Attract = FALSE;

	for(player=0; player<2; player++)
	 	{
		for(ball=0; ball<2; ball++)
			{
			if(Player[player].Ball[ball].Sector == sectorTOP)
				paddlewho = PLAYER_ON_TOP;
			else
				paddlewho = PLAYER_ON_BOTTOM;

			if(who == paddlewho)
				{
				if(Player[player].Ball[ball].Caught)
					{
					Player[player].Ball[ball].Caught = FALSE;
					SetBallSpeed(player, ball, Player[who].Paddle.SpeedX, 0, 
									-BallMaxSpeedZ/2);
					}
				}
			}
	  	}
	RefreshIcons(who);
	}


