/*******************************************************************
 *
 *    TITLE:        player.h
 *
 *    DESCRIPTION:	Header file for player.c
 *
 *    AUTHOR:		Mario Perdue & Richard Degler
 *
 *    HISTORY:    
 *
 *
 *           COPYRIGHT 1994, 1995 MP Graphics Systems         
 *      UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
 *      PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
 *     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
 *                        ALL RIGHTS RESERVED.               
 *******************************************************************/

#ifndef __PLAYER__H
#define __PLAYER__H

#include "support.h"
#include "ball.h"
#include "goody.h"
#include "paddle.h"
#include "brick.h"
#include "bomb.h"

#define MAX_PLAYERS				2

#define TOTAL_RANGE				8320
#define HALF_RANGE				4160

#define	PLAYFIELD_LEFT 			-4160
#define PLAYFIELD_RIGHT			4192 
#define	PLAYFIELD_BACK 			4200
#define	PLAYFIELD_FRONT			8320
#define PLAYFIELD_TOP			-3488
#define PLAYFIELD_BOTTOM		3488

#define PLAYFIELD_WIDTH			320
#define PLAYFIELD_HEIGHT	   	240

#define PLAYFIELD_BUFFER_WIDTH 	320
#define PLAYFIELD_BUFFER_HEIGHT	200

#define	PLAYFIELD_ORG_X   		159
#define PLAYFIELD_ORG_Y   		100

#define PLAYFIELD_FLAGS			PITCH1 | PIXEL16 | WID320 | XADDPIX
#define PLAYFIELD_BUFFER_FLAGS	PITCH2 | PIXEL16 | WID320 | XADDPIX | ZOFFS1

#define BACKGROUND_WIDTH  		320
#define BACKGROUND_HEIGHT	   	240

#define BACKGROUND_FLAGS 		PITCH1 | PIXEL16 | WID320 | XADDPIX

#define GLASS_BACK_X	  		80
#define GLASS_BACK_Y	  		136
#define GLASS_BACK_H	  		104

#define GLASS_LEFT_X  			27
#define GLASS_LEFT_Y  			52
#define	GLASS_RIGHT_X 			292
#define GLASS_RIGHT_Y 			52

#define BARRIER_TOP_X			32
#define BARRIER_TOP_Y			44
#define BARRIER_H				32

#define BARRIER_BOT_X			32
#define BARRIER_BOT_Y			372

#define PLAYER_ON_TOP			(PlayerOnTop)
#define PLAYER_ON_BOTTOM		(PlayerOnTop^1)

enum { PLAYER_RED, PLAYER_GREEN };
enum { FLAT, ROUND };

typedef struct
	{
	DEF_BALL 	Ball[2];
	DEF_GOODY	Goody;
	DEF_PADDLE	Paddle;
	DEF_BOMB   	Bomb;
	DEF_BRICK	Brick[BRICK_TIERS][BRICK_COLS][BRICK_ROWS];
	WORD 		BrickCount;
	
	LONG		Score;
	LONG		OldScore;
	char		Name[MAX_NAME_LENGTH];

	WORD		BallCount;
	BYTE		BallStyle;

	WORD		Button;
	WORD		Joypad;
	WORD		Keypad;
	WORD		OldKeypad;

	BYTE		Mode;
	BYTE		Draw;

	BYTE		Tier;
	BYTE		Row;
	BYTE		Col;

	BYTE		AutoPilot;

	WORD		BonusBalls;
	WORD		BonusBombs;

	ULONG		Timer;
	} DEF_PLAYER;


SCREENLOC	PlayfieldToScreen(int X, int Y, int Z);

void ClearBackground( void );

void ClearPlayfield( void );
void ClearPlayfieldBuffer( void );

void ExpandImage( WORD *Dest, WORD *Src );
void DisplayExpandedImage( WORD *Dest, WORD *Src );

void SetPlayfieldBack( int back );

void DoTransition( void );
void DisplayTransition( WORD *Dest, WORD *Src, int Scale, int Transparent );

void ClearPowerUps( short who );

#endif