/*******************************************************************
 *
 *    TITLE:        ripple.c
 *
 *    DESCRIPTION:	Ripple handling code for Breakout 2000
 *
 *    AUTHOR:		Mario Perdue & Richard Degler
 *
 *    HISTORY:    
 *
 *
 *           COPYRIGHT 1994, 1995 MP Graphics Systems         
 *      UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
 *      PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
 *     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
 *                        ALL RIGHTS RESERVED.               
 *******************************************************************/

#include "\jaguar\include\jaguar.h"
#include "ripple.h"
#include "player.h"
#include "brick.h"
#include "option.h"

extern	WORD	IMG_Ripple[6][32][96];
extern	WORD	IMG_PlayfieldBuffer[];
extern	WORD	IMG_Playfield[];
extern	WORD	IMG_BrickBuffer[];

extern	WORD	RippleWidthTab[5];
extern	WORD	RippleOffsetTab[5];

extern	DEF_BLIT_DATA	Blit[];
extern	LONG			BlitAddIndex;
extern	LONG			BlitUseIndex;

extern DEF_PLAYER Player[];

extern	DEF_OPTION		Option;

DEF_RIPPLE	Ripple[MAX_RIPPLES];

void StartRipple(int x, int y, int z, int style)
	{
	int i;
	int index;
	int step;

	if(Option.GameMode != game2000) 
		return;

	step = 0;
	index = 0;

	for(i=0; i<MAX_RIPPLES; i++)
		{
		if(!Ripple[i].Active)
			{
			index=i;
			break;
			}
		else if(Ripple[i].Step > step)
			{
			index = i;
			step = Ripple[i].Step;
			}
		}

	if(Ripple[index].Active)
		{
		EraseRipple(index);
		DisplayRipple(index);
		}

	switch(style)
		{
		case rippleLEFT:
			x = PLAYFIELD_LEFT;
			Ripple[index].Style = MAX(0, MIN(2,GetDepthScale(z)/16-3));
			Ripple[index].Width = RippleWidthTab[Ripple[index].Style];
			Ripple[index].Height = Ripple[index].Width*2;
			break;

		case rippleRIGHT:
			x = PLAYFIELD_RIGHT;
			Ripple[index].Style = MAX(0, MIN(2,GetDepthScale(z)/16-3))+
								  rippleRIGHT0;
			Ripple[index].Width = RippleWidthTab[Ripple[index].Style];
			Ripple[index].Height = Ripple[index].Width*2;
			break;

		case rippleFRONT:
		case rippleBACK:
			x = MAX(PLAYFIELD_LEFT+512,MIN(PLAYFIELD_RIGHT-512, x));
			Ripple[index].Style = style;
			Ripple[index].Width = RippleWidthTab[Ripple[index].Style];
			Ripple[index].Height = Ripple[index].Width;
			break;
		}


	Ripple[index].Screen = PlayfieldToScreen(x, y, z);

	Ripple[index].Screen.X -= Ripple[index].Width/2;

	if(Ripple[index].Screen.Y >= 100)
		{
		Ripple[index].OnTop = FALSE;
		Ripple[index].Screen.Y = MIN(Ripple[index].Screen.Y-
								(Ripple[index].Height/2), 
								PLAYFIELD_BUFFER_HEIGHT-Ripple[index].Height-1);
		}
	else
		{
		Ripple[index].OnTop = TRUE;
		Ripple[index].Screen.Y = MAX(Ripple[index].Screen.Y+
								(Ripple[index].Height/2), 
								Ripple[index].Height);
		}

	Ripple[index].Step = 0;

	Ripple[index].Active = TRUE;
	}

void AnimateRipples(void)
	{
	int i;

	for(i=0; i<MAX_RIPPLES; i++)
		{
		if(Ripple[i].Active)
			{
			if(++Ripple[i].Step > RIPPLE_STEPS)
				Ripple[i].Active = FALSE;
			}
		}
	}


void EraseRipple(int which)
	{
	int EndX;
	int Offset;
	int StepWidth;
	int a1_step;

	if(!Ripple[which].Active)
		return;

	EndX = Ripple[which].Screen.X+Ripple[which].Width;
	Offset = EndX & 3;
	if(Offset)
		StepWidth = Ripple[which].Width+4-Offset;
	else
		StepWidth = Ripple[which].Width;

	if(Ripple[which].OnTop)
		a1_step = (-1<<16) | (-StepWidth & 0xFFFFL);
	else
		a1_step = (1<<16) | (-StepWidth & 0xFFFFL);

	Blit[BlitAddIndex].Type = blitBITMAP;

	Blit[BlitAddIndex].A1_Base  = (long)IMG_PlayfieldBuffer;
	Blit[BlitAddIndex].A1_Flags = PITCH2 | PIXEL16 | WID320 | XADDPHR | ZOFFS1;
	Blit[BlitAddIndex].A1_Pixel = (Ripple[which].Screen.Y<<16) |
								  (Ripple[which].Screen.X & 0xFFFFL);
	Blit[BlitAddIndex].A1_Step	= a1_step;
		
	Blit[BlitAddIndex].A2_Base  = (long)IMG_BrickBuffer;
	Blit[BlitAddIndex].A2_Flags = Blit[BlitAddIndex].A1_Flags;
	Blit[BlitAddIndex].A2_Pixel = Blit[BlitAddIndex].A1_Pixel;
	Blit[BlitAddIndex].A2_Step  = Blit[BlitAddIndex].A1_Step;

	Blit[BlitAddIndex].B_Count  = (Ripple[which].Height<<16) | 
								  (Ripple[which].Width & 0xFFFFL);
	Blit[BlitAddIndex].B_Patd   = 0x0L;
	Blit[BlitAddIndex].B_Srcz1  = 0x0L;

	Blit[BlitAddIndex].B_Cmd    = LFU_REPLACE | UPDA1 | UPDA2 | SRCEN | 
								  DSTEN | SRCENZ | DSTENZ | DSTWRZ;
	
	QueBlit();
	}

void DrawRipple(int which)
	{
	int a1_step;
	int a2_flags;
	int a2_step;
	int b_srcz1;

	if(!Ripple[which].Active)
		return;

	if(Ripple[which].Step >= RIPPLE_STEPS)
		return;

	if(Ripple[which].OnTop)
		a1_step = (-1<<16L)|(-Ripple[which].Width & 0x0FFFFL);
	else
		a1_step = (1<<16L)|(-Ripple[which].Width & 0x0FFFFL);

	switch(Ripple[which].Style)
		{
		case rippleLEFT0:
		case rippleLEFT1:
		case rippleLEFT2:
		case rippleFRONT:
		case rippleBACK:
		default:
			a2_flags = RIPPLE_FLAGS;
			a2_step  = (1<<16L)|(-Ripple[which].Width & 0x0FFFFL);
			break;

		case rippleRIGHT0:
		case rippleRIGHT1:
		case rippleRIGHT2:
			a2_flags = RIPPLE_FLAGS | XSIGNSUB;
			a2_step  = (1<<16L)|(Ripple[which].Width & 0x0FFFFL);
			break;
		}

	if(Ripple[which].Style == rippleFRONT) 
		b_srcz1  = PLAYFIELD_FRONT-0xFL;
	else
		b_srcz1  = 0xFL;

	Blit[BlitAddIndex].Type = blitBITMAP;

	Blit[BlitAddIndex].A1_Base  = (long)IMG_PlayfieldBuffer;
	Blit[BlitAddIndex].A1_Flags = PLAYFIELD_BUFFER_FLAGS;
	Blit[BlitAddIndex].A1_Pixel = (Ripple[which].Screen.Y<<16L) | 
								  (Ripple[which].Screen.X & 0x0FFFFL);
	Blit[BlitAddIndex].A1_Step	= a1_step;
		
	Blit[BlitAddIndex].A2_Base  = (long)&IMG_Ripple[Ripple[which].Step];
	Blit[BlitAddIndex].A2_Flags = a2_flags;
	Blit[BlitAddIndex].A2_Step  = a2_step;
	Blit[BlitAddIndex].A2_Pixel = RippleOffsetTab[Ripple[which].Style] & 0xFFFFL;

	Blit[BlitAddIndex].B_Count  = (Ripple[which].Height<<16L) | 
								  (Ripple[which].Width & 0x0FFFFL);
	Blit[BlitAddIndex].B_Patd   = 0x0L;
	Blit[BlitAddIndex].B_Srcz1	= b_srcz1;

	Blit[BlitAddIndex].B_Cmd    = LFU_REPLACE | UPDA1 | UPDA2 | SRCEN | 
								  DSTEN | DCOMPEN | DSTENZ | ZMODELT | 
								  DSTWRZ;

	QueBlit();
	}

void DisplayRipple(int which)
	{
	int EndX;
	int Offset;
	int StepWidth;

	int a1_step;

	if(!Ripple[which].Active)
		return;

	EndX = Ripple[which].Screen.X+Ripple[which].Width;
	Offset = EndX & 3;
	if(Offset)
		StepWidth = Ripple[which].Width+4-Offset;
	else
		StepWidth = Ripple[which].Width;
	
	if(Ripple[which].OnTop)
		a1_step = (-1<<16L) | (-StepWidth & 0x0FFFFL);
	else
		a1_step = (1<<16L) | (-StepWidth & 0x0FFFFL);

	Blit[BlitAddIndex].Type = blitBITMAP;

	Blit[BlitAddIndex].A1_Base  = (long)IMG_Playfield;
	Blit[BlitAddIndex].A1_Flags = PITCH1 | PIXEL16 | WID320 | XADDPHR;
	Blit[BlitAddIndex].A1_Pixel = ((Ripple[which].Screen.Y+20)<<16L) | 
										 (Ripple[which].Screen.X & 0x0FFFFL);
	Blit[BlitAddIndex].A1_Step	= a1_step;
		
	Blit[BlitAddIndex].A2_Base  = (long)IMG_PlayfieldBuffer;
	Blit[BlitAddIndex].A2_Flags = PITCH2 | PIXEL16 | WID320 | XADDPHR | 
										 ZOFFS1;
	Blit[BlitAddIndex].A2_Pixel = (Ripple[which].Screen.Y<<16L) | 
										 (Ripple[which].Screen.X & 0x0FFFFL);
	Blit[BlitAddIndex].A2_Step  = Blit[BlitAddIndex].A1_Step;

	Blit[BlitAddIndex].B_Count  = (Ripple[which].Height<<16L) | 
										 (Ripple[which].Width & 0x0FFFFL);
	Blit[BlitAddIndex].B_Patd   = 0x0L;
	Blit[BlitAddIndex].B_Srcz1  = 0xFL;

	Blit[BlitAddIndex].B_Cmd    = LFU_REPLACE | UPDA1 | UPDA2 | SRCEN;

	QueBlit();
	}
