/*******************************************************************
 *
 *    TITLE:        ripple.h
 *
 *    DESCRIPTION:	Header file for ripple.c
 *
 *    AUTHOR:		Mario Perdue & Richard Degler
 *
 *    HISTORY:    
 *
 *
 *           COPYRIGHT 1994, 1995 MP Graphics Systems         
 *      UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
 *      PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
 *     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
 *                        ALL RIGHTS RESERVED.               
 *******************************************************************/

#ifndef __RIPPLE__H
#define __RIPPLE__H

#include 	"support.h"

#define		MAX_RIPPLES		4

#define		RIPPLE_FLAGS	PITCH1 | PIXEL16 | WID96 | XADDPIX

#define		RIPPLE_STEPS	6

enum {rippleLEFT, rippleRIGHT,
	  rippleLEFT0=0, rippleLEFT1, rippleLEFT2, 
	  rippleRIGHT0, rippleRIGHT1, rippleRIGHT2, 
	  rippleBACK, rippleFRONT};

typedef struct
	{
	BYTE		Active;
	BYTE		OnTop;

	SCREENLOC	Screen;

	WORD		Width;
	WORD		Height;

	BYTE		Style;
	BYTE		Step;
	}DEF_RIPPLE;


void StartRipple( int x, int y, int z, int style );
void AnimateRipples( void );
void EraseRipple( int which );
void DrawRipple( int which );
void DisplayRipple( int which );

#endif
