;*==========================================================*
;* TITLE:        SPRITE1.S                                  *
;* Function:     Defines game images                        *
;*                                                          *
;* Project:      Breakout 2000                              *
;*                                                          *
;* Programmer:   Mario Perdue                               *
;*                                                          *
;* COPYRIGHT 1995 MP Graphics Systems                       *
;*                                                          *
;* UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,      *
;* PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR       *
;* THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.  *
;* ALL RIGHTS RESERVED.                                     *
;*                                                          *
;*==========================================================*

    .globl  _ROM_BallNormal
    .globl  _ROM_BallSuper
    .globl  _ROM_BallExplode
	.globl	_ROM_BallShadow
	.globl	_ROM_BallClassic

    .globl  _IMG_BallNormal
    .globl  _IMG_BallSuper
    .globl  _IMG_BallExplode
	.globl	_IMG_BallShadow
	.globl	_IMG_BallClassic

    .globl  _ROM_Paddle
    .globl  _IMG_Paddle
    .globl  _IMG_PaddleBuffer
    .globl  _IMG_PaddleFace
    .globl  _IMG_PaddleFrame

	.globl	_ROM_Bomb
	.globl	_IMG_Bomb

	.globl	_ROM_BombExplode
	.globl	_IMG_BombExplode

	.globl	_ROM_Ripple
	.globl	_IMG_Ripple

	.globl	_ROM_Shatter


    .data
    .phrase
_ROM_BallNormal:
	.incbin			"images/ball_1.lzj"

    .phrase
_ROM_BallSuper:
	.incbin			"images/ball_2.lzj"

    .phrase
_ROM_BallExplode:
	.incbin			"images/ball_3.lzj"

    .phrase
_ROM_BallShadow:
	.incbin			"images/ball_4.lzj"

	.phrase
_ROM_BallClassic:
	.incbin			"images/ball_5.lzj"


	.phrase
_ROM_Paddle:
	.incbin			"images/pad_face.cry"
	.incbin			"images/paddles.cry"

	.phrase
_ROM_Bomb:
	.incbin			"images/bomb.lzj"

	.phrase
_ROM_BombExplode:
	.incbin			"images/bombexpl.lzj"

	.phrase
_ROM_Ripple:
	.incbin			"images/ripple.lzj"

	.phrase
_ROM_Shatter:
	.incbin			"images/shatter.cry"



    .bss
    .phrase
_IMG_BallNormal:
    .ds.w   7680
    .ds.w   7680

    .phrase
_IMG_BallSuper:
    .ds.w   7680
    .ds.w   7680

    .phrase
_IMG_BallExplode:
    .ds.w   20480
    .ds.w   20480

    .phrase
_IMG_BallShadow:
    .ds.w   480

	.phrase
_IMG_BallClassic:
	.ds.w	144


    .phrase
_IMG_Paddle:
    .ds.w   25344
    .ds.w   25344

    .phrase
_IMG_PaddleBuffer:
    .ds.w   1280

    .phrase
_IMG_PaddleFace:
    .ds.w   1536

    .phrase
_IMG_PaddleFrame:
    .ds.w   2560

	.phrase
_IMG_Bomb:
	.ds.w	1152

	.phrase
_IMG_BombExplode:
	.ds.w	19456

	.phrase
_IMG_Ripple:
	.ds.w	18432
