/*******************************************************************
 *
 *    TITLE:        star.c
 *
 *    DESCRIPTION:	Routines to handle starfields
 *
 *    AUTHOR:		Mario Perdue & Richard Degler
 *
 *    HISTORY:    
 *
 *
 *           COPYRIGHT 1994, 1995 MP Graphics Systems         
 *      UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
 *      PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
 *     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
 *                        ALL RIGHTS RESERVED.               
 *******************************************************************/

/** include files **/
#include "\jaguar\include\jaguar.h"
#include "support.h"
#include "star.h"
#include "player.h"
#include "option.h"

/** external data **/
extern	DEF_BLIT_DATA	Blit[];
extern	WORD			ROM_Screen[];
extern	WORD			IMG_Screen[240][320];

extern	int				ScreenHeight;

extern	long 			BlitAddIndex;
extern	long 			BlitUseIndex;

extern	DEF_OPTION		Option;


/** public data **/
DEF_STAR	Star[MAX_STARS];
UWORD		ActiveStar;
int			StarOriginX;
int			StarOriginY;
int			StarMaxX;
int			StarMaxY;

/** internal functions **/
/*********************************************************************
 *  FUNCTION:		InitStarPosition
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void InitStarPosition( int which )
	{
	Star[which].Speed = Random(10)+10;
	Star[which].Accel = Random(5);
	Star[which].Angle = (360/MAX_STARS)*which;

	Star[which].X = (StarOriginX+(Star[which].Speed>>2)*
										cos1000(Star[which].Angle)/1000)<<4;
	Star[which].Y = (StarOriginY+(Star[which].Speed>>2)*
										sin1000(Star[which].Angle)/1000)<<4;
				
	Star[which].Color.cry.x = Random(16);
	Star[which].Color.cry.y = Random(16);
	Star[which].Color.cry.i = Random(128);
	}

/*********************************************************************
 *  FUNCTION:		InitStarField
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void InitStarfield()
	{
	int i;

	ExpandLzjag(IMG_Screen[0], ROM_Screen);

	ActiveStar = 0;

	StarOriginX = STARFIELD_ORG_X;
	StarMaxX = STARFIELD_R;

	if(ScreenHeight > 250)
		{
		StarOriginY = STARFIELD_ORG_Y+24;
		StarMaxY = STARFIELD_B+48;
		}
	else
		{
		StarOriginY = STARFIELD_ORG_Y;
		StarMaxY = STARFIELD_B;
		}

	for (i=0; i<MAX_STARS; i++)
		InitStarPosition( i );
	}


/*********************************************************************
 *  FUNCTION:		UpdateStarfield
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void UpdateStarfield()
	{
	int ox, oy;
	int x, y;  

	if(Option.GameMode == gameCLASSIC)
		return;

	if(ActiveStar >= MAX_STARS)
		ActiveStar = 0;

	ox = Star[ActiveStar].X>>4;
	oy = Star[ActiveStar].Y>>4;

	Star[ActiveStar].X += (Star[ActiveStar].Speed*cos1000(Star[ActiveStar].Angle))/1000;
	Star[ActiveStar].Y += (Star[ActiveStar].Speed*sin1000(Star[ActiveStar].Angle))/1000;

	x = Star[ActiveStar].X>>4;
	y = Star[ActiveStar].Y>>4;

	if((ox != x) || (oy != y))
		{
		IMG_Screen[oy][ox] = Star[ActiveStar].OldColor;
		Star[ActiveStar].OldColor = IMG_Screen[y][x];
		}

	if( (x>=StarMaxX) || (x<=0) || (y>=StarMaxY) || (y<=0) )
		InitStarPosition( ActiveStar );
	else
		IMG_Screen[y][x] = Star[ActiveStar].Color.Val;

	Star[ActiveStar].Color.cry.i = MIN(Star[ActiveStar].Color.cry.i+8, 255);

	Star[ActiveStar].Speed = MIN(Star[ActiveStar].Speed+Star[ActiveStar].Accel, 128);

	ActiveStar++;
	}

/*********************************************************************
 *  FUNCTION:		ClearStarfield
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void ClearStarfield( void )
	{
	Blit[BlitAddIndex].Type 	= blitPATTERN;

	Blit[BlitAddIndex].A1_Base  = (long)IMG_Screen;
	Blit[BlitAddIndex].A1_Flags = PITCH1 | PIXEL16 | WID320 | XADDPIX;
	Blit[BlitAddIndex].A1_Pixel = 0x0L;
	Blit[BlitAddIndex].A1_Step 	= (1<<16L)|(-320 & 0x0FFFFL);

	Blit[BlitAddIndex].B_Count 	= (288<<16L) | (320 & 0x0FFFFL);

	Blit[BlitAddIndex].B_Patd 	= 0x0L;
	Blit[BlitAddIndex].B_Cmd 	= PATDSEL | UPDA1;
	
	QueBlit();
	}



