/*******************************************************************
 *
 *    TITLE:        support.c
 *
 *    DESCRIPTION:	B2K support functions
 *
 *    AUTHOR:		Mario Perdue & Richard Degler
 *
 *    HISTORY:    
 *
 *
 *           COPYRIGHT 1994, 1995 MP Graphics Systems         
 *      UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
 *      PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
 *     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
 *                        ALL RIGHTS RESERVED.               
 *******************************************************************/

/** include files **/
#include "\jaguar\include\jaguar.h"
#include "support.h"
#include "player.h"
#include "option.h"
#include "b2k_game.h"

/** external data **/
extern	DEF_PLAYER	Player[];

extern	WORD		SinTab[91];
extern	WORD		CosTab[91];

extern	ULONG		ticks;

extern	DEF_OPTION	Option;

extern	LONG		TITLE_SCORE[];
extern	LONG		OPT_SCORE[];
extern	LONG		PH0_SCORE[];
extern	LONG		PH1_SCORE[];
extern	LONG		PH2_SCORE[];
extern	LONG		PH3_SCORE[];
extern	LONG		PH4_SCORE[];
extern	LONG		PH5_SCORE[];
extern	LONG		PH6_SCORE[];
extern	LONG		PH7_SCORE[];
extern	LONG		PH8_SCORE[];
extern	LONG		PH9_SCORE[];

extern	long	*DoGpuBlit;

/** defines **/
#define M	(long)0xF0000001
#define B	(long)654365821

/** public data **/
long _RandomSeed;

/*char dummy[1];*/
extern	DEF_BLIT_DATA	Blit[];
extern	LONG			BlitAddIndex;
extern	LONG			BlitUseIndex;


int abs( int value)
	{
	if(value<0)
		return(-value);
	else
		return(value);
	}


/** internal functions **/
/*********************************************************************
 *  FUNCTION:		Randomize
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void Randomize(int seed)
	{
	_RandomSeed = abs(seed);
	}
	
/*********************************************************************
 *  FUNCTION:		Random
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	int limit
 *
 *  RETURNS:		void
 *
 *********************************************************************/
int Random(int limit)
	{
	if(limit <= 0)
		return(0);

	_RandomSeed = abs((_RandomSeed*B+1)%M);
	
	return(_RandomSeed%limit);
	}


/*********************************************************************
 *  FUNCTION:		Delay
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	int time
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void Delay( int time )
	{
	ULONG time2;

	time2 = ticks;

	while(ticks < time2+time);
	}

/*********************************************************************
 *  FUNCTION:		ReadJoystick
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	int which
 *
 *  RETURNS:		int - Joypad data
 *
 *********************************************************************/
int ReadJoyStick(int which)
	{
	int rvalue = 0;

	*JOYSTICK = 0x817E;
	
	if(which == PLAYER_RED)	
	 	rvalue = ~(*JOYSTICK) >> 8;
	else
		rvalue = ~(*JOYSTICK) >> 12;

	return(rvalue & 0x0F);
	}

/*********************************************************************
 *  FUNCTION:		ReadJoyButtons
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	int which
 *
 *  RETURNS:		int - Pressed button
 *
 *********************************************************************/
int ReadButtons(int which)
	{
	long jvalue;
	int rvalue = 0;

	*JOYSTICK = 0x817E;
	jvalue = *JOYBUTS;
	if(which == 1)
		jvalue = jvalue >> 2;

	if(!(jvalue & 0x02L))
		rvalue |= BUTTON_A;

	if(!(jvalue & 0x01L))
		rvalue |= BUTTON_PAUSE;
	
	*JOYSTICK = 0x81BD;
	jvalue = *JOYBUTS;
	if(which == 1)
		jvalue = jvalue >> 2;

	if(!(jvalue & 0x02L))
		rvalue |= BUTTON_B;

	*JOYSTICK = 0x81DB;
	jvalue = *JOYBUTS;
	if(which == 1)
		jvalue = jvalue >> 2;

	if(!(jvalue & 0x02L))
		rvalue |= BUTTON_C;

	*JOYSTICK = 0x81E7;
	jvalue = *JOYBUTS;
	if(which == 1)
		jvalue = jvalue >> 2;

	if(!(jvalue & 0x02L))
		rvalue |= BUTTON_OPTION;

	return(rvalue);
	}

/*********************************************************************
 *  FUNCTION:		ReadKeyPad
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	int which
 *
 *  RETURNS:		int - Pressed key
 *
 *********************************************************************/
int ReadKeyPad( int which )
	{
	long jvalue;
	int rvalue = 0;

	/* Read ROW 1 */
	*JOYSTICK = 0x81BD;
	jvalue = ~(*JOYSTICK);
	if(which == 0)
		jvalue = jvalue >> 8;
	else
		jvalue = jvalue >> 12;

	if(jvalue & 0x01L)
		rvalue |= KEYPAD_STAR;
	if(jvalue & 0x02L)
		rvalue |= KEYPAD_7;
	if(jvalue & 0x04L)
		rvalue |= KEYPAD_4;
	if(jvalue & 0x08L)
		rvalue |= KEYPAD_1;

	/* Read ROW 2 */
	*JOYSTICK = 0x81DB;
	jvalue = ~(*JOYSTICK);
	if(which == 0)
		jvalue = jvalue >> 8;
	else
		jvalue = jvalue >> 12;

	if(jvalue & 0x01L)
		rvalue |= KEYPAD_0;
	if(jvalue & 0x02L)
		rvalue |= KEYPAD_8;
	if(jvalue & 0x04L)
		rvalue |= KEYPAD_5;
	if(jvalue & 0x08L)
		rvalue |= KEYPAD_2;

	/* Read ROW 3 */
	*JOYSTICK = 0x81E7;
	jvalue = ~(*JOYSTICK);
	if(which == 0)
		jvalue = jvalue >> 8;
	else
		jvalue = jvalue >> 12;

	if(jvalue & 0x01L)
		rvalue |= KEYPAD_HASH;
	if(jvalue & 0x02L)
		rvalue |= KEYPAD_9;
	if(jvalue & 0x04L)
		rvalue |= KEYPAD_6;
	if(jvalue & 0x08L)
		rvalue |= KEYPAD_3;

	return(rvalue);
	}


/*********************************************************************
 *  FUNCTION:		PlaySound
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	Plays a sound effect 
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void PlaySound(int sound, int volume, int pitch, int prior)
	{
	DEF_FX_PARAM Params;

	if((Option.GameMode == gameCLASSIC) && (Player[PLAYER_RED].Mode != modeTITLE))
		{
		switch(sound)
			{
			case sndPADDLE:
				sound = sndBRICK1;
				pitch = 4;
				break;

			case sndWALL:
				sound = sndBRICK1;
				pitch = 2;
				break;
			
			case sndEXPLODE:
				sound = sndBRICK1;
				pitch = 0;
				break;
			
			case sndSHOOT:
				return;
				break;

			default:
				sound = sndBRICK1;
				pitch = 6;
			}
		}

	Params.Patch  = sound;
	Params.Volume = MIN(volume, 127);
	Params.Pitch  = pitch+36;
	Params.Prior  = MIN(prior, 6);

	SFireEffect(Params);
	}


/*********************************************************************
 *  FUNCTION:		StartMusic
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	Starts a musical score
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void StartMusic(short which)
	{
	LONG *Score;

/*
	if(Option.GameMode == gameCLASSIC)
		return;
*/
	if(!Option.MusicOn)
		return;

	switch(which)
		{
		case songTITLE:
		default:
			Score = TITLE_SCORE;
			break;

		case songPHASE0:
			Score = PH0_SCORE;
			break;

		case songPHASE1:
			Score = PH1_SCORE;
			break;

		case songPHASE2:
			Score = PH2_SCORE;
			break;

		case songPHASE3:
			Score = PH3_SCORE;
			break;

		case songPHASE4:
			Score = PH4_SCORE;
			break;

		case songPHASE5:
			Score = PH5_SCORE;
			break;

		case songPHASE6:
			Score = PH6_SCORE;
			break;

		case songPHASE7:
			Score = PH7_SCORE;
			break;

		case songPHASE8:
			Score = PH8_SCORE;
			break;

		case songPHASE9:
			Score = PH9_SCORE;
			break;
		}

	SSetScore1(Score);
	}


/*********************************************************************
 *  FUNCTION:		StopMusic
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	Stops the musical score
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void StopMusic()
	{
	SSetScore1((long *)-1L);
	}


/*********************************************************************
 *  FUNCTION:		KillSynth
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void KillSynth()
	{
	STurnOff();
	Delay(500);
	}


/*********************************************************************
 *  FUNCTION:		sin1000
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	int angle
 *
 *  RETURNS:		int  Sine * 1000
 *
 *********************************************************************/
int sin1000( int angle )
	{
	angle = angle%360;
	
	switch (angle/90)
		{
		case 0:
		case 1:
			return(-SinTab[angle%90]);
			break;

		case 2:
		case 3:
			return(SinTab[angle%90]);
			break;

		default:
			return(0);
			break;
	  	}
	}

/*********************************************************************
 *  FUNCTION:		cos1000
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	int angle
 *
 *  RETURNS:		int  Cosine * 1000
 *
 *********************************************************************/
int cos1000( int angle )
	{
	angle = angle%360;

	switch (angle/90)
		{
		case 0:
		case 3:
			return(CosTab[angle%90]);
			break;

		case 1:
		case 2:
			return(-CosTab[angle%90]);
			break;

		default:
			return(0);
			break;
	  	}
	}


/*********************************************************************
 *  FUNCTION:		GetDepthScale
 *
 *  PARAMETERS:	    int depth
 *
 *  DESCRIPTION:  
 *
 *  RETURNS:		int  Scale factor for associated Zdepth
 *
 *********************************************************************/
int GetDepthScale(int depth)
	{
	int scale;

	scale = depth*100/TOTAL_RANGE;

	return(MAX(10, scale));
	}

/*********************************************************************
 *  FUNCTION:		QueBlit
 *
 *  PARAMETERS:		void
 *
 *  DESCRIPTION:	
 *
 *  RETURNS:		void
 *
 *********************************************************************/
void QueBlit()
	{
	int TempAddIndex;
	int TempUseIndex;
	int Delta;

	TempAddIndex = BlitAddIndex;
	TempUseIndex = BlitUseIndex;

	Delta = TempUseIndex-TempAddIndex;

	while((Delta == 1) || (Delta == BLIT_ENTRIES-1))
		{
		TempUseIndex = BlitUseIndex;
		Delta = TempUseIndex-TempAddIndex;
		}


	if(++TempAddIndex >= BLIT_ENTRIES)
		TempAddIndex = 0;

	BlitAddIndex = TempAddIndex;
	}


void ExpandLzjag(WORD *Dest, WORD *Src)
	{
	Blit[BlitAddIndex].Type = blitEXPAND;
	Blit[BlitAddIndex].A1_Base = (long)Dest;
	Blit[BlitAddIndex].A2_Base = (long)Src;

	QueBlit();
	}

