/*******************************************************************
 *
 *    TITLE:        support.h
 *
 *    DESCRIPTION:	Header file for support.c
 *
 *    AUTHOR:		Mario Perdue & Richard Degler
 *
 *    HISTORY:    
 *
 *
 *           COPYRIGHT 1994, 1995 MP Graphics Systems         
 *      UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
 *      PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR   
 *     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
 *                        ALL RIGHTS RESERVED.               
 *******************************************************************/

#ifndef __SUPPORT__H
#define __SUPPORT__H

#define NULL			0L

#define LONG			long
#define ULONG			unsigned long

#define WORD			short
#define UWORD			unsigned short

#define UINT			unsigned int

#define BYTE			unsigned char

#define FALSE			0
#define TRUE			1

#define OFF				0
#define ON				1

#define	TRANSPARENT		TRUE
#define OPAQUE			FALSE

#define MAX(a,b)		((a)>(b)?(a):(b))
#define MIN(a,b)		((a)<(b)?(a):(b))

#define LIMIT(a,b,c)	MAX((b),MIN((a),(c)))
#define SIGN(a)			((a)>=(0)?(1):(-1))	  

#define MAX_NAME_LENGTH			16

#define JOYPAD_UP		0x0001
#define JOYPAD_DOWN		0x0002
#define JOYPAD_LEFT		0x0004
#define JOYPAD_RIGHT	0x0008
#define JOYPAD_ANY		0x000F
#define JOYPAD_NONE		0x0000

#define BUTTON_A	  	0x0001
#define BUTTON_B	  	0x0002
#define BUTTON_C	  	0x0004
#define BUTTON_FIRE	  	0x0007
#define BUTTON_OPTION 	0x0008
#define BUTTON_PAUSE  	0x0010
#define BUTTON_ANY		0x001F
#define BUTTON_NONE		0x0000

#define KEYPAD_0		0x0001
#define KEYPAD_1		0x0002
#define KEYPAD_2		0x0004
#define KEYPAD_3		0x0008
#define KEYPAD_4		0x0010
#define KEYPAD_5		0x0020
#define KEYPAD_6		0x0040
#define KEYPAD_7		0x0080
#define KEYPAD_8		0x0100
#define KEYPAD_9		0x0200
#define KEYPAD_STAR		0x0400
#define KEYPAD_HASH		0x0800
#define KEYPAD_RESET	0x0C00
#define KEYPAD_CLEAN	0x000A
#define KEYPAD_ANY		0x0FFF
#define KEYPAD_NONE		0x0000
#define KEYPAD_HIDE		0x000A

#define KEYPAD_BALL		0x002A
#define KEYPAD_SCREEN	0x00C2
#define KEYPAD_PHASE	0x00A2
#define KEYPAD_SUPER	0x0382
#define KEYPAD_CANNON	0x0384
#define KEYPAD_ATTRACT	0x0388
#define KEYPAD_CATCH	0x0390

#define BLIT_ENTRIES	256

enum {LEFT, RIGHT, FRONT, BACK};

enum {sndBRICK1=10, sndBRICK2, sndEXPLODE, sndEXTRA, sndMISS, sndPADDLE,
	  sndSHOOT, sndWALL, sndBALL2BALL, sndBOMB2WALL, sndLOOP, sndBOMB_LAUNCH,
	  sndSTINGER_LAUNCH, sndSTINGER_HIT, sndGOODY_LAUNCH, sndCRACK, sndSHATTER,
	  sndSLAM};

enum {songTITLE, songPHASE0, songPHASE1, songPHASE2, songPHASE3, songPHASE4, 
      songPHASE5, songPHASE6, songPHASE7, songPHASE8, songPHASE9};

enum {blitPATTERN, blitBITMAP, blitSCALED, blitEXPAND, blitSTOP};

typedef struct
	{
	WORD	X;
	WORD	Y;
	} SCREENLOC;

typedef struct
	{
	WORD	X;
	WORD	Y;
	WORD	Z;
	} REALLOC;

typedef struct
	{
	ULONG	Flags;
	WORD	Width;
	WORD	Height;
	WORD	*Image;
	} DEF_IMAGE;


typedef struct
	{
	ULONG	Type;

	ULONG	A1_Base;
	ULONG	A1_Flags;
	ULONG	A1_Clip;
	ULONG	A1_Pixel;
	ULONG	A1_Step;
	ULONG	A1_Fstep;
	ULONG	A1_Fpixel;
	ULONG	A1_Inc;
	ULONG	A1_Finc;

	ULONG	A2_Base;
	ULONG	A2_Flags;
	ULONG	A2_Pixel;
	ULONG	A2_Step;

	ULONG	B_Count;

	ULONG	B_Dstz;
	ULONG	B_Srcz1;
	ULONG	B_Patd;

	ULONG	B_Iinc;

	ULONG	B_Cmd;
	} DEF_BLIT_DATA;

typedef struct
	{
	UINT	Patch	: 16;
	UINT	Volume	: 16;
	UINT	Pitch	: 16;
	UINT	Prior	: 16;
	} DEF_FX_PARAM;

/* Function prototypes */
int abs( int value);

void  	Randomize( int seed );
int   	Random( int limit );

void	Delay( int time );

int   	ReadJoyStick( int which );
int	  	ReadButtons( int which );
int	  	ReadKeyPad( int which );

void	PlaySound( int sound, int volume, int pitch, int prior );
void	StartMusic( short which );
void	StopMusic( void );

int	  	sin1000( int );
int	  	cos1000( int );

int		GetDepthScale( int depth );

void	QueBlit( void );


void 	SFireEffect(DEF_FX_PARAM);
void	SMainVolume(long volume);
void	SSFXVolume(long volume);
void	SSetScore1(LONG *Score);
void	STurnOff( void );

void 	ExpandLzjag(WORD *Dest, WORD *Src);

void	vmemcpy(long *, long *, long);

#endif