;************************************************
; Includes for sound fx player ver 0.01
;
; uses Atari FullSyn. Not a Music Player
;
;
; started 23.11.93      updated 14.12.93
;
; Glenn Williams & Mike Beaton
;
;************************************************

SOUND	equ	1

.macro  audio_mute
	move.w  #0,$f14000 	        ; audio off
.endm

.macro  audio_UNmute
	move.w  #$100,$f14000           ; audio on
.endm

.if !SOUND			; IGNORE THESE
				;
.macro	sfx			;
	clr.l	d0		;
.endm				

.macro	kill_sfx		;
.endm				;

.macro	init_sounds		;
	clr.l	d0		;
.endm				;

;==========================================================

.else				; USE THESE

.macro  sfx sound_name			; play sound. fx_\name is the addr of and extended sound patch
	move.l  a3,-(sp)		; returns d0=neg if error a0=voice table addr
	lea     fx_\sound_name,a3 	; addr of sfx patch
	bsr     do_sfx                  ; trigger sound
	move.l  (sp)+,a3
.endm

.macro  kill_sfx
	move.l	d0,a0			; allows use of d0 for testing quicker
	move.l  #-4,(a0)		; turn off sound
.endm

.macro	init_sounds
	bsr	init_sfx
.endm

.endif
