;*======================================================================*
;*                TITLE:                  JOYPAD.INC                    *
;*                Function:               Joypad bit definitions        *
;*                                                                      *
;*                Project #:              JAGUAR                        *
;*                Programmer:             Rob Zdybel                    *
;*                                                                      *
;*                MODIFIED:               Andrew J Burgess  04/13/93    *
;*                                                                      *
;*              COPYRIGHT 1993 Atari Computer Corporation               *
;*          UNAUTHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,        *
;*          PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR          *
;*        THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.       *
;*                            ALL RIGHTS RESERVED.                      *
;*                                                                      *
;*======================================================================*

	JOYIN		equ	$f14000	;$d1a000 - Felix
	JOYOUT		equ	$f14000	;$d1a000 - Felix

	NUM_PLAYERS	equ	1
;
;	Format = xxAPxxBx RLDU147* xxCxxxOx 2580369#
;
	JOY_UP		equ	20		;joypad
	JOY_DOWN	equ	21
	JOY_LEFT	equ	22
	JOY_RIGHT	equ	23

	FIRE_A		equ	29		;fire buttons
	FIRE_B		equ	25
	FIRE_C		equ	13
	OPTION		equ	9
	PAUSE		equ	28

	KEY_STAR	equ	16		;keypad
	KEY_7		equ	17
	KEY_4		equ	18
	KEY_1		equ	19

	KEY_0		equ	4
	KEY_8		equ	5
	KEY_5		equ	6
	KEY_2		equ	7

	KEY_HASH	equ	0
	KEY_9		equ	1
	KEY_6		equ	2
	KEY_3		equ	3

	ANY_JOY		equ	$00F00000		;and joyedge with this - joypad was pressed if result is not 0
	ANY_FIRE	equ	$22002000		;and joyedge with this - A,B or C was pressed if result is not 0
	ANY_KEY		equ	$000F00FF		;and joyedge with this - 123456789*0# was pressed if result is not 0

	KEY_123		equ	$00080088
	KEY_456		equ	$00040044
	KEY_789		equ	$00020022
	KEY_S0H		equ	$00010011

	KEY_23456	equ	$000400CC
	ANY_NUMBER	equ	$000E00FE

	RESET_ONLY	equ	$00010001
	RESET_STEER	equ	$00C10001		; note these are key masks, which can be used by the masking routines,
							; or for testing for specific key groups
	FIRE_ZERO	equ	$22002010

	PAUSE_OPT	equ	$10000200
	PAUSEx		equ	$10000000

;*======================================================================*
;*                              EOF
;*======================================================================*


