
;=====================================================
;		DEFINITIONS
;=====================================================

Trace_on	equ 1		; 0 = no trace, 1 = trace, 2 = trace and prevent over-shoot
Borders		equ 0
drift		equ 0
shades		equ 0
;shape		equ 2		; 0 = heptagon, 1 = rectangle, 2 = square


; =========================================
;    LOW PAGE STORAGE FROM 4000 UPWARDS 
; =========================================

MBASE		equ $4000

gpucopy		equ MBASE+$0
blitcopy	equ MBASE+$4
gpusem		equ MBASE+$8
blitsem		equ MBASE+$C
gpustop		equ MBASE+$10
screen		equ MBASE+$14	; 0 or 1 for whichever screen is "on"
delay		equ MBASE+$18	; number of skip frames
extra		equ MBASE+$1C
background	equ MBASE+$20

; leave space for plenty more variables

; delay counters for waiting for the GPU
gcx		equ $4200

obj_list	equ $4800	; list is v.small anyway - allow up to $5000
normal_table	equ $5000	; to be removed because may as well use the points in situ.
point_3d	equ $6000	; thereby allowing up to 256 points maximum
point_2d	equ $7000	; 

;================================
;  ADDITIONAL GPU VALUES
;================================

Gpu_data	equ $F03C00	; for transfers to GPU programs
Gpu_flag	equ $F03FFC	; for control systems

;================================
; MAJOR STORAGE BLOCKS
;================================

Trace_table	equ $60000
Stack 		equ $80000	; got to put it somewhere I s'pose . . .
obj_store	equ $400000	; miles way - shouldn't be a problem. size will be large though - 
				; allow 60000 for z buffering with double buffering of full screen
;================================
;  EXTRA BITS
;================================

objx  		equ 0		; object position on screen (object, not cube or car)
objy  		equ 0
objw  		equ 320		; width, which is 10*32 bits = 5 phrases, giving 0100.01 in the object data area
objh  		equ 200		; height - full screen - these will have to be optimized later
xoff  		equ 0		; x offset to apply to place a point in plain 2d space into screen space for this object.
yoff  		equ 0		; y offset - these may be unused now, but they'll have to be in later, so not removed.
basez		equ 256		; projection value = effective screen Z depth

