; macros for menu system !

; initial data :	Object definition address (long)
;			Display subroutine address (long)

; Commands :		(generally bytes)

exit_menu	equ	0	; Do_quit	;
rle_decode	equ	1	; Do_rle	; followed by rle_no.b,addr.l
reloc_3d	equ	2	; Do_3d		; followed by 3d_no.b
button_setup	equ	3	; Do_init	; followed by button size.b and highlight offset.w
light_button	equ	4	; Do_lite	; followed by button_no.b
key_test	equ	5	; Do_key	; followed by offset.b,key_mask.l - offset is for skipping to next entry
off_button	equ	6	; Do_dull	; to ensure buttons are changed back when released
next_option	equ	7	; Do_next	; option button number to roll forward
last_option	equ	8	; Do_last	; ditto backward
new_obj		equ	9	; Do_new_3d	; change 3d object - object_no.b,new_addr.l
add_obj		equ	10	; Do_add_3d	; modify object choice
set_var		equ	11	; Do_set	; value.b,var_addr.w
add_var		equ	12	; Do_add	; value.b,var_addr.w	- note signed will work
min_var		equ	13	; Do_min	; value.b,var_addr.w	- if variable too low then ignore key
max_var		equ	14	; Do_max	; ditto / high
new_menu	equ	15	; Do_menu	; finish this screen and move on to next one - needs address.l
redo_button	equ	16	; Do_again	; go back to start of this one, and re_test for keys
go_button	equ	17	; Do_but	; button_no.b,addr.l - both light and start to process a button
screen_on	equ	18	; Do_screen	; set object list and start displaying
add_var_obj	equ	19	; Do_var_obj	;
add_var_but	equ	20	; Do_var_but	; apply offset from a variable to a button - for intialising display
light_n_buts	equ	21	; Do_liten
dull_n_buts	equ	22	; Do_dulln
rmw_switch	equ	23	; Do_rmw
zdist		equ	24	; Do_newz	; modify a 3d objects z position
rlp_decode	equ	25	; Do_rlp	; followed by rle_no.b,ouput addr.l,palette addr.l
rmw_make	equ	26	; Do_make_rmw
rlp_v_decode	equ	27	; Do_rlpv	; followed by rle_no.b,var.w,addr.l,addr.l
numeric_display	equ	28	; Do_numeric
key_repeat	equ	29	; Do_key_rep
hangup		equ	30	; Do_halt
button_ypos	equ	31	; Do_ypos
abc_button	equ	32	; Do_abc
const_button	equ	33	; Do_const_but
key_num		equ	34	; Do_num	; actually tests any single key and can replace most uses of Do_key
cmp_var		equ	35	; Do_test	; specific check for a single number
sequence	equ	36	; Do_sequence	; special long string reader
set_var_but	equ	37	; Do_set_var_but ; sets variable and adjusts button appropriately !
switch_mode	equ	38	; Do_switch_mode
numeric_single	equ	39	; Do_digit	; signle digit version of Do_numeric
set_var_but_var	equ	40	; Do_set_var_but_var	; special for dealing with tournament problems
copy_var	equ	41	; Do_copy_var

.macro	Do_make_rmw
	dc.b	rmw_make,0
.endm

.macro	Do_halt
	dc.b	hangup,0
.endm

.macro	Do_rmw	but1,but2,but3,but4,but5,but6,but7,but8,but9
	dc.b	rmw_switch
	multi_byte \but1,\but2,\but3,\but4,\but5,\but6,\but7,\but8,\but9
	dc.b	-1
.even		; required to prevent certain other codes going haywire
.endm

.macro	multi_byte but1,but2,but3,but4,but5,but6,but7,but8,but9
.if	\?but1
	dc.b	\but1
	multi_byte \but2,\but3,\but4,\but5,\but6,\but7,\but8,\but9
.endif
.endm

.macro	Do_rle	rle,addr
	dc.b	rle_decode,\rle
	dc.l	\addr
.endm

.macro	Do_rlp	rlp,addr,pal
	dc.b	rlp_decode,\rlp
	dc.l	\addr,\pal
.endm

.macro	Do_rlpv	rlp,var,addr,pal
	dc.b	rlp_v_decode,\rlp
	dc.w	\var
	dc.l	\addr,\pal
.endm

.macro	Do_3d	x3d
	dc.b	reloc_3d,\x3d
.endm

.macro	Do_lite	but
	dc.b	light_button,\but
.endm

.macro	Do_liten but1,but2,but3,but4,but5,but6,but7,but8,but9
	dc.b	light_n_buts
	multi_byte \but1,\but2,\but3,\but4,\but5,\but6,\but7,\but8,\but9
	dc.b	-1
.even
.endm

.macro	Do_key	offst,mask
	dc.b	key_test,\offst-*
	dc.l	\mask
.endm

.macro	Do_key_rep	offst,mask
	dc.b	key_repeat,\offst-*
	dc.l	\mask
.endm

.macro	Do_num	offst,bit
	dc.b	key_num,\offst-*
	dc.w	\bit
.endm

.macro	Do_dull but
	dc.b	off_button,\but
.endm

.macro	Do_dulln but1,but2,but3,but4,but5,but6,but7,but8,but9
	dc.b	dull_n_buts
	multi_byte \but1,\but2,\but3,\but4,\but5,\but6,\but7,\but8,\but9
	dc.b	-1
.even
.endm

.macro	Do_next	but
	dc.b	next_option,\but
.endm

.macro	Do_last	but
	dc.b	last_option,\but
.endm

.macro	Do_ypos	but,ypos
	dc.b	button_ypos,\but
	dc.w	\ypos
.endm

.macro	Do_new_3d	obj,addr
	dc.b	new_obj,\obj
	dc.l	\addr
.endm

.macro	Do_newz	obj,dist
	dc.b	zdist,\obj
	dc.l	\dist
.endm

.macro	Do_add_3d	obj,count
	dc.b	add_obj,\obj
	dc.w	\count
.endm

.macro	Do_set	value,variable
	dc.b	set_var,\value
	dc.w	\variable
.endm

.macro	Do_add	value,variable
	dc.b	add_var,\value
	dc.w	\variable
.endm

.macro	Do_min	value,variable
	dc.b	min_var,\value
	dc.w	\variable
.endm

.macro	Do_max	value,variable
	dc.b	max_var,\value
	dc.w	\variable
.endm

.macro	Do_test	value,variable
	dc.b	cmp_var,\value
	dc.w	\variable
.endm

.macro	Do_menu	addr
	dc.b	new_menu,0
	dc.l	\addr
.endm

.macro	Do_again
	dc.b	redo_button,0
.endm

.macro	Do_but	but,but2,addr
	dc.b	go_button,\but
	dc.w	\but2
	dc.l	\addr
.endm

.macro	Do_screen	object,routine
	dc.b	screen_on,0
	dc.l	\object,\routine
.endm

.macro	Do_init		but_size,high_size,but_s2,high_s2
	dc.b	button_setup,\but_size
	dc.w	\high_size,\but_s2,\high_s2
.endm

.macro	Do_var_obj	obj,var
	dc.b	add_var_obj,\obj
	dc.w	\var
.endm

.macro	Do_var_but	but,var
	dc.b	add_var_but,\but
	dc.w	\var
.endm

.macro	Do_set_var_but	but,var,val
	dc.b	set_var_but,\but
	dc.w	\var,\val
.endm

.macro	Do_set_var_but_var	but,var,var2
	dc.b	set_var_but_var,\but
	dc.w	\var,\var2
.endm

.macro	Do_copy_var	var,var2
	dc.b	copy_var,0
	dc.w	\var,\var2
.endm

.macro	Do_const_but	but,val
	dc.b	const_button,\but
	dc.w	\val
.endm

.macro	Do_quit
	dc.b	exit_menu,0
.endm

.macro	Do_numeric	but,var
	dc.b	numeric_display,\but
	dc.w	\var
.endm

.macro	Do_digit	but,var
	dc.b	numeric_single,\but
	dc.w	\var
.endm

.macro	Do_abc		but1,but2,but3,var
	dc.b	abc_button,\but1
	dc.w	\var
	dc.b	\but2,\but3
.endm

.macro	entry	address			; macro for entering relocatable addresses
	dc.w	\address-basic
.endm

.macro	Do_sequence	offst,variable,string
	dc.b	sequence,\offst-*
	dc.w	\variable
	dc.l	\string
.endm

.macro	Do_switch_mode
	dc.b	switch_mode,0
.endm
