; macro definition for automated message generation, including storage of message within RAM,
; and call to debugger using trap #5, and everything necessary to allow normal continuation
; simply using 'g'

.macro	message text,var		; note that text will be ended with a zero 
.text
	movem.l	d0-d2/a0-a1,-(sp)
	move.l	#msd\~,-(a7)
	move.w	#$F000,-(a7)		; if zero ending not required, use F0xx where xx is length in bytes
	move.w	#$5,-(a7)		; but this would mean more work !
	move.w	#$B,-(a7)
	trap	#$E
	adda.w	#$A,a7
	movem.l	(sp)+,d0-d2/a0-a1
	rts				; always use as a subroutine, so that normal continuation can occur

.data
.long
msd\~:	dc.b	\text,0			; my data segment is in RAM after being relocated at startup
					; and is needed there for the message modification system

.iif \?var,	\var	equ	msd\~	; clever bit - if you need to know where the message is, give it a variable name
					; and it puts the address in that variable with an equ
.long
.text
.endm


; ================================================
; how to use - suppose you have a data checking routine, and want it to notify any inconsistencies ...


; loop:	test data
;	branch if ok to dbra
;	stack	d0-d2/a0-a1
;	modify message if needed, using for example HEX routine
;	bsr to Message
;	pop	d0-d2/a0-a1
; dbra: dbra to loop
; remainder of checking routine
; rts
; Message: message "Data inconsistency"

; and remember to put the include in !

; Note for Andrew - you could do your x,y coordinates with something like this ...

; in the keypad response routines, add an extra one eg:

; xy:	btst	#KEY_8,d0
;	beq.b	do_nowt
;	movem.l	d0-d2/a0-a1,-(sp)
;	move.l	xcoord,d0
;	movea.l	#msg_xy+4,a0
;	bsr	HEX
;	move.l	ycoord,d0
;	movea.l	#msg_xy+19,a0
;	bsr	HEX
;	bsr	showxy
;	movem.l	(sp)+,d0-d2/a0-a1
;
; do_nowt: rest of keypad routine

;	rts	; end of routine

; showxy:	message	"X = 00000000   Y = 00000000",msg_xy


; this would give a message showing the long x/y co-ordinates, so you will need to change
; things if they are only words !
