; GPU & DSP REGISTERS (TOM & JERRY)
;

; GPU ADDRESSES
GPU_FLAGS 	equ	BASE + $2100	; GPU Flags
GPU_MTXC	equ	BASE + $2104	; GPU Matrix Control
GPU_MTXA	equ	BASE + $2108	; GPU Matrix Address
GPU_END		equ	BASE + $210c	; GPU Data Organization
GPU_PC		equ	BASE + $2110	; GPU Program Counter
GPU_CTRL	equ	BASE + $2114	; GPU Operation Control/Status
GPU_HIDATA 	equ	BASE + $2118	; GPU Bus Interface high data
GPU_REMAIN 	equ	BASE + $211c	; GPU Division Remainder
GPU_DIVCTRL 	equ	BASE + $211c	; DSP Divider control

; FLAGS REGISTER BIT MASKS & BIT NUMBERS
ZERO_FLAG	equ	1<<0
CARRY_FLAG	equ	1<<1
NEG_FLAG	equ	1<<2
IMASK		equ	1<<3
INT_ENA0	equ	1<<4
INT_ENA1	equ	1<<5
INT_ENA2	equ	1<<6
INT_ENA3	equ	1<<7
INT_ENA4	equ	1<<8
INT_CLR0	equ	1<<9
INT_CLR1	equ	1<<10
INT_CLR2	equ	1<<11
INT_CLR3	equ	1<<12
INT_CLR4	equ	1<<13
REGPAGE		equ	1<<14
DMAEN		equ	1<<15

B_ZERO_FLAG	equ	0
B_CARRY_FLAG	equ	1
B_NEG_FLAG	equ	2
B_IMASK		equ	3
B_INT_ENA0	equ	4
B_INT_ENA1	equ	5
B_INT_ENA2	equ	6
B_INT_ENA3	equ	7
B_INT_ENA4	equ	8
B_INT_CLR0	equ	9
B_INT_CLR1	equ	10
B_INT_CLR2	equ	11
B_INT_CLR3	equ	12
B_INT_CLR4	equ	13
B_REGPAGE	equ	14
B_DMAEN		equ	15

; CONTROL REGISTER BIT MASKS & BIT NUMBERS

GPU_GO		equ	1<<0
CPU_INT		equ	1<<1
GPU_INT0	equ	1<<2
SINGLE_STEP	equ	1<<3
SINGLE_GO	equ	1<<4
; bit 5 - unused
INT_LAT0	equ	1<<6
INT_LAT1	equ	1<<7
INT_LAT2	equ	1<<8
INT_LAT3	equ	1<<9
INT_LAT4	equ	1<<10
BUS_HOG		equ	1<<11
VERSION		equ	$f<<12

B_GPU_GO	equ	0
B_CPU_INT	equ	1
B_GPU_INT0	equ	2
B_SINGLE_STEP	equ	3
B_SINGLE_GO	equ	4
; bit 5 - unused
B_INT_LAT0	equ	6
B_INT_LAT1	equ	7
B_INT_LAT2	equ	8
B_INT_LAT3	equ	9
B_INT_LAT4	equ	10
B_BUS_HOG	equ	11
B_VERSION	equ	12


; DSP ADDRESSES
;
DSP_FLAGS	equ	BASE + $1A100	; DSP Flags
DSP_MTXC	equ	BASE + $1A104	; DSP Matrix Control
DSP_MTXA	equ	BASE + $1A108	; DSP Matrix Address
DSP_END		equ	BASE + $1A10c	; DSP Data Organization
DSP_PC		equ	BASE + $1A110	; DSP Program Counter
DSP_CTRL	equ	BASE + $1A114	; DSP Operation Control/Status
DSP_HIDATA 	equ	BASE + $1A118	; DSP Bus Interface high data
DSP_REMAIN 	equ	BASE + $1A11c	; DSP Division Remainder
DSP_DIVCTRL 	equ	BASE + $1A11c	; DSP Divider control

; DSP NAMES FOR CONTROL BITS
DSP_GO		equ	GPU_GO
DSP_INT0	equ	GPU_INT0

B_DSP_GO	equ	B_GPU_GO
B_DSP_INT0	equ	B_GPU_INT0

; EXTRA DSP FLAGS REGISTER BIT MASKS & BIT NUMBERS
INT_ENA5	equ	1<<16
INT_CLR5	equ	1<<17

B_INT_ENA5	equ	16
B_INT_CLR5	equ	17

; EXTRA DSP CONTROL REGISTER BIT MASKS & BIT NUMBERS
INT_LAT5	equ	1<<16

B_INT_LAT5	equ	16

; OTHER JERRY ADDRESSES
;

; should not set these
;;CLK1		equ	BASE + $10010	; System Clock Frequency
;;CLK2		equ	BASE + $10012	; Video Clock Frequency
;;CLK3		equ	BASE + $10014	; Chroma clock control - SHOULD NOT USE THIS

JPIT1		equ	BASE + $10000	; Timer 1 prescaler - WRITE
JPIT2		equ	BASE + $10002	; Timer 1 Divider - WRITE
JPIT3		equ	BASE + $10004	; Timer 2 prescaler - WRITE
JPIT4		equ	BASE + $10006	; Timer 2 divider - WRITE

JPIT1_R		equ	BASE + $10036	; Timer 1 prescaler - READ
JPIT2_R		equ	BASE + $10038	; Timer 1 Divider - READ
JPIT3_R		equ	BASE + $1003A	; Timer 2 prescaler - READ
JPIT4_R		equ	BASE + $1003C	; Timer 2 divider - READ

JINT		equ	BASE + $10020	; JERRY CPU interrupt control

DAC1		equ	BASE + $1a140	; left DAC
DAC2		equ	BASE + $1a144	; right DAC

SCLK		equ	BASE + $1A150	; serial clock frequency - write only
SMODE		equ	BASE + $1A154	; serial mode
SSTAT		equ	BASE + $1A150	; serial status - read only

LTXD		equ	BASE + $1A148	; left transmit data - write only
RTXD		equ	BASE + $1A14C	; right transmit data - write only

LRXD		equ	BASE + $1A148	; left receive data - read only
RRXD		equ	BASE + $1A14C	; right receive data - read only

; these addresses don't make sense
;ASICLK		equ	BASE + $10030	; R/W
;ASICTRL	equ	BASE + $10030	; WO
;ASISTAT	equ	BASE + $10032	; RO
;ASIDATA	equ	BASE + $10030	; R/W

;	ROM Tables built into Jerry 128 samples
;	16 bit samples sign extended to 32
;
ROM_TABLE   	equ	BASE + $1D000	; Base of tables
TRI     	equ	BASE + $1D000	; Triangle wave
SINE    	equ	BASE + $1D200	; Full amplitude SINE
AMSINE  	equ	BASE + $1D400	; Linear (?) ramp SINE
SINE12W 	equ	BASE + $1D600	; SINE(X)+SINE(2*X)
CHIRP16 	equ	BASE + $1D800	; SHORT SWEEP
NTRI    	equ	BASE + $1DA00	; Triangle w/NOISE
DELTA   	equ	BASE + $1DC00	; Positive spike
NOISE   	equ	BASE + $1DE00	; White noise
