; This is the file containing macro calls for the Chequered Flag / Red Line Racer game sound system.

.extern	InitSynth
.extern	StartMusic
.extern AudioMute
.extern AudioUNMute
.extern	StopMusic
.extern DoEffect
.extern	KillAll
.extern	KillSfx
.extern	ModSfx

.extern	FX_tst2
.extern	FX_engine
.extern	FX_skid
.extern	FX_crash
.extern	slength

; list of score address start
.extern	ST_inarctic
.extern	ST_incanyon
.extern	ST_indesert
.extern	ST_inriver
.extern	ST_ingreen
.extern	ST_indeep
.extern	ST_ingorge
.extern	ST_incoastal
.extern	ST_inhole
.extern	ST_inisland
.extern	ST_song0
.extern ST_tarctic
.extern	ST_tcanyon
.extern	ST_tdesert
.extern	ST_tgreen
.extern	ST_tdeep
.extern	ST_tgorge
.extern	ST_tcoastal
.extern	ST_thole
.extern	ST_tisland
.extern	ST_hiscore
.extern	ST_maintit2

; list of score address end
.extern	END_inarctic
.extern	END_incanyon
.extern	END_indesert
.extern	END_inriver
.extern	END_ingreen
.extern	END_indeep
.extern	END_ingorge
.extern	END_incoastal
.extern	END_inhole
.extern	END_inisland
.extern	END_song0
.extern END_tarctic
.extern	END_tcanyon
.extern	END_tdesert
.extern	END_tgreen
.extern	END_tdeep
.extern	END_tgorge
.extern	END_tcoastal
.extern	END_thole
.extern	END_tisland
.extern	END_hiscore
.extern	END_maintit2

; list of music names for addresses of instrument tables
.extern	MS_inarctic
.extern	MS_incanyon
.extern	MS_indesert
.extern	MS_inriver
.extern	MS_ingreen
.extern	MS_indeep
.extern	MS_ingorge
.extern	MS_incoastal
.extern	MS_inhole
.extern	MS_inisland
.extern	MS_song0
.extern	MS_tarctic
.extern	MS_tcanyon
.extern	MS_tdesert
.extern	MS_tgreen
.extern	MS_tdeep
.extern	MS_tgorge
.extern	MS_tcoastal
.extern	MS_thole
.extern	MS_tisland
.extern	MS_hiscore
.extern	MS_maintit2

.offset	$94000
PATCHTAB:	ds.l	12*20
sfxsamples:	ds.l	20000
smusic:		ds.l	15000
instrsamples:	ds.l	40000

.text

.macro	init_sounds
.if use_sound=1
	jsr	InitSynth	; download synthesiser and music data
.endif
.endm

.macro	start_music	score
.if use_sound=1
	move.l	#MS_\score,a0
	move.l	#ST_\score,a5
	move.l	#END_\score,d4	; end of score
	jsr	StartMusic	; start or restart music
.endif
.endm

.macro	stop_music
	jsr	StopMusic	; stop music playing but allow sound effects
.endm

.macro	audio_mute
	jsr	AudioMute	; turn off all sound to speakers
.endm

.macro	audio_UNmute
	jsr	AudioUNMute	; restore sound to speakers
.endm	


.macro	sfx	name, vol, pan, channel
.if use_sound=1
	movem.l	a0-a4/d1-d4,-(sp)		
	.if	\?pan
	move.l	#\pan,d2
	.else
	move.l	#$3fff,d2		; no pan specified so use centred
	.endif
	
	.if 	\?vol
	move.w	#\vol,d1
	.else
	move.w	#$3fff,d1	; no volume so assume a usable value
	.endif

	.if	\?channel
	move.l	#\channel,d3
	.else
	moveq	#0,d3
	.endif

	move.l	#FX_\name,d0	; name should correspond to one of the equates above
	
	jsr	DoEffect
	movem.l	(sp)+,a0-a4/d1-d4
				; return identifier is is d0. -1 means not played. Anything else can be passed to kill_sfx below.
.endif
.endm

.macro	mod_sfx	ident,pitch,vol	; modulate sound effect <ident> or d0 to new pitch value in <pitch> or d1
.if use_sound=1
	movem.l	a0-a1/d0-d3,-(sp)
	.if	\?ident
	move.l	\ident,d0
	.endif

	.if	\?pitch
	move.l	\pitch,d1

	.if	\?vol
	move.l	\vol,d2
	.else
	moveq	#0,d2
	.endif

	.endif

	jsr	ModSfx
	movem.l	(sp)+,a0-a1/d0-d3
.endif
.endm

.macro	kill_all
.if use_sound=1
	jsr	KillAll
.endif
.endm

.macro	kill_sfx	ident
.if use_sound=1
	movem.l	a0-a1/d0-d1,-(sp)
	
	.if	\?ident		; if ident is specified then search for this else assume ident already in d0
	move.l	\ident,d0
	.endif

	jsr	KillSfx
	movem.l	(sp)+,a0-a1/d0-d1
.endif
.endm
