; offset definitions for ai data blocks

.offset 0	; start from zero - start of block

TGT_X:	ds.l	1	; point in world that car is aiming for
TGT_Z:	ds.l	1	; 
TGT_Y:	ds.w	1	; direction wanted when reach that point
TGT_S:	ds.w	1	; segment being aimed at
VELOC:	ds.l	1	; current speed
V_DIR:	ds.w	1	; current direction of movement
SKILL:	ds.w	1	; ability level
STATS:	ds.b	1	; status
LAPS:	ds.b	1	; current laps completed
SEGS:	ds.w	1	; current segment car is on
LTIME:	ds.w	1	; time lap started at [from 'counter']
LBEST:	ds.w	1	; best lap time for this car so far
FTIME:	ds.l	1	; finishing time - since this must be available for results
		; increased ftime to long to accomodate the 99 laps case - could be over an hour !!! (big stuff)

ai_block_size::	ds.w	1	; gives length of block in bytes

; numeric specifics

num_cars	equ	6	; do not change without reference to vardefs.s
min_distance	equ	30000	; minimum distance to target segment
max_distance	equ	10000	; maximum distance for discarding other cars
crash_dist	equ	1000	; distance at which collision is deemed to have occurred
top_speed	equ	600
top_accel	equ	80
top_brake	equ	60	; was 160, but cars stopped very fast
max_steps	equ	80	; allow approx 2 seconds of look ahead - more makes accuracy drop too much
max_steer	equ	30
; status values - maximum $f because saving upper nibble for flags

.offset 0			; only effecting lower four bits hence status bits below
waiting:	ds.b	1	; this will be status until race starts
racing:		ds.b	1	; this is the only one which needs work by ai routine
crashing:	ds.b	1	; this won't happen yet, but when it does, it will have its on routine
out_of_it:	ds.b	1	; status if a car gets wrecked etc
won_it:		ds.b	1	; winner
finished:	ds.b	1	; finisher - probably will require a separate routine for this and the above, to get out of way.
human:		ds.b	1	; player controlled
parked:		ds.b	1	; new status

; status flags - bit numbers

.offset 4		; not used thankfully
GO_LEFT:	ds.b	1	; flags to show current steering status, so that the three different
GO_RIGHT:	ds.b	1	; forms - start, continue, stop - can be produced
ACCEL:		ds.b	1	; also hold the acceleration / braking status so that 
BRAKE:		ds.b	1	; heavy braking can be allowed

; direction flags - not in each block, just one copy whilst deciding where to go

.offset	0



