; since so many addresses need to be phrase or long aligned, this short code section will test them all

.text

TEST::

	move.l	#End_of_bss,d0
	cmpi.l	#MOBJ,d0
	bls.b	.ok1
	bsr.b	MSG2

.ok1:	move.l	#End_of_data,d0
	cmpi.l	#Genstr-$80,d0
	bls.b	.ok2
	bsr.b	MSG3

.ok2:	move.w	#ai_block_size,d0
	cmpi.w	#32,d0
	beq.b	.ok3
	bsr.b	MSG4

.ok3:	movea.l	#blad,a0	; address of block of data

.and:	move.l	(a0)+,d0

.loop:	move.l	(a0)+,d1
	beq.b	.and
	bmi.b	.ex
	and.l	d0,d1
	beq	.loop
	move.l	-(a0),d0		; recover data pointer which failed into d0 for message display
	movea.l	#msgpt1+37,a0
	bsr	HEX			; write hex value into message
	bsr.b	MSG1
	bra	.loop
.ex:	rts

MSG2:	message	"BSS segment too long - change memory settings"
MSG3:	message	"Data segment too long - change memory settings"
MSG4:	message	"A.I. block size incorrect"
MSG1:	message	"Alignment failure in 3d data 00000000",msgpt1

;==================================
HEX:	; routine to put hex value in d0 into ASCII format starting at address in a0
	; not stacked anything, because I assume this will only be used in error routines,
	; which will have to stack everything first in order to be recoverable.

	moveq.l	#7,d1			; count for nibbles
	movea.l	#.htab,a1

.nib:	moveq.l	#$F,d2			; mask
	and.b	d0,d2			; get one nibble
	lsr.l	#4,d0			; shift down for next
	move.b	(a1,d2),-(a0)
	dbra	d1,.nib

	rts

.htab:	dc.b	'0123456789ABCDEF'
;=================================

blad:	dc.l	7	; test phrase alignment
	dc.l	Blob1,charcs,Zeroph,spdpt,pospt,RainA,MOBJ
	dc.l	0,3	; test long alignment
	dc.l	pcarfront,ncarfront
	dc.l	pnewcar,nnewcar,fnewcar
	dc.l	pf1car2,nf1car2,ff1car2
	dc.l	pwheel,nwheel,fwheel
	dc.l	pf1shadow,ff1shadow
	dc.l	pcar2,ncar2,fcar2

	dc.l	pc1build1,nc1build1,fc1build1
	dc.l	pc1build2,nc1build2,fc1build2
	dc.l	pc1build3,nc1build3,fc1build3
	dc.l	pc1bridge1,nc1bridge1,fc1bridge1
	dc.l	pc1bridge2,nc1bridge2,fc1bridge2
	dc.l	pc1bridge3,nc1bridge3,fc1bridge3

	dc.l	pxtree,nxtree,fxtree
	dc.l	pdtree,ndtree,fdtree
	dc.l	ppalm1,npalm1,fpalm1

	dc.l	photel1,nhotel1,fhotel1
	dc.l	photel2,nhotel2,fhotel2
	dc.l	ptower1,ntower1,ftower1
	dc.l	pmill,nmill,fmill
	dc.l	pwind,nwind,fwind

	dc.l	pwind,nwind,fwind
	dc.l	pbridge3,nbridge3,fbridge3
	dc.l	psatdish,nsatdish,fsatdish
	dc.l	psignr,nsignr,fsignr
	dc.l	psignl,nsignl,fsignl
	dc.l	parrow,farrow
	dc.l	plights,nlights,flights
	dc.l	pshadbr1,fshadbr1
	dc.l	pshadbr3,fshadbr3

	dc.l	plake0,nlake0,flake0
	dc.l	plake1,nlake1,flake1
	dc.l	plake2,nlake2,flake2
	dc.l	plake3,nlake3,flake3
	dc.l	pdlake0,ndlake0,fdlake0
	dc.l	pdlake1,ndlake1,fdlake1
	dc.l	pdlake2,ndlake2,fdlake2
	dc.l	pdlake3,ndlake3,fdlake3

	dc.l	pstravn,pstravm,pstravf
	dc.l	pstrawn,nflat,fstran
	dc.l	pstrawm,fstram
	dc.l	pstrawf,fstraf
	dc.l	pstraqn
	dc.l	pstraxn,pstrayn,pstrazn

	dc.l	pcrnwn20	;,ncornn20,fcornn20
	dc.l	pcrnwn30,ncornn30,fcornn30
	dc.l	pcrnwn40,fcornn40
	dc.l	pcrnwn45,ncornn45,fcornn45
	dc.l	pcrnwn90,ncornn90,fcornn90

	dc.l	spc1x,spc1z,fspec
	dc.l	spc2x,spc2z,spc3x,spc3z
	dc.l	spc4x,spc4z,spc5x,spc5z
	dc.l	spc6x,spc6z,spc7x,spc7z
	dc.l	spc8x,spc8z,spc9x,spc9z
	dc.l	pskid,fskid
	dc.l	pdot,fdot
	dc.l	psignr,nsignr,fsignr
	dc.l	pfence,nfence,ffence
	dc.l	pdbar,ndbar,fdbar
	dc.l	pbarrier,nbarrier,fbarrier
	dc.l	pbar2,nbar2,fbar2
	dc.l	pbar3,nbar3,fbar3
	
	dc.l	psignr,nsignr,fsignr
	dc.l	pfence,nfence,ffence
	dc.l	pbarrier,nbarrier,fbarrier
	dc.l	pdbar,ndbar,fdbar
	dc.l	pbar2,nbar2,fbar2
	dc.l	pbar3,nbar3,fbar3
	dc.l	pdbar2,ndbar2,fdbar2
	dc.l	pdbar3,ndbar3,fdbar3
	dc.l	plsign,nlsign,flsign
	dc.l	prsign,nrsign,frsign
	dc.l	pbar01,nbar01,fbar01
	dc.l	pbar02,nbar02,fbar02
	dc.l	pbar03,nbar03,fbar03
	dc.l	pbar04,nbar04,fbar04
	dc.l	pbar05,nbar05,fbar05
	dc.l	pbar06,nbar06,fbar06
	dc.l	pbar07,nbar07,fbar07
	dc.l	pbar08,nbar08,fbar08
	dc.l	pbar09,nbar09,fbar09
	dc.l	pbar10,nbar10,fbar10
	dc.l	pbar11,nbar11,fbar11
	dc.l	pbar12,nbar12,fbar12
	dc.l	pbar13,nbar13,fbar13
	dc.l	pbar14,nbar14,fbar14
	dc.l	pbar15,nbar15,fbar15

	dc.l	pcut01,ncut01,fcut01
	dc.l	pcut01x,ncut01x,fcut01x
	dc.l	pcut01y,ncut01y,fcut01y
	dc.l	pcut01z,ncut01z,fcut01z
	dc.l	pcut01l,ncut01l,fcut01l
	dc.l	pcut01r,ncut01r,fcut01r
	dc.l	pcut03,ncut03,fcut03
	dc.l	pcut04,ncut04,fcut04
	dc.l	pcut04x,ncut04x,fcut04x
	dc.l	pcut04y,ncut04y,fcut04y
	dc.l	pcut04l,ncut04l,fcut04l
	dc.l	pcut05,ncut05,fcut05
	dc.l	pcut05l,ncut05l,fcut05l
	dc.l	pcut06,ncut06,fcut06
	dc.l	pcut07,ncut07,fcut07

	dc.l	pclif01,nclif01,fclif01
	dc.l	pclif01l,nclif01l,fclif01l
	dc.l	pclif01r,nclif01r,fclif01r

	dc.l	pdhill01,ndhill01,fdhill01
	dc.l	pdhill01l,ndhill01l,fdhill01l
	dc.l	pdhill01r,ndhill01r,fdhill01r
	dc.l	pdhill01x,ndhill01x,fdhill01x
	dc.l	pdhill01y,ndhill01y,fdhill01y
	dc.l	pdhill01z,ndhill01z,fdhill01z

	dc.l	pdhill06,ndhill06,fdhill06

	dc.l	pvhill01,nvhill01,fvhill01
	dc.l	pvhill01l,nvhill01l,fvhill01l
	dc.l	pvhill01r,nvhill01r,fvhill01r
	dc.l	pvhill01x,nvhill01x,fvhill01x
	dc.l	pvhill01y,nvhill01y,fvhill01y
	dc.l	pvhill01z,nvhill01z,fvhill01z

	dc.l	pdmt01,ndmt01,fdmt01
	dc.l	pdmt01x,ndmt01x,fdmt01
	dc.l	pdmt01y,ndmt01y,fdmt01y
	dc.l	pdmt01z,ndmt01z,fdmt01z
	dc.l	pdmt01l,ndmt01l,fdmt01l
	dc.l	pdmt01r,ndmt01r,fdmt01r

	dc.l	paero2,naero2,faero2
	dc.l	paero1,naero1,faero1
	dc.l	pwet,nwet,fwet
	dc.l	pdry,ndry,fdry
	dc.l	pauto,nauto,fauto
	dc.l	psteer,nsteer,fsteer
	dc.l	pmanual,nmanual,fmanual
	dc.l	psatlite,nsatlite,fsatlite

	dc.l	pcarpet01,fcarpet01
	dc.l	pcarpet02
	dc.l	pcarpet03,fcarpet03
	dc.l	pcarpet04
	dc.l	pcarpet05
	dc.l	pcarpet06
	dc.l	pcarpet07
	dc.l	pcarpet08

.iif use_sound=1,	dc.l	FX_tst2			; all sound effects must be long aligned for the DSP !

	dc.l	-1
