; colours for CRY objects with sensible names

upext		=	$FFFF0000	; to prevent "16 bit overflow" errors from colours with high bit set

wheel		==	$3877		; dark grey
wheel1		==	$2877		; very dark grey
black		==	$3077
black0		==	$3077
black1		==	$2077
black2		==	$1077
black3		==	$0077
interior	==	$8077 + upext	; medium grey

shadow		==	$D000 + upext	; darkening poly 
shadow_pale	==	$e800 + upext	; much less obvious darkening for see-through look

;=====================================================
;option screen car colours are darker than real ones

optcar		==	$1077 		; black
optcar2		==	$d0f0 + upext	; red

optcar_1	==	$6400 		; blue
optcar2_1	==	$ffff + upext	; yellow

optcar_2	==	$ff77 + upext	; white
optcar2_2	==	$808f + upext	; green (dark)

optcar_3	==	$d0f0 + upext	; red
optcar2_3	==	$ff77 + upext	; white

optcar_4	==	$908f + upext	; green (medium-dark)
optcar2_4	==	$c400 + upext	; blue

optcar_5	==	$fff9 + upext	; orange
optcar2_5	==	$ff77 + upext	; white

optcar_d	==	shadow_pale
optcar2_d	==	shadow_pale

;====================================================
; these are the real (in game) ones

car		==	$1077 		; black
car2		==	$f0f0 + upext	; red

car_1		==	$ff00 + upext	; blue
car2_1		==	$ffff + upext	; yellow

car_2		==	$ff77 + upext	; white
car2_2		==	$c08f + upext	; green (dark)

car_3		==	$f0f0 + upext	; red
car2_3		==	$ff77 + upext	; white

car_4		==	$f08f + upext	; green (medium-dark)
car2_4		==	$d400 + upext	; blue

car_5		==	$fff9 + upext	; orange
car2_5		==	$ff77 + upext	; white

carmid		==	$d0F0 + upext	; red
carfar		==	$d0F0 + upext	; red
redish		==	$c0F0 + upext	; almost pure red
dred		==	$a0F0 + upext
helmet		==	$808f + upext	; dark green
visor		==	$4000		; very dark blue - for helmet
strut		==	$b077 + upext

pp1		==	$ffFf + upext	; yellow
pp2		==	$ff8F + upext	; green
pp3		==	$fff8 + upext	; orange
pp4		==	$ff80 + upext	; magenta
pp5		==	$ff88 + upext	; white
pp6		==	$c400 + upext	; dark blue
pp7		==	$d0F0 + upext	; red
pp8		==	$ff0f + upext	; cyan

track		==	$3888 		; white
track1		==	$3088 		; white
track2		==	$3488 		; white
track3		==	$3c88 		; white
skid		==	$e000 + upext	; darkening, to give better effect
;grass		==	$8daa + upext	; green/brown
grass		==	$808b + upext	; green/brown
grass1		==	$f0cF + upext	; yellow/green
grass2		==	$8f4F + upext	; blue/green
grass3		==	$ff8b + upext	; light green
pgreen		==	$808e + upext	; green to match the flat plain
meadow		==      $906E + upext	; dark green
lake		==	$9a19 + upext	; medium blue 
lake2		==	$942a + upext	; medium blue 
sea		==	$9a27 + upext	; like sea colour
sea2		==	$9428 + upext	; medium sea csolour
lake0		==	$8006 + upext	; medium blue - old version

lightsea	==	$a047 + upext
darksea		==	$9035 + upext

trunk		==	$90FC + upext	; brown

fence		==	$F077 + upext	; lite grey

bridge		==	$80a8 + upext	; sandy
palm		==	$d0FC + upext	; light brown
palm1		==	$d0FC + upext	; light brown
palmtree	==	$d0FC + upext	; light brown
cup		==	$FCff + upext
wood		==	$A0FA + upext
baize		==	$906C + upext
hill		==      $d0fc + upext	; 
hill1		==      $909e + upext	; 
hill2		==      $988e  + upext	; 
hill3		==      $908e + upext	; 
hill4		==      $a08e + upext	; 
hillbig		==	$a08e + upext	; 

build		==	$A088 + upext
build1		==	$A088 + upext
build2		==	$A088 + upext
build3		==	$A098 + upext
build4		==	$A098 + upext
build5		==	$A098 + upext
build6		==	$A098 + upext
build11		==	$7077

clif3		==	$c0a9 + upext
clif4		==	$c0a9 + upext

grey40		==	$4088
grey50		==	$5088
grey80		==	$8088 + upext
grey90		==	$9088 + upext
greyA0		==	$A088 + upext
greyB0		==	$B088 + upext
greyC0		==	$C088 + upext

gray80		==	$8087 + upext
gray90		==	$9087 + upext
grayA0		==	$A087 + upext
grayB0		==	$B087 + upext
grayC0		==	$C087 + upext

gren80		==	$808a + upext
gren90		==	$908a + upext
grenA0		==	$A08a + upext
grenB0		==	$B08a + upext
grenC0		==	$C08a + upext

Prism		==	$6077
aero		==	$d0F0 + upext
sat		==	$9077 + upext
f1		==	$d0F0 + upext
wheel2		==	$4077
wheel3		==	$4077
wheel4		==	$4077

paint		==	$D0DD + upext


yellow		==	$FFFF + upext
myellow		==	$E0FF + upext
dyellow		==	$c0FF + upext

blue		==	$FF00 + upext
mblue		==	$e000 + upext
dblue		==	$c000 + upext


bar1		==	$FF77 + upext
mbar1		==	$E077 + upext
dbar1		==	$c077 + upext

bar2		==	$4077
mbar2		==	$3077
dbar2		==	$2077

white		==	$FF77 + upext
mwhite		==	$e077 + upext
dwhite		==	$c077 + upext

mwayblue	==	$D000 + upext

earth		==	$30e5
brown		==	palm

roof		==	$6096
walls		==	$a069 + upext
red		==	pp7
darkred		==	$20f0
softred		==	$50f0
halfred		==	$80f0 + upext
magenta		==	$ff80 + upext

metal_blue	==	$4024
lite_blue	==	$8024 + upext
orange		==	pp3
dorange		==	$d0f8 + upext
olight		==	$fffa + upext	;$ffc4 + upext
olight2		==	$fffa + upext
tunconc		==	$50ca
tunconc2	==	$30ca
track1t		==	$1888;ca 		; tunnel track surface - darker
track2t		==	$1c88;ca 		; 
track3t		==	$2088;ca
linet		==	$8088 + upext 		; white
jagice		==	white	;$ff66 + upext
pyramid		==	$a0b9 + upext
bluegrey	==	$ff57 + upext

gold		==	$fffc + upext
cactus		==	$b0be + upext

darkwood	==	$40da
oak		==	$c0b9 + upext
bird		==	$40da
bird2		==	$70da
deadwood	==	$7098
bone		==	$d899 + upext
horn		==	$f888 + upext
pterosaur	==	$80b7 + upext
luminous	==	$ffbf + upext
rustred		==	$60f2

; temp colours

green   == pp2
darkgreen	==	$208f
aerob	== car
aerof	== car2
exhaust	== redish
top	== car
head	== helmet
bod	== car
whbl	== wheel1
whbr	== wheel1
whfl	== wheel1
whfr	== wheel1
stbl	== strut
stbr	== strut
stfl	== strut
stfr	== strut
bodl	== car
bodr	== car
bodb	== car
bodf	== car

c1walls		==	$c0a8 + upext
c1wallsdark	==	$80a8 + upext
c1wallsdarker	==	$40a8
c1windows	==	$30e5
CIR2 == white

; colours for track maps and other intro items

basecol		==	black1
skirtcol	==	softred
trackcol	==	dred

facefr		==	greyC0
clocknum	==	metal_blue
clockhand	==	white
facebk		==	black0
clockedge	==	black0
clockbut	==	gold

sattop		==	gold
satpole		==	gold
satdome		==	greyC0
satbody1	==	grey80
satbody2	==	grey80
satbody3	==	halfred
satbody4	==	grey80
satbar		==	greyC0
sattip		==	trunk	; same as gold but darker
letters		==	black3

; colours for people

torso		==	metal_blue
armr		==	metal_blue
arml		==	metal_blue
legl		==	black0
legr		==	black0
manhead		==	$c0a7 + upext
girlskin	==	$a0b8 + upext	; attempted sun tan
girlhair	==	$d0cc + upext	; attempted blonde
bikini		==	$d08c + upext

; Palette driven colours - mostly for scenery

flame		==	Palette		; glowing changing red on back of exhaust

redlight1	==	Palette+$2	; upper lights - red
redlight2	==	Palette+$4	; upper lights - red
redlight3	==	Palette+$6	; upper lights - red
redlight4	==	Palette+$8	; upper lights - red
greenlight	==	Palette+$a	; lower lights - green


groundfill	==	Palette+$10	;variable by track - this is the ground fill colour, so some additional code is required for this
tree1		==	Palette+$12	;$a08f + upext	; light green
clif1		==	Palette+$14	;$a88b + upext	; greenish colours for hills
clif2		==	Palette+$16	;$a08b + upext
sandbank	==	Palette+$18	;$909a + upext
sandy		==	Palette+$1a	;$80b8 + upext
mount1		==	Palette+$1c
mount2		==	Palette+$1e
track_build	==	Palette+$20
stad_wall	==	Palette+$22
stad_seats	==	Palette+$24
stad_support	==	Palette+$26
warn1		==	Palette+$28
warn2		== 	Palette+$2a
bridgecol	==	Palette+$2c
dbridgecol	==	Palette+$2e

wheelx		==	Palette+$30
wheely		==	Palette+$32
wheelx2		==	Palette+$34
wheely2		==	Palette+$36
edging		==	Palette+$38
marking		==	Palette+$3a
rededge		==	Palette+$3c
lights		==	Palette+$3e

; proper cry colours used elsewhere

raincol		==	$00f2
