; new demo code - almost identical to real game code

Demo::

	moveq	#1,d0
	move.b	d0,display_mode.w	; instruct to use blit for sky, not object
	bsr	Request_3d

	moveq.l	#2,d0			; delay time
	move.w	d0,delay.w
	move.w	d0,perspective.w	; 2 is most extreme possible - 0 is more 'real'

	moveq	#6,d1
	move.b	d1,real_num_drones	; this may have to be 6
	st.b	demo_mode.w
	bsr	Randx
	move.b	d0,grid_position.w	; controls which car is being followed

	bsr	prepare_grid_allocations

	moveq	#5,d1
	move.w	d1,program_area.w
	bsr	Randx
	addq.w	#1,d0
	move.w	d0,view_last.w
	move.b	d0,view_wants.w
	clr.l	viewmove

	moveq	#10,d1
	bsr	Randx			; get random track number
	bsr	Track_init
	bsr	Twrite

	move.l	d0,d2			; keep track code safe
	moveq	#3,d1
	bsr	Randx
	move.l	d0,d1			; use weather in d1
	move.l	d2,d0			; and track in d0
	bsr	Sky_expand
	bsr	palette_install
	bsr	Weather_init
	move.l	d1,d0			; and have weather back for this
	bsr	Weather_cue

	move.l	#start_light,light_address.w
	bsr	init_light		; get light colours ready BEFORE drawing the first frame !
	bsr	initialise_ai

	bsr	Horizon_height		; make sure we don't get a grassy screen
	bsr	Obj_blank		; clear a screen (the offscreen)
	bsr 	Draw			; draw into it
	bchg.b	#3,screen+3.w		; flip screen number
.wt:	tst.l	blitsem.w		
	bne.b	.wt

	movea.l	#ObjDef1,a0
	bsr	ObjSetup		; switch on display
	bsr	readpad
	bsr	Flightinit
	bsr	start_race		; allows cars to start moving

	move.w	#3000,start_count.w	; countdown	
Demoloop:
	bsr	Flightpath
	bsr	spark_cycle		; +	deal with animation cycle for sparks - moved here to allow first frame to show !!
	bsr	get_a1_a2		; 	prepare pointers
	bsr	copy_data		; 	moves current car positions to a store where they can be read later by collision stuff
	bsr	Collision		; 1	perform collision event duties
	bsr	readpad
	bsr	AI			; c.100 note this screws up current segment, which is then reinstated
	bsr	front_wheel_roll	; +	make wheels roll in animated 3d
	bsr	Spark_follow		; +	move sparks to behind car
	bsr	segment_effects		; +6	modify anything that needs it due to current segment status
	bsr	car_on_car		; 6	test for collision between all types of car

	move.w	6(a1),d0		; 	sort out the cars direction 
	neg	d0			; 	NOTE uses MINUS the direction
	bsr	get_sine
	move.w	d1,xspd.w		; 	sine d0
	move.w	d2,zspd.w		; 	cos d0 
	move.l	d1,Gpu_xspd
	move.l	d2,Gpu_zspd
	move.l	#60000,splim.w

	bsr	Viewpoint
	bsr	test_twist		; added to ensure camera doesn't jerk
	bsr	Shadow			; 2	move cars shadow so it follows car
	bsr	FX
	bsr	ResetKey
	bsr	Horizon_height		; <1
	bsr	Display_routine
	bsr	pclip2			; 100	perform collision detection

	movea.w	#(reset_list+Rono+9),a0		; get address of rain object, 'first pixel' byte
	bsr	Rand1				; get random (word) number in d0
	bset.l	#0,d0				; make sure release is left on
	move.b	d0,(a0)	

	move.w	framect.w,d0
	sub.w	d0,start_count.w
	bpl.b	.nto
	moveq	#0,d0			; force eq so won't go into game
	rts

.nto:	move.l	joy_cur.w,d0
	and.l	#ANY_FIRE,d0
	beq	Demoloop
	rts
