;==============================================
; Variable space reservations for Dennis's code
;==============================================

.bss

crash_pointer::	ds.l	1
engine_sound::	ds.l	1
;speed::	ds.l	1
tcx::		ds.l	1
tcz::		ds.l	1
lateral_z::	ds.l	1
lateral_x::	ds.l	1
z_offset::	ds.l	1
x_offset::	ds.l	1
yaw_velocity::	ds.w	1
frame_count::	ds.w	1
;car_yaw::	ds.w	1
;car_roll::	ds.w	1
;car_pitch::	ds.w	1
last_view::	ds.w	1
crash_type::	ds.w	1
car_sine::	ds.w	1
car_cos::	ds.w	1
true_speed::	ds.w	1
understeer::	ds.w	1
gear_offset::	ds.w	1
;joy_count::	ds.w	1	; (reserve 1 word)
steer::		ds.w	1	; (reserve 1 word)
car_angle::	ds.w	1	; (reserve 1 word)
wheel_rotate::	ds.w	1	; steering wheel angle
braking_effectiveness::	ds.w	1
speed_adjustment::	ds.w	1
engage_clutch_at_revs::	ds.w	1
swing_camera_angle::	ds.w	1
swing_camera::	ds.w	1
sine_a_temp::	ds.w	1
cosine_a_temp::	ds.w	1
car_direction::	ds.w	1	;@ new
radius_temp::	ds.w	1
tyre_factor::	ds.b	1
clutch::	ds.b	1
last_turn::	ds.b	1
crash_flag::	ds.b	1
start_crash::	ds.b	1	;@ new
gear_type::	ds.b	1
steering_direction::	ds.b	1
camera_lock_switch::	ds.b	1
accelerator_pressed::	ds.b	1
brake_pressed::		ds.b	1
cruise_pressed::	ds.b	1
gear_up_pressed::	ds.b	1
gear_down_pressed::	ds.b	1

;==========================================
;  Initialized data in data segment
;==========================================

up_gear_limit		==	12500
down_gear_limit		==	11000
brake_gear_limit	==	12000
limit_difference	equ	up_gear_limit-down_gear_limit
brake_difference	equ	up_gear_limit-brake_gear_limit

gear_ratio_1		equ	12500/80;12500/117;revs/speed;	106
gear_ratio_2		equ	12500/100;12500/135;revs/speed;	92
gear_ratio_3		equ	12500/120;12500/147;revs/speed;	85
gear_ratio_4		equ	12500/140;12500/158;revs/speed;	79
gear_ratio_5		equ	12500/160;12500/168;revs/speed;   74
gear_ratio_6		equ	12500/184;12500/184;revs/speed;	70

auto_gear_1		equ	12500/70
auto_gear_2		equ	12500/95
auto_gear_3		equ	12500/120
auto_gear_4		equ	12500/145
auto_gear_5		equ	12500/185

.data

gear_acceleration_table::
	dc.w	350*3	;300	;gear 1
	dc.w	90*3	;60	;gear 2
	dc.w	57*3	;37	;gear 3
	dc.w	50*3	;30	;gear 4
	dc.w	45*3	;25	;gear 5
	dc.w	37*3	;17	;gear 6

gear_decceleration_table::
	dc.w	gear_ratio_1*brake_difference/600	;gear 1
	dc.w	gear_ratio_2*brake_difference/700	;gear 2
	dc.w	gear_ratio_3*brake_difference/800	;gear 3
	dc.w	gear_ratio_4*brake_difference/900	;gear 4
	dc.w	gear_ratio_5*brake_difference/1000 	;gear 5
	dc.w	gear_ratio_6*brake_difference/1100 	;gear 6

automatic_gear_brake_table::
	dc.w	gear_ratio_1*brake_difference/70	;100	;gear 1
	dc.w	gear_ratio_2*brake_difference/140	;260	;gear 2
	dc.w	gear_ratio_3*brake_difference/100	;220	;gear 3
	dc.w	gear_ratio_4*brake_difference/100;85	;180	;gear 4
	dc.w	gear_ratio_5*brake_difference/95;70	;140 	;gear 5
	dc.w	gear_ratio_6*(13500-down_gear_limit)/90;60	;110	;gear 6

manual_gear_brake_table::
	dc.w	530	;530	;gear 1
	dc.w	280	;119	;gear 2
	dc.w	360	;193	;gear 3
	dc.w	360;400	;219	;gear 4
	dc.w	360;500	;264 	;gear 5
	dc.w	360;580	;300;2234	;gear 6
	
gear_ratios_table::
	dc.w	gear_ratio_1	;gear 1
	dc.w	gear_ratio_2	;gear 2
	dc.w	gear_ratio_3	;gear 3
	dc.w	gear_ratio_4	;gear 4
	dc.w	gear_ratio_5	;gear 5
	dc.w	gear_ratio_6	;gear 6

auto_gear_ratios_table::
	dc.w	auto_gear_1
	dc.w	auto_gear_2
	dc.w	auto_gear_3
	dc.w	auto_gear_4
	dc.w	auto_gear_5


auto_gear_change_up_ratio_table::	; this is used to generate new revs when auto transmission switches gear
	dc.w	0
	dc.w	256*auto_gear_2/auto_gear_1
	dc.w	256*auto_gear_3/auto_gear_2
	dc.w	256*auto_gear_4/auto_gear_3
	dc.w	256*auto_gear_5/auto_gear_4

auto_gear_change_down_ratio_table::
	dc.w	256*auto_gear_1/auto_gear_2
	dc.w	256*auto_gear_2/auto_gear_3
	dc.w	256*auto_gear_3/auto_gear_4
	dc.w	256*auto_gear_4/auto_gear_5
	dc.w	0

auto_gear_change_brake_revs_table::
	dc.w	brake_gear_limit/gear_ratio_2*gear_ratio_1
	dc.w	brake_gear_limit/gear_ratio_3*gear_ratio_2
	dc.w	brake_gear_limit/gear_ratio_4*gear_ratio_3
	dc.w	brake_gear_limit/gear_ratio_5*gear_ratio_4
	dc.w	brake_gear_limit/gear_ratio_6*gear_ratio_5
	dc.w	0

steer_amounts::			; how much to turn the wheel when holding down the button
	dc.w	3
	dc.w	3
	dc.w	5
	dc.w	6
	dc.w	5
	dc.w	3
	dc.w	3
	dc.w	2
	dc.w	1
	dc.w	1
	dc.w	1
	dc.w	1
	dc.w	1
	dc.w	1
	dc.w	1
	dc.w	1
	dc.w	1
	dc.w	1
	dc.w	0



.if 1
steer_limit_table::
	dc.w	50;70	;10
	dc.w	55;69	;20
	dc.w	60;68	;30
	dc.w	65;82	;40
	dc.w	70;81	;50
;	dc.w	80	;60
;	dc.w	79	;70
;	dc.w	78	;80
;	dc.w	76	;90
;	dc.w	75	;100
;	dc.w	75	;110
;	dc.w	70	;120
;	dc.w	65	;130
;	dc.w	60	;140
;	dc.w	55	;150
;	dc.w	50	;160
;	dc.w	45	;170
;	dc.w	40	;180
;	dc.w	35	;190
;	dc.w	30	;200
;	dc.w	25	;210
	dc.w	20	;220
.rept 30
	dc.w	20;	;220
.endr
.else
steer_limit_table::
	dc.w	80;70	;10
	dc.w	80;69	;20
	dc.w	80;68	;30
	dc.w	80;82	;40
	dc.w	80;81	;50
	dc.w	70;	;60
	dc.w	60;	;70
	dc.w	50;	;80
	dc.w	40;	;90
	dc.w	30;	;100
	dc.w	20;	;110
	dc.w	20;	;120
	dc.w	20;	;130
	dc.w	20;	;140
	dc.w	20;	;150
	dc.w	20;	;160
	dc.w	20;	;170
	dc.w	20;	;180
	dc.w	20;	;190
	dc.w	20;	;200
	dc.w	20;	;210
.endif
steer_turn_table::	
	dc.w	5;20	;10
	dc.w	5;50	;20
	dc.w	5	;30
	dc.w	92	;40
	dc.w	91	;50
	dc.w	89	;60
	dc.w	87	;70
	dc.w	85	;80
	dc.w	83	;90
	dc.w	81	;100
	dc.w	79	;110
	dc.w	77	;120
	dc.w	75	;130
	dc.w	73	;140
	dc.w	71	;150
	dc.w	69	;160
	dc.w	67	;170
	dc.w	65	;180
	dc.w	63	;190
	dc.w	61	;200
	dc.w	59	;210
	dc.w	57	;220

steer_return_table::	
	dc.w	170	;10
	dc.w	170	;20
	dc.w	170	;30
	dc.w	170	;40
	dc.w	170	;50
	dc.w	165	;60
	dc.w	160	;70
	dc.w	155	;80
	dc.w	150	;90
	dc.w	145	;100
	dc.w	140	;110
	dc.w	135	;120
	dc.w	130	;130
	dc.w	125	;140
	dc.w	120	;150
	dc.w	115	;160
	dc.w	110	;170
	dc.w	105	;180
	dc.w	100	;190
	dc.w	95	;200
	dc.w	90	;210
	dc.w	85	;220

;@ replace entire crash list with this version :

crash_list::
	dc.l	crash_0
	dc.l	crash_1
	dc.l	crash_2
	dc.l	crash_3
	dc.l	crash_4
	dc.l	crash_5
	dc.l	crash_6
	dc.l	crash_7
	dc.l	crash_8
	dc.l	crash_9
	dc.l	crash_10
	dc.l	crash_11
	dc.l	crash_12
	dc.l	crash_13
	dc.l	crash_14
	dc.l	crash_15
	dc.l	crash_0			; because of wrap around problems - why make life hard !

crash_0:
	dc.w	128,0,50,-0		; complex roll sideways together with a spin that ends up 
	dc.w	128,0,45,-700		; pointing 90 degrees away from the start direction
	dc.w	128,0,40,-1400
	dc.w	128,0,35,-1900
	dc.w	128,0,30,-1700
	dc.w	128,0,25,-1200
	dc.w	128,0,20,-800
	dc.w	128,0,10,-400

;	dc.w	128,0,80,-0
;	dc.w	96,0,75,-500
;	dc.w	96,0,70,-1000
;	dc.w	96,0,65,-1500
;	dc.w	96,0,60,-2000
;	dc.w	96,0,55,-1500
;	dc.w	96,0,20,-1000
;	dc.w	96,0,15,-500
;	dc.w	96,0,10,-00
;	dc.w	64,0,5,-200
;	dc.w	64,0,5,-100

	dc.w	64,0,3,0
	dc.w	-64,0,2,-50

	dc.w	$8002
	dc.w	64,0,1,-20
	dc.w	-64,0,1,-20
	dc.w	-64,0,1,-20

	dc.w	32,0,0,-20
	dc.w	32,0,0,-20
	dc.w	32,0,0,-20

	dc.w	-32,0,0,-20
	dc.w	-16,0,0,-20
	dc.w	16,0,0,-20
	dc.w	8,0,0,-20
	dc.w	-8,0,0,-20
	dc.w	-8,0,0,-20
	dc.w	8,0,0,-20
	dc.w	4,0,0,-20
	dc.w	-4,0,0,-20
	dc.w	-2,0,0,-10
	dc.w	2,0,0,0
	dc.w	$8000

crash_1:
	dc.w	25,0,$8,-0	;roll/pitch/yaw slight lift and spin 11.25 degrees
	dc.w	0,0,$8,-0
	dc.w	-25,0,$8,-0
	dc.w	-10,0,$8,-0
	dc.w	$8002
	dc.w	10,0,0,-0
	dc.w	5,0,0,-0
	dc.w	-10,0,0,-0
	dc.w	10,0,0,-0
	dc.w	-5,0,0,-0
	dc.w	$8000
	
crash_2:dc.w	15,0,$10,-0		; simple lift to one side and spin 16.875 degrees
	dc.w	-25,0,$10,-0
	dc.w	20,0,$10,-0
	dc.w	$8002
	dc.w	-15,0,0,-0
	dc.w	10,0,0,-0
	dc.w	-10,0,0,-0
	dc.w	5,0,0,-0

	dc.w	$8000

crash_3:
	dc.w	20,0,$18,-0 		;roll/pitch/yaw simple lift and spin 30 degrees [@860 = $35c]
	dc.w	0,0,$18,-0		; not sure I like this one - perhaps the spin should be less
	dc.w	0,0,$18,-0
	dc.w	-35,0,$18,-0
	dc.w	25,0,$18,-0
	dc.w	-17,0,$18,-0
	dc.w	12,0,$18,-0
	dc.w	-5,0,$18,-0

	dc.w	$8000

crash_4:
 	dc.w	128,0,0,-300	; an elegant sideways roll, without changing direction
	dc.w	128,0,0,-900	; ideal for high speed almost straight on collisions
	dc.w	128,0,0,-1500	; but perhaps too slow ??
	dc.w	128,0,0,-1800
	dc.w	128,0,0,-1500
	dc.w	128,0,0,-900
	dc.w	128,0,0,-300
	dc.w	96,0,0,0	; -32

	dc.w	96,0,0,-20	; +64
	dc.w	-48,0,0,-20	; +16
	dc.w	-48,0,0,-20	; -32
	dc.w	24,0,0,-20	; -8
	dc.w	24,0,0,-20	; +16
	dc.w	$8002

	dc.w	-12,0,0,-20	; +4
	dc.w	-12,0,0,-20	; -8
	dc.w	6,0,0,-20	; -2
	dc.w	6,0,0,-20	; +4
	dc.w	-3,0,0,-20	; +1
	dc.w	-3,0,0,-20	; -2
	dc.w	2,0,0,0		; 0
	dc.w	$8000

crash_5:
;	dc.w	$20,0,0,-100	; attempt at a corner roll - lifting onto each wheel in turn
;	dc.w	$20,-$20,0,-200
;	dc.w	-$20,-$20,0,-200
;	dc.w	-$20,$20,0,-200
;	dc.w	-$20,$20,0,-200
;	dc.w	-$20,$20,0,-200
;	dc.w	$20,$20,0,-200
;	dc.w	$20,-$20,0,-200
;	dc.w	$10,-$20,0,-100

	dc.w	$10,0,0,-150
	dc.w	$10,-$10,0,-200
	dc.w	-$10,-$10,0,-200
	dc.w	-$10,$10,0,-200
	dc.w	-$8,$10,0,-200
	dc.w	-$8,$8,0,-100
	dc.w	$8,$8,0,-100
	dc.w	$8,-$8,0,-100
	dc.w	0,-$8,0,0

	dc.w	$8000

crash_6:
	dc.w	20,0,0,-100	;roll/pitch/yaw gentle side to side rocking motion
;	dc.w	20,0,0,-100	; probably ideal for slow collisions
	dc.w	10,0,0,-150
	dc.w	-10,0,0,-100
;	dc.w	-20,0,0,-100
	dc.w	-20,0,0,-50
	dc.w	-10,0,0,-100
	dc.w	$8002

	dc.w	5,0,0,-50
	dc.w	10,0,0,-50
;	dc.w	5,0,0,-100
;	dc.w	-5,0,0,-100
	dc.w	-5,0,0,-50
	dc.w	-5,0,0,-50
	dc.w	5,0,0,-50
;	dc.w	-4,0,0,-100
;	dc.w	4,0,0,-100
	dc.w	$8000

crash_7:
	dc.w	16,$40,0,-400	; spectacular roll along 4 wheels
	dc.w	32,$50,0,-700
	dc.w	48,$60,0,-900
	dc.w	64,$70,0,-1100
	dc.w	48,$80,0,-1100
	dc.w	32,$70,0,-1100
	dc.w	16,$60,0,-1100
	dc.w	-16,$50,0,-1100
	dc.w	-24,$40,0,-900
	dc.w	-48,$40,0,-700
	dc.w	-72,$40,0,-400
	dc.w	-96,$40,0,-0
	dc.w	$8002

	dc.w	-20,0,0,100
	dc.w	20,0,0,100
	dc.w	20,0,0,100
	dc.w	-20,0,0,0

	dc.w	$8000

crash_8:
	dc.w	-128,0,60,-0	; another sideways roll with spin, leaving you 120 degrees from direction started
	dc.w	-128,0,50,-300
	dc.w	-128,0,45,-900
	dc.w	-128,0,40,-1500
	dc.w	-128,0,35,-1800
	dc.w	-128,0,30,-1500
	dc.w	-128,0,24,-900
	dc.w	-128,0,19,-300

	dc.w	-64,0,3,-100
	dc.w	64,0,2,-100

	dc.w	48,0,1,-50
	dc.w	-48,0,0,-50
	dc.w	$8002

	dc.w	-32,0,0,-50
	dc.w	32,0,0,-50

	dc.w	16,0,0,-20
	dc.w	-16,0,0,-20
	dc.w	-8,0,0,-20
	dc.w	8,0,0,-20
	dc.w	4,0,0,-20
	dc.w	-4,0,0,-0
	dc.w	$8000

crash_9:
	dc.w	$50,-$20,0,-160		; Robs patent nose lift and spin and drop - very balletic
	dc.w	$60,-$30,0,-450		; no change of direction
	dc.w	$70,-$40,0,-800		;120
	dc.w	$80,-$50,0,-1150	;1a0
	dc.w	$90,$20,0,-500		;230
	dc.w	$a0,$30,0,-150		;2d0
	dc.w	$b0,$40,0,-230		;380
	dc.w	$90,$50,0,-160		;410
	dc.w	-$20,$20,0,-100		;3f0
	dc.w	$10,-$20,0,0		;400
	dc.w	$8000

crash_10:
	dc.w	0,$80,0,-780		; reasonable straight line nose-tail roll with nice bounce at end
	dc.w	0,$80,0,-1100
	dc.w	0,$80,0,-1100
	dc.w	0,$80,0,-1100
	dc.w	0,$80,0,-1100
	dc.w	0,$80,0,-1100
	dc.w	0,$80,0,-1100
	dc.w	$8002
	dc.w	0,$80,0,-780
	dc.w	0,$40,0,-420
	dc.w	0,-$60,0,-320
	dc.w	0,$40,0,-320
	dc.w	0,-$40,0,-160
	dc.w	0,$20,0,0
	dc.w	$8000

crash_11:
	dc.w	0,0,$40,0		; test flat spin
	dc.w	0,0,$40,0
	dc.w	0,0,$40,0
	dc.w	0,0,$40,0
	dc.w	0,0,$40,0
	dc.w	0,0,$40,0
	dc.w	0,0,$40,0
	dc.w	$8002
	dc.w	0,0,$40,0
	dc.w	0,0,$40,0
	dc.w	0,0,$40,0
	dc.w	0,0,$40,0
	dc.w	0,0,$40,0
	dc.w	0,0,$40,0
	dc.w	0,0,$40,0
	dc.w	0,0,$40,0
	dc.w	0,0,$40,0
	dc.w	$8000

crash_12:
	dc.w	0,0,$8,-0	;roll/pitch/yaw slight lift and spin 11.25 degrees
	dc.w	0,0,$8,-0
	dc.w	0,0,$8,-0
	dc.w	0,0,$8,-0
	dc.w	$8000
	
crash_13:dc.w	0,0,$10,-0		; simple lift to one side and spin 16.875 degrees
	dc.w	0,0,$10,-0
	dc.w	0,0,$10,-0
	dc.w	$8000

crash_14:
	dc.w	0,0,$18,-0 		;roll/pitch/yaw simple lift and spin 30 degrees [@860 = $35c]
	dc.w	0,0,$18,-0		; not sure I like this one - perhaps the spin should be less
	dc.w	0,0,$18,-0
	dc.w	$8000

crash_15:
	dc.w	0,0,0,0
	dc.w	$8000

