; bits of stuff for what happens after the game has finished

;===============================================================

.text

GameOver::

	bsr	blackout		; clear screen, prepare for unfade, let keys restart
	cmp.b	#1,race_type.w		; check for free practice
	bne.b	.more			; free practice doesn't allow best lap times, as they should only
	rts				; count under race conditions

.more:	bsr	tie_breaker
	move.l	race_timer.w,time_stopped.w
	clr.l	viewmove.w		; flicker prevention
	bsr	readpad			; not used yet, but prevents non-edge skipping

	movea.l	#Exdisp,a0		; most stuff is same for both race types
	movea.l	#winrace,a1
	movea.l	#winpal,a2
	bsr	rlpin			; fill background (always same)
	bsr	title_setup		; sets lighting and perspective values
	RunGPU	12			; install new perspective value etc	
	bsr	clearin			; clears overlays, starts display, unfades

	moveq	#2,d0
	bsr	Request_3d		; get the 3d object data for intro screens
	bsr	Mwrite			; set up 3d data
	clr.w	Genstr+40+4		; stop spin
	moveq	#0,d0
	move.l	d0,key_mask.w
	move.b	winner.w,d0
	movea.w	#grid_colour0,a0
	move.b	(a0,d0.w),d0		; get colour
	muls	#20,d0
	add.l	#Ncar,d0
	move.l	d0,Genstr+$44
	lea	Movement_data-*-2(PC),a0
	move.w	(a0)+,d0
	bsr	place_object

.lp:	bsr	move_to_next
	dbra	d0,.lp

	movea.l	#Mapdisp,a0		; get the font required for stats screen.
	move.l	#fontaz,a1
	move.l	#fontpal,a2
	bsr	rlpin

	moveq	#120,d1
	bsr	Wait_time
	not.l	key_mask.w
	move	#1800,d1
	bsr	Wait_time
	bsr	Fade

	moveq	#67,d0			; mini car graphics
	bsr	rldin

	movea.l	#ObjDef9,a0
	bsr	ObjSetup
	moveq	#0,d0
	moveq	#0,d1
	bsr	CLUT_write
	bsr	Fade_find
	moveq	#0,d3			; new using d3 to flag the blitter for solid blits

	movea.l	#cockpit+$1e00,a0	; for placing heading

	tst.b	race_type.w		; check for single race
	bne.b	.tourn

	moveq	#32,d0
	bsr	rldin
	lea	Testtext-*-2(PC),a0	; stuff to print
	bra.b	.show

.tourn:	moveq	#33,d0
	bsr	rldin
	lea	Tourtext-*-2(PC),a0	
	addq.b	#1,tourn_track.w	; moved to here to ensure that correct results are printed

.show:	movea.l	#cockpit,a1		; screen to print to
	bsr	Print_some		; outputs the headings for the results screen
	bsr	Print_results		; self correcting for race type
	bsr	Best_lap		; checks if you got best lap, and if so prints text, and sets a flag

	moveq	#0,d0
	bsr	Roll_object_up

	tst.b	best_lap.w
	beq.b	.skp

	moveq	#1,d3
	bsr	Fame_name_set		; get address prepared for data entry
	bsr	Name_entry		; assuming we always do this at the same co-ordinates, so not pre-set
	bsr	cart_refill
	moveq	#0,d0
	bsr	Roll_object_down
	movea.l	#cockpit,a1		; screen to print to
	bsr	cleartext
	bsr	Print_fame
	moveq	#0,d0
	bsr	Roll_object_up		

.skp:	moveq	#120,d1
	bsr	Wait_time
	bne.b	.exit	

.lp2:	bsr	readpad
	bsr	FX
	bsr	ResetKey
	move.l	#ANY_FIRE,d0
	and.l	joy_edge.w,d0
	beq	.lp2

.exit:	bsr	Fade
	cmp.b	#2,race_type.w
	bne	.nex
	cmp.b	#10,tourn_track.w
	bne	.nex

	movea.l	#Exdisp,a0		; most stuff is same for both race types
	clr.b	tourn_track.w		; because the tournament is over
	moveq	#66,d0
	bsr	rldin			; get tournament win screen
	move.w	#$06b0,BG
	bsr	clearin			; clears text and goes into appropriate screen

	moveq	#2,d0
	bsr	Request_3d		; get the 3d object data for intro screens
	bsr	Mwrite			; set up 3d data
	clr.w	Genstr+40+4		; stop spin
	moveq	#0,d0
	move.l	d0,key_mask.w

	bsr	get_tour_winners	; returns colour in d0 
	muls	#20,d0
	add.l	#Ncar,d0
	move.l	d0,Genstr+$44
	lea	Movement_data-*-2(PC),a0
	move.w	(a0)+,d0
	bsr	place_object

.lp3:	bsr	move_to_next
	dbra	d0,.lp3

	moveq	#120,d1
	bsr	Wait_time
	not.l	key_mask.w
	move	#1800,d1
	bsr	Wait_time
	bsr	Fade

	move.w	#0,BG

	movea.l	#Mapdisp,a0		; get the font required for stats screen.
	move.l	#fontaz,a1		; AGAIN even though it should be ok
	move.l	#fontpal,a2
	bsr	rlpin

	moveq	#67,d0			; mini car graphics AGAIN
	bsr	rldin

	movea.l	#ObjDef9,a0
	bsr	ObjSetup
	moveq	#0,d0
	moveq	#0,d1
	bsr	CLUT_write
	bsr	Fade_find
	moveq	#0,d3			; new using d3 to flag the blitter for solid blits

	movea.l	#cockpit+$1e00,a0	; for placing heading
	moveq	#33,d0
	bsr	rldin
	lea	Champtext-*-2(PC),a0
	movea.l	#cockpit,a1
	bsr	Print_some		; outputs the headings for the results screen
	bsr	Print_results		; modified version detects that tournament is over and prints tournament points etc
	bsr	All_time		; checks for a top 5 record entry, and if so then sets things up

	moveq	#0,d0
	bsr	Roll_object_up

	tst.b	best_lap.w
	beq.b	.out

	moveq	#1,d3
	movea.l	a2,a0
	bsr	Name_entry
	bsr	cart_refill
	moveq	#0,d0
	bsr	Roll_object_down
	
	movea.l	#cockpit,a1		; screen to print to
	bsr	cleartext
	bsr	Print_top5
	moveq	#0,d0
	bsr	Roll_object_up		

.out:	move.w	#36000,d1
	bsr	Wait_time
	bne	.nex
	moveq	#0,d0
	bsr	Roll_object_down

.nex:	bsr	sync
	bsr	VidOff
	rts

get_tour_winners:			; returns winner in d0 and whilst doing so generates list of positions
	movem.l	a0-a2/d1-d3,-(sp)
	movea.w	#points_colour0,a0
	movea.w	#time_colour0,a1
	movea.w	#pos1_car,a2
	moveq	#5,d2			; loop counter

.lp:	moveq	#0,d0
	move.b	(a0)+,d1
	move.l	(a1)+,d3
	bsr	get_posit		; returns position of this car in d0, so can write the car colour (5-d2) into position
	moveq	#5,d1
	sub.w	d2,d1
	move.b	d1,-1(a2,d0.w)		; -1 is because position 1 car goes in the zero'th byte
	dbra	d2,.lp

	moveq	#0,d0
	move.b	(a2),d0
	movem.l	(sp)+,a0-a2/d1-d3
	rts

get_posit:				; takes d1 points and d3 time and turns into d0 position
	movem.l	a0-a1/d2,-(sp)

	movea.w	#points_colour0,a0
	movea.w	#time_colour0,a1

	moveq	#0,d0			; count number of cars on same or better time/points to give position
	moveq	#5,d2

.lp:	cmp.b	(a0)+,d1
	bgt.b	.dl
	bne.b	.si
	cmp.l	(a1),d3
	blt.b	.dl
.si:	addq.l	#1,d0
.dl:	addq.l	#4,a1
	dbra	d2,.lp

	movem.l	(sp)+,a0-a1/d2
	rts

Best_lap:
	moveq	#0,d0
	move.b	d0,best_lap.w
	move.b	grid_position.w,d0	; get players car thing
	movea.l	#ai_blocks,a2		; point at appropriate ai block
	asl.w	#5,d0			; 
	adda.w	d0,a2			; 
	move.w	LBEST(a2),d1		; get best lap time for player
	beq.b	.not			; don't allow failed times to be used !!!!!
	bmi.b	.not			; and same goes for negatives (which were causing bugs)
	movea.w	#Fame_times,a2
	moveq	#0,d0
	move.b	track_no.w,d0
	asl.w	#1,d0
	adda.w	d0,a2
	move.w	(a2),d0			; read previous best time
	cmp.w	d0,d1
	slt.b	best_lap.w
	bge.b	.not
	move.w	d1,(a2)			; set the best lap time immediately - if you are stupid enough not to enter your name, tuff.
	lea	Besttext-*-2(PC),a0	; stuff to print
	movea.l	#cockpit,a1
	bsr	Print_some

.not:	rts

Fame_name_set:
	movea.l	#Fame_names,a0
	moveq	#0,d0	
	move.b	track_no.w,d0
	asl.w	#3,d0			; eight bytes per entry
	add.l	d0,a0

	rts


All_time:
	movem.l	d0-d2,-(sp)
	moveq	#0,d0			; 
	move.b	d0,best_lap.w		; clear flag
	move.b	car_colour.w,d0		; get car colour
	movea.w	#points_colour0,a0
	move.b	(a0,d0.w),d2		; read cars points
	asl.w	#2,d0
	movea.w	#time_colour0,a0
	move.l	(a0,d0),d1		; read time in case its needed for secondary verification
	movea.w	#Tour_times+16,a0	; point at current best 5, last entry
	movea.w	#Tour_names+32,a1	; point at associated name entry
	movea.w	#Tour_points+4,a2	; and points entry

	cmp.b	(a2),d2			; check this entry
	blt.b	.not			; if less then no entry
	bne.b	.easy
	cmp.l	(a0),d1			; check the time entries if points are the same
	bgt.b	.not			; if time is more then no entry
.easy:	subq.l	#1,a2			; if time is same then allow for generosities sake
	subq.l	#8,a1			; move back, to point at higher entry
	subq.l	#4,a0

	moveq	#3,d0			; loop count

.lp:	cmp.b	(a2),d2
	blt.b	.done			; if less than then previous one is the one to fill
	bne.b	.sim			; if not same then don't have to check time
	cmp.l	(a0),d1
	bgt.b	.done			; if time is more then use previous one
.sim:	move.l	(a0),4(a0)
	move.l	(a1),8(a1)
	move.l	4(a1),12(a1)
	move.b	(a2),1(a2)
	subq.l	#1,a2
	subq.l	#8,a1
	subq.l	#4,a0
	dbra	d0,.lp			; if drop through occurs then we can use top entry, and either way we are pointing above the entry to use

.done:	addq.l	#1,a2
	addq.l	#4,a0
	addq.l	#8,a1

	move.b	d2,(a2)			; write new points value out
	move.l	d1,(a0)			; and time taken
	clr.l	(a1)			; and clear the name ready for data entry
	clr.l	4(a1)
	move.l	a1,a2
	st.b	best_lap.w		; set flag
.not:	movem.l	(sp)+,d0-d2
	tst.b	best_lap.w
	beq.b	.out
	lea	Alltext-*-2(PC),a0
	movea.l	#cockpit,a1
	bsr	Print_some
.out:	rts

blackout:				; switches off screen, and prepares for a fade in from black
	moveq	#-1,d1
	move.l	d1,key_mask.w
;	moveq	#50,d1
;	bsr	Wait_time
	bsr	VidOff
	move.w	#$0080,d0
	moveq	#0,d1
	move.l	d1,ground.w
	move.l	d1,background.w
	move.b	d1,display_mode.w
	bsr	CLUT_write		; set fade stuff to black
	rts

clearin:				; clears overlay screens, and initiates un-fade
	bsr.b	cleartext
	bsr	Obj_blank		; clear a 3d screen (the offscreen)
	bchg.b	#3,screen+3.w		; flip screen number
	movea.l	#ObjDef6,a0
	bsr	ObjSetup
	bsr	Fade_find		; and let it be light (or something)
	bsr	Unfade
	rts

cleartext:
	move.l	#$25800,d0		; one full screen
	move.l	#cockpit,d1		; start of screen
	bsr	Blank			; clear screen for text later
	rts

Roll_object_up::
	movea.w	#reset_list+6,a0	; point at results data y position
	adda.w	d0,a0
	move.w	#130,d1
	tst.b	ntsc_type.w
	bne.b	.lp
	moveq	#112,d1			; pal version doesn't come up so far because it wouldn't be centred
.lp:	sub.w	#32,(a0)		; up two lines (four half lines)
	bsr	sync
	bsr	Keystuff
	dbra	d1,.lp
	rts

Roll_object_down::
	movea.w	#reset_list+6,a0	; point at results data y position
	adda.w	d0,a0
	move.w	#130,d1
	tst.b	ntsc_type.w
	bne.b	.lp
	moveq	#112,d1			; pal version doesn't come up so far because it wouldn't be centred
.lp:	add.w	#32,(a0)		; down two lines (four half lines)
	bsr	sync
	bsr	Keystuff
	dbra	d1,.lp
	rts

calc_time::
	movem.l	d1-d3,-(sp)
	move.w	final_segment.w,d0	; get last track segment (this is really the number of segments)
	moveq	#0,d1
	move.b	qty_laps.w,d1
	mulu	d0,d1			; total number of segments in race
	moveq	#0,d2
	move.b	(a0)+,d2		; read actual laps
	bmi.b	.zero		; 
	bne.b	.ok
	cmp.b	#1,qty_laps.w
	bne.b	.zero
.ok:	mulu	d0,d2
	add.w	(a0)+,d2		; total number of segments traversed so far
	beq.b	.zero			; ZERO PROTECTION

	move.l	time_stopped.w,d0
	move.l	d0,d3
	add.l	#$8000,d3
	swap	d3
	mulu	d1,d0
	mulu	d1,d3
	swap	d3
	add.l	d3,d0
	divu	d2,d0
	swap	d0
	clr.w	d0
	swap	d0
	tst.w	d0
	bra.b	.done

.zero:	moveq	#0,d0
.done:	movem.l	(sp)+,d1-d3
	rts

point_at_ai:				; input grid number d0, output a2 pointing at ai data block
	movea.l	#ai_blocks,a2		; point at appropriate ai block
	asl.w	#5,d0			; for use later on - placed here to minimise code
	adda.w	d0,a2			; in line loop
	asr.w	#5,d0			; rescale to correct size
	rts

convert_to_colour:			; input d0 grid number, output d0 car colour number
	movea.w	#grid_colour0,a3	; to get this cars colour, when given grid position
	adda.w	d0,a3
	move.b	(a3),d0			; get colour
	move.w	d0,temp_colour.w
	cmp.b	car_colour.w,d0
	bne.b	.exit
	move.b	d3,last_result.w
.exit:	rts

add_points_on:				; input d0 is car colour, d3 is position, output - adds up running total, and appends to special store
	movem.l	d1/d3/a0,-(sp)	
	movea.w	#points_colour0,a3	; points at points data	- using a3 so that it gets left pointing at right number
	adda.w	d0,a3
	neg.b	d3
	addq.b	#7,d3			; seven pts less position = true points
	add.b	d3,(a3)			; subtract position.

	movea.w	#result_colour0,a0
	asl.w	#2,d0
	adda.w	d0,a0
	move.l	(a0),d1
	asl.l	#3,d1
	or.b	d3,d1
	move.l	d1,(a0)			; note d3 trashed - uncertain if needed * * * * * * * *
	asr.w	#2,d0			; d0 must be returned unharmed

	movem.l	(sp)+,d1/d3/a0	
	rts

add_time_on:
	movem.l	d1/a0,-(sp)
	movea.w	#time_colour0,a0
	move.w	temp_colour.w,d1
	asl.w	#2,d1
	add.l	d0,(a0,d1.w)
	movem.l	(sp)+,d1/a0
	rts

draw_car:
	movem.l	d0-d2,-(sp)

	muls	#$320,d0
	add.l	#Mapdisp+$4800,d0
	move.w	#238,d1
	tst.b	race_type.w	
	beq.b	.nt
	move.w	#264,d1
.nt:	addq.w	#4,d2
	bsr	Blit_car

	movem.l	(sp)+,d0-d2
	rts

Output_10:				; reads appropriate set of results and prints them
	movem.l	d0/d3-d4/a0,-(sp)
	movea.w	#points_colour0,a0
	adda.w	d0,a0
	asl.w	#2,d0
	move.l	(a4,d0),d3
	rol.l	#2,d3			; to get first number to top
	moveq	#9,d4

.lp:	rol.l	#3,d3
	move.b	d3,d0
	and.b	#7,d0
	bsr	Blit_digit
	add.w	#13,d1
	dbra	d4,.lp

	add.w	#7,d1			; prints total of points after individual ones
	moveq	#0,d0
	move.b	(a0),d0
	moveq	#2,d4
	bsr	Blit_number
	movem.l	(sp)+,d0/d3-d4/a0
	rts

tour_time_bit:
	move.l	a0,-(sp)
	movea.w	#time_colour0,a0
	asl.w	#2,d0
	move.l	(a0,d0),d0
	bsr	Blit_time
	move.l	(sp)+,a0
	rts

Line_results:

	movem.l	d0/d2/d3,-(sp)

	tst.b	race_type.w
	bne.b	.ok
	add.w	#24,d1

.ok:	move.b	d3,d0
	bsr	Blit_digit		; prints position digit
	add.w	#20,d1			; move x across

	tst.b	race_type.w
	beq.b	.nx
	tst.b	tourn_track.w
	bne.b	.nx

	moveq	#0,d0			; this is the stuff for after 10 races
	move.b	(a0)+,d0		; reads car colour
	bsr	draw_car
	bsr	Output_10
	add.w	#12,d1

	bsr	tour_time_bit

	movem.l	(sp)+,d0/d2/d3
	rts


.nx:	cmp.b	race_won.w,d0		; check for this position having been filled
	ble.b	.tex			; if it is then don't need to mess with any clever calculations

	movea.l	#posit_block-4,a0	; point at position data, which is valid for unfinished cars, less one cars worth because positions start at 1
	asl.w	#2,d3			; scale up - one long each
	adda.w	d3,a0			; apply offset so we can use without messing about
	move.b	(a0)+,d0		; read car grid number
	asr.w	#2,d3

	bsr	point_at_ai		; wrecks a2
	bsr	convert_to_colour	; wrecks a3
	move.b	d0,(a5)+		; put the colour in place, so that it can be used later for generating the grid positions
	bsr	add_points_on		; wrecks a3
	bsr	draw_car		; draw this car on screen

	bsr	calc_time		; calculate the averaged up time for this car to finish the race - return in d0
	move.l	d0,FTIME(a2)
	bra.b	.norm

.tex:	move.b	(a0)+,d0		; read car number - note this is the grid position, so we still need to get the colour later

	bsr	point_at_ai
	bsr	convert_to_colour
	move.b	d0,(a5)+		; put the colour in place, so that it can be used later for generating the grid positions
	bsr	add_points_on
	bsr	draw_car		; takes car grid position in d0, turns it into a colour,
					; multiplies by 19, blits resulting address onto screen at fixed x value, current y

	move.l	FTIME(a2),d0
.norm:	beq.b	.done			; special - if no time, then no race, especially for players who just park
	bsr	add_time_on
	bsr	Blit_time		; leaves x (d1) pointing just after last digit
	addq.w	#8,d1

	moveq	#0,d0
	move.w	LBEST(a2),d0
	bne.b	.use
	move.l	FTIME(a2),d0
	move.w	d0,LBEST(a2)
.use:	bsr	Blit_time		; note that blit-time destroys the value in d0
	add.w	#16,d1

	move.w	LBEST(a2),d0
	moveq	#0,d3
	move.b	track_no.w,d3
	lea	Track_lengths-*-2(PC),a2
	asl.w	#2,d3
	move.l	(a2,d3.w),d3		; read track length
	divu	d0,d3			; turn into speed (mph *10)
	moveq	#0,d0			; need to remove remainder
	move.w	d3,d0			; so it won't be used as part of the result !
	bsr	Blit_speed
	add.w	#16,d1

	tst.b	race_type.w
	beq.b	.done

	moveq	#0,d0
	move.b	(a3),d0
	moveq	#2,d4			; two digit number
	bsr	Blit_number

.done:	movem.l	(sp)+,d0/d2/d3
	rts

Print_results:

	moveq	#0,d0
	move.b	real_num_drones.w,d0	; for looping round correct number of times
	moveq	#60,d2			; y coordinate is pre-set to allow increment to be placed at start of loop
	moveq	#0,d3			; holds position - I know it could be worked out from the other stuff, but heck, who cares !
	movea.w	#pos1_car,a0		; so that can pick up cars in order as far as is known
	movea.w	#result_colour0,a4	; a3 is set up in add-points to point at 'points_colourx'
	movea.w	#pos1_colour,a5

.lp:	moveq	#24,d1			; x coordinate is re-set every loop
	add.w	#16,d2			; move down a line
	addq.l	#1,d3			; increment position
	bsr	Line_results		; think structured
	dbra	d0,.lp
	rts

Name_entry:
	clr.l	(a0)
	clr.l	4(a0)			; zap the entry completely
	move.b	#1,(a0)			; initialize first letter to 'A', thus preventing wierdness
	moveq	#0,d5
	move.w	#178,d1
	move.w	#192,d2			; provisional co-ordinates
	moveq	#1,d4

loop:	tst.b	d4
	bne.b	.on
	moveq	#30,d0
	bra.b	.do
.on:	move.b	(a0,d5.w),d0
.do:	bsr	Blit_char
	btst	#4,counter+1.w
	sne	d4
	bsr	sync
	bsr	sync
	bsr	sync
	bsr	readpad
	bsr	FX
	bsr	ResetKey
	move.l	joy_edge.w,d0
	btst	#JOY_LEFT,d0
	bne.b	move_left
	btst	#JOY_RIGHT,d0
	bne.b	move_right
	move.l	joy_rep.w,d0
	btst	#JOY_UP,d0
	bne.b	last_letter
	btst	#JOY_DOWN,d0
	bne.b	next_letter
	and.l	#ANY_FIRE,d0
	beq	loop
	move.b	(a0,d5.w),d0
	bsr	Blit_char		; last thing to do is redraw letter in case it's off when key is hit
	rts

move_left:
	move.b	(a0,d5.w),d0
	bsr	Blit_char
	subq.w	#1,d5
	bmi.b	.fail
	sub.w	#10,d1
	bra	loop

.fail:	tst.b	8(a0,d5.w)	; check to see if last letter is valid, in which case allow wrap
	bne.b	.wrap
	addq.w	#1,d5
	bra	loop

.wrap:	addq.w	#8,d5	
	add.w	#70,d1
	bra	loop

move_right:
	move.b	(a0,d5.w),d0
	bsr	Blit_char
	addq.w	#1,d5
	cmp.b	#8,d5
	beq.b	.wrap
	add.w	#10,d1
	move.b	(a0,d5.w),d0
	bne	loop		; assume valid if non-zero, since cleared already
	move.b	#1,(a0,d5.w)
	bra	loop

.wrap:	subq.w	#8,d5
	sub.w	#70,d1
	bra	loop

last_letter:
	subq.b	#1,(a0,d5.w)
	bgt	loop		; this is because 0 doesn't exist as a code

.wrap:	move.b	#30,(a0,d5.w)
	bra	loop

next_letter:
	addq.b	#1,(a0,d5.w)
	cmp.b	#31,(a0,d5.w)
	bne	loop
.wrap:	move.b	#1,(a0,d5.w)
	bra	loop



; this data moved to here so it can be independently modified, and so that the code works properly

Movement_data:	; format : extra,y rotation, x position, z position, where extra is step count for first one, and scale value for subsequent ones
	init	3,$100,$8000.l,$b000.l		; 3 because its count-1, and last section is only for leaving
	init	$5,$180,0.l,$7800.l
	init	$2,$1e0,-$1000.l,$6000.l
	init	$3,$240,-$1400.l,$3000.l
	init	$3,$280,-$180.l,$a00.l
	init	$4,$300,$1000.l,$0.l		; if taken, drives off screen


Testtext:
;	dc.w	320-(12*10)/2,11
;	dc.b	"RACE^RESULTS",0
	dc.w	34,40
	dc.b	"^^^^^^^^^^^^BEST^LAP",0
	dc.w	34,56
	dc.b	"POSN^TIME^^TIME^^SPEED^^CAR",0
	dc.w	-1

Tourtext:
;	dc.w	320-(18*10)/2,11
;	dc.b	"TOURNAMENT^RESULTS",0
	dc.w	10,40
	dc.b	"^^^^^^^^^^^^BEST^LAP",0
	dc.w	10,56
	dc.b	"POSN^TIME^^TIME^^SPEED^POINTS^CAR",0
	dc.w	-1

Besttext:
	dc.w	18,176
	dc.b	"A^RECORD^TIME^[^CONGRATULATIONS\\",0
	dc.w	18,192
	dc.b	"ENTER^YOUR^NAME^[",0
	dc.w	-1

Champtext:
	dc.w	10,48
	dc.b	"POSN^^RACE^POINTS^TOTAL^TIME^^CAR",0
	dc.w	-1	

Alltext:
	dc.w	18,176
	dc.b	"AN^ALL^TIME^TOP^FIVE^RESULT^\\"
	dc.w	18,192
	dc.b	"ENTER^YOUR^NAME^[",0
	dc.w	-1

Track_lengths:
	dc.l	$425f4*10
	dc.l	$3e2ec*10
	dc.l	$479a0*10
	dc.l	$3ce4c*10
	dc.l	$3b5ec*10
	dc.l	$41c1c*10
	dc.l	$3bb14*10
	dc.l	$42ea0*10
	dc.l	$3aee4*10
	dc.l	$4ea5c*10

tie_breaker:

	movea.w	#pos1_car,a0		; this is a list of cars known to have finished
	moveq	#0,d1
	move.b	grid_position.w,d1	; this is the players car

	moveq	#5,d0
.lp:	cmp.b	(a0)+,d1
	beq.b	.fnd
	dbra	d0,.lp
	bra.b	.exit

.fnd:	moveq	#0,d0
	move.b	-2(a0),d0

	bsr	point_at_ai		; point a2 at car in d0 (car ahead of player)
	move.l	FTIME(a2),d2		; read that cars time
	exg	d0,d1
	bsr	point_at_ai
	cmp.l	FTIME(a2),d2
	bne.b	.exit

	move.b	d1,-(a0)
	move.b	d0,-(a0)

.exit:	rts
