; definition file for positioning extra objects relative to track segments
; in the following format :
;	left barrier		2 words (x,z)
;	left trees - row 1	4 words (x,z) twice - will also hold palms
;	left trees - row 2	4 words
;	right barrier		2 words
;	right trees - row 1	4 words	
;	right trees - row 2	4 words
; if straight then :
;	dotted line *4		8 words (x,z) each
; if corner then :
;	chevrons *4		8 words (x,z) each
;	dotted line *4		12 words (x,z,yrot) each

; the type distinction will be made at the start of processing, so ensuring correct data usage
; rather than force yet more use of numbers, names relating to the object in question will be
; used, primarily because every different track segment will need its own, and none of the 
; sets will be shared.

bar	set	1000		; distance to barrier from edge of track
row1	set	7000		; distance to first row of trees (from edge of track)
row2	set	12000		; second row of trees

wid	set	15000
Exstrv::
	dc.w	-(wid +bar),0
	dc.w	wid +bar,0
	dc.w	-(wid +row1),-2500,-(wid +row1),7500
	dc.w	-(wid +row2),-7500,-(wid +row2),2500
	dc.w	(wid +row1),2500,(wid +row1),-7500
	dc.w	(wid +row2),7500,(wid +row2),-2500
	dc.w	0,-7500,0,-2500,0,2500,0,7500

wid	set	10000
Exstrw::
	dc.w	-(wid +bar),0
	dc.w	wid +bar,0
	dc.w	-(wid +row1),-2500,-(wid +row1),7500
	dc.w	-(wid +row2),-7500,-(wid +row2),2500
	dc.w	(wid +row1),2500,(wid +row1),-7500
	dc.w	(wid +row2),7500,(wid +row2),-2500
	dc.w	0,-7500,0,-2500,0,2500,0,7500

;wid	set	7500
;Exstrm::
;	dc.w	-(wid +bar),0
;	dc.w	wid +bar,0
;	dc.w	-(wid +row1),-2500,-(wid +row1),7500
;	dc.w	-(wid +row2),-7500,-(wid +row2),2500
;	dc.w	(wid +row1),2500,(wid +row1),-7500
;	dc.w	(wid +row2),7500,(wid +row2),-2500
;	dc.w	0,-7500,0,-2500,0,2500,0,7500

wid	set	5000
Exstrn::
	dc.w	-(wid +bar),0
	dc.w	wid +bar,0
	dc.w	-(wid +row1),-2500,-(wid +row1),7500
	dc.w	-(wid +row2),-7500,-(wid +row2),2500
	dc.w	(wid +row1),2500,(wid +row1),-7500
	dc.w	(wid +row2),7500,(wid +row2),-2500
	dc.w	0,-7500,0,-2500,0,2500,0,7500

wid	set	15000
Exstrvwo::
	dc.w	-(wid+bar),0
	dc.w	(wid+bar),0
	dc.w	-(wid +row1),-2500,-(wid +row1),7500
	dc.w	-(wid +row2),-7500,-(wid +row2),2500
	dc.w	(wid +row1),2500,(wid +row1),-7500
	dc.w	(wid +row2),7500,(wid +row2),-2500
	dc.w	0,-7500,0,-2500,0,2500,0,7500

wid	set	10000
Exstrwm::
	dc.w	-(wid+bar),0
	dc.w	(wid+bar),0
	dc.w	-(wid +row1),-2500,-(wid +row1),7500
	dc.w	-(wid +row2),-7500,-(wid +row2),2500
	dc.w	(wid +row1),2500,(wid +row1),-7500
	dc.w	(wid +row2),7500,(wid +row2),-2500
	dc.w	0,-7500,0,-2500,0,2500,0,7500

wid	set	7500
Exstrmn::
	dc.w	-(wid +bar),0
	dc.w	wid +bar,0
	dc.w	-(wid +row1),-2500,-(wid +row1),7500
	dc.w	-(wid +row2),-7500,-(wid +row2),2500
	dc.w	(wid +row1),2500,(wid +row1),-7500
	dc.w	(wid +row2),7500,(wid +row2),-2500
	dc.w	0,-7500,0,-2500,0,2500,0,7500

wid	set	10000
Exstrwn::
	dc.w	-(wid +bar),0
	dc.w	wid +bar,0
	dc.w	-(wid +row1),-2500,-(wid +row1),7500
	dc.w	-(wid +row2),-7500,-(wid +row2),2500
	dc.w	(wid +row1),2500,(wid +row1),-7500
	dc.w	(wid +row2),7500,(wid +row2),-2500
	dc.w	0,-7500,0,-2500,0,2500,0,7500

Exstrvw::
	dc.w	-(wid +bar),0
	dc.w	wid +bar+wid,0
	dc.w	-(wid +row1+(wid/4)),2500,-(wid +row1+(3*wid/4)),-7500
	dc.w	-(wid +row2+(3*wid/4)),7500,-(wid +row2+(wid/4)),-2500
	dc.w	(wid +row1),-2500,(wid +row1),7500
	dc.w	(wid +row2),-7500,(wid +row2),2500
	dc.w	10000,-5000,0,-5000,0,5000,10000,5000

Exstrwv::
	dc.w	-(wid +bar+wid),0
	dc.w	wid +bar,0
	dc.w	-(wid +row1),-2500,-(wid +row1),7500
	dc.w	-(wid +row2),-7500,-(wid +row2),2500
	dc.w	(wid +row1+(wid/4)),2500,(wid +row1+(3*wid/4)),-7500
	dc.w	(wid +row2+(3*wid/4)),7500,(wid +row2+(wid/4)),-2500
	dc.w	-10000,-5000,0,-5000,0,5000,-10000,5000

;======================================================
; extension piece data - place barriers half way along, ignore trees for now,
; place white lines as per usual - at 1/8,3/8,5/8,7/8 for long, or 1/4,3/4 for short

.macro exlong length
	dc.w	-11000,\length/2
	dc.w	11000,\length/2
	dc.w	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.w	0,\length/8,0,3*\length/8,0,5*\length/8,0,7*\length/8
.endm

.macro exshort length
	dc.w	-11000,\length/2
	dc.w	11000,\length/2
	dc.w	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,1*\length/4,0,3*\length/4,0,0
.endm

Exx0z:: exlong 19962
Exx1x:: exlong 17406
Exx1z:: exlong 16721
Exx2x:: exshort 13672
Exx2z:: exlong 20068
Exx3x:: exlong 19167
Exx3z:: exshort 9093
Exx4x:: exlong 16946
Exx4z:: exlong 15878
Exx5x:: exlong 14827
Exx5z:: exshort 13190
Exx6x:: exlong 19638
Exx6z:: exshort 11096
Exx7x:: exshort 6314
Exx7z:: exshort 11026
Exx8x:: exshort 14829
Exx8z:: exshort 11482
Exx9x:: exshort 8255
Exx9z:: exlong 16807

;======================================================

Excorw10::			; ALL VALUES NEED CHANGING
	dc.w	-11000,0
	dc.w	11000,0
	dc.w	-16683,-1393,-15277,10003
	dc.w	-21963,-7005,-21083,4934
	dc.w	17025,-7963,17624,160		; one line of trees on right - but no more
;	dc.w	22211,-4262,23148,3335		; second line data if required
	dc.w	0,0,0,0				; currently using these zeros (ie no tree)
	dc.w	0,0,0,0,0,0,0,0			; no chevrons
	dc.w	120,-5093,-8			; two 'dotted' white lines
	dc.w	1082,4673,-24			; with rotation settings
	dc.w	0,0,0,0,0,0			; plus two empty ones

Excorw20::
	dc.w	-11000,0
	dc.w	11000,0
	dc.w	-16863,-1393,-15727,10003
	dc.w	-21963,-7005,-21083,4934
	dc.w	17025,-7963,17624,160		; one line of trees on right - but no more
;	dc.w	22211,-4262,23148,3335		; second line data if required
	dc.w	0,0,0,0				; currently using these zeros (ie no tree)
	dc.w	0,0,0,0,0,0,0,0			; no chevrons
	dc.w	120,-5093,-8			; two 'dotted' white lines
	dc.w	1082,4673,-24			; with rotation settings
	dc.w	0,0,0,0,0,0			; plus two empty ones

Excorw30::
	dc.w	-11000,0
	dc.w	11000,-5000
	dc.w	-12462,-2037,-10112,4884
	dc.w	-16931,-5407,-15302,2786
	dc.w	0,0,0,0				; no trees on right
	dc.w	0,0,0,0
	dc.w	0,0,0,0,0,0,0,0			; chevrons
	dc.w	128,-5542,-21			; two 'dotted' white lines
	dc.w	1141,-1760,-42			; with rotation settings
	dc.w	0,0,0,0,0,0			; plus two empty ones

Excorw40::
	dc.w	-11000,0
	dc.w	11000,0
	dc.w	-12694,-1687,-11336,9319
	dc.w	-16965,-7129,-16120,3832
	dc.w	18000,0,16500,-7000
	dc.w	0,0,0,0
	dc.w	0,0,0,0,0,0,0,0			; no chevrons
	dc.w	60,-7546,-8			; four 'dotted' white lines
	dc.w	541,-2663,-24			; with rotation settings
	dc.w	1498,2149,-40
	dc.w	2923,6844,-56

Excorw45::
	dc.w	-11000,0
	dc.w	11000,-6000
	dc.w	-15407,741,-8601,13473
	dc.w	-21798,-5883,-17041,9799
	dc.w	0,0,0,0
	dc.w	0,0,0,0
	dc.w	0,0,0,0,0,0,0,0			; no chevrons
	dc.w	171,-7389,-21			; three 'dotted' white lines
	dc.w	1522,-2346,-64			; with rotation settings
	dc.w	4132,2175,-107
	dc.w	0,0,0				; plus one empty ones

Excorw90::
	dc.w	-5000,5000
	dc.w	0,0	; 11000,-11000		disabled temporarily
	dc.w	-12694,-1687,-11336,9319
	dc.w	-16965,-7129,-16120,3832
	dc.w	0,0,0,0
	dc.w	0,0,0,0
	dc.w	0,0,0,0,0,0,0,0			; no chevrons
	dc.w	288,-12074,-32			; four 'dotted' white lines
	dc.w	2528,-6666,-96			; with rotation settings
	dc.w	6666,-2528,-160
	dc.w	12074,-288,-224

.if 0
Excorn30::
	dc.w	-6000,0
	dc.w	6000,-5000
	dc.w	-12462,-2037,-10112,4884
	dc.w	-16931,-5407,-15302,2786
	dc.w	0,0,0,0				; no trees on right
	dc.w	0,0,0,0
	dc.w	0,0,0,0,0,0,0,0			; chevrons
	dc.w	511,-3619,-42			; one 'dotted' white line
	dc.w	0,0,0				; with rotation settings
	dc.w	0,0,0,0,0,0			; plus three empty ones
.endif

Excorv10::			; ALL VALUES NEED CHANGING
	dc.w	-16000,0
	dc.w	16000,0
	dc.w	-16683,-1393,-15277,10003
	dc.w	-21963,-7005,-21083,4934
	dc.w	17025,-7963,17624,160		; one line of trees on right - but no more
;	dc.w	22211,-4262,23148,3335		; second line data if required
	dc.w	0,0,0,0				; currently using these zeros (ie no tree)
	dc.w	0,0,0,0,0,0,0,0			; no chevrons
	dc.w	5044,-6441,-4			; two 'dotted' white lines
	dc.w	-4953,-6196,-4			; with rotation settings
	dc.w	5392,666,-12
	dc.w	-4580,1403,-12

Excorv20::
	dc.w	-16000,0
	dc.w	16000,0
	dc.w	-16683,-1393,-15277,10003
	dc.w	-21963,-7005,-21083,4934
	dc.w	17025,-7963,17624,160		; one line of trees on right - but no more
;	dc.w	22211,-4262,23148,3335		; second line data if required
	dc.w	0,0,0,0				; currently using these zeros (ie no tree)
	dc.w	0,0,0,0,0,0,0,0			; no chevrons
	dc.w	5114,-5339,-8			; two 'dotted' white lines
	dc.w	-4874,-4848,-8			; with rotation settings
	dc.w	6028,3939,-24
	dc.w	-3864,5407,-24

;-------------------------------------------------------------

Expit03::
	dc.w	-11000,0
	dc.w	11000,0
	dc.w	-(wid +row1),-2500,-(wid +row1),7500
	dc.w	-(wid +row2),-7500,-(wid +row2),2500
	dc.w	0,0,0,0				; no trees on right
	dc.w	0,0,0,0
	dc.w	0,-7500,0,-2500,0,2500,0,7500

Expit04::
	dc.w	0,0
	dc.w	1000,0
	dc.w	-(wid +row1),-2500,-(wid +row1),7500
	dc.w	-(wid +row2),-7500,-(wid +row2),2500
	dc.w	0,0,0,0				; no trees on right
	dc.w	0,0,0,0
	dc.w	0,0,0,0				; no white lines
	dc.w	0,0,0,0

Expit05::
	dc.w	0,0
	dc.w	8000,0
	dc.w	0,0,0,0				; no trees
	dc.w	0,0,0,0
	dc.w	0,0,0,0				; no trees
	dc.w	0,0,0,0
	dc.w	0,0,0,0				; no white lines
	dc.w	0,0,0,0

Expit06::
	dc.w	-6000,0
	dc.w	6000,0
	dc.w	0,0,0,0				; no trees
	dc.w	0,0,0,0
	dc.w	0,0,0,0				; no trees
	dc.w	0,0,0,0
	dc.w	0,0,0,0				; no white lines
	dc.w	0,0,0,0

Expit07::
	dc.w	-6000,0
	dc.w	6000,0
	dc.w	0,0,0,0				; no trees
	dc.w	0,0,0,0
	dc.w	0,0,0,0				; no trees
	dc.w	0,0,0,0
	dc.w	0,0,0,0				; no white lines
	dc.w	0,0,0,0

Expit08::
	dc.w	0,0
	dc.w	8000,0
	dc.w	0,0,0,0				; no trees
	dc.w	0,0,0,0
	dc.w	0,0,0,0				; no trees
	dc.w	0,0,0,0
	dc.w	0,0,0,0				; no white lines
	dc.w	0,0,0,0

Expit09::
	dc.w	0,0
	dc.w	1000,0
	dc.w	-(wid +row1),-2500,-(wid +row1),7500
	dc.w	-(wid +row2),-7500,-(wid +row2),2500
	dc.w	0,0,0,0				; no trees on right
	dc.w	0,0,0,0
	dc.w	0,0,0,0				; no white lines
	dc.w	0,0,0,0

.end

what is really needed here is a flexible structure, which allows different numbers of the same kind of objects for different
track pieces.  For example, the number of trees is hugely variable, even the dotted lines needs to be variable to allow for the 
difference between 3 lane and 4 lane track pieces, and also the problem of wide spaced lines needs to be covered.
