; special routines to deal with font that is not truly mono-spaced...

move_forward_char::
	movem.l	a0/d2,-(sp)
	lea	basic_character_widths-*-2(PC),a0
	moveq	#0,d2
	move.b	(a0,d0),d2
	add.w	d2,d1
	movem.l	(sp)+,d2/a0
	rts

perform_kerning::
	movem.l	a0/d0/d2,-(sp)
	moveq	#$1f,d2
	and.b	(a0),d2			; read next letter early as a0 gets trashed
	beq.b	.done			; just in case we are at end of string !
	asl.w	#1,d0
	lea	kerning_pointers-*-2(PC),a0
	move.w	(a0,d0),d0		; get offset pointer for this letter
	bmi.b	.done
	lea	kerning_tables-*-2(PC),a0
	add.w	d0,a0
.loop:	move.b	(a0)+,d0
	beq.b	.done			; reached end of kerning table
	cmp.b	d0,d2
	bne.b	.loop
	moveq	#0,d0
	move.b	(a0),d0			; found it, so get change
	sub.w	d0,d1			; apply it
.done:	movem.l	(sp)+,a0/d0/d2
	rts

Print_string::				; prints string pointed to by a0, 0 terminated, converting each character as it goes
	move.w	(a0)+,d1		; x and y co-ordinates precede the text
	move.w	(a0)+,d2
print_string_here::			; call to here if x,y is already set up
.loop:	moveq	#$1f,d0
	and.b	(a0)+,d0
	beq.b	.done
	cmp.b	#$1f,d0
	beq.b	.skip			; to allow narrow spaces to be used internally
	bsr	Blit_char
.skip:	bsr	move_forward_char
	bsr	perform_kerning
	bra	.loop
.done:	rts

Print_some::
	tst.w	(a0)
	bmi.b	.done
	bsr	Print_string
	move.l	a0,d0
	addq.l	#1,d0
	andi.w	#$fffe,d0
	move.l	d0,a0
	bra.b	Print_some
.done:	rts

Blit_time::			; d0 input value
	bsr	time_to_bcd	; get it into usable format
	swap	d0
	ror.l	#4,d0		; leaves just the correct amount in d0.b
	tst.b	d0
	beq.b	.sk1		; skip the blit if its zero, to give leading blank (only one though)
	bsr	Blit_digit	; minutes upper digit
.sk1:	addq.w	#8,d1
	clr.b	d0
	rol.l	#4,d0
	bsr	Blit_digit	; minutes lower digit
	addq.w	#8,d1
	move.b	#11,d0
	bsr	Blit_digit	; semi-colon
	addq.w	#4,d1
	clr.b	d0
	rol.l	#4,d0
	bsr	Blit_digit	; seconds upper digit
	addq.w	#8,d1
	clr.b	d0
	rol.l	#4,d0
	bsr	Blit_digit	; seconds lower digit
	addq.w	#8,d1
	move.b	#11,d0
	bsr	Blit_digit	; semi_colon
	addq.w	#4,d1
	clr.b	d0
	rol.l	#4,d0
	bsr	Blit_digit	; tenths digit
	addq.w	#8,d1
	rts

Blit_speed:
	movem.l	d0/d3,-(sp)
	bsr	word_to_bcd	; turn into 4 
	swap	d0		; put digits into upper part ready for rolling

	rol.l	#4,d0
	tst.b	d0		; check if its a zero
	sne.b	leading_zero.w	; remember status for next digit
	beq.b	.sk1
	bsr	Blit_digit
.sk1:	addq.w	#8,d1
	clr.b	d0

	rol.l	#4,d0
	tst.b	leading_zero.w
	bne.b	.ns
	tst.b	d0
	beq.b	.sk2
.ns:	bsr	Blit_digit
.sk2:	addq.w	#8,d1
	clr.b	d0

	rol.l	#4,d0
	bsr	Blit_digit
	addq.w	#6,d1

	moveq	#0,d3
	move.b	#29,d0
	bsr	Blit_char
	addq.w	#6,d1
	clr.b	d0
	rol.l	#4,d0
	bsr	Blit_digit
	addq.w	#8,d1
	movem.l	(sp)+,d0/d3
	rts

Blit_number::			; number in d0, digits in d4
	movem.l	d0/d3,-(sp)
	bsr	word_to_bcd	; turn into 4 
	asl.w	#2,d4		; 4 * num digits to output
	ror.l	d4,d0		; rotates appropriate number of bits off bottom onto top
	clr.b	leading_zero.w
	asr.w	#2,d4		; put back for count
	bra.b	.dbr

.loop:	rol.l	#4,d0
	tst.b	leading_zero.w	; check for non-zero having already gone
	bne.b	.ok
	tst.w	d4		; check for final digit
	beq.b	.ok
	tst.b	d0		; check if its a zero
	sne.b	leading_zero.w	; remember status for next digit
	beq.b	.sk1
.ok:	bsr	Blit_digit
.sk1:	addq.w	#8,d1
	clr.b	d0
.dbr:	dbra	d4,.loop

	movem.l	(sp)+,d0/d3
	rts




basic_character_widths:
	dc.b	0	; nul
	dc.b	9	; A
	dc.b	9	; B
	dc.b	9	; C
	dc.b	9	; D
	dc.b	8	; E
	dc.b	8	; F
	dc.b	9	; G
	dc.b	9	; H
	dc.b	4	; I
	dc.b	9	; J
	dc.b	9	; K
	dc.b	8	; L
	dc.b	11	; M
	dc.b	9	; N
	dc.b	9	; O
	dc.b	9	; P
	dc.b	9	; Q
	dc.b	9	; R
	dc.b	9	; S
	dc.b	8	; T
	dc.b	9	; U
	dc.b	9	; V
	dc.b	11	; W
	dc.b	9	; X
	dc.b	9	; Y
	dc.b	9	; Z
	dc.b	8	; :
	dc.b	6	; /
	dc.b	8	; .
	dc.b	9	; space
	dc.b	4	; undefined

; kerning data structure	-1 signifies no kerning, non zero is an offset into a table
kerning_pointers:
	dc.w	-1	; nul		; 0
	dc.w	-1	; A		; 1
	dc.w	-1	; B		; 2
	dc.w	-1	; C		; 3
	dc.w	-1	; D		; 4
	dc.w	-1	; E		; 5
	dc.w	0	; F		; 6
	dc.w	-1	; G		; 7
	dc.w	-1	; H		; 8
	dc.w	-1	; I		; 9
	dc.w	-1	; J		; 10
	dc.w	-1	; K		; 11
	dc.w	5	; L		; 12
	dc.w	-1	; M		; 13
	dc.w	-1	; N		; 14
	dc.w	-1	; O		; 15
	dc.w	0	; P		; 16
	dc.w	-1	; Q		; 17
	dc.w	-1	; R		; 18
	dc.w	-1	; S		; 19
	dc.w	0	; T		; 20
	dc.w	-1	; U		; 21
	dc.w	-1	; V		; 22
	dc.w	-1	; W		; 23
	dc.w	-1	; X		; 24
	dc.w	-1	; Y		; 25
	dc.w	-1	; Z		; 26
	dc.w	-1	; :		; 27
	dc.w	-1	; /		; 28
	dc.w	-1	; .		; 29
	dc.w	-1	; space		; 30
	dc.w	-1	; narrow space	; 31 - only available internally
	
kerning_tables:		; consisting of character and offset amount - offset is amount to move BACK
	dc.b	10,2	; FJ also used for PJ,TJ
	dc.b	0	; break mark - to prevent accidental use of another characters kerning data
	dc.b	20,2	; LT
	dc.b	0



