;==============================================
;	INITIAL MAIN REGISTER SETTINGS
;==============================================

wrk0		.equr		r0
wrk1		.equr		r1
wrk2		.equr		r2
Mat1		.equr		r3
Mat2		.equr		r4
Mat3		.equr		r5
Mat4		.equr		r6
Mat5		.equr		r7
Mat6		.equr		r8
Mat7		.equr		r9
Mat8		.equr		r10
Mat9		.equr		r11

Index1		.equr		r14
Index2		.equr		r15

Xin		.equr		r12
Yin		.equr		r13

Zin		.equr		r16
Xout		.equr		r17
Yout		.equr		r18
Zout		.equr		r19
Sinx		.equr		r20
Siny		.equr		r21
Sinz		.equr		r22
Cosx		.equr		r23
Cosy		.equr		r24
Cosz		.equr		r25
Xoff		.equr		r26
Yoff		.equr		r27
Zoff		.equr		r28
Data_reg	.equr		r29
return		.equr		r30	; for fast subroutine returns and exit vector
stack		.equr		r31

; ============ ALTERNATE REGISTER SET ===============

; first off, registers for holding specific values during processing

colour		.equr		r0	; current cry colour value
intens		.equr		r1	; current cry intensity
litex		.equr		r2	; light vector (transformed into view space)
litey		.equr		r3	; 
litez		.equr		r4	; 
Dcue		.equr		r5	; shift to apply to z to get fade value and multiplier as well
Target		.equr		r6	; target colour for depth cueing
Ambient		.equr		r7	; ambient light level 
Bright		.equr		r8	; scale factor for lighting - in 16ths


; then registers holding specific permanent values eg pointers

Gbuffer		.equr		r9	; pointer to GPU variable space
PNo		.equr		r10	; pointer to normal transformation space
P2d		.equr		r11	; pointer to 2d point output zone
P3d		.equr		r12	; pointer to 3d point output zone
Blit_index	.equr		r13	; pointer to A1_BASE which is first blitter register
GPU_index	.equr		r14	; pointer to GPU_FLAGS which is first GPU register
B_Com		.equr		r15	; holds the actual command for drawing (to avoid using movei)

; then registers holding values for calculations

screen_h	.equr		r16	;  screen height in pixels
screen_z	.equr		r17	;  screen z position relative to eye
screen_w	.equr		r18	;  screen width in pixels
Zbase		.equr		r19	;  pre-multiplied z position for rapid use in generating screen co-ordinates for points

; then remainder allocated for general messing around

Addr1		.equr		r20	; 
Addr2		.equr		r21	; 
Addr3		.equr		r22	;
Store1		.equr		r23	;
Store2		.equr		r24	;
Store3		.equr		r25	;

; then registers to hold overlay specific information

overlay		.equr		r26	; current overlay number
routine		.equr		r27	; requested routine number

; then a few values which aren't held but could be ...

;clip		; the screen clipping value used in line draw
;base		; the address of the start of memory mapped stuff - allows access to border colour and the like.
;int1		; address of CPU interrupt acknowledgment system - could I use this ?
;gpuprog	; program number holder
;gstop		; halt routine - held in main set currently
;blitsem	; for CPU/GPU interaction over blitter usage
;gpusem		; for notifying CPU of end of GPU program
;sine_table	; ...
;data3d		; where to get the 3d data from
;displaymem	; address of screen display
;screen		; screen switch	flag
;blitflag	; value to write to blitter flags for normal writes to screen
;transform	; the most frequently called subroutine
;any number of other subroutine addresses


