; new grouping - all bitmapped graphics functions in one file, just using includes

;========================================
;         INCLUDES OF EQUATES
;========================================

.include 'jaguar.inc'
.include 'blit.inc'
.include 'memdefs.inc'
.include 'msg.inc'
.include 'datatype.inc'

;========================================
;	MACROS
;========================================

.macro	border colour,override
.iif Borders=1, move.l #b_\colour,BORD1
.iif \?override&!Borders, move.l #b_\colour,BORD1
.endm

;=======================

.macro	RunGPU	 program

	movea.w	#gpusem,a0
notc\~:	tst.l	(a0)
	bne.b	notc\~
	addq.l	#1,(a0)			; note addq.l to a known zero is same effect as move.l #1, but 2 bytes (not 6) and 20 ticks (not 28)

	bclr	#0,G_CTRL+3		; halt GPU - note +3 to force last byte
	move.l	#G_RAM,G_PC		; set pc to start
	move.l	#\program*GPUM,gpustop
	move.l	#$11,G_CTRL		; start GPU

.endm

;=======================

.macro	waitgpu
movea.w	#gpusem,a0
.wait\~:
tst.l	(a0)
bne.b	.wait\~
.endm

;========================================
;	INCLUDES OF PROGRAMS
;========================================

.include 'crycols.s'
.include 'skyfill.s'
.include 'greysky.s'
.include 'rld.s'
.include 'rldtest.s'
.include 'rlepal.s'
.include 'scrnshot.s'
.include 'strip.s'
.include 'colfil.s'
.include 'cycle.s'
.include 'maprot.s'
